<?php

namespace App\Services;

use Twilio\Rest\Client;

class TwilioService
{
    protected $twilioSid;
    protected $twilioAuthToken;
    protected $twilioPhoneNumber;

    public function __construct()
    {
        $this->twilioSid = env('ACCOUNT_SID');
        $this->twilioAuthToken = env('AUTH_TOKEN');
        $this->twilioPhoneNumber = env('Twilio_Number');
    }

    public function sendWhatsAppMessageWithFile($to, $message, $filePath)
    {
        // Twilio Client initialization
        $client = new Client($this->twilioSid, $this->twilioAuthToken);

        // Upload the file to Twilio
        $mediaUrl = $this->uploadFileToTwilio($filePath);

        if (!$mediaUrl) {
            return false; // Handle failure to upload the file
        }

        // Send the WhatsApp message with the media
        $client->messages->create(
            'whatsapp:' . $to, 
            [
                'from' => $this->twilioPhoneNumber,
                'body' => $message,
                'mediaUrl' => [$mediaUrl] // Add the media URL for the file
            ]
        );

        return true;
    }

    private function uploadFileToTwilio($filePath)
    {
        // Twilio API for uploading media
        try {
            $client = new Client($this->twilioSid, $this->twilioAuthToken);

            // Upload the PDF file to Twilio's Media Service
            $media = $client->media->create(
                'whatsapp:' . $this->twilioPhoneNumber,
                ['file' => fopen($filePath, 'r')] // Open the file and upload it
            );

            return $media->url; // Return the media URL for the uploaded file
        } catch (\Exception $e) {
            // Handle error in file upload
            return false;
        }
    }
}
