

CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_no` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `initial_balance` double DEFAULT NULL,
  `total_balance` double NOT NULL,
  `note` text DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO accounts VALUES("1","11111","Sales Account","1000","1000","this is first account","0","1","2018-12-18 02:58:02","2024-10-06 14:57:47");
INSERT INTO accounts VALUES("3","21211","Sa","","0","","1","1","2018-12-18 02:58:56","2024-10-06 14:57:47");
INSERT INTO accounts VALUES("4","000111","Cost of Goods Sold","1000","1000","","","1","2024-09-11 17:41:42","2024-09-11 17:41:42");



CREATE TABLE `adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `total_qty` double NOT NULL,
  `item` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO adjustments VALUES("1","adr-20240814-010343","1","","1","1","","2024-08-14 13:03:43","2024-08-14 13:03:43");



CREATE TABLE `attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `employee_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `checkin` varchar(191) NOT NULL,
  `checkout` varchar(191) NOT NULL,
  `status` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO attendances VALUES("1","2024-09-14","1","1","8:00am","6:00pm","1","","2024-09-14 19:59:36","2024-09-14 19:59:36");
INSERT INTO attendances VALUES("2","2024-09-14","2","1","8:00am","6:00pm","1","","2024-09-14 19:59:36","2024-09-14 19:59:36");
INSERT INTO attendances VALUES("3","2024-09-14","3","1","8:00am","6:00pm","1","","2024-09-14 19:59:36","2024-09-14 19:59:36");
INSERT INTO attendances VALUES("4","2024-09-29","2","1","9:00am","6:00pm","1","","2024-09-29 13:54:08","2024-09-29 13:54:08");
INSERT INTO attendances VALUES("5","2024-09-29","1","1","9:00am","6:00pm","1","","2024-09-29 13:54:34","2024-09-29 13:54:34");



CREATE TABLE `billers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `vat_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO billers VALUES("1","Laramed","Laramed.png","Laramed","","l@gmail.com","72556625","Villadolores","La paz","","","","1","2024-07-06 20:17:47","2024-07-06 20:17:47");



CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO brands VALUES("1","Filter","20240706075424.jpg","0","2024-07-06 19:54:24","2024-09-13 13:11:59");
INSERT INTO brands VALUES("2","KAEM","","1","2024-08-24 16:04:43","2024-08-24 16:04:43");
INSERT INTO brands VALUES("3","HES","","1","2024-09-10 00:10:27","2024-09-10 00:10:27");
INSERT INTO brands VALUES("4","Mi","","1","2024-09-13 11:41:24","2024-09-13 11:41:24");
INSERT INTO brands VALUES("5","Winston","","1","2024-09-16 00:01:44","2024-09-16 00:01:44");



CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_in_hand` double NOT NULL,
  `user_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cash_registers VALUES("1","2360","1","1","0","2024-07-06 20:15:00","2024-08-19 06:07:14");
INSERT INTO cash_registers VALUES("2","100","1","1","1","2024-07-18 01:54:08","2024-07-18 01:54:08");
INSERT INTO cash_registers VALUES("3","50","1","1","1","2024-07-20 20:16:42","2024-07-20 20:16:42");
INSERT INTO cash_registers VALUES("4","1","1","1","1","2024-08-01 14:08:48","2024-08-01 14:08:48");
INSERT INTO cash_registers VALUES("5","1","1","1","1","2024-08-03 02:20:21","2024-08-03 02:20:21");
INSERT INTO cash_registers VALUES("6","100","1","1","1","2024-08-04 13:46:54","2024-08-04 13:46:54");
INSERT INTO cash_registers VALUES("7","100","1","1","1","2024-08-05 11:46:22","2024-08-05 11:46:22");
INSERT INTO cash_registers VALUES("8","100","1","1","1","2024-08-09 19:17:36","2024-08-09 19:17:36");
INSERT INTO cash_registers VALUES("9","1","33","1","1","2024-08-10 10:02:48","2024-08-10 10:02:48");
INSERT INTO cash_registers VALUES("10","100","1","1","1","2024-08-12 19:52:00","2024-08-12 19:52:00");
INSERT INTO cash_registers VALUES("11","2","1","1","1","2024-08-13 13:02:45","2024-08-13 13:02:45");
INSERT INTO cash_registers VALUES("12","20","1","1","1","2024-08-13 13:15:38","2024-08-13 13:15:38");
INSERT INTO cash_registers VALUES("13","1000","35","1","1","2024-08-15 09:11:22","2024-08-15 09:11:22");
INSERT INTO cash_registers VALUES("14","200","1","1","1","2024-08-17 14:18:11","2024-08-17 14:18:11");
INSERT INTO cash_registers VALUES("15","0","1","1","1","2024-08-22 13:26:05","2024-08-22 13:26:05");
INSERT INTO cash_registers VALUES("16","1000","1","1","1","2024-08-22 14:08:24","2024-08-22 14:08:24");
INSERT INTO cash_registers VALUES("17","100","1","1","1","2024-08-23 21:33:08","2024-08-23 21:33:08");
INSERT INTO cash_registers VALUES("18","100","1","1","1","2024-08-23 21:38:29","2024-08-23 21:38:29");
INSERT INTO cash_registers VALUES("19","1500","1","1","1","2024-08-23 21:40:57","2024-08-23 21:40:57");
INSERT INTO cash_registers VALUES("20","100","1","1","1","2024-08-26 11:01:57","2024-08-26 11:01:57");
INSERT INTO cash_registers VALUES("21","500","1","1","1","2024-08-26 15:02:19","2024-08-26 15:02:19");
INSERT INTO cash_registers VALUES("22","2000","1","1","1","2024-08-26 15:02:43","2024-08-26 15:02:43");
INSERT INTO cash_registers VALUES("23","0","1","1","1","2024-08-28 22:01:30","2024-08-28 22:01:30");
INSERT INTO cash_registers VALUES("24","1","1","1","1","2024-09-03 07:54:04","2024-09-03 07:54:04");
INSERT INTO cash_registers VALUES("25","0","1","1","1","2024-09-04 09:28:16","2024-09-04 09:28:16");
INSERT INTO cash_registers VALUES("26","1","1","1","1","2024-09-05 08:11:06","2024-09-05 08:11:06");
INSERT INTO cash_registers VALUES("27","1000","1","1","1","2024-09-06 06:54:58","2024-09-06 06:54:58");
INSERT INTO cash_registers VALUES("28","1000","1","1","1","2024-09-06 06:55:08","2024-09-06 06:55:08");
INSERT INTO cash_registers VALUES("29","1","1","1","1","2024-09-07 11:24:08","2024-09-07 11:24:08");
INSERT INTO cash_registers VALUES("30","1","1","1","1","2024-09-07 12:15:14","2024-09-07 12:15:14");
INSERT INTO cash_registers VALUES("31","3","1","1","1","2024-09-07 12:24:44","2024-09-07 12:24:44");
INSERT INTO cash_registers VALUES("32","1","1","2","1","2024-09-10 14:51:03","2024-09-10 14:51:03");
INSERT INTO cash_registers VALUES("33","1","1","3","1","2024-09-13 12:06:41","2024-09-13 12:06:41");
INSERT INTO cash_registers VALUES("34","600","1","4","1","2024-09-16 14:20:30","2024-09-16 14:20:30");
INSERT INTO cash_registers VALUES("35","1000","1","5","1","2024-10-06 16:02:51","2024-10-06 16:02:51");
INSERT INTO cash_registers VALUES("36","12","40","6","1","2024-10-09 07:01:15","2024-10-09 07:01:15");
INSERT INTO cash_registers VALUES("37","1","40","7","1","2024-10-09 07:36:20","2024-10-09 07:36:20");



CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO categories VALUES("1","Insumos terapia intensiva","","","0","2024-07-06 19:50:06","2024-09-13 13:10:55");
INSERT INTO categories VALUES("2","software","","","0","2024-08-24 16:04:43","2024-09-13 13:11:01");
INSERT INTO categories VALUES("3","cable","","","0","2024-09-10 00:05:29","2024-09-13 13:10:48");
INSERT INTO categories VALUES("4","Agave / Aloe Vera","","","1","2024-09-13 11:41:24","2024-09-13 11:41:24");
INSERT INTO categories VALUES("5","Small Plants","","","1","2024-09-13 13:11:33","2024-09-13 13:11:33");
INSERT INTO categories VALUES("6","STYLO","","5","1","2024-09-16 14:51:48","2024-09-16 14:51:48");
INSERT INTO categories VALUES("7","Endashaw Negsh","","5","1","2024-09-29 13:36:02","2024-09-29 13:36:02");



CREATE TABLE `coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `amount` double NOT NULL,
  `minimum_amount` double DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `used` int(11) NOT NULL,
  `expired_date` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO coupons VALUES("1","6Xq1TeZQv3","fixed","15","15","2","0","2024-08-22","1","1","2024-08-22 13:53:09","2024-08-22 13:53:09");



CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` varchar(191) NOT NULL,
  `exchange_rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO currencies VALUES("1","US Dollar","USD","1","2020-11-01 00:22:58","2020-11-01 00:34:55");
INSERT INTO currencies VALUES("2","Euro","Euro","0.85","2020-11-01 01:29:12","2020-11-10 23:15:34");
INSERT INTO currencies VALUES("3","الريال","SR","3.75","2024-06-11 09:13:41","2024-06-11 09:13:41");
INSERT INTO currencies VALUES("4","Bolivianos","Bs","6.97","2024-07-06 19:56:07","2024-07-06 19:56:07");
INSERT INTO currencies VALUES("5","Ghana Cedis","GHC","15","2024-08-15 09:51:32","2024-08-15 09:51:32");
INSERT INTO currencies VALUES("6","Metical","MZN","61.2","2024-08-22 14:03:57","2024-08-22 14:03:57");
INSERT INTO currencies VALUES("7","manat","AZN","1.7025","2024-09-10 00:14:06","2024-09-10 00:14:06");
INSERT INTO currencies VALUES("8","DH","MAD","9","2024-09-16 00:01:09","2024-09-16 15:17:14");



CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `percentage` varchar(191) NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_groups VALUES("1","DIVERS","0","1","2024-07-06 20:11:26","2024-09-16 15:16:22");
INSERT INTO customer_groups VALUES("2","Cliente privado","0","0","2024-07-06 20:11:45","2024-09-16 15:16:29");



CREATE TABLE `customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `phone_number` varchar(191) NOT NULL,
  `tax_no` varchar(191) DEFAULT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `points` double DEFAULT NULL,
  `deposit` double DEFAULT NULL,
  `expense` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customers VALUES("1","2","","Freddy","Villalobos","","5678875","4901401012","Villadolores","La paz","","","Bolivia","1340","","","1","2024-07-06 20:14:16","2024-09-16 15:11:35");
INSERT INTO customers VALUES("2","1","","akram","","king.1991@gmail.com","+962563542569","","unite kindom -liverpool","liverpool","","","","10","","","1","2024-07-31 23:56:30","2024-09-03 20:52:57");
INSERT INTO customers VALUES("3","1","32","akram","x","kefah.rajha.1991@gmail.com","+962563542569","125","unite kindom -liverpool","liverpool","wws","65932","england","","","","0","2024-08-01 14:03:25","2024-08-01 14:03:25");
INSERT INTO customers VALUES("4","1","","Ali Azemi","","ali_azemi2000@yahoo.com","049580429","","Rizah Matoshi No 25","Ferizaj","","","","","","","0","2024-08-10 13:54:25","2024-08-10 13:58:11");
INSERT INTO customers VALUES("5","1","","Cemi","","cemi@gmail.com","045580429","","Ferizaj","Ferizaj","","","","33","","","1","2024-08-20 18:47:49","2024-08-20 18:49:13");
INSERT INTO customers VALUES("6","2","","Qhsh","Aa","","1123","","Ss","Ss","","","Irq","336","100","","1","2024-08-23 21:37:19","2024-08-23 21:39:37");
INSERT INTO customers VALUES("7","2","","khalid l"amala","","","0655224465","","ain sebaa","casablanca","","","","26","","","1","2024-09-16 15:13:57","2024-10-06 16:03:31");
INSERT INTO customers VALUES("8","1","","FACTUR","","","FACTURCMOUSE","","MOUSE M90","MOUSE","","","","","","","1","2024-10-07 14:10:10","2024-10-07 14:10:10");



CREATE TABLE `deliveries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `address` text NOT NULL,
  `delivered_by` varchar(191) DEFAULT NULL,
  `recieved_by` varchar(191) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deliveries VALUES("1","dr-20240822-014430","18","1","Villadolores La paz Bolivia","","","","","3","2024-08-22 13:44:49","2024-08-22 13:45:11");
INSERT INTO deliveries VALUES("2","dr-20240916-121700","35","1","Villadolores La paz Bolivia","","","","2eme livr","3","2024-09-16 00:17:20","2024-09-16 00:27:37");
INSERT INTO deliveries VALUES("3","dr-20240916-030925","36","1","Villadolores La paz Bolivia","","","","","2","2024-09-16 15:09:35","2024-09-16 15:09:35");
INSERT INTO deliveries VALUES("4","dr-20240917-033033","41","1","ain sebaa casablanca","","","","","2","2024-09-17 15:30:42","2024-09-17 15:30:42");



CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES("1","ZONGO Mathieu","0","2024-08-13 12:08:26","2024-08-13 12:09:19");
INSERT INTO departments VALUES("2","Beeciye Online","1","2024-08-13 12:09:55","2024-09-14 19:53:26");



CREATE TABLE `deposits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `amount` double NOT NULL,
  `customer_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deposits VALUES("1","100","6","1","Ebay","2024-08-23 21:37:38","2024-08-23 21:37:38");



CREATE TABLE `employees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `department_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES("1","ZONGO Mathieu","mthzongo@gmail.com","2677888999","2","34","","","","","1","2024-08-13 12:10:56","2024-08-13 12:10:56");
INSERT INTO employees VALUES("2","QASIM","naa@gmail.com","0247439813","2","35","naagmailcom.jpg","","","Ghana","1","2024-08-15 09:09:39","2024-09-29 13:51:48");
INSERT INTO employees VALUES("3","Derrick","derrick@gmail.com","0247439813","2","36","","","","","1","2024-08-15 09:14:03","2024-08-15 09:14:03");



CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expense_categories VALUES("1","16718342","washing","1","2018-08-16 00:32:48","2019-03-02 07:02:07");
INSERT INTO expense_categories VALUES("2","60128975","electric bill","1","2018-08-16 00:39:18","2018-08-16 00:39:18");
INSERT INTO expense_categories VALUES("3","83954970","test","0","2018-08-16 00:50:28","2018-08-16 00:51:40");
INSERT INTO expense_categories VALUES("4","1234","snacks","1","2018-09-01 02:40:04","2018-09-01 02:40:04");



CREATE TABLE `expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `expense_category_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `amount` double NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expenses VALUES("2","er-20180817-012254","1","2","1","1","","150","first expense...","2018-08-17 07:22:54","2018-08-17 07:44:13");
INSERT INTO expenses VALUES("3","er-20180817-014241","1","1","1","1","","125","second expense...","2018-08-17 07:42:41","2018-08-17 07:43:50");
INSERT INTO expenses VALUES("4","er-20181022-043609","2","1","1","1","","1000","","2018-10-22 10:36:09","2018-10-22 10:36:09");
INSERT INTO expenses VALUES("5","er-20181101-050207","2","2","1","1","","1000","","2018-10-31 23:02:07","2018-10-31 23:02:07");
INSERT INTO expenses VALUES("6","er-20181101-050231","2","1","1","1","","550","","2018-10-31 23:02:31","2018-10-31 23:02:31");
INSERT INTO expenses VALUES("7","er-20181105-091913","1","1","1","1","","2000","","2018-11-05 03:19:13","2018-11-05 03:19:13");
INSERT INTO expenses VALUES("8","er-20181105-091929","2","2","1","1","","1000","","2018-11-05 03:19:29","2018-11-05 03:19:29");
INSERT INTO expenses VALUES("9","er-20190101-063342","2","1","1","1","","100","","2019-01-01 00:33:42","2019-01-01 00:33:42");
INSERT INTO expenses VALUES("10","er-20190103-070018","2","2","1","9","","2000","","2019-01-03 01:00:18","2019-01-03 01:00:18");
INSERT INTO expenses VALUES("11","er-20190209-104656","2","2","1","1","","500","","2019-02-09 04:46:56","2019-02-09 04:46:56");
INSERT INTO expenses VALUES("12","er-20190209-104716","2","1","1","1","","400","","2019-02-09 04:47:16","2019-02-09 04:47:16");
INSERT INTO expenses VALUES("14","er-20190303-104142","2","2","1","1","","250","jjj","2019-03-03 04:41:42","2019-03-20 09:17:16");
INSERT INTO expenses VALUES("15","er-20190404-095645","2","1","1","1","","200","","2019-04-04 03:56:45","2019-04-04 03:56:45");
INSERT INTO expenses VALUES("16","er-20190528-103306","2","1","1","1","","560","","2019-05-28 04:33:06","2019-05-28 04:33:06");
INSERT INTO expenses VALUES("17","er-20190528-103325","2","2","1","1","","600","","2019-05-28 04:33:25","2019-05-28 04:33:25");
INSERT INTO expenses VALUES("19","er-20190613-101955","2","2","1","1","","800","","2019-06-13 04:19:55","2019-06-13 04:19:55");
INSERT INTO expenses VALUES("20","er-20191019-033149","2","1","1","1","","300","","2019-10-19 09:31:49","2019-10-19 09:31:49");
INSERT INTO expenses VALUES("21","er-20191222-023508","2","1","1","1","","550","","2019-12-22 08:35:08","2019-12-22 08:35:08");
INSERT INTO expenses VALUES("22","er-20200101-022304","2","2","1","1","","500","","2020-01-01 08:23:04","2020-01-01 08:23:04");
INSERT INTO expenses VALUES("23","er-20200204-105938","1","1","1","1","","400","","2020-02-04 16:59:38","2020-02-04 16:59:38");
INSERT INTO expenses VALUES("24","er-20200204-105957","1","2","1","1","","350","","2020-02-04 16:59:57","2020-02-04 16:59:57");
INSERT INTO expenses VALUES("25","er-20200406-075239","2","2","1","1","","750","","2020-04-06 13:52:39","2020-04-06 13:52:39");
INSERT INTO expenses VALUES("26","er-20200506-110112","2","2","1","1","","1260","","2020-05-06 17:01:12","2020-05-06 17:01:12");
INSERT INTO expenses VALUES("27","er-20200609-124344","2","1","1","1","","500","","2020-06-09 06:43:44","2020-06-09 06:43:44");
INSERT INTO expenses VALUES("28","er-20200609-124406","2","2","1","1","","1000","","2020-06-09 06:44:06","2020-06-09 06:44:06");
INSERT INTO expenses VALUES("29","er-20200703-064005","2","2","1","1","","630","","2020-07-03 12:40:05","2020-07-03 12:40:05");
INSERT INTO expenses VALUES("30","er-20200812-062947","1","2","1","1","","320","","2020-08-12 12:29:47","2020-08-12 12:29:47");
INSERT INTO expenses VALUES("31","er-20200812-063010","2","2","1","1","","730","","2020-08-12 12:30:10","2020-08-12 12:30:10");
INSERT INTO expenses VALUES("32","er-20201018-124438","2","1","1","9","2","100","","2020-10-18 06:44:38","2020-10-18 06:44:38");
INSERT INTO expenses VALUES("33","er-20201101-072257","1","2","1","1","4","50","","2020-11-01 01:22:57","2020-11-01 01:22:57");
INSERT INTO expenses VALUES("34","er-20201118-062500","4","1","1","1","3","200","","2020-11-18 00:25:00","2020-11-18 00:25:00");
INSERT INTO expenses VALUES("37","er-20210114-065938","2","2","1","1","4","25.5","","2021-01-14 00:59:38","2021-01-14 00:59:38");
INSERT INTO expenses VALUES("38","er-20210601-075909","2","1","1","1","3","100","","2021-06-01 13:59:09","2021-06-01 13:59:09");
INSERT INTO expenses VALUES("39","er-20211208-115635","2","2","1","1","4","200","","2021-12-08 05:56:35","2021-12-08 05:56:35");



CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) NOT NULL,
  `site_logo` varchar(191) DEFAULT NULL,
  `is_rtl` tinyint(1) DEFAULT NULL,
  `currency` varchar(191) NOT NULL,
  `staff_access` varchar(191) NOT NULL,
  `date_format` varchar(191) NOT NULL,
  `developed_by` varchar(191) DEFAULT NULL,
  `invoice_format` varchar(191) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `theme` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES("1","3F TRADING","20241010071609.jpg","0","1","own","d/m/Y","KAEM Software","gst","1","default.css","2018-07-06 06:13:11","2024-10-10 07:25:40","suffix");



CREATE TABLE `gift_card_recharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gift_card_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO gift_card_recharges VALUES("1","2","100","1","2018-08-24 23:08:29","2018-08-24 23:08:29");
INSERT INTO gift_card_recharges VALUES("2","1","200","1","2018-08-24 23:08:50","2018-08-24 23:08:50");
INSERT INTO gift_card_recharges VALUES("3","1","100","1","2018-09-04 23:50:41","2018-09-04 23:50:41");
INSERT INTO gift_card_recharges VALUES("4","1","50","1","2018-09-04 23:51:38","2018-09-04 23:51:38");
INSERT INTO gift_card_recharges VALUES("5","1","50","1","2018-09-04 23:53:36","2018-09-04 23:53:36");
INSERT INTO gift_card_recharges VALUES("6","2","50","1","2018-09-04 23:54:34","2018-09-04 23:54:34");
INSERT INTO gift_card_recharges VALUES("7","5","10","1","2018-09-30 00:19:48","2018-09-30 00:19:48");
INSERT INTO gift_card_recharges VALUES("8","5","10","1","2018-09-30 00:20:04","2018-09-30 00:20:04");
INSERT INTO gift_card_recharges VALUES("9","2","100","1","2018-10-07 03:13:05","2018-10-07 03:13:05");
INSERT INTO gift_card_recharges VALUES("10","1","200","1","2018-10-07 03:13:39","2018-10-07 03:13:39");
INSERT INTO gift_card_recharges VALUES("11","1","300","1","2018-10-23 00:22:49","2018-10-23 00:22:49");
INSERT INTO gift_card_recharges VALUES("12","2","130","1","2021-02-11 07:36:01","2021-02-11 07:36:01");



CREATE TABLE `gift_cards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_no` varchar(191) NOT NULL,
  `amount` double NOT NULL,
  `expense` double NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `expired_date` date DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO gift_cards VALUES("1","1302922618713400","100","0","2","","2024-09-22","1","1","2024-08-22 13:51:54","2024-08-22 13:51:54");
INSERT INTO gift_cards VALUES("2","0259925133261137","-1","0","1","","2024-09-27","1","1","2024-09-27 11:53:47","2024-09-27 11:53:47");



CREATE TABLE `holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `note` text DEFAULT NULL,
  `is_approved` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `hrm_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `checkin` varchar(191) NOT NULL,
  `checkout` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO hrm_settings VALUES("1","9:00am","6:00pm","2019-01-02 02:20:08","2024-05-28 15:38:45");



CREATE TABLE `languages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO languages VALUES("1","en","2018-07-07 22:59:17","2019-12-24 17:34:20");



CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES("1","2014_10_12_000000_create_users_table","1");
INSERT INTO migrations VALUES("2","2014_10_12_100000_create_password_resets_table","1");
INSERT INTO migrations VALUES("3","2018_02_17_060412_create_categories_table","1");
INSERT INTO migrations VALUES("4","2018_02_20_035727_create_brands_table","1");
INSERT INTO migrations VALUES("5","2018_02_25_100635_create_suppliers_table","1");
INSERT INTO migrations VALUES("6","2018_02_27_101619_create_warehouse_table","1");
INSERT INTO migrations VALUES("7","2018_03_03_040448_create_units_table","1");
INSERT INTO migrations VALUES("8","2018_03_04_041317_create_taxes_table","1");
INSERT INTO migrations VALUES("9","2018_03_10_061915_create_customer_groups_table","1");
INSERT INTO migrations VALUES("10","2018_03_10_090534_create_customers_table","1");
INSERT INTO migrations VALUES("11","2018_03_11_095547_create_billers_table","1");
INSERT INTO migrations VALUES("12","2018_04_05_054401_create_products_table","1");
INSERT INTO migrations VALUES("13","2018_04_06_133606_create_purchases_table","1");
INSERT INTO migrations VALUES("14","2018_04_06_154600_create_product_purchases_table","1");
INSERT INTO migrations VALUES("15","2018_04_06_154915_create_product_warhouse_table","1");
INSERT INTO migrations VALUES("16","2018_04_10_085927_create_sales_table","1");
INSERT INTO migrations VALUES("17","2018_04_10_090133_create_product_sales_table","1");
INSERT INTO migrations VALUES("18","2018_04_10_090254_create_payments_table","1");
INSERT INTO migrations VALUES("19","2018_04_10_090341_create_payment_with_cheque_table","1");
INSERT INTO migrations VALUES("20","2018_04_10_090509_create_payment_with_credit_card_table","1");
INSERT INTO migrations VALUES("21","2018_04_13_121436_create_quotation_table","1");
INSERT INTO migrations VALUES("22","2018_04_13_122324_create_product_quotation_table","1");
INSERT INTO migrations VALUES("23","2018_04_14_121802_create_transfers_table","1");
INSERT INTO migrations VALUES("24","2018_04_14_121913_create_product_transfer_table","1");
INSERT INTO migrations VALUES("25","2018_05_13_082847_add_payment_id_and_change_sale_id_to_payments_table","2");
INSERT INTO migrations VALUES("26","2018_05_13_090906_change_customer_id_to_payment_with_credit_card_table","3");
INSERT INTO migrations VALUES("27","2018_05_20_054532_create_adjustments_table","4");
INSERT INTO migrations VALUES("28","2018_05_20_054859_create_product_adjustments_table","4");
INSERT INTO migrations VALUES("29","2018_05_21_163419_create_returns_table","5");
INSERT INTO migrations VALUES("30","2018_05_21_163443_create_product_returns_table","5");
INSERT INTO migrations VALUES("31","2018_06_02_050905_create_roles_table","6");
INSERT INTO migrations VALUES("32","2018_06_02_073430_add_columns_to_users_table","7");
INSERT INTO migrations VALUES("33","2018_06_03_053738_create_permission_tables","8");
INSERT INTO migrations VALUES("36","2018_06_21_063736_create_pos_setting_table","9");
INSERT INTO migrations VALUES("37","2018_06_21_094155_add_user_id_to_sales_table","10");
INSERT INTO migrations VALUES("38","2018_06_21_101529_add_user_id_to_purchases_table","11");
INSERT INTO migrations VALUES("39","2018_06_21_103512_add_user_id_to_transfers_table","12");
INSERT INTO migrations VALUES("40","2018_06_23_061058_add_user_id_to_quotations_table","13");
INSERT INTO migrations VALUES("41","2018_06_23_082427_add_is_deleted_to_users_table","14");
INSERT INTO migrations VALUES("42","2018_06_25_043308_change_email_to_users_table","15");
INSERT INTO migrations VALUES("43","2018_07_06_115449_create_general_settings_table","16");
INSERT INTO migrations VALUES("44","2018_07_08_043944_create_languages_table","17");
INSERT INTO migrations VALUES("45","2018_07_11_102144_add_user_id_to_returns_table","18");
INSERT INTO migrations VALUES("46","2018_07_11_102334_add_user_id_to_payments_table","18");
INSERT INTO migrations VALUES("47","2018_07_22_130541_add_digital_to_products_table","19");
INSERT INTO migrations VALUES("49","2018_07_24_154250_create_deliveries_table","20");
INSERT INTO migrations VALUES("50","2018_08_16_053336_create_expense_categories_table","21");
INSERT INTO migrations VALUES("51","2018_08_17_115415_create_expenses_table","22");
INSERT INTO migrations VALUES("55","2018_08_18_050418_create_gift_cards_table","23");
INSERT INTO migrations VALUES("56","2018_08_19_063119_create_payment_with_gift_card_table","24");
INSERT INTO migrations VALUES("57","2018_08_25_042333_create_gift_card_recharges_table","25");
INSERT INTO migrations VALUES("58","2018_08_25_101354_add_deposit_expense_to_customers_table","26");
INSERT INTO migrations VALUES("59","2018_08_26_043801_create_deposits_table","27");
INSERT INTO migrations VALUES("60","2018_09_02_044042_add_keybord_active_to_pos_setting_table","28");
INSERT INTO migrations VALUES("61","2018_09_09_092713_create_payment_with_paypal_table","29");
INSERT INTO migrations VALUES("62","2018_09_10_051254_add_currency_to_general_settings_table","30");
INSERT INTO migrations VALUES("63","2018_10_22_084118_add_biller_and_store_id_to_users_table","31");
INSERT INTO migrations VALUES("65","2018_10_26_034927_create_coupons_table","32");
INSERT INTO migrations VALUES("66","2018_10_27_090857_add_coupon_to_sales_table","33");
INSERT INTO migrations VALUES("67","2018_11_07_070155_add_currency_position_to_general_settings_table","34");
INSERT INTO migrations VALUES("68","2018_11_19_094650_add_combo_to_products_table","35");
INSERT INTO migrations VALUES("69","2018_12_09_043712_create_accounts_table","36");
INSERT INTO migrations VALUES("70","2018_12_17_112253_add_is_default_to_accounts_table","37");
INSERT INTO migrations VALUES("71","2018_12_19_103941_add_account_id_to_payments_table","38");
INSERT INTO migrations VALUES("72","2018_12_20_065900_add_account_id_to_expenses_table","39");
INSERT INTO migrations VALUES("73","2018_12_20_082753_add_account_id_to_returns_table","40");
INSERT INTO migrations VALUES("74","2018_12_26_064330_create_return_purchases_table","41");
INSERT INTO migrations VALUES("75","2018_12_26_144210_create_purchase_product_return_table","42");
INSERT INTO migrations VALUES("76","2018_12_26_144708_create_purchase_product_return_table","43");
INSERT INTO migrations VALUES("77","2018_12_27_110018_create_departments_table","44");
INSERT INTO migrations VALUES("78","2018_12_30_054844_create_employees_table","45");
INSERT INTO migrations VALUES("79","2018_12_31_125210_create_payrolls_table","46");
INSERT INTO migrations VALUES("80","2018_12_31_150446_add_department_id_to_employees_table","47");
INSERT INTO migrations VALUES("81","2019_01_01_062708_add_user_id_to_expenses_table","48");
INSERT INTO migrations VALUES("82","2019_01_02_075644_create_hrm_settings_table","49");
INSERT INTO migrations VALUES("83","2019_01_02_090334_create_attendances_table","50");
INSERT INTO migrations VALUES("84","2019_01_27_160956_add_three_columns_to_general_settings_table","51");
INSERT INTO migrations VALUES("85","2019_02_15_183303_create_stock_counts_table","52");
INSERT INTO migrations VALUES("86","2019_02_17_101604_add_is_adjusted_to_stock_counts_table","53");
INSERT INTO migrations VALUES("87","2019_04_13_101707_add_tax_no_to_customers_table","54");
INSERT INTO migrations VALUES("89","2019_10_14_111455_create_holidays_table","55");
INSERT INTO migrations VALUES("90","2019_11_13_145619_add_is_variant_to_products_table","56");
INSERT INTO migrations VALUES("91","2019_11_13_150206_create_product_variants_table","57");
INSERT INTO migrations VALUES("92","2019_11_13_153828_create_variants_table","57");
INSERT INTO migrations VALUES("93","2019_11_25_134041_add_qty_to_product_variants_table","58");
INSERT INTO migrations VALUES("94","2019_11_25_134922_add_variant_id_to_product_purchases_table","58");
INSERT INTO migrations VALUES("95","2019_11_25_145341_add_variant_id_to_product_warehouse_table","58");
INSERT INTO migrations VALUES("96","2019_11_29_182201_add_variant_id_to_product_sales_table","59");
INSERT INTO migrations VALUES("97","2019_12_04_121311_add_variant_id_to_product_quotation_table","60");
INSERT INTO migrations VALUES("98","2019_12_05_123802_add_variant_id_to_product_transfer_table","61");
INSERT INTO migrations VALUES("100","2019_12_08_114954_add_variant_id_to_product_returns_table","62");
INSERT INTO migrations VALUES("101","2019_12_08_203146_add_variant_id_to_purchase_product_return_table","63");
INSERT INTO migrations VALUES("102","2020_02_28_103340_create_money_transfers_table","64");
INSERT INTO migrations VALUES("103","2020_07_01_193151_add_image_to_categories_table","65");
INSERT INTO migrations VALUES("105","2020_09_26_130426_add_user_id_to_deliveries_table","66");
INSERT INTO migrations VALUES("107","2020_10_11_125457_create_cash_registers_table","67");
INSERT INTO migrations VALUES("108","2020_10_13_155019_add_cash_register_id_to_sales_table","68");
INSERT INTO migrations VALUES("109","2020_10_13_172624_add_cash_register_id_to_returns_table","69");
INSERT INTO migrations VALUES("110","2020_10_17_212338_add_cash_register_id_to_payments_table","70");
INSERT INTO migrations VALUES("111","2020_10_18_124200_add_cash_register_id_to_expenses_table","71");
INSERT INTO migrations VALUES("112","2020_10_21_121632_add_developed_by_to_general_settings_table","72");
INSERT INTO migrations VALUES("113","2019_08_19_000000_create_failed_jobs_table","73");
INSERT INTO migrations VALUES("114","2020_10_30_135557_create_notifications_table","73");
INSERT INTO migrations VALUES("115","2020_11_01_044954_create_currencies_table","74");
INSERT INTO migrations VALUES("116","2020_11_01_140736_add_price_to_product_warehouse_table","75");
INSERT INTO migrations VALUES("117","2020_11_02_050633_add_is_diff_price_to_products_table","76");
INSERT INTO migrations VALUES("118","2020_11_09_055222_add_user_id_to_customers_table","77");
INSERT INTO migrations VALUES("119","2020_11_17_054806_add_invoice_format_to_general_settings_table","78");
INSERT INTO migrations VALUES("120","2021_02_10_074859_add_variant_id_to_product_adjustments_table","79");
INSERT INTO migrations VALUES("121","2021_03_07_093606_create_product_batches_table","80");
INSERT INTO migrations VALUES("122","2021_03_07_093759_add_product_batch_id_to_product_warehouse_table","80");
INSERT INTO migrations VALUES("123","2021_03_07_093900_add_product_batch_id_to_product_purchases_table","80");
INSERT INTO migrations VALUES("124","2021_03_11_132603_add_product_batch_id_to_product_sales_table","81");
INSERT INTO migrations VALUES("127","2021_03_25_125421_add_is_batch_to_products_table","82");
INSERT INTO migrations VALUES("128","2021_05_19_120127_add_product_batch_id_to_product_returns_table","82");
INSERT INTO migrations VALUES("130","2021_05_22_105611_add_product_batch_id_to_purchase_product_return_table","83");
INSERT INTO migrations VALUES("131","2021_05_23_124848_add_product_batch_id_to_product_transfer_table","84");
INSERT INTO migrations VALUES("132","2021_05_26_153106_add_product_batch_id_to_product_quotation_table","85");
INSERT INTO migrations VALUES("133","2021_06_08_213007_create_reward_point_settings_table","86");
INSERT INTO migrations VALUES("134","2021_06_16_104155_add_points_to_customers_table","87");
INSERT INTO migrations VALUES("135","2021_06_17_101057_add_used_points_to_payments_table","88");
INSERT INTO migrations VALUES("136","2021_07_06_132716_add_variant_list_to_products_table","89");
INSERT INTO migrations VALUES("137","2021_09_27_161141_add_is_imei_to_products_table","90");
INSERT INTO migrations VALUES("138","2021_09_28_170052_add_imei_number_to_product_warehouse_table","91");
INSERT INTO migrations VALUES("139","2021_09_28_170126_add_imei_number_to_product_purchases_table","91");
INSERT INTO migrations VALUES("140","2021_10_03_170652_add_imei_number_to_product_sales_table","92");
INSERT INTO migrations VALUES("141","2021_10_10_145214_add_imei_number_to_product_returns_table","93");
INSERT INTO migrations VALUES("142","2021_10_11_104504_add_imei_number_to_product_transfer_table","94");
INSERT INTO migrations VALUES("143","2021_10_12_160107_add_imei_number_to_purchase_product_return_table","95");
INSERT INTO migrations VALUES("144","2021_10_12_205146_add_is_rtl_to_general_settings_table","96");



CREATE TABLE `money_transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `from_account_id` int(11) NOT NULL,
  `to_account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO money_transfers VALUES("1","mtr-20240812-080105","1","1","1000","2024-08-12 20:01:05","2024-08-12 20:01:05");



CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_cheque` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `cheque_no` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_with_cheque VALUES("1","4","23567876524","2024-08-12 19:51:16","2024-08-12 19:51:16");
INSERT INTO payment_with_cheque VALUES("2","35","gjhk","2024-09-17 15:31:45","2024-09-17 15:31:45");



CREATE TABLE `payment_with_credit_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `customer_stripe_id` varchar(191) DEFAULT NULL,
  `charge_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_gift_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `gift_card_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_paypal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `transaction_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_reference` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `used_points` double DEFAULT NULL,
  `change` double NOT NULL,
  `paying_method` varchar(191) NOT NULL,
  `payment_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payments VALUES("1","ppr-20240801-050538","1","1","","","1","452","","0","Cash","","2024-08-01 17:05:38","2024-08-01 17:05:38");
INSERT INTO payments VALUES("2","spr-20240810-015622","1","","1","1","1","20","","0","Cash","","2024-08-10 13:56:22","2024-08-10 13:56:22");
INSERT INTO payments VALUES("3","spr-20240812-123620","33","","2","9","1","22.6","","0","Cash","","2024-08-12 12:36:20","2024-08-12 12:36:20");
INSERT INTO payments VALUES("4","spr-20240812-075116","1","","3","1","1","67.8","","0","Cheque","","2024-08-12 19:51:16","2024-08-12 19:51:16");
INSERT INTO payments VALUES("5","spr-20240812-075702","1","","4","1","1","723.2","","276.8","Cash","","2024-08-12 19:57:02","2024-08-12 19:57:02");
INSERT INTO payments VALUES("6","spr-20240813-110104","1","","5","1","1","3078","","922","Cash","","2024-08-13 11:01:04","2024-08-13 11:01:04");
INSERT INTO payments VALUES("7","spr-20240813-010817","1","","6","1","1","150","","50","Cash","","2024-08-13 13:08:17","2024-08-13 13:08:17");
INSERT INTO payments VALUES("8","spr-20240815-094256","1","","7","1","1","1515","","0","Cash","","2024-08-15 09:42:56","2024-08-15 09:42:56");
INSERT INTO payments VALUES("9","spr-20240815-101808","1","","8","1","1","225","","75","Cash","","2024-08-15 10:18:08","2024-08-15 10:18:08");
INSERT INTO payments VALUES("10","spr-20240815-105259","1","","9","1","1","339","","0","Cash","","2024-08-15 10:52:59","2024-08-15 10:52:59");
INSERT INTO payments VALUES("11","spr-20240815-121001","1","","10","1","1","24345","","0","Cash","","2024-08-15 12:10:01","2024-08-15 12:10:01");
INSERT INTO payments VALUES("12","spr-20240815-014933","1","","11","1","1","54330","","0","Cash","I pagoi 300euro tjerat borgj - Pagesen ka me ba 12Gusht2024","2024-08-15 13:49:33","2024-08-15 13:49:33");
INSERT INTO payments VALUES("13","spr-20240815-033851","1","","12","1","1","13725","","0","Cash","gfcnbsfgnsfd","2024-08-15 15:38:51","2024-08-15 15:38:51");
INSERT INTO payments VALUES("14","spr-20240817-021110","1","","13","1","1","200","","0","Cash","Zbritje Cmimi 200.00 nga 250","2024-08-17 14:11:10","2024-08-17 14:11:10");
INSERT INTO payments VALUES("15","spr-20240817-021628","1","","14","1","1","200","","0","Cash","","2024-08-17 14:16:28","2024-08-17 14:16:28");
INSERT INTO payments VALUES("16","spr-20240817-021700","1","","15","1","1","200","","0","Cash","","2024-08-17 14:17:00","2024-08-17 14:17:00");
INSERT INTO payments VALUES("17","spr-20240817-021841","1","","16","1","1","10000","","0","Cash","","2024-08-17 14:18:41","2024-08-17 14:18:41");
INSERT INTO payments VALUES("18","spr-20240820-064913","1","","17","2","1","10170","","0","Cash","I pagujti kesh edhe ni meter katror e ka te pagume vje e merr.","2024-08-20 18:49:13","2024-08-20 18:49:13");
INSERT INTO payments VALUES("19","ppr-20240822-014025","1","5","","","1","360","","0","Cash","","2024-08-22 13:40:25","2024-08-22 13:40:25");
INSERT INTO payments VALUES("20","ppr-20240822-014221","1","6","","","1","500","","40","Cash","","2024-08-22 13:42:21","2024-08-22 13:42:21");
INSERT INTO payments VALUES("21","spr-20240822-021105","1","","19","2","1","300","","700","Cash","","2024-08-22 14:11:05","2024-08-22 14:11:05");
INSERT INTO payments VALUES("22","spr-20240822-041758","1","","20","2","1","9792","","0","Cash","","2024-08-22 16:17:58","2024-08-22 16:17:58");
INSERT INTO payments VALUES("23","spr-20240823-093937","1","","22","2","1","100980","","0","Cash","","2024-08-23 21:39:37","2024-08-23 21:39:37");
INSERT INTO payments VALUES("24","spr-20240902-114853","1","","24","2","1","120","","0","Cash","","2024-09-02 11:48:53","2024-09-02 11:48:53");
INSERT INTO payments VALUES("25","spr-20240903-085257","1","","25","2","1","1500","","0","Paypal","","2024-09-03 20:52:57","2024-09-03 20:52:57");
INSERT INTO payments VALUES("26","spr-20240906-065641","1","","26","2","1","5054","","946","Cash","","2024-09-06 06:56:41","2024-09-06 06:56:41");
INSERT INTO payments VALUES("27","spr-20240910-093243","1","","27","2","1","1590","","0","Cash","","2024-09-10 09:32:43","2024-09-10 09:32:43");
INSERT INTO payments VALUES("28","spr-20240911-053517","1","","28","2","1","982","","18","Cash","","2024-09-11 17:35:17","2024-09-11 17:35:17");
INSERT INTO payments VALUES("29","spr-20240911-054615","1","","29","2","1","90","","10","Credit Card","","2024-09-11 17:46:15","2024-09-11 17:46:15");
INSERT INTO payments VALUES("30","spr-20240911-054623","1","","30","2","1","90","","10","Credit Card","","2024-09-11 17:46:23","2024-09-11 17:46:23");
INSERT INTO payments VALUES("32","spr-20240916-022421","1","","38","34","1","1800","","200","Cash","","2024-09-16 14:24:21","2024-09-16 14:24:21");
INSERT INTO payments VALUES("33","spr-20240917-052814","1","","39","34","1","34.2","","0","Cash","","2024-09-17 05:28:14","2024-09-17 05:28:14");
INSERT INTO payments VALUES("34","spr-20240917-054611","1","","40","34","1","16.2","","0","Cash","","2024-09-17 05:46:11","2024-09-17 05:46:11");
INSERT INTO payments VALUES("35","spr-20240917-033145","1","","41","34","1","2160","","0","Cheque","","2024-09-17 15:31:45","2024-09-17 15:31:45");
INSERT INTO payments VALUES("36","spr-20240926-051235","1","","42","34","1","1000","","0","Cash","","2024-09-26 17:12:35","2024-09-26 17:12:35");
INSERT INTO payments VALUES("37","spr-20240927-121140","1","","43","34","1","3.8","","0","Cash","","2024-09-27 12:11:40","2024-09-27 12:11:40");
INSERT INTO payments VALUES("38","spr-20241006-035049","1","","46","34","3","11.4","","0","Cash","","2024-10-06 15:50:49","2024-10-06 15:50:49");
INSERT INTO payments VALUES("39","spr-20241006-040331","1","","47","35","3","3000","","0","Cash","","2024-10-06 16:03:31","2024-10-06 16:03:31");
INSERT INTO payments VALUES("40","spr-20241010-053539","1","","48","34","3","3.8","","46.2","Cash","","2024-10-10 05:35:39","2024-10-10 05:35:39");



CREATE TABLE `payrolls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `paying_method` varchar(191) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payrolls VALUES("1","payroll-20240813-121149","1","1","1","1900","0","","2024-08-13 12:11:49","2024-08-13 12:11:49");
INSERT INTO payrolls VALUES("2","payroll-20240914-075843","2","1","1","100","0","HFCHDXFHNFGJ","2024-09-14 19:58:43","2024-09-14 19:58:43");



CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES("4","products-edit","web","2018-06-03 01:00:09","2018-06-03 01:00:09");
INSERT INTO permissions VALUES("5","products-delete","web","2018-06-03 22:54:22","2018-06-03 22:54:22");
INSERT INTO permissions VALUES("6","products-add","web","2018-06-04 00:34:14","2018-06-04 00:34:14");
INSERT INTO permissions VALUES("7","products-index","web","2018-06-04 03:34:27","2018-06-04 03:34:27");
INSERT INTO permissions VALUES("8","purchases-index","web","2018-06-04 08:03:19","2018-06-04 08:03:19");
INSERT INTO permissions VALUES("9","purchases-add","web","2018-06-04 08:12:25","2018-06-04 08:12:25");
INSERT INTO permissions VALUES("10","purchases-edit","web","2018-06-04 09:47:36","2018-06-04 09:47:36");
INSERT INTO permissions VALUES("11","purchases-delete","web","2018-06-04 09:47:36","2018-06-04 09:47:36");
INSERT INTO permissions VALUES("12","sales-index","web","2018-06-04 10:49:08","2018-06-04 10:49:08");
INSERT INTO permissions VALUES("13","sales-add","web","2018-06-04 10:49:52","2018-06-04 10:49:52");
INSERT INTO permissions VALUES("14","sales-edit","web","2018-06-04 10:49:52","2018-06-04 10:49:52");
INSERT INTO permissions VALUES("15","sales-delete","web","2018-06-04 10:49:53","2018-06-04 10:49:53");
INSERT INTO permissions VALUES("16","quotes-index","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("17","quotes-add","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("18","quotes-edit","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("19","quotes-delete","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("20","transfers-index","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("21","transfers-add","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("22","transfers-edit","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("23","transfers-delete","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("24","returns-index","web","2018-06-04 22:50:24","2018-06-04 22:50:24");
INSERT INTO permissions VALUES("25","returns-add","web","2018-06-04 22:50:24","2018-06-04 22:50:24");
INSERT INTO permissions VALUES("26","returns-edit","web","2018-06-04 22:50:25","2018-06-04 22:50:25");
INSERT INTO permissions VALUES("27","returns-delete","web","2018-06-04 22:50:25","2018-06-04 22:50:25");
INSERT INTO permissions VALUES("28","customers-index","web","2018-06-04 23:15:54","2018-06-04 23:15:54");
INSERT INTO permissions VALUES("29","customers-add","web","2018-06-04 23:15:55","2018-06-04 23:15:55");
INSERT INTO permissions VALUES("30","customers-edit","web","2018-06-04 23:15:55","2018-06-04 23:15:55");
INSERT INTO permissions VALUES("31","customers-delete","web","2018-06-04 23:15:55","2018-06-04 23:15:55");
INSERT INTO permissions VALUES("32","suppliers-index","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("33","suppliers-add","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("34","suppliers-edit","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("35","suppliers-delete","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("36","product-report","web","2018-06-24 23:05:33","2018-06-24 23:05:33");
INSERT INTO permissions VALUES("37","purchase-report","web","2018-06-24 23:24:56","2018-06-24 23:24:56");
INSERT INTO permissions VALUES("38","sale-report","web","2018-06-24 23:33:13","2018-06-24 23:33:13");
INSERT INTO permissions VALUES("39","customer-report","web","2018-06-24 23:36:51","2018-06-24 23:36:51");
INSERT INTO permissions VALUES("40","due-report","web","2018-06-24 23:39:52","2018-06-24 23:39:52");
INSERT INTO permissions VALUES("41","users-index","web","2018-06-25 00:00:10","2018-06-25 00:00:10");
INSERT INTO permissions VALUES("42","users-add","web","2018-06-25 00:00:10","2018-06-25 00:00:10");
INSERT INTO permissions VALUES("43","users-edit","web","2018-06-25 00:01:30","2018-06-25 00:01:30");
INSERT INTO permissions VALUES("44","users-delete","web","2018-06-25 00:01:30","2018-06-25 00:01:30");
INSERT INTO permissions VALUES("45","profit-loss","web","2018-07-14 21:50:05","2018-07-14 21:50:05");
INSERT INTO permissions VALUES("46","best-seller","web","2018-07-14 22:01:38","2018-07-14 22:01:38");
INSERT INTO permissions VALUES("47","daily-sale","web","2018-07-14 22:24:21","2018-07-14 22:24:21");
INSERT INTO permissions VALUES("48","monthly-sale","web","2018-07-14 22:30:41","2018-07-14 22:30:41");
INSERT INTO permissions VALUES("49","daily-purchase","web","2018-07-14 22:36:46","2018-07-14 22:36:46");
INSERT INTO permissions VALUES("50","monthly-purchase","web","2018-07-14 22:48:17","2018-07-14 22:48:17");
INSERT INTO permissions VALUES("51","payment-report","web","2018-07-14 23:10:41","2018-07-14 23:10:41");
INSERT INTO permissions VALUES("52","warehouse-stock-report","web","2018-07-14 23:16:55","2018-07-14 23:16:55");
INSERT INTO permissions VALUES("53","product-qty-alert","web","2018-07-14 23:33:21","2018-07-14 23:33:21");
INSERT INTO permissions VALUES("54","supplier-report","web","2018-07-30 03:00:01","2018-07-30 03:00:01");
INSERT INTO permissions VALUES("55","expenses-index","web","2018-09-05 01:07:10","2018-09-05 01:07:10");
INSERT INTO permissions VALUES("56","expenses-add","web","2018-09-05 01:07:10","2018-09-05 01:07:10");
INSERT INTO permissions VALUES("57","expenses-edit","web","2018-09-05 01:07:10","2018-09-05 01:07:10");
INSERT INTO permissions VALUES("58","expenses-delete","web","2018-09-05 01:07:11","2018-09-05 01:07:11");
INSERT INTO permissions VALUES("59","general_setting","web","2018-10-19 23:10:04","2018-10-19 23:10:04");
INSERT INTO permissions VALUES("60","mail_setting","web","2018-10-19 23:10:04","2018-10-19 23:10:04");
INSERT INTO permissions VALUES("61","pos_setting","web","2018-10-19 23:10:04","2018-10-19 23:10:04");
INSERT INTO permissions VALUES("62","hrm_setting","web","2019-01-02 10:30:23","2019-01-02 10:30:23");
INSERT INTO permissions VALUES("63","purchase-return-index","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("64","purchase-return-add","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("65","purchase-return-edit","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("66","purchase-return-delete","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("67","account-index","web","2019-01-02 22:06:13","2019-01-02 22:06:13");
INSERT INTO permissions VALUES("68","balance-sheet","web","2019-01-02 22:06:14","2019-01-02 22:06:14");
INSERT INTO permissions VALUES("69","account-statement","web","2019-01-02 22:06:14","2019-01-02 22:06:14");
INSERT INTO permissions VALUES("70","department","web","2019-01-02 22:30:01","2019-01-02 22:30:01");
INSERT INTO permissions VALUES("71","attendance","web","2019-01-02 22:30:01","2019-01-02 22:30:01");
INSERT INTO permissions VALUES("72","payroll","web","2019-01-02 22:30:01","2019-01-02 22:30:01");
INSERT INTO permissions VALUES("73","employees-index","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("74","employees-add","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("75","employees-edit","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("76","employees-delete","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("77","user-report","web","2019-01-16 06:48:18","2019-01-16 06:48:18");
INSERT INTO permissions VALUES("78","stock_count","web","2019-02-17 10:32:01","2019-02-17 10:32:01");
INSERT INTO permissions VALUES("79","adjustment","web","2019-02-17 10:32:02","2019-02-17 10:32:02");
INSERT INTO permissions VALUES("80","sms_setting","web","2019-02-22 05:18:03","2019-02-22 05:18:03");
INSERT INTO permissions VALUES("81","create_sms","web","2019-02-22 05:18:03","2019-02-22 05:18:03");
INSERT INTO permissions VALUES("82","print_barcode","web","2019-03-07 05:02:19","2019-03-07 05:02:19");
INSERT INTO permissions VALUES("83","empty_database","web","2019-03-07 05:02:19","2019-03-07 05:02:19");
INSERT INTO permissions VALUES("84","customer_group","web","2019-03-07 05:37:15","2019-03-07 05:37:15");
INSERT INTO permissions VALUES("85","unit","web","2019-03-07 05:37:15","2019-03-07 05:37:15");
INSERT INTO permissions VALUES("86","tax","web","2019-03-07 05:37:15","2019-03-07 05:37:15");
INSERT INTO permissions VALUES("87","gift_card","web","2019-03-07 06:29:38","2019-03-07 06:29:38");
INSERT INTO permissions VALUES("88","coupon","web","2019-03-07 06:29:38","2019-03-07 06:29:38");
INSERT INTO permissions VALUES("89","holiday","web","2019-10-19 08:57:15","2019-10-19 08:57:15");
INSERT INTO permissions VALUES("90","warehouse-report","web","2019-10-22 06:00:23","2019-10-22 06:00:23");
INSERT INTO permissions VALUES("91","warehouse","web","2020-02-26 06:47:32","2020-02-26 06:47:32");
INSERT INTO permissions VALUES("92","brand","web","2020-02-26 06:59:59","2020-02-26 06:59:59");
INSERT INTO permissions VALUES("93","billers-index","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("94","billers-add","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("95","billers-edit","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("96","billers-delete","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("97","money-transfer","web","2020-03-02 05:41:48","2020-03-02 05:41:48");
INSERT INTO permissions VALUES("98","category","web","2020-07-13 12:13:16","2020-07-13 12:13:16");
INSERT INTO permissions VALUES("99","delivery","web","2020-07-13 12:13:16","2020-07-13 12:13:16");
INSERT INTO permissions VALUES("100","send_notification","web","2020-10-31 06:21:31","2020-10-31 06:21:31");
INSERT INTO permissions VALUES("101","today_sale","web","2020-10-31 06:57:04","2020-10-31 06:57:04");
INSERT INTO permissions VALUES("102","today_profit","web","2020-10-31 06:57:04","2020-10-31 06:57:04");
INSERT INTO permissions VALUES("103","currency","web","2020-11-09 00:23:11","2020-11-09 00:23:11");
INSERT INTO permissions VALUES("104","backup_database","web","2020-11-15 00:16:55","2020-11-15 00:16:55");
INSERT INTO permissions VALUES("105","reward_point_setting","web","2021-06-27 04:34:42","2021-06-27 04:34:42");



CREATE TABLE `pos_setting` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `product_number` int(11) NOT NULL,
  `keybord_active` tinyint(1) NOT NULL,
  `stripe_public_key` varchar(191) DEFAULT NULL,
  `stripe_secret_key` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `pos_setting_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pos_setting VALUES("1","7","4","1","5","1","pk_test_ITN7KOYiIsHSCQ0UMRcgaYUB","sk_test_TtQQaawhEYRwa3mU9CzttrEy","2018-09-02 03:17:04","2024-09-16 14:20:08");



CREATE TABLE `product_adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adjustment_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `action` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_adjustments VALUES("1","1","11","","1","+","2024-08-14 13:03:43","2024-08-14 13:03:43");



CREATE TABLE `product_batches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `batch_no` varchar(191) NOT NULL,
  `expired_date` date NOT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_batches VALUES("1","3","455","2025-02-26","3","2024-08-13 10:11:56","2024-09-10 09:32:43");
INSERT INTO product_batches VALUES("2","12","123","2026-08-23","-2","2024-08-22 13:39:11","2024-09-13 03:35:07");
INSERT INTO product_batches VALUES("3","12","00123","2026-08-23","21","2024-08-22 13:41:44","2024-08-22 16:17:58");



CREATE TABLE `product_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `recieved` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_purchases VALUES("1","1","2","","","","8","8","1","50","0","13","52","452","2024-08-01 17:00:56","2024-08-01 17:00:56");
INSERT INTO product_purchases VALUES("2","2","2","","","","1","0","1","50","0","13","6.5","56.5","2024-08-12 19:48:24","2024-08-12 19:48:24");
INSERT INTO product_purchases VALUES("3","2","1","","","","4","4","1","150","0","13","78","678","2024-08-12 19:48:24","2024-08-12 19:48:24");
INSERT INTO product_purchases VALUES("4","3","4","","","","9","9","1","100","0","0","0","900","2024-08-13 10:11:56","2024-08-13 10:11:56");
INSERT INTO product_purchases VALUES("5","3","9","","","","10","10","1","10","0","0","0","100","2024-08-13 10:11:56","2024-08-13 10:11:56");
INSERT INTO product_purchases VALUES("6","3","3","1","","","8","8","1","2000","0","0","0","16000","2024-08-13 10:11:56","2024-08-13 10:11:56");
INSERT INTO product_purchases VALUES("7","3","7","","","","11","11","1","17","0","0","0","187","2024-08-13 10:11:56","2024-08-13 10:11:56");
INSERT INTO product_purchases VALUES("8","3","11","","","","9","9","1","1000","0","0","0","9000","2024-08-13 10:11:56","2024-08-13 10:11:56");
INSERT INTO product_purchases VALUES("9","4","11","","","","3","3","1","1000","0","0","0","3000","2024-08-14 13:08:33","2024-08-14 13:08:33");
INSERT INTO product_purchases VALUES("10","5","12","2","","","20","20","1","15.93","0","13","41.42","360","2024-08-22 13:39:11","2024-08-22 13:39:11");
INSERT INTO product_purchases VALUES("11","6","12","3","","","30","30","1","15.93","0","13","62.12","540","2024-08-22 13:41:44","2024-08-22 13:41:44");
INSERT INTO product_purchases VALUES("12","7","14","","","","100","100","3","100","0","0","0","10000","2024-09-02 11:48:19","2024-09-02 11:48:19");
INSERT INTO product_purchases VALUES("13","8","15","","","","100","100","3","1200","0","0","0","120000","2024-09-03 08:23:00","2024-09-03 08:23:00");
INSERT INTO product_purchases VALUES("14","9","17","","","","54","54","3","26","0","0","0","1404","2024-09-13 12:05:19","2024-09-13 12:05:19");
INSERT INTO product_purchases VALUES("15","10","22","","","","368","368","3","1.5","0","0","0","552","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO product_purchases VALUES("16","10","21","","","","609","609","3","1.8","0","0","0","1096.2","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO product_purchases VALUES("17","10","20","","","","24","24","3","2.2","0","0","0","52.8","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO product_purchases VALUES("18","10","19","","","","761","761","3","1.2","0","0","0","913.2","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO product_purchases VALUES("19","10","18","","","","2","2","3","1.5","0","0","0","3","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO product_purchases VALUES("20","11","24","","","","2","2","3","200","0","16","64","464","2024-09-15 23:41:03","2024-09-15 23:41:03");
INSERT INTO product_purchases VALUES("21","12","26","","","","1","1","2","100","0","0","0","100","2024-09-16 15:04:38","2024-09-16 15:04:38");
INSERT INTO product_purchases VALUES("22","12","26","","","","10","10","2","100","0","0","0","1000","2024-09-16 14:22:03","2024-09-16 14:22:03");
INSERT INTO product_purchases VALUES("23","14","27","","","","10","10","3","1.2","0","0","0","12","2024-09-17 05:27:55","2024-09-17 05:27:55");
INSERT INTO product_purchases VALUES("24","15","28","","","","224","224","3","0.69","0","0","0","154.56","2024-09-17 05:45:53","2024-09-17 05:45:53");
INSERT INTO product_purchases VALUES("25","16","18","","","","12","12","3","1.5","0","0","0","18","2024-10-04 04:00:20","2024-10-04 04:00:20");
INSERT INTO product_purchases VALUES("26","17","32","","","","1","1","3","12","0","0","0","12","2024-10-09 07:03:08","2024-10-09 07:03:08");
INSERT INTO product_purchases VALUES("27","18","33","","","","2","2","3","1200","0","0","0","2400","2024-10-09 07:35:04","2024-10-09 07:35:04");



CREATE TABLE `product_quotation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_quotation VALUES("1","1","12","2","","15","1","265.49","0","13","517.7","4500","2024-08-22 13:47:32","2024-08-22 13:49:51");
INSERT INTO product_quotation VALUES("2","2","4","","","1","1","4590","0","0","0","4590","2024-08-25 07:38:26","2024-08-25 07:38:26");
INSERT INTO product_quotation VALUES("3","3","27","","","1","3","3.8","0","0","0","3.8","2024-10-07 14:28:35","2024-10-07 14:28:35");



CREATE TABLE `product_returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_returns VALUES("1","1","11","","","","1","1","900","0","0","0","900","2024-08-14 13:06:23","2024-08-14 13:06:23");
INSERT INTO product_returns VALUES("2","2","4","","","","1.5","1","75","0","0","0","112.5","2024-09-11 17:48:44","2024-09-11 17:48:44");



CREATE TABLE `product_sales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_sales VALUES("1","1","2","","","","1","1","20","0","13","2.6","22.6","2024-08-10 13:56:22","2024-08-10 13:56:22");
INSERT INTO product_sales VALUES("2","2","2","","","","1","1","20","0","13","2.6","22.6","2024-08-12 12:36:20","2024-08-12 12:36:20");
INSERT INTO product_sales VALUES("3","3","2","","","","3","1","20","0","13","7.8","67.8","2024-08-12 19:51:16","2024-08-12 19:51:16");
INSERT INTO product_sales VALUES("4","4","1","","","","1","1","600","0","13","78","678","2024-08-12 19:57:02","2024-08-12 19:57:02");
INSERT INTO product_sales VALUES("5","4","2","","","","2","1","20","0","13","5.2","45.2","2024-08-12 19:57:02","2024-08-12 19:57:02");
INSERT INTO product_sales VALUES("6","5","3","1","","","1","1","1500","0","0","0","1500","2024-08-13 11:01:04","2024-08-13 11:01:04");
INSERT INTO product_sales VALUES("7","5","1","","","","1","1","600","0","13","78","678","2024-08-13 11:01:04","2024-08-13 11:01:04");
INSERT INTO product_sales VALUES("8","5","11","","","","1","1","900","0","0","0","900","2024-08-13 11:01:04","2024-08-13 11:01:04");
INSERT INTO product_sales VALUES("9","6","4","","","","2","1","75","0","0","0","150","2024-08-13 13:08:17","2024-08-13 13:08:17");
INSERT INTO product_sales VALUES("10","7","3","1","","","1","1","1500","0","0","0","1500","2024-08-15 09:42:56","2024-08-15 09:42:56");
INSERT INTO product_sales VALUES("11","7","7","","","","1","1","15","0","0","0","15","2024-08-15 09:42:56","2024-08-15 09:42:56");
INSERT INTO product_sales VALUES("12","8","7","","","","1","1","225","0","0","0","225","2024-08-15 10:18:08","2024-08-15 10:18:08");
INSERT INTO product_sales VALUES("13","9","2","","","","1","1","300","0","13","39","339","2024-08-15 10:52:59","2024-08-15 10:52:59");
INSERT INTO product_sales VALUES("14","10","11","","","","1","1","13500","0","0","0","13500","2024-08-15 12:10:01","2024-08-15 12:10:01");
INSERT INTO product_sales VALUES("15","10","1","","","","1","1","9000","0","13","1170","10170","2024-08-15 12:10:01","2024-08-15 12:10:01");
INSERT INTO product_sales VALUES("16","10","7","","","","3","1","225","0","0","0","675","2024-08-15 12:10:01","2024-08-15 12:10:01");
INSERT INTO product_sales VALUES("17","11","11","","","","4","1","13500","0","0","0","54000","2024-08-15 13:49:33","2024-08-15 13:49:33");
INSERT INTO product_sales VALUES("18","11","9","","","","1","1","105","0","0","0","105","2024-08-15 13:49:33","2024-08-15 13:49:33");
INSERT INTO product_sales VALUES("19","11","7","","","","1","1","225","0","0","0","225","2024-08-15 13:49:33","2024-08-15 13:49:33");
INSERT INTO product_sales VALUES("20","12","11","","","","1","1","13500","0","0","0","13500","2024-08-15 15:38:51","2024-08-15 15:38:51");
INSERT INTO product_sales VALUES("21","12","7","","","","1","1","225","0","0","0","225","2024-08-15 15:38:51","2024-08-15 15:38:51");
INSERT INTO product_sales VALUES("22","13","7","","","","2","1","225","0","0","0","450","2024-08-17 14:11:10","2024-08-17 14:11:10");
INSERT INTO product_sales VALUES("23","14","7","","","","1","1","225","0","0","0","225","2024-08-17 14:16:28","2024-08-17 14:16:28");
INSERT INTO product_sales VALUES("24","15","7","","","","1","1","225","0","0","0","225","2024-08-17 14:17:00","2024-08-17 14:17:00");
INSERT INTO product_sales VALUES("25","16","11","","","","1","1","13500","0","0","0","13500","2024-08-17 14:18:41","2024-08-17 14:18:41");
INSERT INTO product_sales VALUES("26","17","1","","","","1","1","9000","0","13","1170","10170","2024-08-20 18:49:13","2024-08-20 18:49:13");
INSERT INTO product_sales VALUES("27","18","3","1","","","4","1","22500","0","0","0","90000","2024-08-22 13:27:13","2024-08-22 13:27:13");
INSERT INTO product_sales VALUES("28","19","12","3","","","1","1","258.62","0","16","41.38","300","2024-08-22 14:11:05","2024-08-22 14:11:05");
INSERT INTO product_sales VALUES("29","20","12","3","","","8","1","1055.17","0","16","1350.62","9792","2024-08-22 16:17:58","2024-08-22 16:17:58");
INSERT INTO product_sales VALUES("30","21","7","","","","1","1","918","0","0","0","918","2024-08-23 12:58:07","2024-08-23 12:58:07");
INSERT INTO product_sales VALUES("31","21","4","","","","3","1","4590","0","0","0","13770","2024-08-23 12:58:07","2024-08-23 12:58:07");
INSERT INTO product_sales VALUES("32","21","9","","","","3","1","428.4","0","0","0","1285.2","2024-08-23 12:58:07","2024-08-23 12:58:07");
INSERT INTO product_sales VALUES("33","21","11","","","","3","1","55080","0","0","0","165240","2024-08-23 12:58:07","2024-08-23 12:58:07");
INSERT INTO product_sales VALUES("34","22","3","1","","","1","1","91800","0","0","0","91800","2024-08-23 21:39:37","2024-08-23 21:39:37");
INSERT INTO product_sales VALUES("35","22","4","","","","2","1","4590","0","0","0","9180","2024-08-23 21:39:37","2024-08-23 21:39:37");
INSERT INTO product_sales VALUES("36","24","14","","","","1","3","120","0","0","0","120","2024-09-02 11:48:53","2024-09-02 11:48:53");
INSERT INTO product_sales VALUES("37","25","3","1","","","1","1","1500","0","0","0","1500","2024-09-03 20:52:57","2024-09-03 20:52:57");
INSERT INTO product_sales VALUES("38","26","9","","","","2","1","7","0","0","0","14","2024-09-06 06:56:41","2024-09-06 06:56:41");
INSERT INTO product_sales VALUES("39","26","15","","","","2","3","1600","0","0","0","3200","2024-09-06 06:56:41","2024-09-06 06:56:41");
INSERT INTO product_sales VALUES("40","26","12","2","","","2","1","17.24","0","16","5.52","40","2024-09-06 06:56:41","2024-09-06 06:56:41");
INSERT INTO product_sales VALUES("41","26","11","","","","2","1","900","0","0","0","1800","2024-09-06 06:56:41","2024-09-06 06:56:41");
INSERT INTO product_sales VALUES("42","27","7","","","","1","1","15","0","0","0","15","2024-09-10 09:32:43","2024-09-10 09:32:43");
INSERT INTO product_sales VALUES("43","27","4","","","","1","1","75","0","0","0","75","2024-09-10 09:32:43","2024-09-10 09:32:43");
INSERT INTO product_sales VALUES("44","27","3","1","","","1","1","1500","0","0","0","1500","2024-09-10 09:32:43","2024-09-10 09:32:43");
INSERT INTO product_sales VALUES("45","28","4","","","","1","1","75","0","0","0","75","2024-09-11 17:35:17","2024-09-11 17:35:17");
INSERT INTO product_sales VALUES("46","28","9","","","","1","1","7","0","0","0","7","2024-09-11 17:35:17","2024-09-11 17:35:17");
INSERT INTO product_sales VALUES("47","28","11","","","","1","1","900","0","0","0","900","2024-09-11 17:35:17","2024-09-11 17:35:17");
INSERT INTO product_sales VALUES("48","29","12","2","","","4.5","1","17.24","0","16","12.41","90","2024-09-11 17:46:15","2024-09-11 17:46:15");
INSERT INTO product_sales VALUES("49","30","12","2","","","4.5","1","17.24","0","16","12.41","90","2024-09-11 17:46:23","2024-09-11 17:46:23");
INSERT INTO product_sales VALUES("51","32","22","","","","1","3","4.5","0","0","0","4.5","2024-09-13 13:24:00","2024-09-13 13:24:00");
INSERT INTO product_sales VALUES("52","32","21","","","","1","3","5.5","0","0","0","5.5","2024-09-13 13:24:00","2024-09-13 13:24:00");
INSERT INTO product_sales VALUES("53","32","20","","","","1","3","6.5","0","0","0","6.5","2024-09-13 13:24:00","2024-09-13 13:24:00");
INSERT INTO product_sales VALUES("54","32","19","","","","1","3","3.8","0","0","0","3.8","2024-09-13 13:24:00","2024-09-13 13:24:00");
INSERT INTO product_sales VALUES("55","33","24","","","","2","3","250","0","16","80","580","2024-09-15 23:47:09","2024-09-15 23:47:09");
INSERT INTO product_sales VALUES("56","35","4","","","","5","1","4590","0","0","0","22950","2024-09-16 00:14:21","2024-09-16 00:29:24");
INSERT INTO product_sales VALUES("57","36","26","","","","1","2","200","0","0","0","200","2024-09-16 15:07:39","2024-09-16 15:07:39");
INSERT INTO product_sales VALUES("58","37","4","","","","1","1","4590","0","0","0","4590","2024-09-16 15:11:35","2024-09-16 15:11:35");
INSERT INTO product_sales VALUES("59","38","26","","","","1","2","1800","0","0","0","1800","2024-09-16 14:24:21","2024-09-16 14:24:21");
INSERT INTO product_sales VALUES("60","39","27","","","","1","3","34.2","0","0","0","34.2","2024-09-17 05:28:14","2024-09-17 05:28:14");
INSERT INTO product_sales VALUES("61","40","28","","","","1","3","16.2","0","0","0","16.2","2024-09-17 05:46:11","2024-09-17 05:46:11");
INSERT INTO product_sales VALUES("62","41","26","","","","1","2","1800","0","0","0","1800","2024-09-17 15:30:06","2024-09-17 15:30:06");
INSERT INTO product_sales VALUES("63","42","26","","","","5","2","200","0","0","0","1000","2024-09-26 17:12:35","2024-09-26 17:12:35");
INSERT INTO product_sales VALUES("64","43","27","","","","1","3","3.8","0","0","0","3.8","2024-09-27 12:11:40","2024-09-27 12:11:40");
INSERT INTO product_sales VALUES("65","44","27","","","","1","3","3.8","0","0","0","3.8","2024-10-04 04:02:32","2024-10-04 04:02:32");
INSERT INTO product_sales VALUES("66","45","27","","","","1","3","3.8","0","0","0","3.8","2024-10-04 04:02:45","2024-10-04 04:02:45");
INSERT INTO product_sales VALUES("67","46","27","","","","3","3","3.8","0","0","0","11.4","2024-10-06 15:50:49","2024-10-06 15:50:49");
INSERT INTO product_sales VALUES("68","47","30","","","","3","0","1000","0","0","0","3000","2024-10-06 16:03:31","2024-10-06 16:03:31");
INSERT INTO product_sales VALUES("69","48","27","","","","1","3","3.8","0","0","0","3.8","2024-10-10 05:35:39","2024-10-10 05:35:39");
INSERT INTO product_sales VALUES("70","49","27","","","","1","3","3.8","0","0","0","3.8","2024-10-10 07:24:35","2024-10-10 07:24:35");



CREATE TABLE `product_transfer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_variants` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  `item_code` varchar(191) NOT NULL,
  `additional_price` double DEFAULT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_variants VALUES("1","17","1","1","Black-DT019HG22","12000","0","2024-10-04 03:56:03","2024-10-04 03:56:03");
INSERT INTO product_variants VALUES("2","17","2","2","White-DT019HG22","11500","0","2024-10-04 03:56:03","2024-10-04 03:56:03");



CREATE TABLE `product_warehouse` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` varchar(191) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `warehouse_id` int(11) NOT NULL,
  `qty` double NOT NULL,
  `price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_warehouse VALUES("1","2","","","","1","0","","2024-08-01 17:00:56","2024-08-15 10:52:59");
INSERT INTO product_warehouse VALUES("2","1","","","","1","0","","2024-08-12 19:48:24","2024-08-20 18:49:13");
INSERT INTO product_warehouse VALUES("3","4","","","","1","-4.5","","2024-08-13 10:11:56","2024-09-16 15:11:35");
INSERT INTO product_warehouse VALUES("4","9","","","","1","3","","2024-08-13 10:11:56","2024-09-11 17:35:17");
INSERT INTO product_warehouse VALUES("5","3","1","","","1","3","","2024-08-13 10:11:56","2024-09-10 09:32:43");
INSERT INTO product_warehouse VALUES("6","7","","","","1","0","","2024-08-13 10:11:56","2024-09-10 09:32:43");
INSERT INTO product_warehouse VALUES("7","11","","","","1","0","","2024-08-13 10:11:56","2024-09-11 17:35:17");
INSERT INTO product_warehouse VALUES("8","12","2","","","1","9","","2024-08-22 13:39:11","2024-09-13 03:35:07");
INSERT INTO product_warehouse VALUES("9","12","3","","","1","21","","2024-08-22 13:41:44","2024-08-22 16:17:58");
INSERT INTO product_warehouse VALUES("10","14","","","","1","99","","2024-09-02 11:48:19","2024-09-02 11:48:53");
INSERT INTO product_warehouse VALUES("11","15","","","","1","98","","2024-09-03 08:23:00","2024-09-06 06:56:41");
INSERT INTO product_warehouse VALUES("12","17","","","","3","54","","2024-09-13 12:05:19","2024-09-13 12:05:19");
INSERT INTO product_warehouse VALUES("13","22","","","","3","367","","2024-09-13 13:22:43","2024-09-13 13:24:00");
INSERT INTO product_warehouse VALUES("14","21","","","","3","608","","2024-09-13 13:22:43","2024-09-13 13:24:00");
INSERT INTO product_warehouse VALUES("15","20","","","","3","23","","2024-09-13 13:22:43","2024-09-13 13:24:00");
INSERT INTO product_warehouse VALUES("16","19","","","","3","760","","2024-09-13 13:22:43","2024-09-13 13:24:00");
INSERT INTO product_warehouse VALUES("17","18","","","","3","2","","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO product_warehouse VALUES("18","24","","","","2","0","","2024-09-15 23:41:03","2024-09-15 23:47:09");
INSERT INTO product_warehouse VALUES("19","26","","","","1","0","","2024-09-16 15:04:38","2024-09-16 15:07:39");
INSERT INTO product_warehouse VALUES("20","26","","","","4","3","","2024-09-16 14:22:03","2024-09-26 17:12:35");
INSERT INTO product_warehouse VALUES("21","27","","","","4","2","","2024-09-17 05:27:55","2024-10-10 05:35:39");
INSERT INTO product_warehouse VALUES("22","28","","","","4","223","","2024-09-17 05:45:53","2024-09-17 05:46:11");
INSERT INTO product_warehouse VALUES("23","18","","","","4","12","","2024-10-04 04:00:20","2024-10-04 04:00:20");
INSERT INTO product_warehouse VALUES("24","32","","","","6","1","","2024-10-09 07:03:08","2024-10-09 07:03:08");
INSERT INTO product_warehouse VALUES("25","33","","","","7","2","","2024-10-09 07:35:04","2024-10-09 07:35:04");



CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `barcode_symbology` varchar(191) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `cost` varchar(191) NOT NULL,
  `price` varchar(191) NOT NULL,
  `qty` double DEFAULT NULL,
  `alert_quantity` double DEFAULT NULL,
  `promotion` tinyint(4) DEFAULT NULL,
  `promotion_price` varchar(191) DEFAULT NULL,
  `starting_date` varchar(200) DEFAULT NULL,
  `last_date` date DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_method` int(11) DEFAULT NULL,
  `image` longtext DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `is_variant` tinyint(1) DEFAULT NULL,
  `is_batch` tinyint(1) DEFAULT NULL,
  `is_diffPrice` tinyint(1) DEFAULT NULL,
  `is_imei` tinyint(1) DEFAULT NULL,
  `featured` tinyint(4) DEFAULT NULL,
  `product_list` varchar(191) DEFAULT NULL,
  `variant_list` varchar(191) DEFAULT NULL,
  `qty_list` varchar(191) DEFAULT NULL,
  `price_list` varchar(191) DEFAULT NULL,
  `product_details` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO products VALUES("1","Filtro hmef","35520949","standard","C128","1","1","1","1","1","150","600","0","300","","","2024-07-06","","1","1","202407060804112.jpg","","","","0","","1","","","","","<p>Filtro hmef&nbsp;</p>","0","2024-07-06 20:02:55","2024-09-13 13:10:55");
INSERT INTO products VALUES("2","a","1234569","standard","C128","1","1","1","1","1","50","20","0","5","","","","","1","1","zummXD2dvAtI.png","","","","","","1","","","","","","0","2024-08-01 16:57:53","2024-09-13 13:10:55");
INSERT INTO products VALUES("3","ordinateur","ORDI","standard","C128","","1","1","1","1","2000","1500","3","10","1","1400","2024-08-26","2024-08-26","","1","1723538947199ordi.jpg","","","1","0","","1","","","","","","0","2024-08-13 09:50:04","2024-09-13 13:10:55");
INSERT INTO products VALUES("4","Clavier","CLAV","standard","C128","","1","1","1","1","100","75","-4.5","10","","","","","","1","1723539056942images.jpg","","","","","","1","","","","","","0","2024-08-13 09:51:01","2024-09-16 15:11:35");
INSERT INTO products VALUES("5","RAM","RAM","standard","C128","","1","1","1","1","15","10","0","15","","","","","","1","1723539180911ram.jpg","","","","","","1","","","","","","0","2024-08-13 09:53:07","2024-09-13 13:10:55");
INSERT INTO products VALUES("6","Cable RJ","CRJ","standard","C128","","1","1","1","1","10","7","0","20","","","","","1","1","1723539243661cable.jpg","","","","","","1","","","","","","0","2024-08-13 09:54:07","2024-09-13 13:10:55");
INSERT INTO products VALUES("7","Souris","SOURIS","standard","C128","","1","1","1","1","17","15","0","10","","","","","","1","1723539309168souris.jpg","","","","","","1","","","","","","0","2024-08-13 09:55:14","2024-09-13 13:10:55");
INSERT INTO products VALUES("8","Carte Mere","CARTE","standard","C128","","1","1","1","1","1000","900","0","10","","","","","","1","1723539749791carte mere.jpg","","","","","","1","","","","","","0","2024-08-13 10:02:41","2024-09-13 13:10:55");
INSERT INTO products VALUES("9","Resistance","RESISTANCE","standard","C128","","1","1","1","1","10","7","3","20","","","","","","1","1723539839704resistance.jpg","","","","0","","1","","","","","","0","2024-08-13 10:04:03","2024-09-13 13:10:55");
INSERT INTO products VALUES("10","Batterie","BATTERIE","standard","C128","","1","1","1","1","190","100","0","10","","","","","","1","1723539925438batterie.jpg","","","","","","1","","","","","","0","2024-08-13 10:05:28","2024-09-13 13:10:55");
INSERT INTO products VALUES("11","Scanner","SCANNER","standard","C128","","1","1","1","1","1000","900","0","10","","","","","","1","1723540178765scanner.jpg","","","","","","1","","","","","","0","2024-08-13 10:09:44","2024-09-13 13:10:55");
INSERT INTO products VALUES("12","Paracetamol","43791933","standard","EAN13","","1","1","1","1","18","20","30","20","","","","","1","2","zummXD2dvAtI.png","","","1","","","1","","","","","","0","2024-08-22 13:32:14","2024-09-13 13:10:55");
INSERT INTO products VALUES("13","ERP","2222","standard","C128","2","2","3","3","3","1000","1400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","Erpsolution for B2B","0","2024-08-24 16:06:39","2024-09-13 13:11:01");
INSERT INTO products VALUES("14","Kash","3322","standard","C128","2","2","3","3","3","100","120","99","3","","","","","","1","1725270412938EDI_IMG_29.jpg","","","","","","","","","","","","0","2024-09-02 11:47:14","2024-09-13 13:11:01");
INSERT INTO products VALUES("15","Necklace","2255","standard","C128","2","2","3","3","3","1200","1600","98","10","","","","","","1","1725344516612jpeg-optimizer_NECK_05.jpg","","","1","0","","1","","","","","","0","2024-09-03 08:22:13","2024-09-13 13:11:01");
INSERT INTO products VALUES("16","Bag","83329575","standard","C128","2","1","3","3","3","15","200","0","1","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","0","2024-09-03 20:42:06","2024-09-13 13:10:55");
INSERT INTO products VALUES("17","Agave Big Leaves 95CM","DT019HG22","standard","C128","4","4","3","3","3","26","78","54","15","","","","","","2","zummXD2dvAtI.png","","1","","0","1","1","","","","","<ul>
<li>&nbsp;</li>
</ul>","1","2024-09-13 11:43:12","2024-10-04 03:56:03");
INSERT INTO products VALUES("18","Brazil Sword Leaves 49Cm 12 Heads","DT019M143","standard","C128","4","5","3","3","3","1.5","4.5","13","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-13 13:16:35","2024-10-04 04:00:20");
INSERT INTO products VALUES("19","Illicum Verum Leaves 12 Heads 38cm","DT019M147","standard","C128","4","5","3","3","3","1.20","3.80","760","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-13 13:17:18","2024-09-13 13:24:00");
INSERT INTO products VALUES("20","Phoenix Fern Leaves 45Cm 12 Heads","DT019M131","standard","C128","4","5","3","3","3","2.20","6.50","23","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-13 13:18:12","2024-09-13 13:24:00");
INSERT INTO products VALUES("21","Asplenium Nidus Leaves 12 Heads 52Cm","DT019M141","standard","C128","4","5","3","3","3","1.80","5.50","608","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-13 13:18:58","2024-09-13 13:24:00");
INSERT INTO products VALUES("22","Heads Of Sword Leaves 49Cm 12 Head","DT019M144","standard","C128","4","5","3","3","3","1.50","4.50","367","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-13 13:19:44","2024-09-13 13:24:00");
INSERT INTO products VALUES("23","fekon","63207340","standard","C128","2","5","1","1","1","525","528","0","510","","","","","","1","1726290033214IMG_0356.JPG","","","","","","","","","","","","1","2024-09-14 07:04:05","2024-09-14 07:04:05");
INSERT INTO products VALUES("24","FEKON WHITE","81730282","standard","C39","","4","3","3","3","200","250","0","0","","","","","1","1","1726335611591278093189_1909584432584381_3872810876739534730_n.jpg","","","","","","","","","","","","1","2024-09-14 19:40:26","2024-09-15 23:47:09");
INSERT INTO products VALUES("25","Winston light","W24","standard","C128","","4","2","2","2","31","32","0","1","","","","","1","2","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-15 23:54:44","2024-09-15 23:54:44");
INSERT INTO products VALUES("26","SOURI LOGITECH","5099206111998","standard","C39","5","6","2","2","2","100","200","3","10","","","","","","2","zummXD2dvAtI.png","","","","0","","0","","","","","","1","2024-09-16 14:54:26","2024-09-26 17:12:35");
INSERT INTO products VALUES("27","Bracken Fern Leaves 47Cm 17 Heads","DT019M202","standard","C128","4","5","3","3","3","1.20","3.80","2","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-17 05:27:16","2024-10-10 05:35:39");
INSERT INTO products VALUES("28","Anthurium Ultraviolet-Proof 40Cm","DT018N168-B","standard","C128","4","5","3","3","3","0.69","1.80","223","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-17 05:45:24","2024-09-17 05:46:11");
INSERT INTO products VALUES("29","Screw country geyor","06369911","standard","C128","2","5","3","3","3","290","460","0","5","","","","","2","2","1727427411428IMG_3744.jpeg","","","1","","","","","","","","<p>ماتور علف اصلي لسحن سلسلة اعلاف دجاج بياض وأمهات</p>","1","2024-09-27 09:58:18","2024-09-27 09:58:18");
INSERT INTO products VALUES("30","admin","75318529","service","UPCE","3","5","0","0","0","0","1000","0","","","","","","","2","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-09-27 12:00:25","2024-09-27 12:00:25");
INSERT INTO products VALUES("31","Huil","128","standard","C128","","7","3","3","3","25000","26000","0","30","","","","","","1","zummXD2dvAtI.png","","","","","","1","","","","","","1","2024-10-02 09:27:03","2024-10-02 09:27:03");
INSERT INTO products VALUES("32","kash","112233","standard","C128","4","6","3","3","3","12","20","1","100","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-10-09 07:02:14","2024-10-09 07:03:08");
INSERT INTO products VALUES("33","Jaquar classic gold","Fr-77760URY","standard","C128","2","6","3","3","3","1200","2050","2","10","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-10-09 07:34:32","2024-10-09 07:35:04");



CREATE TABLE `purchase_product_return` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `paid_amount` double NOT NULL,
  `status` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchases VALUES("1","pr-20240801-050056","1","1","","1","8","0","52","452","0","0","","","452","452","1","2","","","2024-08-01 17:00:56","2024-08-01 17:05:38");
INSERT INTO purchases VALUES("2","pr-20240812-074824","1","1","","2","5","0","84.5","734.5","0","0","","","734.5","0","4","1","","","2024-08-12 19:48:24","2024-08-12 19:48:24");
INSERT INTO purchases VALUES("3","pr-20240813-101156","1","1","","5","47","0","0","26187","0","0","","1000","27187","0","1","1","","","2024-08-13 10:11:56","2024-08-13 10:11:56");
INSERT INTO purchases VALUES("4","pr-20240814-010833","1","1","","1","3","0","0","3000","0","0","","","3000","0","1","1","","","2024-08-14 13:08:33","2024-08-14 13:08:33");
INSERT INTO purchases VALUES("5","pr-20240822-013911","1","1","","1","20","0","41.42","360","0","0","","","360","360","1","2","","","2024-08-22 13:39:11","2024-08-22 13:40:25");
INSERT INTO purchases VALUES("6","pr-20240822-014144","1","1","","1","30","0","62.12","540","0","0","","","540","500","1","1","","","2024-08-22 13:41:44","2024-08-22 13:42:21");
INSERT INTO purchases VALUES("7","pr-20240902-114819","1","1","","1","100","0","0","10000","0","0","","","10000","0","1","1","","","2024-09-02 11:48:19","2024-09-02 11:48:19");
INSERT INTO purchases VALUES("8","pr-20240903-082300","1","1","","1","100","0","0","120000","0","0","","","120000","0","1","1","","","2024-09-03 08:23:00","2024-09-03 08:23:00");
INSERT INTO purchases VALUES("9","pr-20240913-120519","1","3","1","1","54","0","0","1404","0","0","","","1404","0","1","1","","","2024-09-13 12:05:19","2024-09-13 12:05:19");
INSERT INTO purchases VALUES("10","pr-20240913-012243","1","3","1","5","1764","0","0","2617.2","0","0","","","2617.2","0","1","1","","","2024-09-13 13:22:43","2024-09-13 13:22:43");
INSERT INTO purchases VALUES("11","pr-20240915-114103","1","2","1","1","2","0","64","464","16","74.24","","","538.24","0","1","1","","","2024-09-15 23:41:03","2024-09-15 23:41:03");
INSERT INTO purchases VALUES("12","pr-20240916-030438","1","1","1","1","1","0","0","100","20","20","","","120","0","1","1","","","2024-09-16 15:04:38","2024-09-16 15:04:38");
INSERT INTO purchases VALUES("13","pr-20240916-022203","1","4","","1","10","0","0","1000","20","200","","","1200","0","1","1","","","2024-09-16 14:22:03","2024-09-16 14:22:03");
INSERT INTO purchases VALUES("14","pr-20240917-052755","1","4","1","1","10","0","0","12","0","0","","","12","0","1","1","","","2024-09-17 05:27:55","2024-09-17 05:27:55");
INSERT INTO purchases VALUES("15","pr-20240917-054553","1","4","1","1","224","0","0","154.56","0","0","","","154.56","0","1","1","","","2024-09-17 05:45:53","2024-09-17 05:45:53");
INSERT INTO purchases VALUES("16","pr-20241004-040020","1","4","","1","12","0","0","18","0","0","","","18","0","1","1","","","2024-10-04 04:00:20","2024-10-04 04:00:20");
INSERT INTO purchases VALUES("17","pr-20241009-070308","1","6","1","1","1","0","0","12","0","0","","","12","0","1","1","","","2024-10-09 07:03:08","2024-10-09 07:03:08");
INSERT INTO purchases VALUES("18","pr-20241009-073504","1","7","1","1","2","0","0","2400","0","0","","","2400","0","1","1","","","2024-10-09 07:35:04","2024-10-09 07:35:04");



CREATE TABLE `quotations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `quotation_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO quotations VALUES("1","qr-20240822-014732","1","1","","5","1","1","15","0","517.7","4500","0","0","0","0","4500","2","","","2024-08-22 13:47:32","2024-08-22 13:49:51");
INSERT INTO quotations VALUES("2","qr-20240825-073826","1","1","","1","1","1","1","0","0","4590","0","0","","","4590","1","","Vshsjssnsn
Shshshshs
Shshsusisiskama
Shsjskssksk","2024-08-25 07:38:26","2024-08-25 07:38:26");
INSERT INTO quotations VALUES("3","qr-20241007-022835","1","1","1","1","4","1","1","0","0","3.8","0","0","","","3.8","1","","","2024-10-07 14:28:35","2024-10-07 14:28:35");



CREATE TABLE `return_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO returns VALUES("1","rr-20240814-010623","1","1","1","1","1","1","1","1","0","0","900","0","0","900","","","","2024-08-14 13:06:23","2024-08-14 13:06:23");
INSERT INTO returns VALUES("2","rr-20240911-054844","1","2","1","1","1","1","1","1.5","0","0","112.5","0","0","112.5","","","","2024-09-11 17:48:44","2024-09-11 17:48:44");



CREATE TABLE `reward_point_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `per_point_amount` double NOT NULL,
  `minimum_amount` double NOT NULL,
  `duration` int(11) DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO reward_point_settings VALUES("1","300","1000","1","Year","1","2021-06-08 15:40:15","2021-06-27 05:20:55");



CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES("4","1");
INSERT INTO role_has_permissions VALUES("4","2");
INSERT INTO role_has_permissions VALUES("4","4");
INSERT INTO role_has_permissions VALUES("5","1");
INSERT INTO role_has_permissions VALUES("5","2");
INSERT INTO role_has_permissions VALUES("6","1");
INSERT INTO role_has_permissions VALUES("6","2");
INSERT INTO role_has_permissions VALUES("6","4");
INSERT INTO role_has_permissions VALUES("7","1");
INSERT INTO role_has_permissions VALUES("7","2");
INSERT INTO role_has_permissions VALUES("7","4");
INSERT INTO role_has_permissions VALUES("8","1");
INSERT INTO role_has_permissions VALUES("8","2");
INSERT INTO role_has_permissions VALUES("8","4");
INSERT INTO role_has_permissions VALUES("9","1");
INSERT INTO role_has_permissions VALUES("9","2");
INSERT INTO role_has_permissions VALUES("9","4");
INSERT INTO role_has_permissions VALUES("10","1");
INSERT INTO role_has_permissions VALUES("10","2");
INSERT INTO role_has_permissions VALUES("11","1");
INSERT INTO role_has_permissions VALUES("11","2");
INSERT INTO role_has_permissions VALUES("12","1");
INSERT INTO role_has_permissions VALUES("12","2");
INSERT INTO role_has_permissions VALUES("12","4");
INSERT INTO role_has_permissions VALUES("12","6");
INSERT INTO role_has_permissions VALUES("12","7");
INSERT INTO role_has_permissions VALUES("13","1");
INSERT INTO role_has_permissions VALUES("13","2");
INSERT INTO role_has_permissions VALUES("13","4");
INSERT INTO role_has_permissions VALUES("13","6");
INSERT INTO role_has_permissions VALUES("13","7");
INSERT INTO role_has_permissions VALUES("14","1");
INSERT INTO role_has_permissions VALUES("14","2");
INSERT INTO role_has_permissions VALUES("14","6");
INSERT INTO role_has_permissions VALUES("14","7");
INSERT INTO role_has_permissions VALUES("15","1");
INSERT INTO role_has_permissions VALUES("15","2");
INSERT INTO role_has_permissions VALUES("15","6");
INSERT INTO role_has_permissions VALUES("15","7");
INSERT INTO role_has_permissions VALUES("16","1");
INSERT INTO role_has_permissions VALUES("16","2");
INSERT INTO role_has_permissions VALUES("17","1");
INSERT INTO role_has_permissions VALUES("17","2");
INSERT INTO role_has_permissions VALUES("18","1");
INSERT INTO role_has_permissions VALUES("18","2");
INSERT INTO role_has_permissions VALUES("19","1");
INSERT INTO role_has_permissions VALUES("19","2");
INSERT INTO role_has_permissions VALUES("20","1");
INSERT INTO role_has_permissions VALUES("20","2");
INSERT INTO role_has_permissions VALUES("20","4");
INSERT INTO role_has_permissions VALUES("21","1");
INSERT INTO role_has_permissions VALUES("21","2");
INSERT INTO role_has_permissions VALUES("21","4");
INSERT INTO role_has_permissions VALUES("22","1");
INSERT INTO role_has_permissions VALUES("22","2");
INSERT INTO role_has_permissions VALUES("22","4");
INSERT INTO role_has_permissions VALUES("23","1");
INSERT INTO role_has_permissions VALUES("23","2");
INSERT INTO role_has_permissions VALUES("24","1");
INSERT INTO role_has_permissions VALUES("24","2");
INSERT INTO role_has_permissions VALUES("24","4");
INSERT INTO role_has_permissions VALUES("25","1");
INSERT INTO role_has_permissions VALUES("25","2");
INSERT INTO role_has_permissions VALUES("25","4");
INSERT INTO role_has_permissions VALUES("26","1");
INSERT INTO role_has_permissions VALUES("26","2");
INSERT INTO role_has_permissions VALUES("27","1");
INSERT INTO role_has_permissions VALUES("27","2");
INSERT INTO role_has_permissions VALUES("28","1");
INSERT INTO role_has_permissions VALUES("28","2");
INSERT INTO role_has_permissions VALUES("28","4");
INSERT INTO role_has_permissions VALUES("29","1");
INSERT INTO role_has_permissions VALUES("29","2");
INSERT INTO role_has_permissions VALUES("29","4");
INSERT INTO role_has_permissions VALUES("30","1");
INSERT INTO role_has_permissions VALUES("30","2");
INSERT INTO role_has_permissions VALUES("31","1");
INSERT INTO role_has_permissions VALUES("31","2");
INSERT INTO role_has_permissions VALUES("32","1");
INSERT INTO role_has_permissions VALUES("32","2");
INSERT INTO role_has_permissions VALUES("33","1");
INSERT INTO role_has_permissions VALUES("33","2");
INSERT INTO role_has_permissions VALUES("34","1");
INSERT INTO role_has_permissions VALUES("34","2");
INSERT INTO role_has_permissions VALUES("35","1");
INSERT INTO role_has_permissions VALUES("35","2");
INSERT INTO role_has_permissions VALUES("36","1");
INSERT INTO role_has_permissions VALUES("36","2");
INSERT INTO role_has_permissions VALUES("37","1");
INSERT INTO role_has_permissions VALUES("37","2");
INSERT INTO role_has_permissions VALUES("38","1");
INSERT INTO role_has_permissions VALUES("38","2");
INSERT INTO role_has_permissions VALUES("39","1");
INSERT INTO role_has_permissions VALUES("39","2");
INSERT INTO role_has_permissions VALUES("40","1");
INSERT INTO role_has_permissions VALUES("40","2");
INSERT INTO role_has_permissions VALUES("41","1");
INSERT INTO role_has_permissions VALUES("41","2");
INSERT INTO role_has_permissions VALUES("42","1");
INSERT INTO role_has_permissions VALUES("42","2");
INSERT INTO role_has_permissions VALUES("43","1");
INSERT INTO role_has_permissions VALUES("43","2");
INSERT INTO role_has_permissions VALUES("44","1");
INSERT INTO role_has_permissions VALUES("44","2");
INSERT INTO role_has_permissions VALUES("45","1");
INSERT INTO role_has_permissions VALUES("45","2");
INSERT INTO role_has_permissions VALUES("45","6");
INSERT INTO role_has_permissions VALUES("46","1");
INSERT INTO role_has_permissions VALUES("46","2");
INSERT INTO role_has_permissions VALUES("47","1");
INSERT INTO role_has_permissions VALUES("47","2");
INSERT INTO role_has_permissions VALUES("47","6");
INSERT INTO role_has_permissions VALUES("48","1");
INSERT INTO role_has_permissions VALUES("48","2");
INSERT INTO role_has_permissions VALUES("49","1");
INSERT INTO role_has_permissions VALUES("49","2");
INSERT INTO role_has_permissions VALUES("50","1");
INSERT INTO role_has_permissions VALUES("50","2");
INSERT INTO role_has_permissions VALUES("51","1");
INSERT INTO role_has_permissions VALUES("51","2");
INSERT INTO role_has_permissions VALUES("52","1");
INSERT INTO role_has_permissions VALUES("52","2");
INSERT INTO role_has_permissions VALUES("53","1");
INSERT INTO role_has_permissions VALUES("53","2");
INSERT INTO role_has_permissions VALUES("54","1");
INSERT INTO role_has_permissions VALUES("54","2");
INSERT INTO role_has_permissions VALUES("55","1");
INSERT INTO role_has_permissions VALUES("55","2");
INSERT INTO role_has_permissions VALUES("55","4");
INSERT INTO role_has_permissions VALUES("56","1");
INSERT INTO role_has_permissions VALUES("56","2");
INSERT INTO role_has_permissions VALUES("56","4");
INSERT INTO role_has_permissions VALUES("57","1");
INSERT INTO role_has_permissions VALUES("57","2");
INSERT INTO role_has_permissions VALUES("57","4");
INSERT INTO role_has_permissions VALUES("58","1");
INSERT INTO role_has_permissions VALUES("58","2");
INSERT INTO role_has_permissions VALUES("59","1");
INSERT INTO role_has_permissions VALUES("59","2");
INSERT INTO role_has_permissions VALUES("60","1");
INSERT INTO role_has_permissions VALUES("60","2");
INSERT INTO role_has_permissions VALUES("61","1");
INSERT INTO role_has_permissions VALUES("61","2");
INSERT INTO role_has_permissions VALUES("62","1");
INSERT INTO role_has_permissions VALUES("62","2");
INSERT INTO role_has_permissions VALUES("63","1");
INSERT INTO role_has_permissions VALUES("63","2");
INSERT INTO role_has_permissions VALUES("63","4");
INSERT INTO role_has_permissions VALUES("64","1");
INSERT INTO role_has_permissions VALUES("64","2");
INSERT INTO role_has_permissions VALUES("64","4");
INSERT INTO role_has_permissions VALUES("65","1");
INSERT INTO role_has_permissions VALUES("65","2");
INSERT INTO role_has_permissions VALUES("66","1");
INSERT INTO role_has_permissions VALUES("66","2");
INSERT INTO role_has_permissions VALUES("67","1");
INSERT INTO role_has_permissions VALUES("67","2");
INSERT INTO role_has_permissions VALUES("68","1");
INSERT INTO role_has_permissions VALUES("68","2");
INSERT INTO role_has_permissions VALUES("69","1");
INSERT INTO role_has_permissions VALUES("69","2");
INSERT INTO role_has_permissions VALUES("70","1");
INSERT INTO role_has_permissions VALUES("70","2");
INSERT INTO role_has_permissions VALUES("71","1");
INSERT INTO role_has_permissions VALUES("71","2");
INSERT INTO role_has_permissions VALUES("72","1");
INSERT INTO role_has_permissions VALUES("72","2");
INSERT INTO role_has_permissions VALUES("73","1");
INSERT INTO role_has_permissions VALUES("73","2");
INSERT INTO role_has_permissions VALUES("74","1");
INSERT INTO role_has_permissions VALUES("74","2");
INSERT INTO role_has_permissions VALUES("75","1");
INSERT INTO role_has_permissions VALUES("75","2");
INSERT INTO role_has_permissions VALUES("76","1");
INSERT INTO role_has_permissions VALUES("76","2");
INSERT INTO role_has_permissions VALUES("77","1");
INSERT INTO role_has_permissions VALUES("77","2");
INSERT INTO role_has_permissions VALUES("78","1");
INSERT INTO role_has_permissions VALUES("78","2");
INSERT INTO role_has_permissions VALUES("79","1");
INSERT INTO role_has_permissions VALUES("79","2");
INSERT INTO role_has_permissions VALUES("80","1");
INSERT INTO role_has_permissions VALUES("80","2");
INSERT INTO role_has_permissions VALUES("81","1");
INSERT INTO role_has_permissions VALUES("81","2");
INSERT INTO role_has_permissions VALUES("82","1");
INSERT INTO role_has_permissions VALUES("82","2");
INSERT INTO role_has_permissions VALUES("83","1");
INSERT INTO role_has_permissions VALUES("83","2");
INSERT INTO role_has_permissions VALUES("84","1");
INSERT INTO role_has_permissions VALUES("84","2");
INSERT INTO role_has_permissions VALUES("85","1");
INSERT INTO role_has_permissions VALUES("85","2");
INSERT INTO role_has_permissions VALUES("86","1");
INSERT INTO role_has_permissions VALUES("86","2");
INSERT INTO role_has_permissions VALUES("87","1");
INSERT INTO role_has_permissions VALUES("87","2");
INSERT INTO role_has_permissions VALUES("88","1");
INSERT INTO role_has_permissions VALUES("88","2");
INSERT INTO role_has_permissions VALUES("89","1");
INSERT INTO role_has_permissions VALUES("89","2");
INSERT INTO role_has_permissions VALUES("90","1");
INSERT INTO role_has_permissions VALUES("90","2");
INSERT INTO role_has_permissions VALUES("91","1");
INSERT INTO role_has_permissions VALUES("91","2");
INSERT INTO role_has_permissions VALUES("92","1");
INSERT INTO role_has_permissions VALUES("92","2");
INSERT INTO role_has_permissions VALUES("93","1");
INSERT INTO role_has_permissions VALUES("93","2");
INSERT INTO role_has_permissions VALUES("94","1");
INSERT INTO role_has_permissions VALUES("94","2");
INSERT INTO role_has_permissions VALUES("95","1");
INSERT INTO role_has_permissions VALUES("95","2");
INSERT INTO role_has_permissions VALUES("96","1");
INSERT INTO role_has_permissions VALUES("96","2");
INSERT INTO role_has_permissions VALUES("97","1");
INSERT INTO role_has_permissions VALUES("97","2");
INSERT INTO role_has_permissions VALUES("98","1");
INSERT INTO role_has_permissions VALUES("98","2");
INSERT INTO role_has_permissions VALUES("99","1");
INSERT INTO role_has_permissions VALUES("99","2");
INSERT INTO role_has_permissions VALUES("100","1");
INSERT INTO role_has_permissions VALUES("100","2");
INSERT INTO role_has_permissions VALUES("101","1");
INSERT INTO role_has_permissions VALUES("101","2");
INSERT INTO role_has_permissions VALUES("102","1");
INSERT INTO role_has_permissions VALUES("102","2");
INSERT INTO role_has_permissions VALUES("103","1");
INSERT INTO role_has_permissions VALUES("103","2");
INSERT INTO role_has_permissions VALUES("104","1");
INSERT INTO role_has_permissions VALUES("104","2");
INSERT INTO role_has_permissions VALUES("105","1");
INSERT INTO role_has_permissions VALUES("105","2");



CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `guard_name` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES("1","Admin","admin can access all data...","web","1","2018-06-01 23:46:44","2018-06-02 23:13:05");
INSERT INTO roles VALUES("2","Owner","Owner of shop...","web","1","2018-10-22 02:38:13","2018-10-22 02:38:13");
INSERT INTO roles VALUES("4","staff","staff has specific acess...","web","1","2018-06-02 00:05:27","2018-06-02 00:05:27");
INSERT INTO roles VALUES("5","Customer","","web","1","2020-11-05 06:43:16","2020-11-15 00:24:15");
INSERT INTO roles VALUES("6","Billing","Can only access pos","web","1","2024-08-10 10:00:56","2024-08-10 10:00:56");
INSERT INTO roles VALUES("7","orxan","üarehouse","web","1","2024-09-10 00:12:50","2024-09-10 00:12:50");
INSERT INTO roles VALUES("8","ABBY","Cashier","web","1","2024-10-10 05:38:22","2024-10-10 05:38:22");



CREATE TABLE `sales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) DEFAULT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `grand_total` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `coupon_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `sale_status` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `paid_amount` double DEFAULT NULL,
  `sale_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO sales VALUES("1","1255","1","1","4","1","1","1","1","0","2.6","22.6","20","0","0","2.6","","","","1","4","","20","","","2024-08-10 13:56:22","2024-08-10 13:56:22");
INSERT INTO sales VALUES("2","posr-20240812-123620","33","9","1","1","1","1","1","0","2.6","22.6","22.6","0","0","","","","","1","4","","22.6","","","2024-08-12 12:36:20","2024-08-12 12:36:20");
INSERT INTO sales VALUES("3","sr-20240812-075116","1","1","1","1","1","1","3","0","7.8","67.8","67.8","0","0","","","","","1","4","","67.8","","","2024-08-12 19:51:16","2024-08-12 19:51:16");
INSERT INTO sales VALUES("4","posr-20240812-075702","1","1","1","1","1","2","3","0","83.2","723.2","723.2","0","0","","","","","1","4","","723.2","","","2024-08-12 19:57:02","2024-08-12 19:57:02");
INSERT INTO sales VALUES("5","posr-20240813-110104","1","1","1","1","1","3","3","0","78","3078","3078","0","0","","","","","1","4","","3078","","","2024-08-13 11:01:04","2024-08-13 11:01:04");
INSERT INTO sales VALUES("6","posr-20240813-010817","1","1","1","1","1","1","2","0","0","150","150","0","0","","","","","1","4","","150","","","2024-08-13 13:08:17","2024-08-13 13:08:17");
INSERT INTO sales VALUES("7","posr-20240815-094256","1","1","2","1","1","2","2","0","0","1515","1515","0","0","","","","","1","4","","1515","","","2024-08-15 09:42:56","2024-08-15 09:42:56");
INSERT INTO sales VALUES("8","posr-20240815-101808","1","1","1","1","1","1","1","0","0","225","225","0","0","","","","","3","4","","225","","","2024-08-15 10:18:08","2024-08-15 10:18:08");
INSERT INTO sales VALUES("9","posr-20240815-105259","1","1","1","1","1","1","1","0","39","339","339","0","0","","","","","1","4","","339","","","2024-08-15 10:52:59","2024-08-15 10:52:59");
INSERT INTO sales VALUES("10","posr-20240815-121001","1","1","1","1","1","3","5","0","1170","24345","24345","0","0","","","","","1","4","","24345","","","2024-08-15 12:10:01","2024-08-15 12:10:01");
INSERT INTO sales VALUES("11","posr-20240815-014933","1","1","1","1","1","3","6","0","0","54330","54330","0","0","","","","","1","4","","54330","","","2024-08-15 13:49:33","2024-08-15 13:49:33");
INSERT INTO sales VALUES("12","posr-20240815-033851","1","1","1","1","1","2","2","0","0","13725","13725","0","0","","","","","1","4","","13725","cvzbsdfs","","2024-08-15 15:38:51","2024-08-15 15:38:51");
INSERT INTO sales VALUES("13","posr-20240817-021110","1","1","1","1","1","1","2","0","0","450","450","0","0","","","","","1","2","","200","","Shoki Endritit","2024-08-17 14:11:10","2024-08-17 14:11:10");
INSERT INTO sales VALUES("14","posr-20240817-021628","1","1","1","1","1","1","1","0","0","225","200","0","0","25","","","","3","4","","200","","","2024-08-17 14:16:28","2024-08-17 14:16:28");
INSERT INTO sales VALUES("15","posr-20240817-021700","1","1","1","1","1","1","1","0","0","225","200","0","0","25","","","","1","4","","200","","","2024-08-17 14:17:00","2024-08-17 14:17:00");
INSERT INTO sales VALUES("16","posr-20240817-021841","1","1","1","1","1","1","1","0","0","13500","10000","0","0","3500","","","","1","4","","10000","","","2024-08-17 14:18:41","2024-08-17 14:18:41");
INSERT INTO sales VALUES("17","posr-20240820-064913","1","2","5","1","1","1","1","0","1170","10170","10170","0","0","","","","","1","4","","10170","","Endriti","2024-08-20 18:49:13","2024-08-20 18:49:13");
INSERT INTO sales VALUES("18","posr-20240822-012713","1","2","1","1","1","1","4","0","0","90000","90000","0","0","","","","","3","2","","","","","2024-08-22 13:27:13","2024-08-22 13:27:13");
INSERT INTO sales VALUES("19","posr-20240822-021105","1","2","2","1","1","1","1","0","41.38","300","300","0","0","","","","","1","4","","300","","","2024-08-22 14:11:05","2024-08-22 14:11:05");
INSERT INTO sales VALUES("20","posr-20240822-041758","1","2","1","1","1","1","8","0","1350.62","9792","9792","0","0","","","","","1","4","","9792","","","2024-08-22 16:17:58","2024-08-22 16:17:58");
INSERT INTO sales VALUES("21","sr-20240823-125807","1","2","1","1","1","4","10","0","0","181213.2","181213.2","0","0","0","","","0","1","1","","","","","2024-08-23 12:58:07","2024-08-23 12:58:07");
INSERT INTO sales VALUES("22","posr-20240823-093937","1","2","6","1","1","2","3","0","0","100980","100980","0","0","","","","","1","4","","100980","","","2024-08-23 21:39:37","2024-08-23 21:39:37");
INSERT INTO sales VALUES("23","posr-20240823-094128","1","2","6","1","1","1","0","0","0","0","0","0","0","","","","","1","4","","0","","","2024-08-23 21:41:28","2024-08-23 21:41:28");
INSERT INTO sales VALUES("24","posr-20240902-114853","1","2","1","1","1","1","1","0","0","120","120","0","0","","","","","1","4","","120","","","2024-09-02 11:48:53","2024-09-02 11:48:53");
INSERT INTO sales VALUES("25","342342","1","2","2","1","1","1","1","0","0","1500","1500","0","0","","","","","1","4","","1500","","","2024-09-03 20:52:57","2024-09-03 20:52:57");
INSERT INTO sales VALUES("26","posr-20240906-065641","1","2","1","1","1","4","8","0","5.52","5054","5054","0","0","","","","","1","4","","5054","","","2024-09-06 06:56:41","2024-09-06 06:56:41");
INSERT INTO sales VALUES("27","posr-20240910-093243","1","2","1","1","1","3","3","0","0","1590","1590","0","0","","","","","1","4","","1590","","","2024-09-10 09:32:43","2024-09-10 09:32:43");
INSERT INTO sales VALUES("28","posr-20240911-053517","1","2","1","1","1","3","3","0","0","982","982","0","0","","","","","1","4","","982","","","2024-09-11 17:35:17","2024-09-11 17:35:17");
INSERT INTO sales VALUES("29","posr-20240911-054615","1","2","1","1","1","1","4.5","0","12.41","90","90","0","0","","","","","1","4","","90","","","2024-09-11 17:46:15","2024-09-11 17:46:15");
INSERT INTO sales VALUES("30","posr-20240911-054623","1","2","1","1","1","1","4.5","0","12.41","90","90","0","0","","","","","1","4","","90","","","2024-09-11 17:46:23","2024-09-11 17:46:23");
INSERT INTO sales VALUES("32","posr-20240913-012400","1","33","6","3","1","5","5","0","0","98.3","98.3","0","0","","","","","1","4","","98.3","","","2024-09-13 13:24:00","2024-09-13 13:24:00");
INSERT INTO sales VALUES("33","sr-20240915-114709","1","32","5","2","1","1","2","0","80","580","672.8","16","92.8","","","","","1","1","","","","","2024-09-15 23:47:09","2024-09-15 23:47:09");
INSERT INTO sales VALUES("34","05","1","2","1","1","1","1","1","0","0","4.5","5.22","16","0.72","","","","","1","1","","","","","2024-09-15 23:56:45","2024-09-15 23:56:45");
INSERT INTO sales VALUES("35","sr-20240916-121421","1","2","1","1","1","1","5","0","0","22950","27540","20","4590","0","","","0","1","2","","","Vshsjssnsn
Shshshshs
Shshsusisiskama
Shsjskssksk","","2024-09-16 00:14:21","2024-09-16 00:29:24");
INSERT INTO sales VALUES("36","sr-20240916-030739","1","2","1","1","1","1","1","0","0","200","240","20","40","","","","","1","1","","","","","2024-09-16 15:07:39","2024-09-16 15:07:39");
INSERT INTO sales VALUES("37","sr-20240916-031135","1","2","1","1","1","1","1","0","0","4590","4590","0","0","0","","","0","1","1","","","","","2024-09-16 15:11:35","2024-09-16 15:11:35");
INSERT INTO sales VALUES("38","posr-20240916-022421","1","34","7","4","1","1","1","0","0","1800","1800","0","0","","","","","1","4","","1800","","","2024-09-16 14:24:21","2024-09-16 14:24:21");
INSERT INTO sales VALUES("39","posr-20240917-052814","1","34","7","4","1","1","1","0","0","34.2","34.2","0","0","","","","","1","4","","34.2","","","2024-09-17 05:28:14","2024-09-17 05:28:14");
INSERT INTO sales VALUES("40","posr-20240917-054611","1","34","7","4","1","1","1","0","0","16.2","16.2","0","0","","","","","1","4","","16.2","","","2024-09-17 05:46:11","2024-09-17 05:46:11");
INSERT INTO sales VALUES("41","sr-20240917-033006","1","34","7","4","1","1","1","0","0","1800","2160","20","360","","","","","1","4","","2160","","","2024-09-17 15:30:06","2024-09-17 15:31:45");
INSERT INTO sales VALUES("42","posr-20240926-051235","1","34","7","4","1","1","5","0","0","1000","1000","0","0","","","","","1","4","","1000","","","2024-09-26 17:12:35","2024-09-26 17:12:35");
INSERT INTO sales VALUES("43","posr-20240927-121140","1","34","6","4","1","1","1","0","0","3.8","3.8","0","0","","","","","1","4","","3.8","","","2024-09-27 12:11:40","2024-09-27 12:11:40");
INSERT INTO sales VALUES("44","sr-20241004-040232","1","34","7","4","1","1","1","0","0","3.8","3.8","0","0","","","","","1","1","","","","","2024-10-04 04:02:32","2024-10-04 04:02:32");
INSERT INTO sales VALUES("45","sr-20241004-040245","1","34","7","4","1","1","1","0","0","3.8","3.8","0","0","","","","","1","1","","","","","2024-10-04 04:02:45","2024-10-04 04:02:45");
INSERT INTO sales VALUES("46","posr-20241006-035049","1","34","7","4","1","1","3","0","0","11.4","11.4","0","0","","","","","1","4","","11.4","","","2024-10-06 15:50:49","2024-10-06 15:50:49");
INSERT INTO sales VALUES("47","posr-20241006-040331","1","35","7","5","1","1","3","0","0","3000","3000","0","0","","","","","1","4","","3000","","","2024-10-06 16:03:31","2024-10-06 16:03:31");
INSERT INTO sales VALUES("48","posr-20241010-053539","1","34","7","4","1","1","1","0","0","3.8","3.8","0","0","","","","","1","4","","3.8","","","2024-10-10 05:35:39","2024-10-10 05:35:39");
INSERT INTO sales VALUES("49","posr-20241010-072435","1","34","7","4","1","1","1","0","0","3.8","3.8","0","0","","","","","3","2","","","","","2024-10-10 07:24:35","2024-10-10 07:24:35");



CREATE TABLE `stock_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `category_id` varchar(191) DEFAULT NULL,
  `brand_id` varchar(191) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) NOT NULL,
  `initial_file` varchar(191) DEFAULT NULL,
  `final_file` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_adjusted` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO stock_counts VALUES("1","scr-20240809-074031","1","","","1","full","20240809-074031.csv","","","0","2024-08-09 19:40:31","2024-08-09 19:40:31");
INSERT INTO stock_counts VALUES("2","scr-20240822-013512","1","1","","1","partial","20240822-013512.csv","","","0","2024-08-22 13:35:12","2024-08-22 13:35:12");
INSERT INTO stock_counts VALUES("3","scr-20240927-120333","4","","","1","full","20240927-120333.csv","","","0","2024-09-27 12:03:33","2024-09-27 12:03:33");
INSERT INTO stock_counts VALUES("4","scr-20241009-070414","6","","","1","full","20241009-070414.csv","","","0","2024-10-09 07:04:14","2024-10-09 07:04:14");



CREATE TABLE `suppliers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `vat_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO suppliers VALUES("1","Mia","","Guangzhou Susan Landscape Artificial Plants","0000","mia@gz-sus.com","86 18819477984","Guangdong, China","Guangdong","China","11111","China","1","2024-09-13 11:51:51","2024-09-13 11:51:51");



CREATE TABLE `taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `rate` double NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO taxes VALUES("1","IVA","16","0","2024-07-06 19:56:54","2024-09-16 15:17:33");
INSERT INTO taxes VALUES("2","TVA","20","1","2024-09-16 00:02:43","2024-09-16 00:02:43");



CREATE TABLE `transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `from_warehouse_id` int(11) NOT NULL,
  `to_warehouse_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unit_code` varchar(191) NOT NULL,
  `unit_name` varchar(191) NOT NULL,
  `base_unit` int(11) DEFAULT NULL,
  `operator` varchar(191) DEFAULT NULL,
  `operation_value` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO units VALUES("1","001","Pza","","*","1","1","2024-07-06 19:54:58","2024-07-06 19:54:58");
INSERT INTO units VALUES("2","002","Un","","*","1","1","2024-08-22 14:03:05","2024-08-22 14:03:05");
INSERT INTO units VALUES("3","pieces","pieces","","*","1","1","2024-08-24 16:06:22","2024-09-13 13:13:58");



CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `password` varchar(191) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `phone` varchar(191) NOT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `role_id` int(11) NOT NULL,
  `biller_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES("1","admin","admin@gmail.com","$2y$10$DWAHTfjcvwCpOCXaJg11MOhsqns03uvlwiSUOQwkHL2YYrtrXPcL6","vKyfm91I6EwUqZeD8SESnw7MCPH0jOP2TrEnFsqs28y79mhPLGNHjNy9kXKL","12112","HMH BUSINESS","1","","","1","0","2018-06-02 03:24:15","2024-10-02 08:56:51");
INSERT INTO users VALUES("3","dhiman da","dhiman@gmail.com","$2y$10$Fef6vu5E67nm11hX7V5a2u1ThNCQ6n9DRCvRF9TD7stk.Pmt2R6O.","5ehQM6JIfiQfROgTbB5let0Z93vjLHS7rd9QD5RPNgOxli3xdo7fykU7vtTt","212","lioncoders","1","","","0","1","2018-06-13 22:00:31","2020-11-05 07:06:51");
INSERT INTO users VALUES("6","test","test@gmail.com","$2y$10$TDAeHcVqHyCmurki0wjLZeIl1SngKX3WLOhyTiCoZG3souQfqv.LS","KpW1gYYlOFacumklO2IcRfSsbC3KcWUZzOI37gqoqM388Xie6KdhaOHIFEYm","1234","212312","4","","","0","1","2018-06-23 03:05:33","2018-06-23 03:13:45");
INSERT INTO users VALUES("8","test","test@yahoo.com","$2y$10$hlMigidZV0j2/IPkgE/xsOSb8WM2IRlsMv.1hg1NM7kfyd6bGX3hC","","31231","","4","","","0","1","2018-06-24 22:35:49","2018-07-02 01:07:39");
INSERT INTO users VALUES("9","staff","anda@gmail.com","$2y$10$kxDbnynB6mB1e1w3pmtbSOlSxy/WwbLPY5TJpMi0Opao5ezfuQjQm","dLNcktdks0IxKepKusPC61sjhCPt6UXBhYwXwxbQe89o2ZOQBJo5YZ9oteEA","3123","","4","5","1","1","0","2018-07-02 01:08:08","2018-10-23 21:41:13");
INSERT INTO users VALUES("10","abul","abul@alpha.com","$2y$10$5zgB2OOMyNBNVAd.QOQIju5a9fhNnTqPx5H6s4oFlXhNiF6kXEsPq","x7HlttI5bM0vSKViqATaowHFJkLS3PHwfvl7iJdFl5Z1SsyUgWCVbLSgAoi0","1234","anda","1","","","1","0","2018-09-07 23:44:48","2024-08-01 16:50:38");
INSERT INTO users VALUES("11","teststaff","a@a.com","$2y$10$5KNBIIhZzvvZEQEhkHaZGu.Q8bbQNfqYvYgL5N55B8Pb4P5P/b/Li","DkHDEcCA0QLfsKPkUK0ckL0CPM6dPiJytNa0k952gyTbeAyMthW3vi7IRitp","111","aa","4","5","1","0","1","2018-10-22 02:47:56","2018-10-23 02:10:56");
INSERT INTO users VALUES("12","john","john@gmail.com","$2y$10$P/pN2J/uyTYNzQy2kRqWwuSv7P2f6GE/ykBwtHdda7yci3XsfOKWe","O0f1WJBVjT5eKYl3Js5l1ixMMtoU6kqrH7hbHDx9I1UCcD9CmiSmCBzHbQZg","10001","","4","2","2","0","1","2018-12-30 00:48:37","2019-03-06 04:59:49");
INSERT INTO users VALUES("13","jjj","test@test.com","$2y$10$/Qx3gHWYWUhlF1aPfzXaCeZA7fRzfSEyCIOnk/dcC4ejO8PsoaalG","","1213","","1","","","0","1","2019-01-03 00:08:31","2019-03-03 04:02:29");
INSERT INTO users VALUES("19","shakalaka","shakalaka@gmail.com","$2y$10$ketLWT0Ib/JXpo00eJlxoeSw.7leS8V1CUGInfbyOWT4F5.Xuo7S2","","1212","Digital image","5","","","1","0","2020-11-09 00:07:16","2020-11-09 00:07:16");
INSERT INTO users VALUES("21","modon","modon@gmail.com","$2y$10$7VpoeGMkP8QCvL5zLwFW..6MYJ5MRumDLDoX.TTQtClS561rpFHY.","","2222","modon company","5","","","1","0","2020-11-13 07:12:08","2020-11-13 07:12:08");
INSERT INTO users VALUES("22","dhiman","dhiman@gmail.com","$2y$10$3mPygsC6wwnDtw/Sg85IpuExtUhgaHx52Lwp7Rz0.FNfuFdfKVpRq","","+8801111111101","lioncoders","5","","","1","0","2020-11-15 06:14:58","2020-11-15 06:14:58");
INSERT INTO users VALUES("29","Robin Thomas","bestoexim@gmail.com","$2y$10$rK03Ex59S4gy4FsFR9oQKekVqe23WbbA1fGuKzuyoNP6kgoSsk8Gm","","0965167005","Besto Exim Co.,Ltd","4","1","2","0","1","2024-05-03 15:47:10","2024-06-18 18:20:35");
INSERT INTO users VALUES("30","Thi","example@example.com","$2y$10$XUtnA6oN5nFDUrgBnh6yW.enguQAgnZTpWiDdlwRyNECjAG0XjXwq","","090000000","C 1","1","","","1","0","2024-06-18 17:56:51","2024-06-18 17:56:51");
INSERT INTO users VALUES("31","liverpool","king.1991@gmail.com","$2y$10$B0AH9oYR//L9xtUzXkTZLeaQHXW9CDp1wY1CWfkbP9M51Rkffe0ti","","+962563542569","","5","","","1","0","2024-07-31 23:56:30","2024-07-31 23:56:30");
INSERT INTO users VALUES("32","new","kefah.rajha.1991@gmail.com","$2y$10$3cHLkONxYB7uVIKHUxiuB.XaVRWK.Q8J/5LwctWVBXip8kaXu1yY.","","+962563542569","x","5","","","0","1","2024-08-01 14:03:25","2024-08-01 16:51:44");
INSERT INTO users VALUES("33","Billing","bill@gmail.com","$2y$10$fPTTnqcC.yZrAV2noQfajeeJHmtQO0ENBhR5SHvDUBAEZY02z64R2","","1111111111","","6","1","1","1","0","2024-08-10 10:02:26","2024-08-10 10:02:26");
INSERT INTO users VALUES("34","zongo","mthzongo@gmail.com","$2y$10$z3GahHY0AmdtcbOTeTIE3.LuGM3.Yx5ftwR4ykwlhDb2TN53KXOt2","","2677888999","","1","","","1","0","2024-08-13 12:10:56","2024-08-13 12:10:56");
INSERT INTO users VALUES("35","Naa","naa@gmail.com","$2y$10$9OZicJHjLe79rkH3BHu2ju.0ShDX0Gg1NZHgTgBmmu/gQTNvwVV0e","","0247439813","","4","1","1","1","0","2024-08-15 09:09:39","2024-08-15 09:09:39");
INSERT INTO users VALUES("36","nii","derrick@gmail.com","$2y$10$PcUpPrFom8l.gpF60veWj.WHFCy4ksoJi10YhIdu6zJgQTFparNlm","","0247439813","","6","1","1","1","0","2024-08-15 09:14:03","2024-08-15 09:14:50");
INSERT INTO users VALUES("37","Bambak","bamba5.keletigui@gmail.com","$2y$10$TEA437S6hLbMsIhF0KXHV..nhtDcQ5XTbTjBHqapiEJLtik.3dxhW","","92819395","BAMBA IT","2","","","0","0","2024-08-23 07:20:29","2024-08-23 07:20:29");
INSERT INTO users VALUES("38","Abdisamad","Cartan160@gmail.com","$2y$10$vTn10S3BT5d3.GaIrdmfVuGJWhA4azRS28ErOxMrBeqA6g30Xm3g2","","615666991","beeciye Collection group","1","","","0","0","2024-09-14 06:19:04","2024-09-14 06:19:04");
INSERT INTO users VALUES("39","Nilam Patil","nilam2012@gmail.com","$2y$10$LA3yHXpADRzpAMX/f6z/o.3KyCS0Q9xhATWTc.EzldWZ/8XN9gB3K","","08600006546","Nexgen Promoters","2","","","0","0","2024-09-30 12:09:46","2024-09-30 12:09:46");
INSERT INTO users VALUES("40","demo_k","mr.markwhite1@gmail.com","$2y$10$TUIZFYlihIhH4stP.YAb5OntzmjimiePdV8pv1Ppp26MPiwD0ZhTK","","6463403244","KAEM Softwares pvt ltd","7","1","7","1","0","2024-10-09 07:00:44","2024-10-09 07:35:57");



CREATE TABLE `variants` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO variants VALUES("1","Black","2024-10-04 03:56:03","2024-10-04 03:56:03");
INSERT INTO variants VALUES("2","White","2024-10-04 03:56:03","2024-10-04 03:56:03");



CREATE TABLE `warehouses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `address` text NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO warehouses VALUES("1","Villalobos edif.londres","7899568","almacen@gmail.com","Hhuu","0","2024-07-06 19:53:42","2024-09-16 15:15:26");
INSERT INTO warehouses VALUES("2","Shaki","+99455688888","k.orxan@net.az","asd seh","0","2024-09-10 00:00:32","2024-09-16 15:15:19");
INSERT INTO warehouses VALUES("3","Depo 1","0454580429","dekortropikal@gmail.com","Ferizaj","0","2024-09-13 11:48:56","2024-09-16 15:15:09");
INSERT INTO warehouses VALUES("4","mohamadia","066343526","","mohammadia","1","2024-09-16 15:15:47","2024-09-16 15:15:47");
INSERT INTO warehouses VALUES("5","MANILA","123456789","","manila phils","1","2024-10-06 16:02:21","2024-10-06 16:02:21");
INSERT INTO warehouses VALUES("6","Demo","1111111111","","Dmeo, demo","1","2024-10-08 02:26:41","2024-10-08 02:26:41");
INSERT INTO warehouses VALUES("7","andheri west","9801115993","","andheri west","1","2024-10-09 07:09:12","2024-10-09 07:09:12");

