

CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_no` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `initial_balance` double DEFAULT NULL,
  `total_balance` double NOT NULL,
  `note` text DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO accounts VALUES("1","1111","COMPTE PRINCIPAL","25000","25000","this is first account","0","1","2018-12-18 02:58:02","2025-01-17 20:56:51");
INSERT INTO accounts VALUES("3","21211","Sa","","0","","0","1","2018-12-18 02:58:56","2024-12-28 22:45:55");
INSERT INTO accounts VALUES("4","000111","Cost of Goods Sold","1000","1000","","1","1","2024-09-11 17:41:42","2025-02-03 12:17:15");
INSERT INTO accounts VALUES("5","A02565","Caisse-RT","250000","250000","","0","1","2025-01-16 10:11:57","2025-02-03 12:17:15");



CREATE TABLE `adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `total_qty` double NOT NULL,
  `item` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `employee_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `checkin` varchar(191) NOT NULL,
  `checkout` varchar(191) NOT NULL,
  `status` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `billers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `vat_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO billers VALUES("1","Vendor","","Mine","VAT0001","test@test.com","0000","Adress","City","","","","1","2024-12-28 14:30:15","2024-12-28 14:30:15");
INSERT INTO billers VALUES("2","UMOJA PLUS","","UMOJA","","edka2023@outlook.fr","0974830311","LUBUMBASHI","LUBUMBQSHI","RDC","","Congo (République démocratique du)","1","2024-12-28 23:20:12","2024-12-28 23:20:12");
INSERT INTO billers VALUES("3","huotchanthou","","VK Pharma Import Export","","huotchanthou199@outlook.com","010519666","23455","Phnom Penh","","","","1","2025-01-12 10:51:50","2025-01-12 10:51:50");



CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_in_hand` double NOT NULL,
  `user_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cash_registers VALUES("1","1000","1","1","0","2024-12-28 07:55:47","2025-01-17 22:22:49");
INSERT INTO cash_registers VALUES("2","1","1","1","0","2024-12-28 22:23:54","2025-01-22 06:30:08");
INSERT INTO cash_registers VALUES("3","1234","1","1","1","2024-12-28 22:24:09","2024-12-28 22:24:09");
INSERT INTO cash_registers VALUES("4","0","1","1","1","2024-12-30 12:04:05","2024-12-30 12:04:05");
INSERT INTO cash_registers VALUES("5","100","1","1","1","2025-01-01 16:43:47","2025-01-01 16:43:47");
INSERT INTO cash_registers VALUES("6","500","1","1","1","2025-01-02 16:03:57","2025-01-02 16:03:57");
INSERT INTO cash_registers VALUES("7","200","1","1","1","2025-01-06 14:07:01","2025-01-06 14:07:01");
INSERT INTO cash_registers VALUES("8","200","1","1","1","2025-01-06 14:07:17","2025-01-06 14:07:17");
INSERT INTO cash_registers VALUES("9","200","1","1","1","2025-01-09 15:07:42","2025-01-09 15:07:42");
INSERT INTO cash_registers VALUES("10","0","1","2","1","2025-01-12 10:39:13","2025-01-12 10:39:13");
INSERT INTO cash_registers VALUES("11","0","1","2","1","2025-01-12 10:39:47","2025-01-12 10:39:47");
INSERT INTO cash_registers VALUES("12","5000","1","2","1","2025-01-16 15:58:33","2025-01-16 15:58:33");
INSERT INTO cash_registers VALUES("13","20000","1","3","1","2025-01-16 11:41:11","2025-01-16 11:41:11");
INSERT INTO cash_registers VALUES("14","30000","1","2","1","2025-01-17 16:53:00","2025-01-17 16:53:00");
INSERT INTO cash_registers VALUES("15","30000","1","2","1","2025-01-17 16:53:18","2025-01-17 16:53:18");
INSERT INTO cash_registers VALUES("16","300000","1","3","1","2025-01-17 16:53:34","2025-01-17 16:53:34");
INSERT INTO cash_registers VALUES("17","1000","1","2","1","2025-01-17 16:53:44","2025-01-17 16:53:44");
INSERT INTO cash_registers VALUES("18","5600","48","2","1","2025-01-18 17:12:57","2025-01-18 17:12:57");
INSERT INTO cash_registers VALUES("19","0","49","4","1","2025-01-19 09:52:38","2025-01-19 09:52:38");



CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO categories VALUES("1","Tworzywa","20241226045345.jpg","","1","2024-12-26 16:53:45","2024-12-26 16:53:45");
INSERT INTO categories VALUES("2","Frezy","20241226045441.jpg","","1","2024-12-26 16:54:41","2024-12-26 16:54:41");
INSERT INTO categories VALUES("3","Drukarka","20241226045521.jpg","","1","2024-12-26 16:55:21","2024-12-26 16:55:21");
INSERT INTO categories VALUES("4","Akcesoria","20241226045621.png","","1","2024-12-26 16:56:21","2024-12-26 16:56:21");
INSERT INTO categories VALUES("5","SERVICIOS REPARACIÓN","20250101104958.png","","1","2025-01-01 22:49:58","2025-01-01 22:49:58");
INSERT INTO categories VALUES("6","viandes","20250109062904.jpg","","1","2025-01-09 18:29:04","2025-01-09 18:29:04");
INSERT INTO categories VALUES("7","Sodium Cloride 500ml","20250112102514.jpg","","1","2025-01-12 10:25:14","2025-01-12 10:25:14");



CREATE TABLE `coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `amount` double NOT NULL,
  `minimum_amount` double DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `used` int(11) NOT NULL,
  `expired_date` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` varchar(191) NOT NULL,
  `exchange_rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO currencies VALUES("1","US Dollar","USD","1","2020-11-01 00:22:58","2020-11-01 00:34:55");
INSERT INTO currencies VALUES("2","Euro","Euro","0.85","2020-11-01 01:29:12","2020-11-10 23:15:34");
INSERT INTO currencies VALUES("3","dolar","ls","3.75","2024-06-11 09:13:41","2025-02-04 10:29:51");
INSERT INTO currencies VALUES("4","Bolivianos","Bs","6.97","2024-07-06 19:56:07","2024-07-06 19:56:07");
INSERT INTO currencies VALUES("5","Ghana Cedis","GHC","15","2024-08-15 09:51:32","2024-08-15 09:51:32");
INSERT INTO currencies VALUES("6","Metical","MZN","61.2","2024-08-22 14:03:57","2024-08-22 14:03:57");
INSERT INTO currencies VALUES("7","manat","AZN","1.7025","2024-09-10 00:14:06","2024-09-10 00:14:06");
INSERT INTO currencies VALUES("8","DH","MAD","9","2024-09-16 00:01:09","2024-09-16 15:17:14");
INSERT INTO currencies VALUES("9","Pesos Chilenos","CLP$","952.38","2024-10-27 05:51:26","2024-10-27 05:51:26");
INSERT INTO currencies VALUES("10","Afrique de l'Ouest","FCFA","1","2025-01-16 16:43:37","2025-01-16 16:43:59");
INSERT INTO currencies VALUES("11","Inr","Rs","87","2025-02-04 11:30:22","2025-02-04 11:30:22");



CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `percentage` varchar(191) NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_groups VALUES("1","Narendra","1","1","2024-12-28 08:00:49","2024-12-28 08:00:49");



CREATE TABLE `customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `phone_number` varchar(191) NOT NULL,
  `tax_no` varchar(191) DEFAULT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `points` double DEFAULT NULL,
  `deposit` double DEFAULT NULL,
  `expense` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customers VALUES("1","1","","Narendra","Narendra","narendra@gmail.com","9879879878","1","MANDSAUR","1","MANDSAUR","458001","INDIA","1165","3333333","","0","2024-12-28 08:01:45","2025-01-27 09:45:34");
INSERT INTO customers VALUES("2","1","","KIN-MARCHE","KM LBS","edka2023@outlook.fr","0974830311","","LUBUMBASHI","LUBUMBQSHI","RDC","7010","Congo (République démocratique du)","","","","0","2024-12-28 23:12:32","2025-01-27 09:45:42");
INSERT INTO customers VALUES("3","1","","ROWTECH SARL","ROWTECH","contact@rowtechbf.com","+22655989889","1234567890","1200 logements","Ouagadougou","","","Burkina Faso","","","","0","2025-01-16 10:16:34","2025-01-27 09:45:48");
INSERT INTO customers VALUES("4","1","","Kunde","hid","lkjlk@lkaj.com","012345646465","","akjshdkfjhj","Nürnberg","","90411","DE","159","","44.52","1","2025-01-27 09:46:27","2025-02-04 00:01:32");
INSERT INTO customers VALUES("5","1","","gg","","ahumadaleivaricardo@gmail.com","58586","","ghtg","Pichilemu","","","","23","","","1","2025-01-31 09:37:27","2025-02-03 11:41:36");



CREATE TABLE `deliveries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `address` text NOT NULL,
  `delivered_by` varchar(191) DEFAULT NULL,
  `recieved_by` varchar(191) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES("1","COMPTABILITE","1","2024-12-28 22:18:01","2024-12-28 22:18:45");
INSERT INTO departments VALUES("2","Floor 1","1","2025-01-12 18:13:33","2025-01-12 18:13:33");



CREATE TABLE `deposits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `amount` double NOT NULL,
  `customer_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deposits VALUES("1","3333333","1","45","","2024-12-28 23:13:30","2024-12-28 23:13:30");



CREATE TABLE `employees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `department_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES("1","PREDIS","Ngoykasongopredis@gmail.com","0974830311","1","45","Ngoykasongopredisgmailcom.jpg","","","","1","2024-12-28 22:22:37","2024-12-28 22:22:37");



CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expense_categories VALUES("1","0011","SNL","0","2024-12-28 22:36:30","2024-12-28 22:36:53");
INSERT INTO expense_categories VALUES("2","لوح","لوح رخام","0","2025-01-13 01:18:41","2025-01-13 01:46:31");



CREATE TABLE `expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `expense_category_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `amount` double NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) NOT NULL,
  `site_logo` varchar(191) DEFAULT NULL,
  `is_rtl` tinyint(1) DEFAULT NULL,
  `currency` varchar(191) NOT NULL,
  `staff_access` varchar(191) NOT NULL,
  `date_format` varchar(191) NOT NULL,
  `developed_by` varchar(191) DEFAULT NULL,
  `invoice_format` varchar(191) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `theme` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES("1","abo asba","20250204093412.jpg","0","1","all","d/m/Y","KAEM Sofware","standard","1","default.css","2018-07-06 06:13:11","2025-02-04 09:34:12","suffix");



CREATE TABLE `gift_card_recharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gift_card_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `gift_cards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_no` varchar(191) NOT NULL,
  `amount` double NOT NULL,
  `expense` double NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `expired_date` date DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO gift_cards VALUES("1","6489341908251070","10000000000","0","4","","2025-02-05","1","1","2025-02-04 00:11:10","2025-02-04 00:11:10");



CREATE TABLE `holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `note` text DEFAULT NULL,
  `is_approved` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO holidays VALUES("1","48","2025-01-18","2025-01-18","ljn","0","2025-01-18 17:15:43","2025-01-18 17:15:43");



CREATE TABLE `hrm_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `checkin` varchar(191) NOT NULL,
  `checkout` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO hrm_settings VALUES("1","8:30am","4:30pm","2019-01-02 02:20:08","2024-11-30 13:05:36");



CREATE TABLE `languages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO languages VALUES("1","en","2018-07-07 22:59:17","2019-12-24 17:34:20");



CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES("1","2014_10_12_000000_create_users_table","1");
INSERT INTO migrations VALUES("2","2014_10_12_100000_create_password_resets_table","1");
INSERT INTO migrations VALUES("3","2018_02_17_060412_create_categories_table","1");
INSERT INTO migrations VALUES("4","2018_02_20_035727_create_brands_table","1");
INSERT INTO migrations VALUES("5","2018_02_25_100635_create_suppliers_table","1");
INSERT INTO migrations VALUES("6","2018_02_27_101619_create_warehouse_table","1");
INSERT INTO migrations VALUES("7","2018_03_03_040448_create_units_table","1");
INSERT INTO migrations VALUES("8","2018_03_04_041317_create_taxes_table","1");
INSERT INTO migrations VALUES("9","2018_03_10_061915_create_customer_groups_table","1");
INSERT INTO migrations VALUES("10","2018_03_10_090534_create_customers_table","1");
INSERT INTO migrations VALUES("11","2018_03_11_095547_create_billers_table","1");
INSERT INTO migrations VALUES("12","2018_04_05_054401_create_products_table","1");
INSERT INTO migrations VALUES("13","2018_04_06_133606_create_purchases_table","1");
INSERT INTO migrations VALUES("14","2018_04_06_154600_create_product_purchases_table","1");
INSERT INTO migrations VALUES("15","2018_04_06_154915_create_product_warhouse_table","1");
INSERT INTO migrations VALUES("16","2018_04_10_085927_create_sales_table","1");
INSERT INTO migrations VALUES("17","2018_04_10_090133_create_product_sales_table","1");
INSERT INTO migrations VALUES("18","2018_04_10_090254_create_payments_table","1");
INSERT INTO migrations VALUES("19","2018_04_10_090341_create_payment_with_cheque_table","1");
INSERT INTO migrations VALUES("20","2018_04_10_090509_create_payment_with_credit_card_table","1");
INSERT INTO migrations VALUES("21","2018_04_13_121436_create_quotation_table","1");
INSERT INTO migrations VALUES("22","2018_04_13_122324_create_product_quotation_table","1");
INSERT INTO migrations VALUES("23","2018_04_14_121802_create_transfers_table","1");
INSERT INTO migrations VALUES("24","2018_04_14_121913_create_product_transfer_table","1");
INSERT INTO migrations VALUES("25","2018_05_13_082847_add_payment_id_and_change_sale_id_to_payments_table","2");
INSERT INTO migrations VALUES("26","2018_05_13_090906_change_customer_id_to_payment_with_credit_card_table","3");
INSERT INTO migrations VALUES("27","2018_05_20_054532_create_adjustments_table","4");
INSERT INTO migrations VALUES("28","2018_05_20_054859_create_product_adjustments_table","4");
INSERT INTO migrations VALUES("29","2018_05_21_163419_create_returns_table","5");
INSERT INTO migrations VALUES("30","2018_05_21_163443_create_product_returns_table","5");
INSERT INTO migrations VALUES("31","2018_06_02_050905_create_roles_table","6");
INSERT INTO migrations VALUES("32","2018_06_02_073430_add_columns_to_users_table","7");
INSERT INTO migrations VALUES("33","2018_06_03_053738_create_permission_tables","8");
INSERT INTO migrations VALUES("36","2018_06_21_063736_create_pos_setting_table","9");
INSERT INTO migrations VALUES("37","2018_06_21_094155_add_user_id_to_sales_table","10");
INSERT INTO migrations VALUES("38","2018_06_21_101529_add_user_id_to_purchases_table","11");
INSERT INTO migrations VALUES("39","2018_06_21_103512_add_user_id_to_transfers_table","12");
INSERT INTO migrations VALUES("40","2018_06_23_061058_add_user_id_to_quotations_table","13");
INSERT INTO migrations VALUES("41","2018_06_23_082427_add_is_deleted_to_users_table","14");
INSERT INTO migrations VALUES("42","2018_06_25_043308_change_email_to_users_table","15");
INSERT INTO migrations VALUES("43","2018_07_06_115449_create_general_settings_table","16");
INSERT INTO migrations VALUES("44","2018_07_08_043944_create_languages_table","17");
INSERT INTO migrations VALUES("45","2018_07_11_102144_add_user_id_to_returns_table","18");
INSERT INTO migrations VALUES("46","2018_07_11_102334_add_user_id_to_payments_table","18");
INSERT INTO migrations VALUES("47","2018_07_22_130541_add_digital_to_products_table","19");
INSERT INTO migrations VALUES("49","2018_07_24_154250_create_deliveries_table","20");
INSERT INTO migrations VALUES("50","2018_08_16_053336_create_expense_categories_table","21");
INSERT INTO migrations VALUES("51","2018_08_17_115415_create_expenses_table","22");
INSERT INTO migrations VALUES("55","2018_08_18_050418_create_gift_cards_table","23");
INSERT INTO migrations VALUES("56","2018_08_19_063119_create_payment_with_gift_card_table","24");
INSERT INTO migrations VALUES("57","2018_08_25_042333_create_gift_card_recharges_table","25");
INSERT INTO migrations VALUES("58","2018_08_25_101354_add_deposit_expense_to_customers_table","26");
INSERT INTO migrations VALUES("59","2018_08_26_043801_create_deposits_table","27");
INSERT INTO migrations VALUES("60","2018_09_02_044042_add_keybord_active_to_pos_setting_table","28");
INSERT INTO migrations VALUES("61","2018_09_09_092713_create_payment_with_paypal_table","29");
INSERT INTO migrations VALUES("62","2018_09_10_051254_add_currency_to_general_settings_table","30");
INSERT INTO migrations VALUES("63","2018_10_22_084118_add_biller_and_store_id_to_users_table","31");
INSERT INTO migrations VALUES("65","2018_10_26_034927_create_coupons_table","32");
INSERT INTO migrations VALUES("66","2018_10_27_090857_add_coupon_to_sales_table","33");
INSERT INTO migrations VALUES("67","2018_11_07_070155_add_currency_position_to_general_settings_table","34");
INSERT INTO migrations VALUES("68","2018_11_19_094650_add_combo_to_products_table","35");
INSERT INTO migrations VALUES("69","2018_12_09_043712_create_accounts_table","36");
INSERT INTO migrations VALUES("70","2018_12_17_112253_add_is_default_to_accounts_table","37");
INSERT INTO migrations VALUES("71","2018_12_19_103941_add_account_id_to_payments_table","38");
INSERT INTO migrations VALUES("72","2018_12_20_065900_add_account_id_to_expenses_table","39");
INSERT INTO migrations VALUES("73","2018_12_20_082753_add_account_id_to_returns_table","40");
INSERT INTO migrations VALUES("74","2018_12_26_064330_create_return_purchases_table","41");
INSERT INTO migrations VALUES("75","2018_12_26_144210_create_purchase_product_return_table","42");
INSERT INTO migrations VALUES("76","2018_12_26_144708_create_purchase_product_return_table","43");
INSERT INTO migrations VALUES("77","2018_12_27_110018_create_departments_table","44");
INSERT INTO migrations VALUES("78","2018_12_30_054844_create_employees_table","45");
INSERT INTO migrations VALUES("79","2018_12_31_125210_create_payrolls_table","46");
INSERT INTO migrations VALUES("80","2018_12_31_150446_add_department_id_to_employees_table","47");
INSERT INTO migrations VALUES("81","2019_01_01_062708_add_user_id_to_expenses_table","48");
INSERT INTO migrations VALUES("82","2019_01_02_075644_create_hrm_settings_table","49");
INSERT INTO migrations VALUES("83","2019_01_02_090334_create_attendances_table","50");
INSERT INTO migrations VALUES("84","2019_01_27_160956_add_three_columns_to_general_settings_table","51");
INSERT INTO migrations VALUES("85","2019_02_15_183303_create_stock_counts_table","52");
INSERT INTO migrations VALUES("86","2019_02_17_101604_add_is_adjusted_to_stock_counts_table","53");
INSERT INTO migrations VALUES("87","2019_04_13_101707_add_tax_no_to_customers_table","54");
INSERT INTO migrations VALUES("89","2019_10_14_111455_create_holidays_table","55");
INSERT INTO migrations VALUES("90","2019_11_13_145619_add_is_variant_to_products_table","56");
INSERT INTO migrations VALUES("91","2019_11_13_150206_create_product_variants_table","57");
INSERT INTO migrations VALUES("92","2019_11_13_153828_create_variants_table","57");
INSERT INTO migrations VALUES("93","2019_11_25_134041_add_qty_to_product_variants_table","58");
INSERT INTO migrations VALUES("94","2019_11_25_134922_add_variant_id_to_product_purchases_table","58");
INSERT INTO migrations VALUES("95","2019_11_25_145341_add_variant_id_to_product_warehouse_table","58");
INSERT INTO migrations VALUES("96","2019_11_29_182201_add_variant_id_to_product_sales_table","59");
INSERT INTO migrations VALUES("97","2019_12_04_121311_add_variant_id_to_product_quotation_table","60");
INSERT INTO migrations VALUES("98","2019_12_05_123802_add_variant_id_to_product_transfer_table","61");
INSERT INTO migrations VALUES("100","2019_12_08_114954_add_variant_id_to_product_returns_table","62");
INSERT INTO migrations VALUES("101","2019_12_08_203146_add_variant_id_to_purchase_product_return_table","63");
INSERT INTO migrations VALUES("102","2020_02_28_103340_create_money_transfers_table","64");
INSERT INTO migrations VALUES("103","2020_07_01_193151_add_image_to_categories_table","65");
INSERT INTO migrations VALUES("105","2020_09_26_130426_add_user_id_to_deliveries_table","66");
INSERT INTO migrations VALUES("107","2020_10_11_125457_create_cash_registers_table","67");
INSERT INTO migrations VALUES("108","2020_10_13_155019_add_cash_register_id_to_sales_table","68");
INSERT INTO migrations VALUES("109","2020_10_13_172624_add_cash_register_id_to_returns_table","69");
INSERT INTO migrations VALUES("110","2020_10_17_212338_add_cash_register_id_to_payments_table","70");
INSERT INTO migrations VALUES("111","2020_10_18_124200_add_cash_register_id_to_expenses_table","71");
INSERT INTO migrations VALUES("112","2020_10_21_121632_add_developed_by_to_general_settings_table","72");
INSERT INTO migrations VALUES("113","2019_08_19_000000_create_failed_jobs_table","73");
INSERT INTO migrations VALUES("114","2020_10_30_135557_create_notifications_table","73");
INSERT INTO migrations VALUES("115","2020_11_01_044954_create_currencies_table","74");
INSERT INTO migrations VALUES("116","2020_11_01_140736_add_price_to_product_warehouse_table","75");
INSERT INTO migrations VALUES("117","2020_11_02_050633_add_is_diff_price_to_products_table","76");
INSERT INTO migrations VALUES("118","2020_11_09_055222_add_user_id_to_customers_table","77");
INSERT INTO migrations VALUES("119","2020_11_17_054806_add_invoice_format_to_general_settings_table","78");
INSERT INTO migrations VALUES("120","2021_02_10_074859_add_variant_id_to_product_adjustments_table","79");
INSERT INTO migrations VALUES("121","2021_03_07_093606_create_product_batches_table","80");
INSERT INTO migrations VALUES("122","2021_03_07_093759_add_product_batch_id_to_product_warehouse_table","80");
INSERT INTO migrations VALUES("123","2021_03_07_093900_add_product_batch_id_to_product_purchases_table","80");
INSERT INTO migrations VALUES("124","2021_03_11_132603_add_product_batch_id_to_product_sales_table","81");
INSERT INTO migrations VALUES("127","2021_03_25_125421_add_is_batch_to_products_table","82");
INSERT INTO migrations VALUES("128","2021_05_19_120127_add_product_batch_id_to_product_returns_table","82");
INSERT INTO migrations VALUES("130","2021_05_22_105611_add_product_batch_id_to_purchase_product_return_table","83");
INSERT INTO migrations VALUES("131","2021_05_23_124848_add_product_batch_id_to_product_transfer_table","84");
INSERT INTO migrations VALUES("132","2021_05_26_153106_add_product_batch_id_to_product_quotation_table","85");
INSERT INTO migrations VALUES("133","2021_06_08_213007_create_reward_point_settings_table","86");
INSERT INTO migrations VALUES("134","2021_06_16_104155_add_points_to_customers_table","87");
INSERT INTO migrations VALUES("135","2021_06_17_101057_add_used_points_to_payments_table","88");
INSERT INTO migrations VALUES("136","2021_07_06_132716_add_variant_list_to_products_table","89");
INSERT INTO migrations VALUES("137","2021_09_27_161141_add_is_imei_to_products_table","90");
INSERT INTO migrations VALUES("138","2021_09_28_170052_add_imei_number_to_product_warehouse_table","91");
INSERT INTO migrations VALUES("139","2021_09_28_170126_add_imei_number_to_product_purchases_table","91");
INSERT INTO migrations VALUES("140","2021_10_03_170652_add_imei_number_to_product_sales_table","92");
INSERT INTO migrations VALUES("141","2021_10_10_145214_add_imei_number_to_product_returns_table","93");
INSERT INTO migrations VALUES("142","2021_10_11_104504_add_imei_number_to_product_transfer_table","94");
INSERT INTO migrations VALUES("143","2021_10_12_160107_add_imei_number_to_purchase_product_return_table","95");
INSERT INTO migrations VALUES("144","2021_10_12_205146_add_is_rtl_to_general_settings_table","96");



CREATE TABLE `money_transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `from_account_id` int(11) NOT NULL,
  `to_account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO money_transfers VALUES("2","mtr-20241228-104958","4","1","110","2024-12-28 22:49:58","2024-12-28 22:49:58");
INSERT INTO money_transfers VALUES("3","mtr-20250116-101301","1","5","10000","2025-01-16 10:13:01","2025-01-16 10:13:01");



CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_cheque` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `cheque_no` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_credit_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `customer_stripe_id` varchar(191) DEFAULT NULL,
  `charge_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_gift_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `gift_card_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_paypal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `transaction_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_reference` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `used_points` double DEFAULT NULL,
  `change` double NOT NULL,
  `paying_method` varchar(191) NOT NULL,
  `payment_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payments VALUES("1","spr-20241230-013501","1","","3","1","1","859.36","","140.64","Cash","","2024-12-30 13:35:01","2024-12-30 13:35:01");
INSERT INTO payments VALUES("2","spr-20241230-071632","1","","4","1","1","403.5","","276.5","Cash","","2024-12-30 19:16:32","2024-12-30 19:16:32");
INSERT INTO payments VALUES("3","spr-20250101-104519","1","","5","1","1","201.75","","0","Cash","","2025-01-01 22:45:19","2025-01-01 22:45:19");
INSERT INTO payments VALUES("4","spr-20250101-105213","1","","6","1","1","18.92","","6.08","Cash","","2025-01-01 22:52:13","2025-01-01 22:52:13");
INSERT INTO payments VALUES("5","spr-20250106-020941","1","","7","1","1","455.86","","44.14","Cash","","2025-01-06 14:09:41","2025-01-06 14:09:41");
INSERT INTO payments VALUES("6","spr-20250112-104246","1","","11","10","1","60.09","","39.91","Cash","","2025-01-12 10:42:46","2025-01-12 10:42:46");
INSERT INTO payments VALUES("7","ppr-20250114-062628","1","3","","","1","16358.6","","0","Cash","","2025-01-14 18:26:28","2025-01-14 18:26:28");
INSERT INTO payments VALUES("8","spr-20250116-114345","1","","15","10","1","2","","0","Cash","","2025-01-16 11:43:45","2025-01-16 11:47:51");
INSERT INTO payments VALUES("9","spr-20250118-050420","1","","16","13","5","-98265.01","","0","Cash","","2025-01-18 17:04:20","2025-01-18 17:04:20");
INSERT INTO payments VALUES("10","spr-20250201-101341","1","","18","10","5","0.71","","9.29","Cash","","2025-02-01 10:13:41","2025-02-01 10:13:41");
INSERT INTO payments VALUES("11","spr-20250201-103442","1","","19","10","5","673.33","","0","Cash","","2025-02-01 10:34:42","2025-02-01 10:34:42");
INSERT INTO payments VALUES("12","spr-20250201-103554","1","","20","10","5","673.33","","0","Credit Card","","2025-02-01 10:35:54","2025-02-01 10:35:54");
INSERT INTO payments VALUES("13","ppr-20250203-112925","1","5","","","5","12500","","0","Cash","","2025-02-03 11:29:25","2025-02-03 11:29:25");
INSERT INTO payments VALUES("14","spr-20250203-114136","1","","21","10","5","7070","","-7070","Cash","","2025-02-03 11:41:36","2025-02-03 11:41:36");
INSERT INTO payments VALUES("15","spr-20250203-114158","1","","22","10","5","7070","","0","Cash","","2025-02-03 11:41:58","2025-02-03 11:41:58");
INSERT INTO payments VALUES("16","spr-20250203-114843","1","","23","10","5","22.26","","477.74","Deposit","","2025-02-03 11:48:43","2025-02-03 11:48:43");
INSERT INTO payments VALUES("17","spr-20250203-115015","1","","24","10","5","22.26","","-22.26","Deposit","","2025-02-03 11:50:15","2025-02-03 11:50:15");
INSERT INTO payments VALUES("18","spr-20250203-115534","1","","25","10","5","19.09","1","0","Points","","2025-02-03 11:55:34","2025-02-03 11:55:34");
INSERT INTO payments VALUES("19","spr-20250203-115828","1","","26","10","4","3035","","-2732","Credit Card","","2025-02-03 23:58:28","2025-02-03 23:58:28");
INSERT INTO payments VALUES("20","spr-20250203-115956","1","","27","10","4","3035","","465","Cash","","2025-02-03 23:59:56","2025-02-03 23:59:56");
INSERT INTO payments VALUES("21","spr-20250204-120132","1","","29","10","4","3035","11","0","Points","","2025-02-04 00:01:32","2025-02-04 00:01:32");



CREATE TABLE `payrolls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `paying_method` varchar(191) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payrolls VALUES("1","payroll-20250113-014859","1","1","1","1968.23","2","","2025-01-13 01:48:59","2025-01-13 01:48:59");



CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES("4","products-edit","web","2018-06-03 01:00:09","2018-06-03 01:00:09");
INSERT INTO permissions VALUES("5","products-delete","web","2018-06-03 22:54:22","2018-06-03 22:54:22");
INSERT INTO permissions VALUES("6","products-add","web","2018-06-04 00:34:14","2018-06-04 00:34:14");
INSERT INTO permissions VALUES("7","products-index","web","2018-06-04 03:34:27","2018-06-04 03:34:27");
INSERT INTO permissions VALUES("8","purchases-index","web","2018-06-04 08:03:19","2018-06-04 08:03:19");
INSERT INTO permissions VALUES("9","purchases-add","web","2018-06-04 08:12:25","2018-06-04 08:12:25");
INSERT INTO permissions VALUES("10","purchases-edit","web","2018-06-04 09:47:36","2018-06-04 09:47:36");
INSERT INTO permissions VALUES("11","purchases-delete","web","2018-06-04 09:47:36","2018-06-04 09:47:36");
INSERT INTO permissions VALUES("12","sales-index","web","2018-06-04 10:49:08","2018-06-04 10:49:08");
INSERT INTO permissions VALUES("13","sales-add","web","2018-06-04 10:49:52","2018-06-04 10:49:52");
INSERT INTO permissions VALUES("14","sales-edit","web","2018-06-04 10:49:52","2018-06-04 10:49:52");
INSERT INTO permissions VALUES("15","sales-delete","web","2018-06-04 10:49:53","2018-06-04 10:49:53");
INSERT INTO permissions VALUES("16","quotes-index","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("17","quotes-add","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("18","quotes-edit","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("19","quotes-delete","web","2018-06-04 22:05:10","2018-06-04 22:05:10");
INSERT INTO permissions VALUES("20","transfers-index","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("21","transfers-add","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("22","transfers-edit","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("23","transfers-delete","web","2018-06-04 22:30:03","2018-06-04 22:30:03");
INSERT INTO permissions VALUES("24","returns-index","web","2018-06-04 22:50:24","2018-06-04 22:50:24");
INSERT INTO permissions VALUES("25","returns-add","web","2018-06-04 22:50:24","2018-06-04 22:50:24");
INSERT INTO permissions VALUES("26","returns-edit","web","2018-06-04 22:50:25","2018-06-04 22:50:25");
INSERT INTO permissions VALUES("27","returns-delete","web","2018-06-04 22:50:25","2018-06-04 22:50:25");
INSERT INTO permissions VALUES("28","customers-index","web","2018-06-04 23:15:54","2018-06-04 23:15:54");
INSERT INTO permissions VALUES("29","customers-add","web","2018-06-04 23:15:55","2018-06-04 23:15:55");
INSERT INTO permissions VALUES("30","customers-edit","web","2018-06-04 23:15:55","2018-06-04 23:15:55");
INSERT INTO permissions VALUES("31","customers-delete","web","2018-06-04 23:15:55","2018-06-04 23:15:55");
INSERT INTO permissions VALUES("32","suppliers-index","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("33","suppliers-add","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("34","suppliers-edit","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("35","suppliers-delete","web","2018-06-04 23:40:12","2018-06-04 23:40:12");
INSERT INTO permissions VALUES("36","product-report","web","2018-06-24 23:05:33","2018-06-24 23:05:33");
INSERT INTO permissions VALUES("37","purchase-report","web","2018-06-24 23:24:56","2018-06-24 23:24:56");
INSERT INTO permissions VALUES("38","sale-report","web","2018-06-24 23:33:13","2018-06-24 23:33:13");
INSERT INTO permissions VALUES("39","customer-report","web","2018-06-24 23:36:51","2018-06-24 23:36:51");
INSERT INTO permissions VALUES("40","due-report","web","2018-06-24 23:39:52","2018-06-24 23:39:52");
INSERT INTO permissions VALUES("41","users-index","web","2018-06-25 00:00:10","2018-06-25 00:00:10");
INSERT INTO permissions VALUES("42","users-add","web","2018-06-25 00:00:10","2018-06-25 00:00:10");
INSERT INTO permissions VALUES("43","users-edit","web","2018-06-25 00:01:30","2018-06-25 00:01:30");
INSERT INTO permissions VALUES("44","users-delete","web","2018-06-25 00:01:30","2018-06-25 00:01:30");
INSERT INTO permissions VALUES("45","profit-loss","web","2018-07-14 21:50:05","2018-07-14 21:50:05");
INSERT INTO permissions VALUES("46","best-seller","web","2018-07-14 22:01:38","2018-07-14 22:01:38");
INSERT INTO permissions VALUES("47","daily-sale","web","2018-07-14 22:24:21","2018-07-14 22:24:21");
INSERT INTO permissions VALUES("48","monthly-sale","web","2018-07-14 22:30:41","2018-07-14 22:30:41");
INSERT INTO permissions VALUES("49","daily-purchase","web","2018-07-14 22:36:46","2018-07-14 22:36:46");
INSERT INTO permissions VALUES("50","monthly-purchase","web","2018-07-14 22:48:17","2018-07-14 22:48:17");
INSERT INTO permissions VALUES("51","payment-report","web","2018-07-14 23:10:41","2018-07-14 23:10:41");
INSERT INTO permissions VALUES("52","warehouse-stock-report","web","2018-07-14 23:16:55","2018-07-14 23:16:55");
INSERT INTO permissions VALUES("53","product-qty-alert","web","2018-07-14 23:33:21","2018-07-14 23:33:21");
INSERT INTO permissions VALUES("54","supplier-report","web","2018-07-30 03:00:01","2018-07-30 03:00:01");
INSERT INTO permissions VALUES("55","expenses-index","web","2018-09-05 01:07:10","2018-09-05 01:07:10");
INSERT INTO permissions VALUES("56","expenses-add","web","2018-09-05 01:07:10","2018-09-05 01:07:10");
INSERT INTO permissions VALUES("57","expenses-edit","web","2018-09-05 01:07:10","2018-09-05 01:07:10");
INSERT INTO permissions VALUES("58","expenses-delete","web","2018-09-05 01:07:11","2018-09-05 01:07:11");
INSERT INTO permissions VALUES("59","general_setting","web","2018-10-19 23:10:04","2018-10-19 23:10:04");
INSERT INTO permissions VALUES("60","mail_setting","web","2018-10-19 23:10:04","2018-10-19 23:10:04");
INSERT INTO permissions VALUES("61","pos_setting","web","2018-10-19 23:10:04","2018-10-19 23:10:04");
INSERT INTO permissions VALUES("62","hrm_setting","web","2019-01-02 10:30:23","2019-01-02 10:30:23");
INSERT INTO permissions VALUES("63","purchase-return-index","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("64","purchase-return-add","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("65","purchase-return-edit","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("66","purchase-return-delete","web","2019-01-02 21:45:14","2019-01-02 21:45:14");
INSERT INTO permissions VALUES("67","account-index","web","2019-01-02 22:06:13","2019-01-02 22:06:13");
INSERT INTO permissions VALUES("68","balance-sheet","web","2019-01-02 22:06:14","2019-01-02 22:06:14");
INSERT INTO permissions VALUES("69","account-statement","web","2019-01-02 22:06:14","2019-01-02 22:06:14");
INSERT INTO permissions VALUES("70","department","web","2019-01-02 22:30:01","2019-01-02 22:30:01");
INSERT INTO permissions VALUES("71","attendance","web","2019-01-02 22:30:01","2019-01-02 22:30:01");
INSERT INTO permissions VALUES("72","payroll","web","2019-01-02 22:30:01","2019-01-02 22:30:01");
INSERT INTO permissions VALUES("73","employees-index","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("74","employees-add","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("75","employees-edit","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("76","employees-delete","web","2019-01-02 22:52:19","2019-01-02 22:52:19");
INSERT INTO permissions VALUES("77","user-report","web","2019-01-16 06:48:18","2019-01-16 06:48:18");
INSERT INTO permissions VALUES("78","stock_count","web","2019-02-17 10:32:01","2019-02-17 10:32:01");
INSERT INTO permissions VALUES("79","adjustment","web","2019-02-17 10:32:02","2019-02-17 10:32:02");
INSERT INTO permissions VALUES("80","sms_setting","web","2019-02-22 05:18:03","2019-02-22 05:18:03");
INSERT INTO permissions VALUES("81","create_sms","web","2019-02-22 05:18:03","2019-02-22 05:18:03");
INSERT INTO permissions VALUES("82","print_barcode","web","2019-03-07 05:02:19","2019-03-07 05:02:19");
INSERT INTO permissions VALUES("83","empty_database","web","2019-03-07 05:02:19","2019-03-07 05:02:19");
INSERT INTO permissions VALUES("84","customer_group","web","2019-03-07 05:37:15","2019-03-07 05:37:15");
INSERT INTO permissions VALUES("85","unit","web","2019-03-07 05:37:15","2019-03-07 05:37:15");
INSERT INTO permissions VALUES("86","tax","web","2019-03-07 05:37:15","2019-03-07 05:37:15");
INSERT INTO permissions VALUES("87","gift_card","web","2019-03-07 06:29:38","2019-03-07 06:29:38");
INSERT INTO permissions VALUES("88","coupon","web","2019-03-07 06:29:38","2019-03-07 06:29:38");
INSERT INTO permissions VALUES("89","holiday","web","2019-10-19 08:57:15","2019-10-19 08:57:15");
INSERT INTO permissions VALUES("90","warehouse-report","web","2019-10-22 06:00:23","2019-10-22 06:00:23");
INSERT INTO permissions VALUES("91","warehouse","web","2020-02-26 06:47:32","2020-02-26 06:47:32");
INSERT INTO permissions VALUES("92","brand","web","2020-02-26 06:59:59","2020-02-26 06:59:59");
INSERT INTO permissions VALUES("93","billers-index","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("94","billers-add","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("95","billers-edit","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("96","billers-delete","web","2020-02-26 07:11:15","2020-02-26 07:11:15");
INSERT INTO permissions VALUES("97","money-transfer","web","2020-03-02 05:41:48","2020-03-02 05:41:48");
INSERT INTO permissions VALUES("98","category","web","2020-07-13 12:13:16","2020-07-13 12:13:16");
INSERT INTO permissions VALUES("99","delivery","web","2020-07-13 12:13:16","2020-07-13 12:13:16");
INSERT INTO permissions VALUES("100","send_notification","web","2020-10-31 06:21:31","2020-10-31 06:21:31");
INSERT INTO permissions VALUES("101","today_sale","web","2020-10-31 06:57:04","2020-10-31 06:57:04");
INSERT INTO permissions VALUES("102","today_profit","web","2020-10-31 06:57:04","2020-10-31 06:57:04");
INSERT INTO permissions VALUES("103","currency","web","2020-11-09 00:23:11","2020-11-09 00:23:11");
INSERT INTO permissions VALUES("104","backup_database","web","2020-11-15 00:16:55","2020-11-15 00:16:55");
INSERT INTO permissions VALUES("105","reward_point_setting","web","2021-06-27 04:34:42","2021-06-27 04:34:42");



CREATE TABLE `pos_setting` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `product_number` int(11) NOT NULL,
  `keybord_active` tinyint(1) NOT NULL,
  `stripe_public_key` varchar(191) DEFAULT NULL,
  `stripe_secret_key` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `pos_setting_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pos_setting VALUES("1","4","2","2","5","0","pk_test_ITN7KOYiIsHSCQ0UMRcgaYUB","sk_test_TtQQaawhEYRwa3mU9CzttrEy","2018-09-02 03:17:04","2025-02-01 10:36:53");



CREATE TABLE `product_adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adjustment_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `action` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_batches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `batch_no` varchar(191) NOT NULL,
  `expired_date` date NOT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `recieved` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_purchases VALUES("1","1","2","","","","100","100","1","313","0","0","0","31300","2024-12-27 13:52:49","2024-12-27 13:52:49");
INSERT INTO product_purchases VALUES("2","1","1","","","","10","10","1","235","0","0","0","2350","2024-12-27 13:52:49","2024-12-27 13:52:49");
INSERT INTO product_purchases VALUES("3","2","9","","","","1000","1000","1","0.43","0","16","68.97","500","2025-01-12 10:38:38","2025-01-12 10:38:38");
INSERT INTO product_purchases VALUES("6","3","2","","","","45","30","1","313","0","0","0","14085","2025-01-14 18:29:08","2025-01-14 18:29:08");
INSERT INTO product_purchases VALUES("7","4","12","","","8754685683","10","10","2","150","0","0","0","1500","2025-01-18 17:03:09","2025-01-18 17:03:09");
INSERT INTO product_purchases VALUES("8","5","14","","","","2","2","2","6000","0","0","0","12000","2025-02-03 11:27:36","2025-02-03 11:27:36");
INSERT INTO product_purchases VALUES("9","6","9","","","","1","1","1","0.43","0","16","0.07","0.5","2025-02-03 23:46:23","2025-02-03 23:46:23");
INSERT INTO product_purchases VALUES("10","6","14","","","","1","1","2","1500","0","0","0","1500","2025-02-03 23:46:23","2025-02-03 23:46:23");
INSERT INTO product_purchases VALUES("11","7","16","","","","300000","300000","2","1","0","0","0","300000","2025-02-04 09:56:29","2025-02-04 09:56:29");
INSERT INTO product_purchases VALUES("12","7","15","","","","180000","180000","2","5","0","0","0","900000","2025-02-04 09:56:29","2025-02-04 09:56:29");



CREATE TABLE `product_quotation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_quotation VALUES("1","1","1","","","1","1","201.75","0","0","0","201.75","2025-01-02 20:19:17","2025-01-02 20:19:17");
INSERT INTO product_quotation VALUES("2","2","8","","","6500","0","13.98","0","16","14544.36","105446.64","2025-01-10 08:49:42","2025-01-10 08:49:42");



CREATE TABLE `product_returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_sales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_sales VALUES("1","1","1","","","","2","1","201.75","0","0","0","403.5","2024-12-28 08:02:29","2024-12-28 08:02:29");
INSERT INTO product_sales VALUES("2","2","1","","","","1","1","201.75","0","0","0","201.75","2024-12-28 14:31:11","2024-12-28 14:31:11");
INSERT INTO product_sales VALUES("3","3","2","","","","1","1","455.86","0","0","0","455.86","2024-12-30 13:35:01","2024-12-30 13:35:01");
INSERT INTO product_sales VALUES("4","3","1","","","","2","1","201.75","0","0","0","403.5","2024-12-30 13:35:01","2024-12-30 13:35:01");
INSERT INTO product_sales VALUES("5","4","1","","","","2","1","201.75","0","0","0","403.5","2024-12-30 19:16:32","2024-12-30 19:16:32");
INSERT INTO product_sales VALUES("6","5","1","","","","1","1","201.75","0","0","0","201.75","2025-01-01 22:45:19","2025-01-01 22:45:19");
INSERT INTO product_sales VALUES("7","6","5","","","","1","0","16.31","0","16","2.61","18.92","2025-01-01 22:52:13","2025-01-01 22:52:13");
INSERT INTO product_sales VALUES("8","7","2","","","","1","1","455.86","0","0","0","455.86","2025-01-06 14:09:41","2025-01-06 14:09:41");
INSERT INTO product_sales VALUES("9","8","8","","","","6500","0","13.98","0","16","14544.36","105446.64","2025-01-10 08:51:07","2025-01-10 08:51:07");
INSERT INTO product_sales VALUES("10","9","8","","","","6500","0","13.98","0","16","14544.36","105446.64","2025-01-10 08:52:51","2025-01-10 08:52:51");
INSERT INTO product_sales VALUES("11","10","8","","","","6500","0","13.98","0","0","0","90870","2025-01-10 08:58:08","2025-01-10 08:58:08");
INSERT INTO product_sales VALUES("12","11","9","","","","100","1","0.52","0","16","8.29","60.09","2025-01-12 10:42:46","2025-01-12 10:42:46");
INSERT INTO product_sales VALUES("13","12","9","","","","100","1","0.52","0","16","8.29","60.09","2025-01-12 10:53:44","2025-01-12 10:53:44");
INSERT INTO product_sales VALUES("14","13","9","","","","150","1","0.52","0","16","12.43","90.14","2025-01-12 11:09:51","2025-01-12 11:09:51");
INSERT INTO product_sales VALUES("15","14","8","","","","5","0","16.45","0","16","13.16","95.43","2025-01-13 01:41:00","2025-01-13 01:41:00");
INSERT INTO product_sales VALUES("16","15","9","","","","6","1","0.61","0","16","0.59","4.24","2025-01-16 11:43:45","2025-01-16 11:43:45");
INSERT INTO product_sales VALUES("17","16","12","","","854768754367","1","2","301.99","0","0","0","301.99","2025-01-18 17:04:20","2025-01-18 17:04:20");
INSERT INTO product_sales VALUES("18","18","9","","","","1","1","0.61","0","16","0.1","0.71","2025-02-01 10:13:41","2025-02-01 10:13:41");
INSERT INTO product_sales VALUES("19","19","9","","","","1","1","580.46","0","16","92.87","673.33","2025-02-01 10:34:42","2025-02-01 10:34:42");
INSERT INTO product_sales VALUES("20","20","9","","","","1","1","580.46","0","16","92.87","673.33","2025-02-01 10:35:54","2025-02-01 10:35:54");
INSERT INTO product_sales VALUES("21","21","14","","","","2","2","3535","0","0","0","7070","2025-02-03 11:41:36","2025-02-03 11:41:36");
INSERT INTO product_sales VALUES("22","22","14","","","","2","2","3535","0","0","0","7070","2025-02-03 11:41:58","2025-02-03 11:41:58");
INSERT INTO product_sales VALUES("23","23","5","","","","1","0","19.19","0","16","3.07","22.26","2025-02-03 11:48:43","2025-02-03 11:48:43");
INSERT INTO product_sales VALUES("24","24","5","","","","1","0","19.19","0","16","3.07","22.26","2025-02-03 11:50:15","2025-02-03 11:50:15");
INSERT INTO product_sales VALUES("25","25","8","","","","1","0","16.45","0","16","2.63","19.09","2025-02-03 11:55:34","2025-02-03 11:55:34");
INSERT INTO product_sales VALUES("26","26","14","","","","1","2","3535","0","0","0","3535","2025-02-03 23:58:28","2025-02-03 23:58:28");
INSERT INTO product_sales VALUES("27","27","14","","","","1","2","3535","0","0","0","3535","2025-02-03 23:59:56","2025-02-03 23:59:56");
INSERT INTO product_sales VALUES("28","28","14","","","","1","2","3535","0","0","0","3535","2025-02-04 00:00:06","2025-02-04 00:00:06");
INSERT INTO product_sales VALUES("29","29","14","","","","1","2","3535","0","0","0","3535","2025-02-04 00:01:32","2025-02-04 00:01:32");



CREATE TABLE `product_transfer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_transfer VALUES("1","1","2","","","","1","1","313","0","0","313","2025-02-04 00:15:45","2025-02-04 00:15:45");



CREATE TABLE `product_variants` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  `item_code` varchar(191) NOT NULL,
  `additional_price` double DEFAULT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_variants VALUES("1","11","1","1","Kaspersky-63810948","6000","0","2025-01-16 10:19:37","2025-01-16 10:19:37");



CREATE TABLE `product_warehouse` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` varchar(191) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `warehouse_id` int(11) NOT NULL,
  `qty` double NOT NULL,
  `price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_warehouse VALUES("1","2","","","","1","98","","2024-12-27 13:52:49","2025-01-06 14:09:41");
INSERT INTO product_warehouse VALUES("2","1","","","","1","2","","2024-12-27 13:52:49","2025-01-01 22:45:19");
INSERT INTO product_warehouse VALUES("3","9","","","","2","643","","2025-01-12 10:38:38","2025-02-03 23:46:23");
INSERT INTO product_warehouse VALUES("4","2","","","","2","29","","2025-01-14 18:17:56","2025-02-04 00:15:45");
INSERT INTO product_warehouse VALUES("5","12","","","8754685683","3","9","","2025-01-18 17:03:09","2025-01-18 17:04:20");
INSERT INTO product_warehouse VALUES("6","14","","","","2","-1","","2025-02-03 11:27:36","2025-02-04 00:01:32");
INSERT INTO product_warehouse VALUES("7","2","","","","3","1","","2025-02-04 00:15:45","2025-02-04 00:15:45");
INSERT INTO product_warehouse VALUES("8","16","","","","3","300000","","2025-02-04 09:56:29","2025-02-04 09:56:29");
INSERT INTO product_warehouse VALUES("9","15","","","","3","180000","","2025-02-04 09:56:29","2025-02-04 09:56:29");



CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `barcode_symbology` varchar(191) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `cost` varchar(191) NOT NULL,
  `price` varchar(191) NOT NULL,
  `qty` double DEFAULT NULL,
  `alert_quantity` double DEFAULT NULL,
  `promotion` tinyint(4) DEFAULT NULL,
  `promotion_price` varchar(191) DEFAULT NULL,
  `starting_date` varchar(200) DEFAULT NULL,
  `last_date` date DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_method` int(11) DEFAULT NULL,
  `image` longtext DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `is_variant` tinyint(1) DEFAULT NULL,
  `is_batch` tinyint(1) DEFAULT NULL,
  `is_diffPrice` tinyint(1) DEFAULT NULL,
  `is_imei` tinyint(1) DEFAULT NULL,
  `featured` tinyint(4) DEFAULT NULL,
  `product_list` varchar(191) DEFAULT NULL,
  `variant_list` varchar(191) DEFAULT NULL,
  `qty_list` varchar(191) DEFAULT NULL,
  `price_list` varchar(191) DEFAULT NULL,
  `product_details` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO products VALUES("1","Plexi bb 1,5mm","56082519","standard","C128","","1","1","1","1","235","235","2","10","","","","","","1","17352255258170_0_productGfx_0eeb9ca74b6153d123c95bfdd2061d58.jpg","","","","","","","","","","","","1","2024-12-26 17:06:19","2025-01-01 22:45:19");
INSERT INTO products VALUES("2","Plexi bb 2mm","85043616","standard","C128","","1","1","1","1","313","531","128","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-12-27 13:45:57","2025-01-14 18:29:08");
INSERT INTO products VALUES("3","Plexi bb 3mm","17131905","standard","C128","","1","1","1","1","469","800","0","10","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2024-12-27 13:48:53","2024-12-27 13:48:53");
INSERT INTO products VALUES("4","2.5mm cable","2.51","standard","C128","","4","1","1","1","69","75","0","","","","","","","2","1735741828729image.jpg","","","","","","1","","","","","<p>2.5mm twin an earth cable&nbsp;</p>","1","2025-01-01 16:31:11","2025-01-01 16:31:11");
INSERT INTO products VALUES("5","CAMBIO NEUMÁTICO 8,5&amp;amp;#039; STANDARD","1001","service","C128","","5","0","0","0","0","19","0","","","","","","1","1","1735764534051camara-10x2-para-patinete-xiaomi-mijia-m365-opciones-valvula-recta-y-curva.jpg","","","","0","","0","","","","","","1","2025-01-01 22:49:15","2025-01-01 22:51:15");
INSERT INTO products VALUES("6","Laptop i7","03593891","standard","EAN13","","1","1","1","1","15","20","0","","","","","","","1","zummXD2dvAtI.png","","","","0","1","0","","","","","","1","2025-01-02 16:02:34","2025-01-02 20:18:41");
INSERT INTO products VALUES("7","viande","09506314","standard","C128","","6","1","1","1","15","25","0","20","","","","","","1","1736440278801Côtelette de   veau.jpg","","","","","","1","","","","","","1","2025-01-09 18:31:48","2025-01-09 18:31:48");
INSERT INTO products VALUES("8","Service provide transport used oil kolwezi to kambove","58107480","service","C128","","5","0","0","0","0","16.29","0","","","","","","1","1","zummXD2dvAtI.png","","","","","","","","","","","<p>Service provide transport oil used from kolwezi to kambove</p>
<p>&nbsp;</p>
<p>rate per ton : 16.29$<br /><br /></p>
<p>&nbsp;</p>","1","2025-01-10 08:43:53","2025-01-10 08:43:53");
INSERT INTO products VALUES("9","Sodium Cloride 500ml","20251201","standard","C39","","7","1","1","1","0.5","0.7","643","100","","","","","1","2","1736670462514images.jpg","","","","","","","","","","","<p>Soudium Cloride 0.9 500ml</p>","1","2025-01-12 10:28:16","2025-02-03 23:46:23");
INSERT INTO products VALUES("10","لوح","1","standard","C128","","1","1","1","1","333","1200","0","1","","","","","1","2","zummXD2dvAtI.png","","","","","","1","","","","","","0","2025-01-13 01:30:08","2025-01-13 01:33:10");
INSERT INTO products VALUES("11","Kasperky antivirus","63810948","standard","C128","","2","2","2","2","2000","9000","0","10","","","","","","2","1737022707804Kaspersky-Plus-1-User.png","","1","","0","","1","","","","","<p>Antivirus</p>","1","2025-01-16 10:19:37","2025-01-16 10:21:18");
INSERT INTO products VALUES("12","Dell 5130","10933428","standard","C128","","4","2","2","2","150","299","9","10","","","","","","2","zummXD2dvAtI.png","","","","","1","","","","","","","1","2025-01-18 16:58:49","2025-01-18 17:04:20");
INSERT INTO products VALUES("13","sfg","104215","combo","C128","","1","0","0","0","0","32245","0","","","","","","","1","17379672138207478.jpg","","","","0","","0","4,3,1,7,11",",,,,1","2,2,2,1,2","75,800,235,25,15000","","1","2025-01-27 08:40:39","2025-01-27 08:41:59");
INSERT INTO products VALUES("14","ama","0404","standard","C128","","6","2","2","2","1500","3500","-1","10","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2025-02-03 11:20:54","2025-02-04 00:01:32");
INSERT INTO products VALUES("15","ورق خام 7وز 180 جرام","90701407","standard","C128","","2","2","2","2","5","3.5","180000","100","","","","","","1","zummXD2dvAtI.png","","","","","","1","","","","","","1","2025-02-04 09:43:37","2025-02-04 09:56:29");
INSERT INTO products VALUES("16","ورق مقطع 9وز 250 جرام","90392744","standard","C128","","1","2","2","2","1","00335","300000","500","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","","","1","2025-02-04 09:51:53","2025-02-04 09:56:29");



CREATE TABLE `purchase_product_return` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `imei_number` text DEFAULT NULL,
  `qty` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `paid_amount` double NOT NULL,
  `status` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchases VALUES("1","pr-20241227-015249","1","1","","2","110","0","0","33650","0","0","","","33650","0","1","1","","","2024-12-27 13:52:49","2024-12-27 13:52:49");
INSERT INTO purchases VALUES("2","pr-20250112-103838","1","2","","1","1000","0","68.97","500","16","80","","500","1080","0","1","1","images.jpg","","2025-01-12 10:38:38","2025-01-12 10:38:38");
INSERT INTO purchases VALUES("3","pr-20250114-061756","1","2","","1","45","0","0","14085","16","2253.6","0","20","16358.6","16358.6","2","2","","","2025-01-14 18:17:56","2025-01-14 18:29:08");
INSERT INTO purchases VALUES("4","pr-20250118-050309","1","3","","1","10","0","0","1500","0","0","","","1500","0","1","1","","","2025-01-18 17:03:09","2025-01-18 17:03:09");
INSERT INTO purchases VALUES("5","pr-20250203-112736","1","2","1","1","2","0","0","12000","0","0","","500","12500","12500","1","2","","","2025-02-03 11:27:36","2025-02-03 11:29:25");
INSERT INTO purchases VALUES("6","pr-20250203-114623","1","2","1","2","2","0","0.07","1500.5","0","0","","","1500.5","0","1","1","","","2025-02-03 23:46:23","2025-02-03 23:46:23");
INSERT INTO purchases VALUES("7","pr-20250204-095629","1","3","1","2","480000","0","0","1200000","0","0","","","1200000","0","1","1","","","2025-02-04 09:56:29","2025-02-04 09:56:29");



CREATE TABLE `quotations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `quotation_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO quotations VALUES("1","qr-20250102-081917","1","1","","2","1","1","1","0","0","201.75","0","0","","","201.75","1","","","2025-01-02 20:19:17","2025-01-02 20:19:17");
INSERT INTO quotations VALUES("2","qr-20250110-084942","1","2","","1","1","1","6500","0","14544.36","105446.64","16","16871.46","","7.38","122325.48","1","","Invoice December 2024","2025-01-10 08:49:42","2025-01-10 08:49:42");



CREATE TABLE `return_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `reward_point_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `per_point_amount` double NOT NULL,
  `minimum_amount` double NOT NULL,
  `duration` int(11) DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO reward_point_settings VALUES("1","300","1000","1","Year","1","2021-06-08 15:40:15","2021-06-27 05:20:55");



CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES("4","1");
INSERT INTO role_has_permissions VALUES("4","2");
INSERT INTO role_has_permissions VALUES("4","4");
INSERT INTO role_has_permissions VALUES("4","9");
INSERT INTO role_has_permissions VALUES("4","11");
INSERT INTO role_has_permissions VALUES("5","1");
INSERT INTO role_has_permissions VALUES("5","2");
INSERT INTO role_has_permissions VALUES("5","9");
INSERT INTO role_has_permissions VALUES("6","1");
INSERT INTO role_has_permissions VALUES("6","2");
INSERT INTO role_has_permissions VALUES("6","4");
INSERT INTO role_has_permissions VALUES("6","9");
INSERT INTO role_has_permissions VALUES("6","11");
INSERT INTO role_has_permissions VALUES("7","1");
INSERT INTO role_has_permissions VALUES("7","2");
INSERT INTO role_has_permissions VALUES("7","4");
INSERT INTO role_has_permissions VALUES("7","9");
INSERT INTO role_has_permissions VALUES("7","11");
INSERT INTO role_has_permissions VALUES("8","1");
INSERT INTO role_has_permissions VALUES("8","2");
INSERT INTO role_has_permissions VALUES("8","4");
INSERT INTO role_has_permissions VALUES("8","9");
INSERT INTO role_has_permissions VALUES("9","1");
INSERT INTO role_has_permissions VALUES("9","2");
INSERT INTO role_has_permissions VALUES("9","4");
INSERT INTO role_has_permissions VALUES("9","9");
INSERT INTO role_has_permissions VALUES("10","1");
INSERT INTO role_has_permissions VALUES("10","2");
INSERT INTO role_has_permissions VALUES("10","9");
INSERT INTO role_has_permissions VALUES("11","1");
INSERT INTO role_has_permissions VALUES("11","2");
INSERT INTO role_has_permissions VALUES("11","9");
INSERT INTO role_has_permissions VALUES("12","1");
INSERT INTO role_has_permissions VALUES("12","2");
INSERT INTO role_has_permissions VALUES("12","4");
INSERT INTO role_has_permissions VALUES("12","6");
INSERT INTO role_has_permissions VALUES("12","7");
INSERT INTO role_has_permissions VALUES("12","9");
INSERT INTO role_has_permissions VALUES("12","10");
INSERT INTO role_has_permissions VALUES("12","11");
INSERT INTO role_has_permissions VALUES("13","1");
INSERT INTO role_has_permissions VALUES("13","2");
INSERT INTO role_has_permissions VALUES("13","4");
INSERT INTO role_has_permissions VALUES("13","6");
INSERT INTO role_has_permissions VALUES("13","7");
INSERT INTO role_has_permissions VALUES("13","9");
INSERT INTO role_has_permissions VALUES("13","11");
INSERT INTO role_has_permissions VALUES("14","1");
INSERT INTO role_has_permissions VALUES("14","2");
INSERT INTO role_has_permissions VALUES("14","6");
INSERT INTO role_has_permissions VALUES("14","7");
INSERT INTO role_has_permissions VALUES("14","9");
INSERT INTO role_has_permissions VALUES("15","1");
INSERT INTO role_has_permissions VALUES("15","2");
INSERT INTO role_has_permissions VALUES("15","6");
INSERT INTO role_has_permissions VALUES("15","7");
INSERT INTO role_has_permissions VALUES("15","9");
INSERT INTO role_has_permissions VALUES("16","1");
INSERT INTO role_has_permissions VALUES("16","2");
INSERT INTO role_has_permissions VALUES("16","9");
INSERT INTO role_has_permissions VALUES("16","11");
INSERT INTO role_has_permissions VALUES("17","1");
INSERT INTO role_has_permissions VALUES("17","2");
INSERT INTO role_has_permissions VALUES("17","9");
INSERT INTO role_has_permissions VALUES("17","11");
INSERT INTO role_has_permissions VALUES("18","1");
INSERT INTO role_has_permissions VALUES("18","2");
INSERT INTO role_has_permissions VALUES("18","9");
INSERT INTO role_has_permissions VALUES("18","11");
INSERT INTO role_has_permissions VALUES("19","1");
INSERT INTO role_has_permissions VALUES("19","2");
INSERT INTO role_has_permissions VALUES("19","9");
INSERT INTO role_has_permissions VALUES("20","1");
INSERT INTO role_has_permissions VALUES("20","2");
INSERT INTO role_has_permissions VALUES("20","4");
INSERT INTO role_has_permissions VALUES("20","9");
INSERT INTO role_has_permissions VALUES("21","1");
INSERT INTO role_has_permissions VALUES("21","2");
INSERT INTO role_has_permissions VALUES("21","4");
INSERT INTO role_has_permissions VALUES("21","9");
INSERT INTO role_has_permissions VALUES("22","1");
INSERT INTO role_has_permissions VALUES("22","2");
INSERT INTO role_has_permissions VALUES("22","4");
INSERT INTO role_has_permissions VALUES("22","9");
INSERT INTO role_has_permissions VALUES("23","1");
INSERT INTO role_has_permissions VALUES("23","2");
INSERT INTO role_has_permissions VALUES("23","9");
INSERT INTO role_has_permissions VALUES("24","1");
INSERT INTO role_has_permissions VALUES("24","2");
INSERT INTO role_has_permissions VALUES("24","4");
INSERT INTO role_has_permissions VALUES("24","9");
INSERT INTO role_has_permissions VALUES("25","1");
INSERT INTO role_has_permissions VALUES("25","2");
INSERT INTO role_has_permissions VALUES("25","4");
INSERT INTO role_has_permissions VALUES("25","9");
INSERT INTO role_has_permissions VALUES("26","1");
INSERT INTO role_has_permissions VALUES("26","2");
INSERT INTO role_has_permissions VALUES("26","9");
INSERT INTO role_has_permissions VALUES("27","1");
INSERT INTO role_has_permissions VALUES("27","2");
INSERT INTO role_has_permissions VALUES("27","9");
INSERT INTO role_has_permissions VALUES("28","1");
INSERT INTO role_has_permissions VALUES("28","2");
INSERT INTO role_has_permissions VALUES("28","4");
INSERT INTO role_has_permissions VALUES("28","9");
INSERT INTO role_has_permissions VALUES("28","10");
INSERT INTO role_has_permissions VALUES("28","11");
INSERT INTO role_has_permissions VALUES("29","1");
INSERT INTO role_has_permissions VALUES("29","2");
INSERT INTO role_has_permissions VALUES("29","4");
INSERT INTO role_has_permissions VALUES("29","9");
INSERT INTO role_has_permissions VALUES("29","10");
INSERT INTO role_has_permissions VALUES("29","11");
INSERT INTO role_has_permissions VALUES("30","1");
INSERT INTO role_has_permissions VALUES("30","2");
INSERT INTO role_has_permissions VALUES("30","9");
INSERT INTO role_has_permissions VALUES("30","10");
INSERT INTO role_has_permissions VALUES("30","11");
INSERT INTO role_has_permissions VALUES("31","1");
INSERT INTO role_has_permissions VALUES("31","2");
INSERT INTO role_has_permissions VALUES("31","9");
INSERT INTO role_has_permissions VALUES("32","1");
INSERT INTO role_has_permissions VALUES("32","2");
INSERT INTO role_has_permissions VALUES("32","9");
INSERT INTO role_has_permissions VALUES("33","1");
INSERT INTO role_has_permissions VALUES("33","2");
INSERT INTO role_has_permissions VALUES("33","9");
INSERT INTO role_has_permissions VALUES("34","1");
INSERT INTO role_has_permissions VALUES("34","2");
INSERT INTO role_has_permissions VALUES("34","9");
INSERT INTO role_has_permissions VALUES("35","1");
INSERT INTO role_has_permissions VALUES("35","2");
INSERT INTO role_has_permissions VALUES("35","9");
INSERT INTO role_has_permissions VALUES("36","1");
INSERT INTO role_has_permissions VALUES("36","2");
INSERT INTO role_has_permissions VALUES("36","9");
INSERT INTO role_has_permissions VALUES("37","1");
INSERT INTO role_has_permissions VALUES("37","2");
INSERT INTO role_has_permissions VALUES("38","1");
INSERT INTO role_has_permissions VALUES("38","2");
INSERT INTO role_has_permissions VALUES("39","1");
INSERT INTO role_has_permissions VALUES("39","2");
INSERT INTO role_has_permissions VALUES("40","1");
INSERT INTO role_has_permissions VALUES("40","2");
INSERT INTO role_has_permissions VALUES("41","1");
INSERT INTO role_has_permissions VALUES("41","2");
INSERT INTO role_has_permissions VALUES("42","1");
INSERT INTO role_has_permissions VALUES("42","2");
INSERT INTO role_has_permissions VALUES("43","1");
INSERT INTO role_has_permissions VALUES("43","2");
INSERT INTO role_has_permissions VALUES("44","1");
INSERT INTO role_has_permissions VALUES("44","2");
INSERT INTO role_has_permissions VALUES("45","1");
INSERT INTO role_has_permissions VALUES("45","2");
INSERT INTO role_has_permissions VALUES("45","6");
INSERT INTO role_has_permissions VALUES("45","10");
INSERT INTO role_has_permissions VALUES("46","1");
INSERT INTO role_has_permissions VALUES("46","2");
INSERT INTO role_has_permissions VALUES("46","9");
INSERT INTO role_has_permissions VALUES("47","1");
INSERT INTO role_has_permissions VALUES("47","2");
INSERT INTO role_has_permissions VALUES("47","6");
INSERT INTO role_has_permissions VALUES("47","9");
INSERT INTO role_has_permissions VALUES("47","11");
INSERT INTO role_has_permissions VALUES("48","1");
INSERT INTO role_has_permissions VALUES("48","2");
INSERT INTO role_has_permissions VALUES("48","11");
INSERT INTO role_has_permissions VALUES("49","1");
INSERT INTO role_has_permissions VALUES("49","2");
INSERT INTO role_has_permissions VALUES("49","10");
INSERT INTO role_has_permissions VALUES("50","1");
INSERT INTO role_has_permissions VALUES("50","2");
INSERT INTO role_has_permissions VALUES("51","1");
INSERT INTO role_has_permissions VALUES("51","2");
INSERT INTO role_has_permissions VALUES("52","1");
INSERT INTO role_has_permissions VALUES("52","2");
INSERT INTO role_has_permissions VALUES("52","9");
INSERT INTO role_has_permissions VALUES("53","1");
INSERT INTO role_has_permissions VALUES("53","2");
INSERT INTO role_has_permissions VALUES("53","9");
INSERT INTO role_has_permissions VALUES("53","11");
INSERT INTO role_has_permissions VALUES("54","1");
INSERT INTO role_has_permissions VALUES("54","2");
INSERT INTO role_has_permissions VALUES("54","9");
INSERT INTO role_has_permissions VALUES("55","1");
INSERT INTO role_has_permissions VALUES("55","2");
INSERT INTO role_has_permissions VALUES("55","4");
INSERT INTO role_has_permissions VALUES("55","9");
INSERT INTO role_has_permissions VALUES("55","11");
INSERT INTO role_has_permissions VALUES("56","1");
INSERT INTO role_has_permissions VALUES("56","2");
INSERT INTO role_has_permissions VALUES("56","4");
INSERT INTO role_has_permissions VALUES("56","9");
INSERT INTO role_has_permissions VALUES("56","11");
INSERT INTO role_has_permissions VALUES("57","1");
INSERT INTO role_has_permissions VALUES("57","2");
INSERT INTO role_has_permissions VALUES("57","4");
INSERT INTO role_has_permissions VALUES("57","9");
INSERT INTO role_has_permissions VALUES("57","11");
INSERT INTO role_has_permissions VALUES("58","1");
INSERT INTO role_has_permissions VALUES("58","2");
INSERT INTO role_has_permissions VALUES("58","9");
INSERT INTO role_has_permissions VALUES("59","1");
INSERT INTO role_has_permissions VALUES("59","2");
INSERT INTO role_has_permissions VALUES("60","1");
INSERT INTO role_has_permissions VALUES("60","2");
INSERT INTO role_has_permissions VALUES("61","1");
INSERT INTO role_has_permissions VALUES("61","2");
INSERT INTO role_has_permissions VALUES("62","1");
INSERT INTO role_has_permissions VALUES("62","2");
INSERT INTO role_has_permissions VALUES("63","1");
INSERT INTO role_has_permissions VALUES("63","2");
INSERT INTO role_has_permissions VALUES("63","4");
INSERT INTO role_has_permissions VALUES("63","9");
INSERT INTO role_has_permissions VALUES("64","1");
INSERT INTO role_has_permissions VALUES("64","2");
INSERT INTO role_has_permissions VALUES("64","4");
INSERT INTO role_has_permissions VALUES("64","9");
INSERT INTO role_has_permissions VALUES("65","1");
INSERT INTO role_has_permissions VALUES("65","2");
INSERT INTO role_has_permissions VALUES("65","9");
INSERT INTO role_has_permissions VALUES("66","1");
INSERT INTO role_has_permissions VALUES("66","2");
INSERT INTO role_has_permissions VALUES("66","9");
INSERT INTO role_has_permissions VALUES("67","1");
INSERT INTO role_has_permissions VALUES("67","2");
INSERT INTO role_has_permissions VALUES("68","1");
INSERT INTO role_has_permissions VALUES("68","2");
INSERT INTO role_has_permissions VALUES("69","1");
INSERT INTO role_has_permissions VALUES("69","2");
INSERT INTO role_has_permissions VALUES("70","1");
INSERT INTO role_has_permissions VALUES("70","2");
INSERT INTO role_has_permissions VALUES("71","1");
INSERT INTO role_has_permissions VALUES("71","2");
INSERT INTO role_has_permissions VALUES("72","1");
INSERT INTO role_has_permissions VALUES("72","2");
INSERT INTO role_has_permissions VALUES("73","1");
INSERT INTO role_has_permissions VALUES("73","2");
INSERT INTO role_has_permissions VALUES("74","1");
INSERT INTO role_has_permissions VALUES("74","2");
INSERT INTO role_has_permissions VALUES("75","1");
INSERT INTO role_has_permissions VALUES("75","2");
INSERT INTO role_has_permissions VALUES("76","1");
INSERT INTO role_has_permissions VALUES("76","2");
INSERT INTO role_has_permissions VALUES("77","1");
INSERT INTO role_has_permissions VALUES("77","2");
INSERT INTO role_has_permissions VALUES("78","1");
INSERT INTO role_has_permissions VALUES("78","2");
INSERT INTO role_has_permissions VALUES("79","1");
INSERT INTO role_has_permissions VALUES("79","2");
INSERT INTO role_has_permissions VALUES("79","9");
INSERT INTO role_has_permissions VALUES("80","1");
INSERT INTO role_has_permissions VALUES("80","2");
INSERT INTO role_has_permissions VALUES("81","1");
INSERT INTO role_has_permissions VALUES("81","2");
INSERT INTO role_has_permissions VALUES("82","1");
INSERT INTO role_has_permissions VALUES("82","2");
INSERT INTO role_has_permissions VALUES("82","9");
INSERT INTO role_has_permissions VALUES("83","1");
INSERT INTO role_has_permissions VALUES("83","2");
INSERT INTO role_has_permissions VALUES("84","1");
INSERT INTO role_has_permissions VALUES("84","2");
INSERT INTO role_has_permissions VALUES("85","1");
INSERT INTO role_has_permissions VALUES("85","2");
INSERT INTO role_has_permissions VALUES("86","1");
INSERT INTO role_has_permissions VALUES("86","2");
INSERT INTO role_has_permissions VALUES("87","1");
INSERT INTO role_has_permissions VALUES("87","2");
INSERT INTO role_has_permissions VALUES("88","1");
INSERT INTO role_has_permissions VALUES("88","2");
INSERT INTO role_has_permissions VALUES("88","10");
INSERT INTO role_has_permissions VALUES("89","1");
INSERT INTO role_has_permissions VALUES("89","2");
INSERT INTO role_has_permissions VALUES("90","1");
INSERT INTO role_has_permissions VALUES("90","2");
INSERT INTO role_has_permissions VALUES("90","9");
INSERT INTO role_has_permissions VALUES("91","1");
INSERT INTO role_has_permissions VALUES("91","2");
INSERT INTO role_has_permissions VALUES("91","9");
INSERT INTO role_has_permissions VALUES("91","10");
INSERT INTO role_has_permissions VALUES("92","1");
INSERT INTO role_has_permissions VALUES("92","2");
INSERT INTO role_has_permissions VALUES("93","1");
INSERT INTO role_has_permissions VALUES("93","2");
INSERT INTO role_has_permissions VALUES("93","11");
INSERT INTO role_has_permissions VALUES("94","1");
INSERT INTO role_has_permissions VALUES("94","2");
INSERT INTO role_has_permissions VALUES("94","11");
INSERT INTO role_has_permissions VALUES("95","1");
INSERT INTO role_has_permissions VALUES("95","2");
INSERT INTO role_has_permissions VALUES("95","11");
INSERT INTO role_has_permissions VALUES("96","1");
INSERT INTO role_has_permissions VALUES("96","2");
INSERT INTO role_has_permissions VALUES("97","1");
INSERT INTO role_has_permissions VALUES("97","2");
INSERT INTO role_has_permissions VALUES("98","1");
INSERT INTO role_has_permissions VALUES("98","2");
INSERT INTO role_has_permissions VALUES("98","11");
INSERT INTO role_has_permissions VALUES("99","1");
INSERT INTO role_has_permissions VALUES("99","2");
INSERT INTO role_has_permissions VALUES("99","11");
INSERT INTO role_has_permissions VALUES("100","1");
INSERT INTO role_has_permissions VALUES("100","2");
INSERT INTO role_has_permissions VALUES("100","10");
INSERT INTO role_has_permissions VALUES("101","1");
INSERT INTO role_has_permissions VALUES("101","2");
INSERT INTO role_has_permissions VALUES("101","11");
INSERT INTO role_has_permissions VALUES("102","1");
INSERT INTO role_has_permissions VALUES("102","2");
INSERT INTO role_has_permissions VALUES("103","1");
INSERT INTO role_has_permissions VALUES("103","2");
INSERT INTO role_has_permissions VALUES("104","1");
INSERT INTO role_has_permissions VALUES("104","2");
INSERT INTO role_has_permissions VALUES("105","1");
INSERT INTO role_has_permissions VALUES("105","2");



CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `guard_name` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES("1","Admin","admin can access all data...","web","1","2018-06-01 23:46:44","2018-06-02 23:13:05");
INSERT INTO roles VALUES("2","Owner","Owner of shop...","web","1","2018-10-22 02:38:13","2018-10-22 02:38:13");
INSERT INTO roles VALUES("4","staff","staff has specific acess...","web","1","2018-06-02 00:05:27","2018-06-02 00:05:27");
INSERT INTO roles VALUES("5","Customer","","web","1","2020-11-05 06:43:16","2020-11-15 00:24:15");
INSERT INTO roles VALUES("6","Billing","Can only access pos","web","1","2024-08-10 10:00:56","2024-08-10 10:00:56");
INSERT INTO roles VALUES("7","orxan","üarehouse","web","1","2024-09-10 00:12:50","2024-09-10 00:12:50");
INSERT INTO roles VALUES("8","ABBY","Cashier","web","1","2024-10-10 05:38:22","2024-10-10 05:38:22");
INSERT INTO roles VALUES("9","TL","TL","web","1","2024-11-11 01:58:16","2024-11-11 01:58:16");
INSERT INTO roles VALUES("10","Hotspot","","web","1","2025-01-12 10:59:00","2025-01-12 10:59:00");
INSERT INTO roles VALUES("11","Assistante","","web","1","2025-01-16 09:50:49","2025-01-16 09:50:49");



CREATE TABLE `sales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) DEFAULT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `grand_total` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `coupon_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `sale_status` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `paid_amount` double DEFAULT NULL,
  `sale_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO sales VALUES("1","12","1","1","1","1","","4","7","0","0","403.5","403.5","0","0","","","","","1","4","","403.5","","","2024-12-28 08:02:28","2024-12-28 08:02:28");
INSERT INTO sales VALUES("2","Ref0000001","1","1","1","1","1","1","1","0","0","201.75","201.75","0","0","","","","","1","1","","","","","2024-12-28 14:31:11","2024-12-28 14:31:11");
INSERT INTO sales VALUES("3","posr-20241230-013501","1","1","1","1","2","2","3","0","0","859.36","859.36","0","0","","","","","1","4","","859.36","","","2024-12-30 13:35:01","2024-12-30 13:35:01");
INSERT INTO sales VALUES("4","posr-20241230-071632","1","1","2","1","1","1","2","0","0","403.5","403.5","0","0","","","","","1","4","","403.5","","","2024-12-30 19:16:32","2024-12-30 19:16:32");
INSERT INTO sales VALUES("5","posr-20250101-104519","1","1","2","1","1","1","1","0","0","201.75","201.75","0","0","","","","","1","4","","201.75","","","2025-01-01 22:45:19","2025-01-01 22:45:19");
INSERT INTO sales VALUES("6","posr-20250101-105213","1","1","2","1","1","1","1","0","2.61","18.92","18.92","0","0","","","","","1","4","","18.92","","","2025-01-01 22:52:13","2025-01-01 22:52:13");
INSERT INTO sales VALUES("7","1","1","1","2","1","1","1","1","0","0","455.86","455.86","0","0","","","","","1","4","","455.86","","","2025-01-06 14:09:41","2025-01-06 14:09:41");
INSERT INTO sales VALUES("8","PO 34 OS","1","1","1","1","2","1","6500","0","14544.36","105446.64","122325.48","16","16871.46","0","","","7.38","1","2","","","Invoice December 2024","","2025-01-10 08:51:07","2025-01-10 08:51:07");
INSERT INTO sales VALUES("9","sr-20250110-085251","1","1","1","1","2","1","6500","0","14544.36","105446.64","122325.48","16","16871.46","0","","","7.38","1","1","","","Invoice December 2024","","2025-01-10 08:52:51","2025-01-10 08:52:51");
INSERT INTO sales VALUES("10","sr-20250110-085808","1","1","1","1","2","1","6500","0","0","90870","105416.58","16","14539.2","0","","","7.38","1","1","","","Invoice December 2024","","2025-01-10 08:58:08","2025-01-10 08:58:08");
INSERT INTO sales VALUES("11","posr-20250112-104246","1","10","2","2","1","1","100","0","8.29","60.09","60.09","0","0","","","","","1","4","","60.09","","","2025-01-12 10:42:46","2025-01-12 10:42:46");
INSERT INTO sales VALUES("12","sr-20250112-105344","1","10","2","2","3","1","100","0","8.29","60.09","69.7","16","9.61","","","","","1","1","","","","","2025-01-12 10:53:44","2025-01-12 10:53:44");
INSERT INTO sales VALUES("13","20251201","1","10","1","2","3","1","150","0","12.43","90.14","134.56","16","14.42","","","","30","1","1","","","","","2025-01-12 11:09:51","2025-01-12 11:09:51");
INSERT INTO sales VALUES("14","sr-20250113-014100","1","10","1","2","1","1","5","0","13.16","95.43","95.43","0","0","","","","","1","2","","","","","2025-01-13 01:41:00","2025-01-13 01:41:00");
INSERT INTO sales VALUES("15","sr-20250116-114345","1","10","3","2","1","1","6","0","0.59","4.24","3.24","0","0","1","","","","1","2","","2","","","2025-01-16 11:43:45","2025-01-16 11:47:51");
INSERT INTO sales VALUES("16","posr-20250118-050420","1","13","2","3","1","1","1","0","0","301.99","-98265.01","0","0","98567","","","","1","4","","-98265.01","","","2025-01-18 17:04:20","2025-01-18 17:04:20");
INSERT INTO sales VALUES("17","sr-20250127-095040","1","13","4","3","1","1","1","0","0","32567.45","32567.45","0","0","","","","","1","1","","","","","2025-01-27 09:50:40","2025-01-27 09:50:40");
INSERT INTO sales VALUES("18","posr-20250201-101341","1","10","4","2","1","1","1","0","0.1","0.71","0.71","0","0","","","","","1","4","","0.71","","","2025-02-01 10:13:41","2025-02-01 10:13:41");
INSERT INTO sales VALUES("19","posr-20250201-103442","1","10","4","2","2","1","1","0","92.87","673.33","673.33","0","0","","","","","1","4","","673.33","","","2025-02-01 10:34:42","2025-02-01 10:34:42");
INSERT INTO sales VALUES("20","posr-20250201-103554","1","10","4","2","2","1","1","0","92.87","673.33","673.33","0","0","","","","","3","4","","673.33","","","2025-02-01 10:35:54","2025-02-01 10:35:54");
INSERT INTO sales VALUES("21","posr-20250203-114136","1","10","5","2","2","1","2","0","0","7070","7070","0","0","","","","","3","4","","7070","","","2025-02-03 11:41:36","2025-02-03 11:41:36");
INSERT INTO sales VALUES("22","posr-20250203-114158","1","10","4","2","2","1","2","0","0","7070","7070","0","0","","","","","1","4","","7070","","","2025-02-03 11:41:58","2025-02-03 11:41:58");
INSERT INTO sales VALUES("23","posr-20250203-114843","1","10","4","2","2","1","1","0","3.07","22.26","22.26","0","0","","","","","1","4","","22.26","","","2025-02-03 11:48:43","2025-02-03 11:48:43");
INSERT INTO sales VALUES("24","posr-20250203-115015","1","10","4","2","2","1","1","0","3.07","22.26","22.26","0","0","","","","","1","4","","22.26","","","2025-02-03 11:50:15","2025-02-03 11:50:15");
INSERT INTO sales VALUES("25","posr-20250203-115534","1","10","4","2","2","1","1","0","2.63","19.09","19.09","0","0","","","","","1","4","","19.09","","","2025-02-03 11:55:34","2025-02-03 11:55:34");
INSERT INTO sales VALUES("26","posr-20250203-115828","1","10","4","2","2","1","1","0","0","3535","3035","0","0","500","","","","1","4","","3035","","","2025-02-03 23:58:28","2025-02-03 23:58:28");
INSERT INTO sales VALUES("27","posr-20250203-115956","1","10","4","2","2","1","1","0","0","3535","3035","0","0","500","","","","3","4","","3035","","","2025-02-03 23:59:56","2025-02-03 23:59:56");
INSERT INTO sales VALUES("28","posr-20250204-120006","1","10","4","2","2","1","1","0","0","3535","3035","0","0","500","","","","3","2","","","","","2025-02-04 00:00:06","2025-02-04 00:00:06");
INSERT INTO sales VALUES("29","posr-20250204-120132","1","10","4","2","2","1","1","0","0","3535","3035","0","0","500","","","","1","4","","3035","","","2025-02-04 00:01:32","2025-02-04 00:01:32");



CREATE TABLE `stock_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `category_id` varchar(191) DEFAULT NULL,
  `brand_id` varchar(191) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) NOT NULL,
  `initial_file` varchar(191) DEFAULT NULL,
  `final_file` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_adjusted` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO stock_counts VALUES("1","scr-20250112-104733","2","","","1","full","20250112-104733.csv","","","0","2025-01-12 10:47:33","2025-01-12 10:47:33");
INSERT INTO stock_counts VALUES("2","scr-20250114-063722","2","","","1","full","20250114-063722.csv","","","0","2025-01-14 18:37:22","2025-01-14 18:37:22");



CREATE TABLE `suppliers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `vat_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO suppliers VALUES("1","TE","","TE GmbH","","lskj@te.com","012654897526","haadffjlkjja","nuernberg","","","Germany","1","2025-01-27 08:43:42","2025-01-27 08:43:42");



CREATE TABLE `taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `rate` double NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO taxes VALUES("1","TVA","16","1","2024-12-28 14:28:34","2024-12-28 14:28:34");
INSERT INTO taxes VALUES("2","SRL LAMA","18","1","2025-01-07 18:02:58","2025-01-07 18:02:58");
INSERT INTO taxes VALUES("3","iva","19","1","2025-02-01 10:23:07","2025-02-01 10:23:07");



CREATE TABLE `transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `from_warehouse_id` int(11) NOT NULL,
  `to_warehouse_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO transfers VALUES("1","tr-20250204-121545","1","1","2","3","1","1","0","313","500","813","","","2025-02-04 00:15:45","2025-02-04 00:15:45");



CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unit_code` varchar(191) NOT NULL,
  `unit_name` varchar(191) NOT NULL,
  `base_unit` int(11) DEFAULT NULL,
  `operator` varchar(191) DEFAULT NULL,
  `operation_value` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO units VALUES("1","szt","szt","","*","1","0","2024-12-26 17:04:21","2025-02-04 11:38:31");
INSERT INTO units VALUES("2","tonne","Pièces","3","كرتونة","1","1","2025-01-16 09:47:05","2025-02-04 11:38:10");
INSERT INTO units VALUES("3","Ton","Tonne","","*","1","0","2025-02-04 10:00:42","2025-02-04 11:38:39");



CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `password` varchar(191) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `phone` varchar(191) NOT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `role_id` int(11) NOT NULL,
  `biller_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `is_deleted` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES("1","admin","admin@gmail.com","$2y$10$DWAHTfjcvwCpOCXaJg11MOhsqns03uvlwiSUOQwkHL2YYrtrXPcL6","LGGvToeOoxwbB4zYfbfapISgltEDIff9sKFFPnXwMorBcfnxoAfYEGTuYSAS","12112","HMH BUSINESS","1","","","1","0","2018-06-02 03:24:15","2024-10-02 08:56:51");
INSERT INTO users VALUES("3","dhiman da","dhiman@gmail.com","$2y$10$Fef6vu5E67nm11hX7V5a2u1ThNCQ6n9DRCvRF9TD7stk.Pmt2R6O.","5ehQM6JIfiQfROgTbB5let0Z93vjLHS7rd9QD5RPNgOxli3xdo7fykU7vtTt","212","lioncoders","1","","","0","1","2018-06-13 22:00:31","2020-11-05 07:06:51");
INSERT INTO users VALUES("6","test","test@gmail.com","$2y$10$TDAeHcVqHyCmurki0wjLZeIl1SngKX3WLOhyTiCoZG3souQfqv.LS","KpW1gYYlOFacumklO2IcRfSsbC3KcWUZzOI37gqoqM388Xie6KdhaOHIFEYm","1234","212312","4","","","0","1","2018-06-23 03:05:33","2018-06-23 03:13:45");
INSERT INTO users VALUES("8","test","test@yahoo.com","$2y$10$hlMigidZV0j2/IPkgE/xsOSb8WM2IRlsMv.1hg1NM7kfyd6bGX3hC","","31231","","4","","","0","1","2018-06-24 22:35:49","2018-07-02 01:07:39");
INSERT INTO users VALUES("9","staff","anda@gmail.com","$2y$10$kxDbnynB6mB1e1w3pmtbSOlSxy/WwbLPY5TJpMi0Opao5ezfuQjQm","dLNcktdks0IxKepKusPC61sjhCPt6UXBhYwXwxbQe89o2ZOQBJo5YZ9oteEA","3123","","4","5","1","1","0","2018-07-02 01:08:08","2018-10-23 21:41:13");
INSERT INTO users VALUES("10","abul","abul@alpha.com","$2y$10$5zgB2OOMyNBNVAd.QOQIju5a9fhNnTqPx5H6s4oFlXhNiF6kXEsPq","x7HlttI5bM0vSKViqATaowHFJkLS3PHwfvl7iJdFl5Z1SsyUgWCVbLSgAoi0","1234","anda","1","","","1","0","2018-09-07 23:44:48","2024-08-01 16:50:38");
INSERT INTO users VALUES("11","teststaff","a@a.com","$2y$10$5KNBIIhZzvvZEQEhkHaZGu.Q8bbQNfqYvYgL5N55B8Pb4P5P/b/Li","DkHDEcCA0QLfsKPkUK0ckL0CPM6dPiJytNa0k952gyTbeAyMthW3vi7IRitp","111","aa","4","5","1","0","1","2018-10-22 02:47:56","2018-10-23 02:10:56");
INSERT INTO users VALUES("12","john","john@gmail.com","$2y$10$P/pN2J/uyTYNzQy2kRqWwuSv7P2f6GE/ykBwtHdda7yci3XsfOKWe","O0f1WJBVjT5eKYl3Js5l1ixMMtoU6kqrH7hbHDx9I1UCcD9CmiSmCBzHbQZg","10001","","4","2","2","0","1","2018-12-30 00:48:37","2019-03-06 04:59:49");
INSERT INTO users VALUES("13","jjj","test@test.com","$2y$10$/Qx3gHWYWUhlF1aPfzXaCeZA7fRzfSEyCIOnk/dcC4ejO8PsoaalG","","1213","","1","","","0","1","2019-01-03 00:08:31","2019-03-03 04:02:29");
INSERT INTO users VALUES("19","shakalaka","shakalaka@gmail.com","$2y$10$ketLWT0Ib/JXpo00eJlxoeSw.7leS8V1CUGInfbyOWT4F5.Xuo7S2","","1212","Digital image","5","","","1","0","2020-11-09 00:07:16","2020-11-09 00:07:16");
INSERT INTO users VALUES("21","modon","modon@gmail.com","$2y$10$7VpoeGMkP8QCvL5zLwFW..6MYJ5MRumDLDoX.TTQtClS561rpFHY.","","2222","modon company","5","","","1","0","2020-11-13 07:12:08","2020-11-13 07:12:08");
INSERT INTO users VALUES("22","dhiman","dhiman@gmail.com","$2y$10$3mPygsC6wwnDtw/Sg85IpuExtUhgaHx52Lwp7Rz0.FNfuFdfKVpRq","","+8801111111101","lioncoders","5","","","1","0","2020-11-15 06:14:58","2020-11-15 06:14:58");
INSERT INTO users VALUES("29","Robin Thomas","bestoexim@gmail.com","$2y$10$rK03Ex59S4gy4FsFR9oQKekVqe23WbbA1fGuKzuyoNP6kgoSsk8Gm","","0965167005","Besto Exim Co.,Ltd","4","1","2","0","1","2024-05-03 15:47:10","2024-06-18 18:20:35");
INSERT INTO users VALUES("30","Thi","example@example.com","$2y$10$XUtnA6oN5nFDUrgBnh6yW.enguQAgnZTpWiDdlwRyNECjAG0XjXwq","","090000000","C 1","1","","","1","0","2024-06-18 17:56:51","2024-06-18 17:56:51");
INSERT INTO users VALUES("31","liverpool","king.1991@gmail.com","$2y$10$B0AH9oYR//L9xtUzXkTZLeaQHXW9CDp1wY1CWfkbP9M51Rkffe0ti","","+962563542569","","5","","","1","0","2024-07-31 23:56:30","2024-07-31 23:56:30");
INSERT INTO users VALUES("32","new","kefah.rajha.1991@gmail.com","$2y$10$3cHLkONxYB7uVIKHUxiuB.XaVRWK.Q8J/5LwctWVBXip8kaXu1yY.","","+962563542569","x","5","","","0","1","2024-08-01 14:03:25","2024-08-01 16:51:44");
INSERT INTO users VALUES("33","Billing","bill@gmail.com","$2y$10$fPTTnqcC.yZrAV2noQfajeeJHmtQO0ENBhR5SHvDUBAEZY02z64R2","","1111111111","","6","1","1","1","0","2024-08-10 10:02:26","2024-08-10 10:02:26");
INSERT INTO users VALUES("34","zongo","mthzongo@gmail.com","$2y$10$z3GahHY0AmdtcbOTeTIE3.LuGM3.Yx5ftwR4ykwlhDb2TN53KXOt2","","2677888999","","1","","","1","0","2024-08-13 12:10:56","2024-08-13 12:10:56");
INSERT INTO users VALUES("35","Naa","naa@gmail.com","$2y$10$9OZicJHjLe79rkH3BHu2ju.0ShDX0Gg1NZHgTgBmmu/gQTNvwVV0e","","0247439813","","4","1","1","1","0","2024-08-15 09:09:39","2024-08-15 09:09:39");
INSERT INTO users VALUES("36","nii","derrick@gmail.com","$2y$10$PcUpPrFom8l.gpF60veWj.WHFCy4ksoJi10YhIdu6zJgQTFparNlm","","0247439813","","6","1","1","1","0","2024-08-15 09:14:03","2024-08-15 09:14:50");
INSERT INTO users VALUES("37","Bambak","bamba5.keletigui@gmail.com","$2y$10$TEA437S6hLbMsIhF0KXHV..nhtDcQ5XTbTjBHqapiEJLtik.3dxhW","","92819395","BAMBA IT","2","","","0","0","2024-08-23 07:20:29","2024-08-23 07:20:29");
INSERT INTO users VALUES("38","Abdisamad","Cartan160@gmail.com","$2y$10$vTn10S3BT5d3.GaIrdmfVuGJWhA4azRS28ErOxMrBeqA6g30Xm3g2","","615666991","beeciye Collection group","1","","","0","0","2024-09-14 06:19:04","2024-09-14 06:19:04");
INSERT INTO users VALUES("39","Nilam Patil","nilam2012@gmail.com","$2y$10$LA3yHXpADRzpAMX/f6z/o.3KyCS0Q9xhATWTc.EzldWZ/8XN9gB3K","","08600006546","Nexgen Promoters","2","","","0","0","2024-09-30 12:09:46","2024-09-30 12:09:46");
INSERT INTO users VALUES("40","demo_k","mr.markwhite1@gmail.com","$2y$10$TUIZFYlihIhH4stP.YAb5OntzmjimiePdV8pv1Ppp26MPiwD0ZhTK","","6463403244","KAEM Softwares pvt ltd","7","1","7","1","0","2024-10-09 07:00:44","2024-10-09 07:35:57");
INSERT INTO users VALUES("41","Jose Luis Reyes","joseluisreyesposligua@gmail.com","$2y$10$RS.HTApBAdt/bl6npEwPHuOV3RdlAJBQsvbSh2AKPCRxCnm7EMy6q","","+593967574047","Galco","1","","","0","0","2024-11-07 11:25:20","2024-11-07 11:25:20");
INSERT INTO users VALUES("42","admin_tl","admintl@admin.com","$2y$10$WjvgyYaSkcig4PveaXTWA.UFuLZYYUrwVhIpKGacRs6bH/qQtURMa","","888888888","","9","1","7","1","0","2024-11-11 01:59:39","2024-11-11 01:59:39");
INSERT INTO users VALUES("43","dany","chsksk@vk.com","$2y$10$FYGgMKRoI7pJv0rL2nXgoeZJqW9Vng0yrVti..iXugTUL5clBqxi6","","010519666","vk","6","1","4","1","0","2024-11-30 12:59:07","2024-11-30 12:59:07");
INSERT INTO users VALUES("44","alan","bushiriabrantes@gmail.com","$2y$10$rBjBth32aUdmxHR01y.EDOV9QT0VJ7Lu0K6xuPKaxSV4clS3ypClW","","+243817664861","aba","2","","","1","0","2024-12-23 10:11:58","2024-12-23 10:11:58");
INSERT INTO users VALUES("45","Predis","Ngoykasongopredis@gmail.com","$2y$10$cJHnM80eY0caZyiwRboPO.xv9AqS1NowrYz4X7UIRIKSyLCtNl2K2","","0974830311","","4","1","1","1","0","2024-12-28 22:22:37","2024-12-28 22:22:37");
INSERT INTO users VALUES("46","Hotspot","chanthou_huot007@yahoo.com","$2y$10$67AQuSM7Zry380ZyDIKtWuwMlXVxwE8ypSJyFDAhpwdu1TCXqUmnC","","029388384843","","10","3","2","1","0","2025-01-12 11:01:07","2025-01-12 11:01:07");
INSERT INTO users VALUES("47","odile","odile@rowtechbf.com","$2y$10$I2/aIklGsj6N556Umu8d4.2Jxi1r4CEuG7MHLUP6fNz6kGSUsbdW6","","+22600010203","ROWTECH","11","1","3","1","0","2025-01-16 09:56:30","2025-01-16 09:56:30");
INSERT INTO users VALUES("48","bbt","hbfdjhs@gmail.com","$2y$10$G0IYQAGZYK7P410NTV58V.k8t5mlIHiCQwqxeCoUE4ZQVlsJS67LC","","5345987987","46","6","1","2","1","0","2025-01-18 17:09:26","2025-01-18 17:12:28");
INSERT INTO users VALUES("49","diane","diane@rowtechbf.com","$2y$10$v0cwB/hahHYTEyhba0dV7u5wEbskuk8sIYJxPRdc7YMKgWrbMKTxa","","+22666031796","","11","1","4","1","0","2025-01-19 09:51:39","2025-01-19 09:51:39");
INSERT INTO users VALUES("50","Ibdiallo","porekoibrahima@gmail.com","$2y$10$gcLLLDlhW52Jvlzk1pn.SO5mMMgcHgCZzIXNMTUh3F4YV1QNZieH6","","+224621805563","","2","","","0","0","2025-01-31 10:53:13","2025-01-31 10:53:13");
INSERT INTO users VALUES("51","Ib","issd900@gmail.com","$2y$10$0kFgMXv8Bo9a8wl18EnROOaf3RBVjYnME0Emdr1RfJBfIC8yzNrmG","","+2250716664884","","1","","","0","0","2025-01-31 10:56:17","2025-01-31 10:56:17");



CREATE TABLE `variants` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO variants VALUES("1","Kaspersky 1 poste","2025-01-16 10:19:37","2025-01-16 10:19:37");



CREATE TABLE `warehouses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `address` text NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO warehouses VALUES("1","magazyn","123456","","pp","0","2024-12-27 13:51:53","2025-01-12 10:46:00");
INSERT INTO warehouses VALUES("2","Sodium Cloride 500ml","010519666","","05 hdj jtjdls","1","2025-01-12 10:32:43","2025-01-12 10:32:43");
INSERT INTO warehouses VALUES("3","Rowtech","+22655989889","contact@rowtechbf.com","Ouagadougou - 1200 logements","1","2025-01-16 16:41:33","2025-01-16 16:41:33");
INSERT INTO warehouses VALUES("4","Enaid Fashion","+22666031796","","Wemtenga","1","2025-01-19 09:50:05","2025-01-19 09:50:05");

