<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;

class GiftcardImage extends Model
{
    protected $table = 'giftcard_images';

    protected $fillable = [
        'front_image',
        'back_image',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Upload and store the front and back images.
     *
     * @param UploadedFile|null $front
     * @param UploadedFile|null $back
     * @return void
     */
    public function uploadImages(?UploadedFile $front, ?UploadedFile $back)
    {
        $destination = public_path('images/gift_card');

        // Create directory if not exists
        if (!File::exists($destination)) {
            File::makeDirectory($destination, 0755, true);
        }

        if ($front instanceof UploadedFile) {
            $frontName = time() . '_front.' . $front->getClientOriginalExtension();
            $front->move($destination, $frontName);
            $this->front_image = 'images/gift_card/' . $frontName;
        }

        if ($back instanceof UploadedFile) {
            $backName = time() . '_back.' . $back->getClientOriginalExtension();
            $back->move($destination, $backName);
            $this->back_image = 'images/gift_card/' . $backName;
        }

        $this->save();
    }
}
