<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\BarcodeSetting; // Make sure you're using the correct path

class BarcodeSettingController extends Controller
{
    public function edit()
    {
        $barcodesetting = BarcodeSetting::first();
        return view('barcode-setting', compact('barcodesetting'));
    }

    public function update(Request $request)
    {
     
        $validated = $request->validate([
            'name' => 'nullable|string|max:255',
            'price' => 'nullable|numeric',
            'promotional_price' => 'nullable|numeric',
            'paper_size' => 'required|string|max:100',
        ]);
    
        $barcodesetting = BarcodeSetting::first();
    
        if ($barcodesetting) {
            $barcodesetting->update($validated);
        } else {
            BarcodeSetting::create($validated);
        }
    
        return redirect()->back()->with('success', 'Barcode setting updated successfully!');
    }

}

