<?php

namespace App\Http\Controllers;

use App\Color;
use Illuminate\Http\Request;

class ColorController extends Controller
{
    public function index()
    {
        $colors = Color::latest()->paginate(10);

        return view('color-setting.index', compact('colors'));
    }
    public function create()
    {
        return view('color-setting.create');
    }
    public function store(Request $request)
    {
        $validated = $request->validate([
            'color_name' => 'required|string|max:255',
            'color_code' => 'required|string|max:50',
            'is_active'  => 'required|boolean',
        ]);
    
        $color = Color::create($validated);
    
        // Check if it's an Ajax request
        if ($request->ajax()) {
            $colors = Color::where('is_active',true)->get();
            return response()->json([
                'success' => true,
                'message' => 'Color created successfully.',
                'data'    => $colors
            ]);
        }
    
        return redirect()->route('color.index')
            ->with('success', 'Color created successfully.');
    }

    // public function store(Request $request)
    // {
    //     $validated = $request->validate([
    //         'color_code' => 'required|string|max:50',
    //         'color_name' => 'required|string|max:255',
    //         'is_active'  => 'required|boolean',
    //     ]);

    //     Color::create($validated);

    //     return redirect()->route('color.index')
    //         ->with('success', 'Color created successfully.');
    // }
    public function show(Color $color)
    {
        return view('color-setting.show', compact('color'));
    }
    public function edit(Color $color)
    {
        return view('color-setting.edit', compact('color'));
    }
    public function update(Request $request, Color $color)
    {
        $validated = $request->validate([
            'color_code' => 'required|string|max:50',
            'color_name' => 'required|string|max:255',
            'is_active'  => 'required|boolean',
        ]);

        $color->update($validated);

        return redirect()->route('color.index')
            ->with('success', 'Color updated successfully.');
    }
    public function destroy(Color $color)
    {
        $color->delete();

        return redirect()->route('color.index')
            ->with('success', 'Color deleted successfully.');
    }
public function updateSelection(Request $request)
{
    $selected = $request->colors ?? [];

    Color::query()->update(['is_active' => 0]);
    Color::whereIn('id', $selected)->update(['is_active' => 1]);

    $colors = Color::where('is_active',true)->get();
    return response()->json([
        'status' => true,
        'colors' => $colors
    ]);
}
}

