<?php

namespace App\Http\Controllers;

// Manually include Dompdf files
require_once base_path('vendor/dompdf/dompdf/src/Autoloader.php');

use Dompdf\Dompdf;
use Dompdf\Options;

class ExportController extends Controller
{
    public function exportPdf()
    {
        $html = view('pdf.invoice')->render();
        $policyId = 123;

        // PDF Options
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isPhpEnabled', true);
        $options->set('isRemoteEnabled', true); // Enable remote images

        // Initialize Dompdf
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        // Generate a proper file name
        $fileName = 'insurance_certificate_' . $policyId . '.pdf';

        // Return PDF as download
        return $dompdf->stream($fileName);
    }
}
