<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Customer;
use App\User;
use App\GiftcardImage;
use Keygen;
use Auth;
use Illuminate\Validation\Rule;
use App\Mail\UserNotification;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class GiftCardSettingController extends Controller
{
    
     public function index()
    {
        $giftcardImages = GiftcardImage::latest()->get();
        return view('gift-card-setting.index', compact('giftcardImages'));
    }

       public function store(Request $request)
        {
            $request->validate([
                'front_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
                'back_image'  => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);
        
            $giftcard = new GiftcardImage([
                'is_active' => $request->has('is_active') ? 1 : 0,
            ]);
        
            $giftcard->uploadImages($request->file('front_image'), $request->file('back_image'));
        
            return redirect()->back()->with('success', 'Gift card image uploaded successfully!');
        }

      public function update($id)
    {
        GiftcardImage::query()->update(['is_active' => 0]);
    
        $giftcard = GiftcardImage::find($id);
    
        if ($giftcard) {
            $giftcard->is_active = 1; 
            $giftcard->save(); 
    
            return redirect()->back()->with('success', 'Giftcard image updated successfully!');
        }
    
        return redirect()->back()->with('error', 'Giftcard image not found!');
    }

    
     public function destroy($id)
    {
        $giftcard = GiftcardImage::findOrFail($id);
    
        // Delete image files from storage if they exist
        if ($giftcard->front_image && file_exists(public_path($giftcard->front_image))) {
            unlink(public_path($giftcard->front_image));
        }
    
        if ($giftcard->back_image && file_exists(public_path($giftcard->back_image))) {
            unlink(public_path($giftcard->back_image));
        }
    
        // Delete the database record
        $giftcard->delete();
    
        return back()->with('success', 'Gift card image deleted successfully.');
    }

}
