<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Dompdf\Dompdf;
use Dompdf\Options;

class PdfController extends Controller
{
    public function generatePDF()
    {
        $html = view('pdf.index')->render();
        // Configure DomPDF
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);

        // Instantiate DomPDF
        $dompdf = new Dompdf($options);

        // Load HTML content
        $dompdf->loadHtml($html);

        // Render PDF
        $dompdf->render();

        // Output PDF
        return $dompdf->stream('invoice.pdf');
    }
}
