<?php

namespace App\Http\Controllers;

use App\Size;
use Illuminate\Http\Request;

class SizeController extends Controller
{
    public function index()
    {
        $sizes = Size::latest()->paginate(10);
        return view('sizes-setting.index', compact('sizes'));
    }
    public function create()
    {
        return view('sizes-setting.create');
    }
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'      => 'required|string|max:255',
            'is_active' => 'required|boolean',
        ]);
    
        $size = Size::create($validated);
    
        // Ajax request handling
        if ($request->ajax()) {
            $sizes = Size::where('is_active',true)->get();
            return response()->json([
                'success' => true,
                'message' => 'Size created successfully.',
                'data'    => $sizes
            ]);
        }
    
        return redirect()->route('size.index')
            ->with('success', 'Size created successfully.');
    }

    // public function store(Request $request)
    // {
    //     $validated = $request->validate([
    //         'name' => 'required|string|max:255',
    //         'is_active' => 'required|boolean',
    //     ]);

    //     Size::create($validated);

    //     return redirect()->route('size.index')
    //         ->with('success', 'Size created successfully.');
    // }

    public function show(Size $size)
    {
        return view('sizes-setting.show', compact('size'));
    }

    public function edit(Size $size)
    {
        return view('sizes-setting.edit', compact('size'));
    }

    public function update(Request $request, Size $size)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'is_active' => 'required|boolean',
        ]);

        $size->update($validated);

        return redirect()->route('size.index')
            ->with('success', 'Size updated successfully.');
    }

    public function destroy(Size $size)
    {
        $size->delete();

        return redirect()->route('size.index')
            ->with('success', 'Size deleted successfully.');
    }
    
 public function updateSelection(Request $request)
{
    $selected = $request->sizes ?? [];

    // Set all inactive
    Size::query()->update(['is_active' => 0]);

    // Activate selected
    Size::whereIn('id', $selected)->update(['is_active' => 1]);

    // Return all sizes back
    $sizes = Size::where('is_active',true)->get();
    return response()->json([
        'status' => true,
        'sizes' => $sizes
    ]);
}

}
