<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Customer;
use App\CustomerGroup;
use App\WhatsappEvoProfile;
use App\Services\EvoService;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;


class WhatsappMarkatingController extends Controller
{
    public function index()
    {
        $customers = Customer::all();
        $customergroups=CustomerGroup::all();
        return view('whatsapp-markating',compact('customergroups','customers'));
    }
    
    
    public function sendMessage(Request $request)
{
    

    Log::info('WhatsApp Marketing: sendMessage started', [
        'request_data' => $request->except(['image'])
    ]);

    // Validation
    if (
        (empty($request->ids) || !is_array($request->ids) || count(array_filter($request->ids)) === 0)
        && empty($request->group_ids)
    ) {
        Log::warning('WhatsApp Marketing: No customers or groups selected');
        return redirect()->back()->with('error', 'Please select at least one customer or a customer group.');
    }

    if (!$request->message) {
        Log::warning('WhatsApp Marketing: Message missing');
        return redirect()->back()->with('error', 'Please provide message.');
    }

    $mobiles = [];

    if (!empty($request->ids) && is_array($request->ids)) {
        $ids = $request->ids;
        if (count($ids) === 1 && str_contains($ids[0], ',')) {
            $ids = explode(',', $ids[0]);
        }

        $ids = array_map('intval', $ids);
        
        $mobiles = Customer::whereIn('id', $ids)
            ->pluck('phone_number')
            ->toArray();

      


        Log::info('WhatsApp Marketing: Customers fetched', [
            'count' => count($mobiles)
        ]);
    }

    if (empty($mobiles)) {
        Log::warning('WhatsApp Marketing: No mobiles found');
        return redirect()->back()->with('error', 'No customers found with the given selection.');
    }
    
      $mobiles = array_map(function ($number) {
            return preg_replace('/\D+/', '', $number);
        }, $mobiles);

    // Message + Image
    $message  = $request->message;
    $filePath = null;

    if ($request->hasFile('image')) {
        $file     = $request->file('image');
        $fileName = Str::uuid() . '.' . $file->getClientOriginalExtension();
        $file->move(public_path('images'), $fileName);
        $filePath = asset("images/{$fileName}");

        Log::info('WhatsApp Marketing: Image uploaded', [
            'path' => $filePath
        ]);
    }

    // Fetch active profiles once
    $profiles = WhatsappEvoProfile::where('is_active', 1)->get();

    if ($profiles->isEmpty()) {
        Log::error('WhatsApp Marketing: No active WhatsApp profiles available');
        return redirect()->back()->with('error', 'No active WhatsApp profiles available.');
    }

    // Sending loop
    foreach ($mobiles as $mobile) {

        Log::info('WhatsApp Marketing: Sending message', [
            'mobile' => $mobile
        ]);

        $profile  = $profiles->random();
        $instance = $profile->instance;

        Log::info('WhatsApp Marketing: Using profile', [
            'profile_id' => $profile->id,
            'instance'   => $instance
        ]);

        try {
            $response = $filePath
                ? EvoService::sendMedia($instance, $mobile, $message, $filePath, 'image')
                : EvoService::sendText($instance, $mobile, $message);

            Log::info('WhatsApp Marketing: API response', [
                'mobile'   => $mobile,
                'response' => $response
            ]);

            $apiStatus = $response['status'] ?? null;

            if ($apiStatus == '500') {
                Log::error('WhatsApp Marketing: Profile failed, deactivating', [
                    'profile_id' => $profile->id,
                    'mobile'     => $mobile
                ]);

                $profile->update(['is_active' => 0]);

                // Remove failed profile from list
                $profiles = $profiles->filter(fn ($p) => $p->id !== $profile->id);
            }

        } catch (\Exception $e) {

            Log::critical('WhatsApp Marketing: Exception while sending', [
                'mobile'  => $mobile,
                'error'   => $e->getMessage(),
                'trace'   => $e->getTraceAsString()
            ]);
        }
    }

    Log::info('WhatsApp Marketing: sendMessage completed successfully');

    return redirect()->back()->with('success', 'Message sent successfully!');
}


// public function sendMessage(Request $request)
// {

//     if ((empty($request->ids) || !is_array($request->ids) || count(array_filter($request->ids)) === 0) 
//         && empty($request->group_ids)) {
        
//         return redirect()->back()->with('error', 'Please select at least one customer or a customer group.');
//     }
    
//     if(!$request->message)
//     {
//         return redirect()->back()->with('error', 'Please provide message.');
//     }

//     $mobiles = [];

//     if (!empty($request->ids) && is_array($request->ids) && count(array_filter($request->ids)) > 0) {
//         $mobiles = Customer::whereIn('id', $request->ids)->pluck('phone_number')->toArray();
//     }

//     if (empty($mobiles)) {
//         return redirect()->back()->with('error', 'No customers found with the given selection.');
//     }

//     $message = $request->message;
//     $filePath = null;

//     if ($request->hasFile('image')) {
//         $file = $request->file('image');
//          $fileName = Str::uuid() . '.' . $file->getClientOriginalExtension();
//         $file->move(public_path('images'), $fileName);
//         $filePath = asset("images/{$fileName}");
//     }
//     foreach ($mobiles as $mobile) {
     
//           $profiles = WhatsappEvoProfile::where('is_active', 1)
//                     ->get();
        
//                     if ($profiles->isEmpty()) {
                            
//                     }else
//                     {
                          
//                             $profile = $profiles->random();
//                             $instance = $profile->instance;
                       
//                              $response = $filePath ?  EvoService::sendMedia($instance, $mobile, $message, $filePath, 'image') : EvoService::sendText($instance, $mobile, $message);
                    
                        
//                              $apiStatus = $response['status'] ?? null;
                        
//                             if ($apiStatus == '500') {
                        
//                                  $profile->update(['is_active' => 0]);
            
//                                 $profiles = $profiles->filter(fn($p) => $p->id !== $profile->id);
                        
//                             }

                        
//                     }

//     }

//     return redirect()->back()->with('success', 'Message sent successfully!');
// }


}
