<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesPayment extends Model
{
    use HasFactory;

    protected $table = 'sales_payments'; // Table name

    protected $fillable = [
        'salesid',
        'payment_method',
        'amount',
    ];

    protected $dates = ['created_at', 'updated_at'];

    public function sale(): BelongsTo
    {
        return $this->belongsTo(Sale::class, 'salesid', 'id'); 
    }
}
