<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;

class SampleFileController extends Controller
{
    public function downloadSampleProducts()
    {
        $filePath = public_path('sample_file/sample_products.csv');

        // Safety check
        if (!file_exists($filePath)) {
            abort(404, 'Sample file not found');
        }

        return response()->download(
            $filePath,
            'sample_products.csv',
            [
                'Content-Type'        => 'text/csv',
                'Content-Disposition' => 'attachment; filename="sample_products.csv"',
            ]
        );
    }
    
      public function downloadSampleSales()
    {
        $filePath = public_path('sample_file/sample_sale_products.csv');

        // Safety check
        if (!file_exists($filePath)) {
            abort(404, 'Sample file not found');
        }

        return response()->download(
            $filePath,
            'sample_sale.csv',
            [
                'Content-Type'        => 'text/csv',
                'Content-Disposition' => 'attachment; filename="sample_products.csv"',
            ]
        );
    }
    
       public function downloadSampleCustomer()
    {
        $filePath = public_path('sample_file/sample_customer.csv');

        // Safety check
        if (!file_exists($filePath)) {
            abort(404, 'Sample file not found');
        }

        return response()->download(
            $filePath,
            'sample_customer.csv',
            [
                'Content-Type'        => 'text/csv',
                'Content-Disposition' => 'attachment; filename="sample_products.csv"',
            ]
        );
    }
    
    
    
}
