@extends('layout.main')

@section('content')

<section class="forms">
    <div class="container-fluid">

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Error Messages --}}
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="row">
            <div class="col-md-12"> {{-- Full Width --}}
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Barcode setting</h4>
                    </div>
                    <div class="card-body">
                      <form id="product-form" action="{{ url('barcode-setting') }}" method="POST">
                        @csrf
                        @method('PUT')
                    
                        <div class="row">
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>Name</strong></label>
                                    <div class="input-group">
                                        <select name="name" class="form-control selectpicker">
                                            <option value="1" {{ isset($barcodesetting) && $barcodesetting->name == 1 ? 'selected' : '' }}>Yes</option>
                                            <option value="0" {{ isset($barcodesetting) && $barcodesetting->name == 0 ? 'selected' : '' }}>No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>{{ trans('file.Product Type') }}</strong> *</label>
                                    <div class="input-group">
                                        <select name="price" class="form-control selectpicker">
                                            <option value="1" {{ isset($barcodesetting) && $barcodesetting->price == 1 ? 'selected' : '' }}>Yes</option>
                                            <option value="0" {{ isset($barcodesetting) && $barcodesetting->price == 0 ? 'selected' : '' }}>No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>Promotional Price</strong></label>
                                    <div class="input-group">
                                        <select name="promotional_price" class="form-control selectpicker">
                                            <option value="1" {{ isset($barcodesetting) && $barcodesetting->promotional_price == 1 ? 'selected' : '' }}>Yes</option>
                                            <option value="0" {{ isset($barcodesetting) && $barcodesetting->promotional_price == 0 ? 'selected' : '' }}>No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>Paper Type (Size)</strong></label>
                                    <div class="input-group">
                                        <select class="form-control selectpicker" name="paper_size" required id="paper-size">
                                            <option value="" disabled {{ empty($barcodesetting->paper_size) ? 'selected' : '' }}>Select paper size...</option>
                                            <option value="38" {{ isset($barcodesetting) && $barcodesetting->paper_size == '38' ? 'selected' : '' }}>38 mm (1.496 inch)</option>
                                            <option value="36" {{ isset($barcodesetting) && $barcodesetting->paper_size == '36' ? 'selected' : '' }}>36 mm (1.4 inch)</option>
                                            <option value="24" {{ isset($barcodesetting) && $barcodesetting->paper_size == '24' ? 'selected' : '' }}>24 mm (0.94 inch)</option>
                                            <option value="18" {{ isset($barcodesetting) && $barcodesetting->paper_size == '18' ? 'selected' : '' }}>18 mm (0.7 inch)</option>
                                            
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                        </div>
                    
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                {{ trans('file.submit') }}
                            </button>
                        </div>
                    </form>

                    </div> <!-- card-body -->
                </div> <!-- card -->
            </div> <!-- col-md-12 -->
        </div> <!-- row -->
    </div> <!-- container-fluid -->
</section>

@endsection
