@extends('layout.main')

@section('content')
<section class="forms">
    <div class="container-fluid">

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Error Messages --}}
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Page Header --}}
        <div class="row mb-3">
            <div class="col-md-6">
                <h4>Color List</h4>
            </div>
            <div class="col-md-6 text-right">
                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addColorModal">
                    + Add New Color
                </button>
            </div>
        </div>

        {{-- Color Table --}}
        <div class="card h-100">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="">
                            <tr>
                                <th>S.no</th>
                                <th>Color Name</th>
                                <th>Color Code</th>
                                <th>Status</th>
                                <th>Toggle</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($colors as $index => $color)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $color->color_name }}</td>
                                <td>
                                    <span style="background-color: {{ $color->color_code }}; padding: 5px 10px; border: 1px solid #ccc;">
                                        {{ $color->color_code }}
                                    </span>
                                </td>
                                <td>{{ $color->is_active ? 'Active' : 'Inactive' }}</td>
                                <td>
                                    <form action="{{ route('color.update', $color->id) }}" method="POST" id="toggle-form-{{ $color->id }}">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="color_name" value="{{ $color->color_name }}">
                                        <input type="hidden" name="color_code" value="{{ $color->color_code }}">
                                        <input type="hidden" name="is_active" value="{{ $color->is_active ? 0 : 1 }}">
                                        <input
                                            type="checkbox"
                                            onchange="document.getElementById('toggle-form-{{ $color->id }}').submit()"
                                            {{ $color->is_active ? 'checked' : '' }}
                                        >
                                    </form>
                                </td>
                                <td>{{ $color->created_at->format('Y-m-d') }}</td>
                                <td>
                                    <form action="{{ route('color.destroy', $color->id) }}" method="POST" onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">
                                            Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">No colors found.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $colors->links() }}
            </div>
        </div>
    </div>
</section>

<!-- Add Color Modal -->
<div class="modal fade" id="addColorModal" tabindex="-1" role="dialog" aria-labelledby="addColorModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="{{ route('color.store') }}" method="POST">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addColorModalLabel">Add New Color</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="color_name"><strong>Color Name</strong></label>
            <input type="text" name="color_name" id="color_name" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="color_code"><strong>Color Code</strong></label>
            <input type="color" name="color_code" id="color_code" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Status</strong></label>
            <select name="is_active" id="is_active" class="form-control" required>
              <option value="1">Active</option>
              <option value="0">Inactive</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Add Color</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
