@extends('layout.main')

@section('content')
<section class="forms">
    <div class="container-fluid">

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Error Messages --}}
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Page Header --}}
        <div class="row mb-3">
            <div class="col-md-6">
                <h4>Qr Whatsapp Profiles</h4>
            </div>
            <div class="col-md-6 text-right">
                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addSizeModal">
                    + Add New Whatsapp
                </button>
            </div>
        </div>

        {{-- Color Table --}}
        <div class="card h-100">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>S.no</th>
                        <th>Name</th>
                        <th>Instant</th>
                        <th>Phone</th>
                        <th>Created On</th>
                        <th>Status</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                        <tbody>
                        @if($profiles->count() > 0)
                        @foreach($profiles as $index =>  $profile)
                          @php $encryptedId = encrypt($profile->id); @endphp
                              <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $profile->name }}</td>
                                <td>{{ $profile->instance}}</td>
                                <td>{{ $profile->phone }}</td>
                                </td>
                                <td><strong>{{ $profile->created_at->format('d F Y') }}</strong></td>
                                <td>
                                  <span
                                    class="badge bg-label-{{ $profile->is_active ? 'success' : 'danger' }}">
                                    {{ $profile->is_active ? 'Active' : 'Inactive' }}
                                  </span>
                                </td>
                                <td>
                                      <form id="deleteForm{{ $encryptedId }}" method="POST" action="{{ route('profiles.whatsapp.destroy', $encryptedId) }}" onsubmit="return confirm('Are you sure?');">
                                          @csrf
                                          @method('DELETE')
                                         <button class="btn btn-sm btn-danger">
                                            Delete
                                        </button>
                                      </form>
                                </td>
                              </tr>
                            @endforeach
                          @else
                            <tr>
                              <td colspan="10" class="text-center text-muted">No User found</td>
                            </tr>
                          @endif
                        </tbody>
                    </table>
                </div>
                {{ $profiles->links() }}
            </div>
        </div>
    </div>
</section>

<!-- Add Color Modal -->
<div class="modal fade" id="addSizeModal" tabindex="-1" role="dialog" aria-labelledby="addSizeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form method="POST" enctype="multipart/form-data" id="profileForm">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addSizeModalLabel">Qr Generate</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="name"><strong>Name</strong></label>
            <input type="text" id="name" name="name" class="form-control @error('name') is-invalid @enderror" placeholder="Enter profile Name" value="{{ old('name') }}" required>
            @error('name')<div class="text-danger">{{ $message }}</div>@enderror
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Phone</strong></label>
            <input type="text" id="phone" name="phone" class="form-control @error('phone') is-invalid @enderror" placeholder="Enter Number with Country Code" value="{{ old('phone') }}" required>
            <small class="text-danger">Note: Please include the country code (e.g. 91xxxxxxxxxx).</small>
            @error('phone')<div class="text-danger">{{ $message }}</div>@enderror
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Click to generate Qr</button>
        </div>
      </div>
    </form>
     <div id="responseBox" class="mt-3"></div>
  </div>
</div>
<script>
document.getElementById('profileForm').addEventListener('submit', async function (e) {
    e.preventDefault();

    let form = e.target;
    let formData = new FormData(form);
    let responseBox = document.getElementById('responseBox');
    let pollInterval = null;

    // show loading card
    responseBox.innerHTML = `
        <div class="card border-primary shadow-sm mt-3">
            <div class="card-body text-center">
                <h5 class="card-title text-primary mb-2">
                    <i class="bx bx-loader-alt bx-spin"></i> Please wait...
                </h5>
            </div>
        </div>
    `;

    try {
        let response = await fetch("{{ route('profiles.whatsapp.store') }}", {
            method: "POST",
            headers: {
                "X-CSRF-TOKEN": document.querySelector('input[name=_token]').value
            },
            body: formData
        });

        let data = await response.json();

        if (data.success) {
            if (data.api?.qrcode?.base64) {
                // ✅ QR code exists → show QR
                responseBox.innerHTML = `
                    <div class="card shadow-sm mt-3">
                        <div class="card-body text-center">
                          <h5 class="card-title mb-3"> Enter this code to connect ${data.api.qrcode.pairingCode}</h5>
                            <h5 class="card-title mb-3">📱 Scan this QR Code to connect</h5>
                            <img src="${data.api.qrcode.base64}" 
                                 class="img-fluid border rounded shadow-sm p-2 bg-white"
                                 style="max-width:250px">
                            <p class="mt-3 text-muted">
                                After scanning, please wait a few seconds while we check the connection...
                            </p>
                            <div class="spinner-border text-success mt-2" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                `;

                let instance = data.api.instance.instanceName;

                // 🔄 Polling
                pollInterval = setInterval(async () => {
                    try {
                        let checkRes = await fetch("{{ route('profiles.whatsapp.connection-status', '') }}/" + instance, {
                            method: "GET",
                            headers: { "Accept": "application/json" }
                        });

                        let checkData = await checkRes.json();

                        if (checkData.connected) {
                            clearInterval(pollInterval);

                            // Countdown 5 → show success text instead of "0 sec"
                            let countdown = 5;
                            responseBox.innerHTML = `
                                <div class="card border-info shadow-sm mt-3">
                                    <div class="card-body text-center">
                                        <h5 class="card-title text-info">
                                            <i class="bx bx-time"></i> Connected! Finalizing in <span id="countdown">${countdown}</span> sec...
                                        </h5>
                                        <div class="spinner-grow text-info mt-2" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                </div>
                            `;

                            let countdownInterval = setInterval(() => {
                                countdown--;
                                if (countdown > 0) {
                                    document.getElementById('countdown').textContent = countdown;
                                } else {
                                    clearInterval(countdownInterval);

                                    responseBox.innerHTML = `
                                        <div class="card shadow-lg border-0 rounded-3 mt-3 animate__animated animate__fadeIn">
                                            <div class="card-body text-center bg-gradient bg-success text-white rounded-3 p-4">
                                                <i class="bx bx-check-circle display-1 mb-3"></i>
                                                <h3 class="fw-bold mb-2">Profile Created Successfully!</h3>
                                            </div>
                                        </div>
                                    `;
                                    
                                    setTimeout(() => {
                                            location.reload();
                                        }, 200);
                                                                            
                                }
                            }, 1000);
                        }

                    } catch (err) {
                        console.error("Polling error:", err);
                    }
                }, 5000);

            } else {
                // ❌ No QR → show error toast only
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "❌ QR code not created. Please try again.",
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true
                });
                responseBox.innerHTML = "";
            }

            form.reset();
        } else {
             if (data.errors) {
                // Show validation messages
                let errorMessages = Object.values(data.errors).flat().join('<br>');
                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: errorMessages,
                    toast: false,
                    confirmButtonText: 'OK'
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: data.message || "❌ Something went wrong",
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true
                });
            }
        
            responseBox.innerHTML = "";
            return; 
        }
    } catch (err) {
        Swal.fire({
            toast: true,
            position: 'top-end',
            icon: 'error',
            title: "❌ Error: " + err.message,
            showConfirmButton: false,
            timer: 4000,
            timerProgressBar: true
        });
        responseBox.innerHTML = "";
    }
});
</script>
@endsection
