@extends('layout.main')

@section('content')

<section class="forms">
    <div class="container-fluid">

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Error Messages --}}
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Upload Form --}}
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Upload Gift Card Images</h4>
                    </div>
                    <div class="card-body">
                        <form id="image-form" action="{{ route('gift.card.setting.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <label><strong>Front Image</strong></label>
                                    <input type="file" name="front_image" class="form-control" accept="image/*" onchange="previewImage(event, 'frontPreview')">
                                     <span class="text-danger d-block mt-2">Upload 80 width and 55 height pixel image</span>
                                    <img id="frontPreview" src="#" alt="Front Preview" style="max-width: 100px; margin-top: 10px; display: none;">
                                </div>

                                <div class="col-md-6">
                                    <label><strong>Back Image</strong></label>
                                    <input type="file" name="back_image" class="form-control" accept="image/*" onchange="previewImage(event, 'backPreview')">
                                     <span class="text-danger d-block mt-2">Upload 80 width and 55 height pixel image</span>
                                    <img id="backPreview" src="#" alt="Back Preview" style="max-width: 100px; margin-top: 10px; display: none;">
                                </div>
                            </div>

                            <div class="form-group mt-3 ">
                                <button type="submit" class="btn btn-primary">
                                    {{ trans('file.submit') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        {{-- Existing Images Table --}}
        <div class="row mt-4">
            <div class="col-md-12">
                <h4>Existing Gift Card Images</h4>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Front Image</th>
                                <th>Back Image</th>
                                <th>Active</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($giftcardImages as $index => $image)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td><img src="{{ asset($image->front_image) }}" alt="Front" width="80"></td>
                            <td><img src="{{ asset($image->back_image) }}" alt="Back" width="80"></td>
                            <td>
                                <form action="{{ route('gift.card.setting.update', $image->id) }}" method="POST" id="toggle-form-{{ $image->id }}">
                                    @csrf
                                    @method('PUT')
                                    <input type="checkbox" onchange="document.getElementById('toggle-form-{{ $image->id }}').submit()" {{ $image->is_active ? 'checked' : '' }}>
                                </form>
                            </td>
                            <td>
                                {{ $image->created_at->format('Y-m-d') }}
                                <form action="{{ route('gift.card.setting.destroy', $image->id) }}" method="POST" style="display:inline-block;" onsubmit="return confirm('Are you sure you want to delete this image?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</section>

@endsection

@push('scripts')
<script>
    function previewImage(event, previewId) {
        const output = document.getElementById(previewId);
        output.src = URL.createObjectURL(event.target.files[0]);
        output.style.display = 'block';
    }
</script>
@endpush
