@extends('layout.main')
@section('content')

<!-- Bootstrap JS -->
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!--<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>-->
<section class="forms">
   <div class="container-fluid">
      <div class="row">
         <div class="col-md-12">
            <div class="card">
               <div class="card-header d-flex align-items-center">
                  <h4>{{trans('file.add_product')}}</h4>
               </div>
               <div class="card-body">
                  <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                  <form id="product-form">
                     <div class="row">
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Type')}} *</strong> </label>
                              <div class="input-group">
                                 <select name="type" required class="form-control selectpicker" id="type">
                                    <option value="standard">Standard</option>
                                    <option value="combo">Combo</option>
                                    <option value="digital">Digital</option>
                                    <option value="service">Service</option>
                                 </select>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Name')}} *</strong> </label>
                              <input type="text" name="name" class="form-control" id="name" aria-describedby="name" required>
                              <span class="validation-msg" id="name-error"></span>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Code')}} *</strong> </label>
                              <div class="input-group">
                                 <input type="text" name="code" class="form-control" id="code" aria-describedby="code" required>
                                 <div class="input-group-append">
                                    <button id="genbutton" type="button" class="btn btn-sm btn-default" title="{{trans('file.Generate')}}"><i class="fa fa-refresh"></i></button>
                                 </div>
                              </div>
                              <span class="validation-msg" id="code-error"></span>
                           </div>
                        </div>
                        <select name="barcode_symbology" required class="form-control d-none">
                           <option value="C128" selected>Code 128</option>
                           <option value="C39">Code 39</option>
                           <option value="UPCA">UPC-A</option>
                           <option value="UPCE">UPC-E</option>
                           <option value="EAN8">EAN-8</option>
                           <option value="EAN13">EAN-13</option>
                        </select>
                        <div id="digital" class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Attach File')}} *</strong> </label>
                              <div class="input-group">
                                 <input type="file" name="file" class="form-control">
                              </div>
                              <span class="validation-msg"></span>
                           </div>
                        </div>
                        <div id="combo" class="col-md-9 mb-1">
                           <label>{{trans('file.add_product')}}</label>
                           <div class="search-box input-group mb-3">
                              <button class="btn btn-secondary"><i class="fa fa-barcode"></i></button>
                              <input type="text" name="product_code_name" id="lims_productcodeSearch" placeholder="Please type product code and select..." class="form-control" />
                           </div>
                           <label>{{trans('file.Combo Products')}}</label>
                           <div class="table-responsive">
                              <table id="myTable" class="table table-hover order-list">
                                 <thead>
                                    <tr>
                                       <th>{{trans('file.product')}}</th>
                                       <th>{{trans('file.Quantity')}}</th>
                                       <th>{{trans('file.Unit Price')}}</th>
                                       <th><i class="dripicons-trash"></i></th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-md-6">
                           <div class="form-group">
                              <label>{{trans('file.Brand')}}</strong> </label>
                              <div class="input-group">
                                 <select name="brand_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Brand...">
                                    @foreach($lims_brand_list as $brand)
                                    <option value="{{$brand->id}}">{{$brand->title}}</option>
                                    @endforeach
                                 </select>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-6">
                           <div class="form-group">
                              <label>{{trans('file.category')}} *</strong> </label>
                              <div class="input-group">
                                 <select name="category_id" required class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Category...">
                                    @foreach($lims_category_list as $category)
                                    <option value="{{$category->id}}">{{$category->name}}</option>
                                    @endforeach
                                 </select>
                              </div>
                              <span class="validation-msg"></span>
                           </div>
                        </div>
                        <div id="unit" class="col-md-12">
                           <div class="row ">
                              <div class="col-md-4 form-group">
                                 <label>{{trans('file.Product Unit')}} *</strong> </label>
                                 <div class="input-group">
                                    <select required class="form-control selectpicker" name="unit_id" id="unit_id">
                                       <option value="" disabled selected>Select Product Unit...</option>
                                       @foreach($lims_unit_list as $unit)
                                       @if($unit->base_unit==null)
                                       <option value="{{$unit->id}}">{{$unit->unit_name}}</option>
                                       @endif
                                       @endforeach
                                    </select>
                                 </div>
                                 <span class="validation-msg"></span>
                              </div>
                              <div class="col-md-4">
                                 <label>{{trans('file.Sale Unit')}}</strong> </label>
                                 <div class="input-group">
                                    <select class="form-control selectpicker" name="sale_unit_id" id="sale-unit">
                                    </select>
                                 </div>
                              </div>
                              <div class="col-md-4">
                                 <div class="form-group">
                                    <label>{{trans('file.Purchase Unit')}}</strong> </label>
                                    <div class="input-group">
                                       <select class="form-control selectpicker" name="purchase_unit_id">
                                       </select>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div  class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Cost')}} *</strong> </label>
                              <input type="number" name="cost"  id="cost" required class="form-control" step="any">
                              <span class="validation-msg"></span>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Price')}} *</strong> </label>
                              <input type="number" name="price" id="price" required class="form-control" step="any">
                              <span class="validation-msg"></span>
                           </div>
                           <!--<div class="form-group">-->
                           <!--    <input type="text" name="qty" value="0.00">-->
                           <!--</div>-->
                        </div>
                        <div  class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('Opning Quantity')}}</strong> </label>
                              <input type="text" id="qty" name="qty" value="0.00"  class="form-control" step="any">
                           </div>
                        </div>
                        <div  class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('Warehouse')}}</strong> </label>
                              <select name="warehouse" class="form-control">
                              @foreach($lims_warehouse_list as $index => $warehouse)
                              <option value="{{$warehouse->id}}" {{ $index === 0 ? 'selected' : '' }}>{{$warehouse->name}}</option>
                              @endforeach
                              </select>
                           </div>
                        </div>
                        <div id="alert-qty" class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Alert Quantity')}}</strong> </label>
                              <input type="number" id="alert_quantity" name="alert_quantity" class="form-control" step="any">
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Tax')}}</strong> </label>
                              <select name="tax_id" class="form-control selectpicker">
                                 <option value="">No Tax</option>
                                 @foreach($lims_tax_list as $tax)
                                 <option value="{{$tax->id}}">{{$tax->name}}</option>
                                 @endforeach
                              </select>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Tax Method')}}</strong> </label> <i class="dripicons-question" data-toggle="tooltip" title="{{trans('file.Exclusive: Poduct price = Actual product price + Tax. Inclusive: Actual product price = Product price - Tax')}}"></i>
                              <select name="tax_method" class="form-control selectpicker">
                                 <option value="1">{{trans('file.Exclusive')}}</option>
                                 <option value="2">{{trans('file.Inclusive')}}</option>
                              </select>
                           </div>
                        </div>
                        <div class="col-md-2">
                           <div class="form-group mt-3">
                              <input type="checkbox" name="featured" value="1">&nbsp;
                              <label>{{trans('file.Featured')}}</label>
                              <p class="italic">{{trans('file.Featured product will be displayed in POS')}}</p>
                           </div>
                           
                        </div>
<div class="col-md-2">
   
  <div class="form-group mt-3">
    <input type="checkbox" id="is_variant" name="is_variant" value="1">
    <label for="is_variant">{{ trans('variant') }}</label>
  </div>

  <div id="variant-options" class="form-group mt-2" style="display: none;">
    <label>{{ trans('variant_type') }}</label><br>

    <input type="radio" id="variant_only_color" name="group_order" value="only_color">
    <label for="variant_only_color">{{ trans('color') }}</label><br>

    <input type="radio" id="variant_only_size" name="group_order" value="only_size">
    <label for="variant_only_size">{{ trans('size') }}</label><br>

    <input type="radio" id="variant_color_size" name="group_order" value="color_size">
    <label for="variant_color_size">{{ trans('color') }} × {{ trans('size') }}</label><br>

    <input type="radio" id="variant_size_color" name="group_order" value="size_color">
    <label for="variant_size_color">{{ trans('size') }} × {{ trans('color') }}</label>
  </div>
</div>
<div class="col-md-4">

<div class="container mt-3">
 <div class="row">
  <div class="col-md-6 mb-3">
    <button type="button" class="btn btn-success w-100" data-toggle="modal" data-target="#addColorModal">
      + Add Color
    </button>
  </div>
  
  <div class="col-md-6 mb-3">
    <button type="button" class="btn btn-warning w-100" data-toggle="modal" data-target="#customizeColorModal">
      + Toggle Color
    </button>
  </div>
  
  <div class="col-md-6 mb-3">
    <button type="button" class="btn btn-success w-100" data-toggle="modal" data-target="#addSizeModal">
      + Add Size
    </button>
  </div>
  
  <div class="col-md-6 mb-3">
    <button type="button" class="btn btn-warning w-100" data-toggle="modal" data-target="#customizeSizeModal">
      + Toggle Size
    </button>
  </div>
</div>

</div>

</div>

<!-- Variant Table -->
<div class="table-responsive ml-2" id="variant-table-wrapper" style="display: none;">
  <table id="variant-table" class="table table-hover variant-list">
    <thead>
      <tr>
        <th>#</th>
        <th>{{trans('Image')}}</th>
        <th>{{ trans('name') }}</th>
        <th>{{ trans('Color') }}</th>
        <th>{{ trans('Size') }}</th>
        <th>{{ trans('Item Code') }}</th>
        <th>{{ trans('Purchase Price') }}</th>
        <th>{{ trans('Sale Price') }}</th>
        <th>{{ trans('Opening Qty') }}</th>
        <th>{{ trans('Alert Qty') }}</th>
        <th><i class="dripicons-trash"></i></th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>
  <button type="button" class="btn btn-primary" onclick="addmore()">Add More</button>
</div>
<script>
// const colorArray = @json($colors);
// const sizeArray = @json($sizes);
 let colorArray = @json($colors ?? []);
 let sizeArray  = @json($sizes ?? []);
const warehouseList = @json($lims_warehouse_list);



document.addEventListener("DOMContentLoaded", function () {
    
$(document).ready(function () {
    // Size update
     $("#customizeSize").on("submit", function(e){
        e.preventDefault();
        let data = $(this).serialize();

        $.ajax({
            url: "{{ route('size.updateSelection') }}", 
            method: "POST",
            data: data,
            success: function(res){
                if(res.status){
                    // update global JS variable
                    sizeArray = res.sizes;

                    Swal.fire({
                        icon: 'success',
                        title: 'Sizes Updated',
                        text: '✅ Sizes updated successfully!',
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 2000,
                        toast: true
                    });

                    $("#customizeSizeModal").modal('hide');
                    renderSizes(); // re-render table
                }
            },
            error: function(){
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: '❌ Something went wrong!',
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 2000,
                    toast: true
                });
            }
        });
    });

    // Color update
    $("#customizeColor").on("submit", function(e){
        e.preventDefault();
        let data = $(this).serialize();

        $.ajax({
            url: "{{ route('color.updateSelection') }}", 
            method: "POST",
            data: data,
            success: function(res){
                if(res.status){
                    // update global JS variable
                    colorArray = res.colors;

                    Swal.fire({
                        icon: 'success',
                        title: 'Colors Updated',
                        text: '✅ Colors updated successfully!',
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 2000,
                        toast: true
                    });

                    $("#customizeColorModal").modal('hide');
                    renderColors(); // re-render table
                }
            },
            error: function(){
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: '❌ Something went wrong!',
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 2000,
                    toast: true
                });
            }
        });
    });
});


    
function renderSizes() {
    let tbody = document.getElementById("sizeTableBody");
    tbody.innerHTML = "";
    sizeArray.forEach(size => {
        let row = `
            <tr>
                <td>
                  <input type="checkbox" name="sizes[]" value="${size.id}" ${size.is_active ? 'checked' : ''}>
                </td>
                <td>${size.name}</td>
                <td>
                  <span class="badge badge-${size.is_active ? 'success' : 'secondary'}">
                    ${size.is_active ? 'Active' : 'Inactive'}
                  </span>
                </td>
            </tr>`;
        tbody.insertAdjacentHTML("beforeend", row);
    });
}

function renderColors() {
    let tbody = document.getElementById("colorTableBody");
    console.log("hello");
    tbody.innerHTML = "";
    colorArray.forEach(color => {
        let row = `
            <tr>
                <td>
                  <input type="checkbox" name="colors[]" value="${color.id}" ${color.is_active ? 'checked' : ''}>
                </td>
                <td>${color.color_name}</td>
                <td>
                  <span style="background:${color.color_code}; display:inline-block; width:30px; height:20px; border:1px solid #000;"></span>
                </td>
                <td>
                  <span class="badge badge-${color.is_active ? 'success' : 'secondary'}">
                    ${color.is_active ? 'Active' : 'Inactive'}
                  </span>
                </td>
            </tr>`;
        tbody.insertAdjacentHTML("beforeend", row);
    });
}

// Initial render when modal opens
$('#customizeSizeModal').on('shown.bs.modal', renderSizes);
$('#customizeColorModal').on('shown.bs.modal', renderColors);

  const isVariant = document.getElementById("is_variant").checked;

  if (isVariant && groupOrder) {
    document.getElementById("variant-options").style.display = "block";
    document.getElementById("variant-table-wrapper").style.display = "block";

    // Check the correct radio button
    const radio = document.querySelector(`input[name="group_order"][value="${groupOrder}"]`);
    if (radio) {
      radio.checked = true;
      handleVariantTypeChange(groupOrder);
    }
  }
});

const tbody = document.querySelector("#variant-table tbody");
let rowCounter = 0;

function removeRow(btn) {
  const currentRow = btn.closest("tr");

  if (!currentRow) return;

  const previousRow = currentRow.previousElementSibling;

  // Remove current row
  currentRow.remove();

  // Check if the previous row exists and has the data-name="ad_new_variant"
  if (previousRow && previousRow.getAttribute("data-name") === "add_new_variant") {
    previousRow.remove();
  }

  // Call your function to update row numbers
  updateVariantRowNumbers();
}


function clearAllVariantRows() {
  tbody.innerHTML = "";
  rowCounter = 0;
}
function updateVariantRowNumbers() {
  const name = document.getElementById("name").value.trim();
  const baseCode = document.getElementById("code").value.trim();
  const rows = tbody.querySelectorAll("tr");

  let currentId = 0;
  rows.forEach(row => {
    const tds = row.querySelectorAll("td");
    if (tds.length < 10) return;

    currentId++;
    const paddedId = String(currentId).padStart(3, '0');
    tds[0].textContent = currentId;

    const variantNameInput = row.querySelector("input[name='variants_name[]']");
    if (variantNameInput) variantNameInput.value = `${name}-${currentId}`;

    const color = row.querySelector("select[name='variants_color[]']")?.value || row.querySelector("input[name='variants_color[]']")?.value || '';
    const size = row.querySelector("select[name='variants_size[]']")?.value || row.querySelector("input[name='variants_size[]']")?.value || '';

    const suffixParts = [];
    if (color && color.toLowerCase() !== 'null') suffixParts.push(color.toLowerCase().replace(/\s+/g, ''));
    if (size && size.toLowerCase() !== 'null') suffixParts.push(size.toLowerCase().replace(/\s+/g, ''));

    const suffix = suffixParts.join("-");
    const itemCodeInput = row.querySelector("input[name='variants_item_code[]']");
    if (itemCodeInput) itemCodeInput.value = suffix ? `${baseCode}-${paddedId}-${suffix}` : `${baseCode}-${paddedId}`;
  });

  rowCounter = currentId;
}

function handleVariantTypeChange(type) {
  clearAllVariantRows();
  switch (type) {
    case "only_color": appendOnlyColorRows(); break;
    case "only_size": appendOnlySizeRows(); break;
    case "color_size": appendColorSizeRows(); break;
    case "size_color": appendSizeColorRows(); break;
  }
}

function appendOnlyColorRows() {
  tbody.insertAdjacentHTML("beforeend", `<tr><td colspan="10"><strong>Only Colors</strong></td></tr>`);
  colorArray.forEach(c => {
    const id = ++rowCounter;
    const paddedId = String(id).padStart(3, '0');
    const name = document.getElementById("name").value;
    const baseCode = document.getElementById("code").value;
    const variantName = `${name}-${id}`;
    const variantCode = `${baseCode}-${paddedId}-${c.color_name.toLowerCase().replace(/\s+/g, '')}`;
    const variantCost = document.getElementById("cost").value;
    const variantPrice = document.getElementById("price").value;
    const variantAlertQty = document.getElementById("alert_quantity").value;
    const variantOpenQty = document.getElementById("qty").value;

    const row = `
      <tr>
        <td>${id}</td>
        <td><input type="file" class="form-control" name="variants_image[]"> </td>
        <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}" ></td>
        <td><input type="hidden" name="variants_color[]" value="${c.color_name}">${c.color_name}</td>
        <td>-<input type="hidden" name="variants_size[]" value="null"></td>
        <td><input type="text" class="form-control" name="variants_item_code[]" value="${variantCode}" ></td>
        <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variantCost}" step="0.01"></td>
        <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variantPrice}" step="0.01"></td>
        <td><input type="number" class="form-control" name="variants_qty[]" value="${variantOpenQty}" step="0.01"></td>
         <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variantAlertQty}" ></td>
        <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
      </tr>`;
    tbody.insertAdjacentHTML("beforeend", row);
  });
}


function appendOnlySizeRows() {
  tbody.insertAdjacentHTML("beforeend", `<tr><td colspan="10"><strong>Only Sizes</strong></td></tr>`);
  sizeArray.forEach(s => {
    const id = ++rowCounter;
    const paddedId = String(id).padStart(3, '0');
    const name = document.getElementById("name").value;
    const baseCode = document.getElementById("code").value;
    const variantName = `${name}-${id}`;
    const variantCode = `${baseCode}-${paddedId}-${s.name.toLowerCase().replace(/\s+/g, '')}`;
    const variantCost = document.getElementById("cost").value;
    const variantPrice = document.getElementById("price").value;
    const variantAlertQty = document.getElementById("alert_quantity").value;
    const variantOpenQty = document.getElementById("qty").value;
     
    const row = `
      <tr>
        <td>${id}</td>
        <td><input type="file" class="form-control" name="variants_image[]"> </td>
        <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}" ></td>
        <td>-<input type="hidden" name="variants_color[]" value="null"></td>
        <td><input type="hidden" name="variants_size[]" value="${s.name}">${s.name}</td>
        <td><input type="text" class="form-control" name="variants_item_code[]" value="${variantCode}" ></td>
        <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variantCost}" step="0.01"></td>
        <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variantPrice}" step="0.01"></td>
        <td><input type="number" class="form-control" name="variants_qty[]" step="0.01" value="${variantOpenQty}"></td>
        <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variantAlertQty}" ></td>
        <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
      </tr>`;
    tbody.insertAdjacentHTML("beforeend", row);
  });
}


function appendColorSizeRows() {
  colorArray.forEach(c => {
    tbody.insertAdjacentHTML("beforeend", `<tr><td colspan="10"><strong>${c.color_name}</strong></td></tr>`);
    sizeArray.forEach(s => {
      const id = ++rowCounter;
      const paddedId = String(id).padStart(3, '0');
      const name = document.getElementById("name").value;
      const baseCode = document.getElementById("code").value;
      const variantName = `${name}-${id}`;
      const colorSlug = c.color_name.toLowerCase().replace(/\s+/g, '');
      const sizeSlug = s.name.toLowerCase().replace(/\s+/g, '');
      const variantCode = `${baseCode}-${paddedId}-${colorSlug}-${sizeSlug}`;
      const variantCost = document.getElementById("cost").value;
      const variantPrice = document.getElementById("price").value;
      const variantAlertQty = document.getElementById("alert_quantity").value;
      const variantOpenQty = document.getElementById("qty").value;
      
      const row = `
        <tr>
          <td>${id}</td>
          <td><input type="file" class="form-control" name="variants_image[]"> </td>
          <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}" ></td>
          <td><input type="hidden" name="variants_color[]" value="${c.color_name}">${c.color_name}</td>
          <td><input type="hidden" name="variants_size[]" value="${s.name}">${s.name}</td>
          <td><input type="text" class="form-control" name="variants_item_code[]" value="${variantCode}" ></td>
          <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variantCost}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variantPrice}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_qty[]" step="0.01"value="${variantOpenQty}"></td>
          <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variantAlertQty}" ></td>
          <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
        </tr>`;
      tbody.insertAdjacentHTML("beforeend", row);
    });
  });
}


function appendSizeColorRows() {
  sizeArray.forEach(s => {
    tbody.insertAdjacentHTML("beforeend", `<tr><td colspan="10"><strong>${s.name}</strong></td></tr>`);
    colorArray.forEach(c => {
      const id = ++rowCounter;
      const paddedId = String(id).padStart(3, '0');
      const name = document.getElementById("name").value;
      const baseCode = document.getElementById("code").value;
      const variantName = `${name}-${id}`;
      const colorSlug = c.color_name.toLowerCase().replace(/\s+/g, '');
      const sizeSlug = s.name.toLowerCase().replace(/\s+/g, '');
      const variantCode = `${baseCode}-${paddedId}-${colorSlug}-${sizeSlug}`;
      const variantCost = document.getElementById("cost").value;
      const variantPrice = document.getElementById("price").value;
      const variantAlertQty = document.getElementById("alert_quantity").value;
      const variantOpenQty = document.getElementById("qty").value;
      
      const row = `
        <tr>
          <td>${id}</td>
          <td><input type="file" class="form-control" name="variants_image[]"> </td>
          <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}" ></td>
          <td><input type="hidden" name="variants_color[]" value="${c.color_name}">${c.color_name}</td>
          <td><input type="hidden" name="variants_size[]" value="${s.name}">${s.name}</td>
          <td><input type="text" class="form-control" name="variants_item_code[]" value="${variantCode}" ></td>
          <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variantCost}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variantPrice}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_qty[]" step="0.01" value="${variantOpenQty}"></td>
          <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variantAlertQty}" ></td>
          <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
        </tr>`;
      tbody.insertAdjacentHTML("beforeend", row);
    });
  });
}


                           function addmore() {
  const name = document.getElementById("name").value.trim();
  const code = document.getElementById("code").value.trim();
  const variantCost = document.getElementById("cost").value;
  const variantPrice = document.getElementById("price").value;
  const selectedType = document.querySelector('input[name="group_order"]:checked')?.value;
  const variantAlertQty = document.getElementById("alert_quantity").value;
  const variantOpenQty = document.getElementById("qty").value;
   
  const existingRows = Array.from(tbody.querySelectorAll("tr")).filter(row =>
    row.querySelector("input[name='variants_name[]']")
  );

  // Collect existing selections
  const usedColors = new Set();
  const usedSizes = new Set();
  const usedCombos = new Set();

  existingRows.forEach(row => {
    const color = row.querySelector("select[name='variants_color[]']")?.value || row.querySelector("input[name='variants_color[]']")?.value || '';
    const size = row.querySelector("select[name='variants_size[]']")?.value || row.querySelector("input[name='variants_size[]']")?.value || '';

    if (selectedType === 'only_color') usedColors.add(color);
    if (selectedType === 'only_size') usedSizes.add(size);
    if (selectedType === 'color_size' || selectedType === 'size_color') {
      if (color && size) usedCombos.add(`${color}::${size}`);
    }
  });

  // Enforce limits
  if (selectedType === 'only_color' && usedColors.size >= colorArray.length) {
    alert("All colors already used.");
    return;
  }

  if (selectedType === 'only_size' && usedSizes.size >= sizeArray.length) {
    alert("All sizes already used.");
    return;
  }

  if ((selectedType === 'color_size' || selectedType === 'size_color') &&
      usedCombos.size >= (colorArray.length * sizeArray.length)) {
    alert("All color-size combinations used.");
    return;
  }

  // Build select options dynamically
  const colorOptions = colorArray
    .filter(c => !usedColors.has(c.color_name))
    .map(c => `<option value="${c.color_name}">${c.color_name}</option>`)
    .join("");

  const sizeOptions = sizeArray
    .filter(s => !usedSizes.has(s.name))
    .map(s => `<option value="${s.name}">${s.name}</option>`)
    .join("");

  let colorSelect = `<select name="variants_color[]" class="form-control" onchange="updateVariantCode(this)">
                       <option value="">Select Color</option>
                       ${colorOptions}
                     </select>`;

  let sizeSelect = `<select name="variants_size[]" class="form-control" onchange="updateVariantCode(this)">
                      <option value="">Select Size</option>
                      ${sizeOptions}
                    </select>`;

  if (selectedType === 'color_size' || selectedType === 'size_color') {
    // Allow full sets, but restrict combo
    colorSelect = `<select name="variants_color[]" class="form-control" onchange="checkCombo(this)">
                     <option value="">Select Color</option>
                     ${colorArray.map(c => `<option value="${c.color_name}">${c.color_name}</option>`).join("")}
                   </select>`;

    sizeSelect = `<select name="variants_size[]" class="form-control" onchange="checkCombo(this)">
                    <option value="">Select Size</option>
                    ${sizeArray.map(s => `<option value="${s.name}">${s.name}</option>`).join("")}
                  </select>`;
  }

  const id = ++rowCounter;
  const paddedId = String(id).padStart(3, '0');
  const variantName = `${name}-${id}`;
  const variantCode = `${code}-${paddedId}`;

    const headingRow = `
      <tr data-name="add_new_variant">
        <td colspan="11" style="font-weight: bold; background-color: #f9f9f9;" >Add New Variant</td>
      </tr>
    `;

  const row = `
    <tr>
      <td>${id}</td>
      <td><input type="file" class="form-control" name="variants_image[]"></td>
      <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}" readonly></td>
      <td>${colorSelect}</td>
      <td>${sizeSelect}</td>
      <td><input type="text" class="form-control" name="variants_item_code[]" value="${variantCode}"></td>
      <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variantCost}" step="0.01"></td>
      <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variantPrice}" step="0.01"></td>
      <td><input type="number" class="form-control" name="variants_qty[]" step="0.01" value="${variantOpenQty}"></td>
      <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variantAlertQty}" ></td>
      <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
    </tr>
  `;

  tbody.insertAdjacentHTML("beforeend", headingRow);
  tbody.insertAdjacentHTML("beforeend", row);
}


function updateVariantCode(selectElement) {
  const row = selectElement.closest("tr");
  const color = row.querySelector("select[name='variants_color[]']").value || '';
  const size = row.querySelector("select[name='variants_size[]']").value || '';
  const baseCode = document.getElementById("code").value.trim();
  const suffix = [color, size].filter(Boolean).map(s => s.toLowerCase().replace(/\s+/g, '')).join("-");
  row.querySelector("input[name='variants_item_code[]']").value = suffix ? `${baseCode}-${suffix}` : baseCode;
}

// Event listeners
document.querySelectorAll("input[name='group_order']").forEach(radio => {
  radio.addEventListener("change", function () {
    if (this.checked) handleVariantTypeChange(this.value);
  });
});

document.getElementById("is_variant").addEventListener("change", function () {
  const show = this.checked;
  document.getElementById("variant-options").style.display = show ? "block" : "none";
  document.getElementById("variant-table-wrapper").style.display = show ? "block" : "none";
  if (!show) {
    clearAllVariantRows();
    document.querySelectorAll("input[name='group_order']").forEach(r => r.checked = false);
  }
});

function checkCombo(selectEl) {
  const row = selectEl.closest("tr");
  const selectedType = document.querySelector('input[name="group_order"]:checked')?.value;

  const color = row.querySelector("select[name='variants_color[]']")?.value || '';
  const size = row.querySelector("select[name='variants_size[]']")?.value || '';
  let comboKey = '';
  if (selectedType === 'only_color') {
    comboKey = color;
  } else if (selectedType === 'only_size') {
    comboKey = size;
  } else if (selectedType === 'color_size' || selectedType === 'size_color') {
    comboKey = `${color}::${size}`;
  }
  let count = 0;
  const rows = tbody.querySelectorAll("tr");

  rows.forEach(r => {
    const c = r.querySelector("select[name='variants_color[]']")?.value || r.querySelector("input[name='variants_color[]']")?.value || '';
    const s = r.querySelector("select[name='variants_size[]']")?.value || r.querySelector("input[name='variants_size[]']")?.value|| '';
    
    console.log(c,s);
    let rowCombo = '';
    if (selectedType === 'only_color') rowCombo = c;
    else if (selectedType === 'only_size') rowCombo = s;
    else rowCombo = `${c}::${s}`;

    if (comboKey && comboKey === rowCombo) count++;
  });

  if (count >1) {
    alert("This combination already exists.");

    if (selectedType === 'only_color' || selectedType === 'color_size' || selectedType === 'size_color') {
      row.querySelector("select[name='variants_color[]']").value = '';
    }

    if (selectedType === 'only_size' || selectedType === 'color_size' || selectedType === 'size_color') {
      row.querySelector("select[name='variants_size[]']").value = '';
    }

    updateVariantCode(selectEl);
    return;
  }

  updateVariantCode(selectEl);
}

</script>











                        <div class="col-md-12">
                           <div class="form-group">
                              <label>{{trans('file.Product Image')}}</strong> </label> <i class="dripicons-question" data-toggle="tooltip" title="{{trans('file.You can upload multiple image. Only .jpeg, .jpg, .png, .gif file can be uploaded. First image will be base image.')}}"></i>
                              <div id="imageUpload" class="dropzone"></div>
                              <span class="validation-msg" id="image-error"></span>
                           </div>
                        </div>
                        <div class="col-md-12">
                           <div class="form-group">
                              <label>{{trans('file.Product Details')}}</label>
                              <textarea name="product_details" class="form-control" rows="3"></textarea>
                           </div>
                        </div>
                        <div class="col-md-12 mt-2" id="diffPrice-option">
                           <h5><input name="is_diffPrice" type="checkbox" id="is-diffPrice" value="1">&nbsp; {{trans('file.This product has different price for different warehouse')}}</h5>
                        </div>
                        <div class="col-md-6" id="diffPrice-section">
                           <div class="table-responsive ml-2">
                              <table id="diffPrice-table" class="table table-hover">
                                 <thead>
                                    <tr>
                                       <th>{{trans('file.Warehouse')}}</th>
                                       <th>{{trans('file.Price')}}</th>
                                    </tr>
                                    @foreach($lims_warehouse_list as $warehouse)
                                    <tr>
                                       <td>
                                          <input type="hidden" name="warehouse_id[]" value="{{$warehouse->id}}">
                                          {{$warehouse->name}}
                                       </td>
                                       <td><input type="number" name="diff_price[]" class="form-control"></td>
                                    </tr>
                                    @endforeach
                                 </thead>
                                 <tbody>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-md-12 mt-3" id="batch-option">
                           <h5><input name="is_batch" type="checkbox" id="is-batch" value="1">&nbsp; {{trans('file.This product has batch and expired date')}}</h5>
                        </div>
                        <div class="col-md-12 mt-3" id="imei-option">
                           <!--<h5><input name="is_imei" type="checkbox" id="is-imei" value="1">&nbsp; {{trans('file.This product has IMEI or Serial numbers')}}</h5>-->
                           <h5><input name="is_imei" type="checkbox" id="is-imei" value="1">&nbsp; {{trans('Sale Product as Single and bulk')}}</h5>
                        </div>
                        <div class="col-md-12 mt-3" id="price-section" style="display: none;">
                           <div class="form-group">
                              <label>Provide <span id="unit-name-placeholder">--</span> price</label>
                              <input type="text" name="single_product_price" class="form-control" id="single_product_price" placeholder="Enter Price" aria-describedby="single_product_price">
                              <span class="validation-msg" id="name-error"></span>
                           </div>
                        </div>
                        <div class="col-md-4 mt-3">
                           <input name="promotion" type="checkbox" id="promotion" value="1">&nbsp;
                           <label>
                              <h5> {{trans('file.Add Promotional Price')}}</h5>
                           </label>
                        </div>
                        <div class="col-md-12">
                           <div class="row">
                              <div class="col-md-4" id="promotion_price">
                                 <label>{{trans('file.Promotional Price')}}</label>
                                 <input type="number" name="promotion_price" class="form-control" step="any" />
                              </div>
                              <div class="col-md-4" id="start_date">
                                 <div class="form-group">
                                    <label>{{trans('file.Promotion Starts')}}</label>
                                    <div class="input-group">
                                       <div class="input-group-prepend">
                                          <div class="input-group-text"><i class="dripicons-calendar"></i></div>
                                       </div>
                                       <input type="text" name="starting_date" id="starting_date" class="form-control" />
                                    </div>
                                 </div>
                              </div>
                              <div class="col-md-4" id="last_date">
                                 <div class="form-group">
                                    <label>{{trans('file.Promotion Ends')}}</label>
                                    <div class="input-group">
                                       <div class="input-group-prepend">
                                          <div class="input-group-text"><i class="dripicons-calendar"></i></div>
                                       </div>
                                       <input type="text" name="last_date" id="ending_date" class="form-control" />
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="form-group">
                        <button type="button" name="submit_type" value="no_print" class="btn btn-primary submit-product" id="submit-btn">
                            {{ trans('Only Save') }}
                        </button>
                        
                        <button type="button" name="submit_type" value="print_one" class="btn btn-success submit-product">
                            {{ trans('Save & print 1 Barcode') }}
                        </button>
                        
                        <button type="button" name="submit_type" value="print_quantity" class="btn btn-warning submit-product">
                            {{ trans('Save & print full Stock') }}
                        </button>

                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>


<div class="modal fade" id="addColorModal" tabindex="-1" role="dialog" aria-labelledby="addColorModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form id="colorForm" action="{{ route('color.store') }}" method="POST">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addColorModalLabel">Add New Color</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="color_name"><strong>Color Name</strong></label>
            <input type="text" name="color_name" id="color_name" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="color_code"><strong>Color Code</strong></label>
            <input type="color" name="color_code" id="color_code" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Status</strong></label>
            <select name="is_active" id="is_active" class="form-control" required>
              <option value="1">Active</option>
              <option value="0">Inactive</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Add Color</button>
        </div>
      </div>
    </form>
  </div>
</div>
<div class="modal fade" id="addSizeModal" tabindex="-1" role="dialog" aria-labelledby="addSizeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form id="sizeForm" action="{{ route('size.store') }}" method="POST">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addSizeModalLabel">Size</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="name"><strong>Name</strong></label>
            <input type="text" name="name" id="name" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Status</strong></label>
            <select name="is_active" id="is_active" class="form-control" required>
              <option value="1">Active</option>
              <option value="0">Inactive</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Add Size</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- SIZE MODAL -->
<div class="modal fade" id="customizeSizeModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <form id="customizeSize">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Manage Sizes</h5>
          <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        </div>
        <div class="modal-body">
          <table class="table table-bordered">
            <thead>
              <tr>
                <th>Select</th>
                <th>Size Name</th>
                <th>Status</th>
              </tr>
            </thead>
            <tbody id="sizeTableBody">
              <!-- Filled by JS -->
            </tbody>
          </table>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Update Sizes</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- COLOR MODAL -->
<div class="modal fade" id="customizeColorModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <form id="customizeColor">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Manage Colors</h5>
          <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        </div>
        <div class="modal-body">
          <table class="table table-bordered">
            <thead>
              <tr>
                <th>Select</th>
                <th>Color Name</th>
                <th>Preview</th>
                <th>Status</th>
              </tr>
            </thead>
            <tbody id="colorTableBody">
              <!-- Filled by JS -->
            </tbody>
          </table>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Update Colors</button>
        </div>
      </div>
    </form>
  </div>
</div>


@endsection
@push('scripts')

<script type="text/javascript">
    
    $(function () {
    // COLOR FORM
    $('#colorForm').on('submit', function (e) {
        e.preventDefault();

        let form = $(this);
        let actionUrl = form.attr('action');
        let token = form.find('input[name="_token"]').val(); // grab CSRF token from hidden input

        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            headers: { 'X-CSRF-TOKEN': token },
            success: function (response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: response.message,
                        toast: true,
                        position: 'top-end',
                        timer: 3000,
                        showConfirmButton: false
                    });
                    colorArray = response.data;
                    
                    form[0].reset();
                    closeModal('addColorModal');

                }
            },
            error: function (xhr) {
                console.error(xhr.responseJSON);
                Swal.fire('Error!', 'Something went wrong.', 'error');
            }
        });
    });

    // SIZE FORM
    $('#sizeForm').on('submit', function (e) {
        e.preventDefault();

        let form = $(this);
        let actionUrl = form.attr('action');
        let token = form.find('input[name="_token"]').val(); // grab CSRF token

        $.ajax({
            type: "POST",
            url: actionUrl,
            data: form.serialize(),
            headers: { 'X-CSRF-TOKEN': token },
            success: function (response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: response.message,
                        toast: true,
                        position: 'top-end',
                        timer: 3000,
                        showConfirmButton: false
                    });
                    sizeArray = response.data;
                    form[0].reset();
                    closeModal('addSizeModal');
                }
            },
            error: function (xhr) {
                console.error(xhr.responseJSON);
                Swal.fire('Error!', 'Something went wrong.', 'error');
            }
        });
    });
});
function closeModal(id) {
    const modal = document.getElementById(id);
    if (!modal) return;

    // Start fade-out by removing 'show'
    modal.classList.remove('show');

    // Wait for Bootstrap's transition (300ms default)
    setTimeout(() => {
        modal.setAttribute('aria-hidden', 'true');
        modal.style.display = 'none';

        // Remove backdrop if exists
        const backdrops = document.getElementsByClassName('modal-backdrop');
        while (backdrops.length > 0) {
            backdrops[0].parentNode.removeChild(backdrops[0]);
        }

        // Remove body scroll lock
        document.body.classList.remove('modal-open');
        document.body.style.removeProperty('padding-right');
    }, 300); // match Bootstrap’s CSS transition duration
}


   $("ul#product").siblings('a').attr('aria-expanded','true');
   $("ul#product").addClass("show");
   $("ul#product #product-create-menu").addClass("active");
   
   $("#digital").hide();
   $("#combo").hide();
   $("#variant-section").hide();
   $("#diffPrice-section").hide();
   $("#promotion_price").hide();
   $("#start_date").hide();
   $("#last_date").hide();
   
   $('[data-toggle="tooltip"]').tooltip();
   
   $.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
   });
   
   $('#genbutton').on("click", function(){
     $.get('gencode', function(data){
       $("input[name='code']").val(data);
     });
   });
   
   
   
   tinymce.init({
     selector: 'textarea',
     height: 130,
     plugins: [
       'advlist autolink lists link image charmap print preview anchor textcolor',
       'searchreplace visualblocks code fullscreen',
       'insertdatetime media table contextmenu paste code wordcount'
     ],
     toolbar: 'insert | undo redo |  formatselect | bold italic backcolor  | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat',
     branding:false
   });
   
   $('select[name="type"]').on('change', function() {
       if($(this).val() == 'combo'){
           $("input[name='cost']").prop('required',false);
           $("select[name='unit_id']").prop('required',false);
           hide();
           $("#combo").show(300);
           $("input[name='price']").prop('disabled',true);
           $("#is-variant").prop("checked", false);
           $("#is-diffPrice").prop("checked", false);
           $("#variant-section, #variant-option, #diffPrice-option, #diffPrice-section").hide(300);
       }
       else if($(this).val() == 'digital'){
           $("input[name='cost']").prop('required',false);
           $("select[name='unit_id']").prop('required',false);
           $("input[name='file']").prop('required',true);
           hide();
           $("#digital").show(300);
           $("#combo").hide(300);
           $("input[name='price']").prop('disabled',false);
           $("#is-variant").prop("checked", false);
           $("#is-diffPrice").prop("checked", false);
           $("#variant-section, #variant-option, #diffPrice-option, #diffPrice-section").hide(300);
       }
       else if($(this).val() == 'service') {
           $("input[name='cost']").prop('required',false);
           $("select[name='unit_id']").prop('required',false);
           $("input[name='file']").prop('required',true);
           hide();
           $("#combo").hide(300);
           $("#digital").hide(300);
           $("input[name='price']").prop('disabled',false);
           $("#is-variant").prop("checked", false);
           $("#variant-section, #variant-option").hide(300);
       }
       else if($(this).val() == 'standard') {
           $("input[name='cost']").prop('required',true);
           $("select[name='unit_id']").prop('required',true);
           $("input[name='file']").prop('required',false);
           $("#cost").show(300);
           $("#unit").show(300);
           $("#alert-qty").show(300);
           $("#variant-option").show(300);
           $("#diffPrice-option").show(300);
           $("#digital").hide(300);
           $("#combo").hide(300);
           $("input[name='price']").prop('disabled',false);
       }
   });
   
   $('select[name="unit_id"]').on('change', function() {
   
       unitID = $(this).val();
       if(unitID) {
           populate_category(unitID);
       }else{
           $('select[name="sale_unit_id"]').empty();
           $('select[name="purchase_unit_id"]').empty();
       }
   });
   <?php $productArray = []; ?>
   var lims_product_code = [
       @foreach($lims_product_list_without_variant as $product)
       <?php
      $productArray[] = htmlspecialchars($product->code . ' (' . $product->name . ')');
      ?>
       @endforeach
       @foreach($lims_product_list_with_variant as $product)
           <?php
      $productArray[] = htmlspecialchars($product->item_code . ' (' . $product->name . ')');
      ?>
       @endforeach
           <?php
      echo  '"'.implode('","', $productArray).'"';
      ?> ];
   
   var lims_productcodeSearch = $('#lims_productcodeSearch');
   
   lims_productcodeSearch.autocomplete({
       source: function(request, response) {
           var matcher = new RegExp(".?" + $.ui.autocomplete.escapeRegex(request.term), "i");
           response($.grep(lims_product_code, function(item) {
               return matcher.test(item);
           }));
       },
       select: function(event, ui) {
           var data = ui.item.value;
           $.ajax({
               type: 'GET',
               url: 'lims_product_search',
               data: {
                   data: data
               },
               success: function(data) {
                   //console.log(data);
                   var flag = 1;
                   $(".product-id").each(function() {
                       if ($(this).val() == data[8]) {
                           alert('Duplicate input is not allowed!')
                           flag = 0;
                       }
                   });
                   $("input[name='product_code_name']").val('');
                   if(flag){
                       var newRow = $("<tr>");
                       var cols = '';
                       cols += '<td>' + data[0] +' [' + data[1] + ']</td>';
                       cols += '<td><input type="number" class="form-control qty" name="product_qty[]" value="1" step="any"/></td>';
                       cols += '<td><input type="number" class="form-control unit_price" name="unit_price[]" value="' + data[2] + '" step="any"/></td>';
                       cols += '<td><button type="button" class="ibtnDel btn btn-sm btn-danger">X</button></td>';
                       cols += '<input type="hidden" class="product-id" name="product_id[]" value="' + data[8] + '"/>';
                       cols += '<input type="hidden" class="" name="variant_id[]" value="' + data[9] + '"/>';
   
                       newRow.append(cols);
                       $("table.order-list tbody").append(newRow);
                       calculate_price();
                   }
               }
           });
       }
   });
   
   //Change quantity or unit price
   $("#myTable").on('input', '.qty , .unit_price', function() {
       calculate_price();
   });
   
   //Delete product
   $("table.order-list tbody").on("click", ".ibtnDel", function(event) {
       $(this).closest("tr").remove();
       calculate_price();
   });
   
   function hide() {
       $("#cost").hide(300);
       $("#unit").hide(300);
       $("#alert-qty").hide(300);
   }
   
   function calculate_price() {
       var price = 0;
       $(".qty").each(function() {
           rowindex = $(this).closest('tr').index();
           quantity =  $(this).val();
           unit_price = $('table.order-list tbody tr:nth-child(' + (rowindex + 1) + ') .unit_price').val();
           price += quantity * unit_price;
       });
       $('input[name="price"]').val(price);
   }
   
   function populate_category(unitID){
       $.ajax({
           url: 'saleunit/'+unitID,
           type: "GET",
           dataType: "json",
           success:function(data) {
                 $('select[name="sale_unit_id"]').empty();
                 $('select[name="purchase_unit_id"]').empty();
                 $.each(data, function(key, value) {
                     $('select[name="sale_unit_id"]').append('<option value="'+ key +'">'+ value +'</option>');
                     $('select[name="purchase_unit_id"]').append('<option value="'+ key +'">'+ value +'</option>');
                 });
                 $('.selectpicker').selectpicker('refresh');
           },
       });
   }
   
   $("input[name='is_batch']").on("change", function () {
       if ($(this).is(':checked')) {
           $("#variant-option").hide(300);
       }
       else
           $("#variant-option").show(300);
   });
   
   $("input[name='is_variant']").on("change", function () {
       if ($(this).is(':checked')) {
           $("#variant-section").show(300);
           $("#batch-option").hide(300);
       }
       else {
           $("#variant-section").hide(300);
           $("#batch-option").show(300);
       }
   });
   
   $("input[name='is_diffPrice']").on("change", function () {
       if ($(this).is(':checked')) {
           $("#diffPrice-section").show(300);
       }
       else
           $("#diffPrice-section").hide(300);
   });
   
   $("input[name='variant']").on("input", function () {
       if($("#code").val() == ''){
           $("input[name='variant']").val('');
           alert('Please fillup above information first.');
       }
       else if($(this).val().indexOf(',') > -1) {
           var variant_name = $(this).val().slice(0, -1);
           var item_code = variant_name+'-'+$("#code").val();
           var newRow = $("<tr>");
           var cols = '';
           cols += '<td style="cursor:grab"><i class="dripicons-view-apps"></i></td>';
           // cols += '<td><input type="text" class="form-control" name="variant_name[]" value="' + variant_name + '" /></td>';
           cols += '<td><input type="text" class="form-control" name="variant_name[]" value="" /></td>';
           cols += '<td><input type="text" class="form-control" name="item_code[]" value="'+item_code+'" /></td>';
           cols += '<td><input type="number" class="form-control" name="additional_price[]" value="" step="any" /></td>';
           cols += '<td><button type="button" class="vbtnDel btn btn-sm btn-danger">X</button></td>';
   
           $("input[name='variant']").val('');
           newRow.append(cols);
           $("table.variant-list tbody").append(newRow);
       }
   });
   
   //Delete variant
   $("table#variant-table tbody").on("click", ".vbtnDel", function(event) {
       $(this).closest("tr").remove();
   });
   
   $( "#promotion" ).on( "change", function() {
       if ($(this).is(':checked')) {
           $("#starting_date").val($.datepicker.formatDate('dd-mm-yy', new Date()));
           $("#promotion_price").show(300);
           $("#start_date").show(300);
           $("#last_date").show(300);
       }
       else {
           $("#promotion_price").hide(300);
           $("#start_date").hide(300);
           $("#last_date").hide(300);
       }
   });
   
   var starting_date = $('#starting_date');
   starting_date.datepicker({
    format: "dd-mm-yyyy",
    startDate: "<?php echo date('d-m-Y'); ?>",
    autoclose: true,
    todayHighlight: true
    });
   
   var ending_date = $('#ending_date');
   ending_date.datepicker({
    format: "dd-mm-yyyy",
    startDate: "<?php echo date('d-m-Y'); ?>",
    autoclose: true,
    todayHighlight: true
    });
   
   $(window).keydown(function(e){
       if (e.which == 13) {
           var $targ = $(e.target);
   
           if (!$targ.is("textarea") && !$targ.is(":button,:submit")) {
               var focusNext = false;
               $(this).find(":input:visible:not([disabled],[readonly]), a").each(function(){
                   if (this === e.target) {
                       focusNext = true;
                   }
                   else if (focusNext){
                       $(this).focus();
                       return false;
                   }
               });
   
               return false;
           }
       }
   });
   //dropzone portion
   Dropzone.autoDiscover = false;
   
   jQuery.validator.setDefaults({
       errorPlacement: function (error, element) {
           if(error.html() == 'Select Category...')
               error.html('This field is required.');
           $(element).closest('div.form-group').find('.validation-msg').html(error.html());
       },
       highlight: function (element) {
           $(element).closest('div.form-group').removeClass('has-success').addClass('has-error');
       },
       unhighlight: function (element, errorClass, validClass) {
           $(element).closest('div.form-group').removeClass('has-error').addClass('has-success');
           $(element).closest('div.form-group').find('.validation-msg').html('');
       }
   });
   
   function validate() {
       var product_code = $("input[name='code']").val();
       var barcode_symbology = $('select[name="barcode_symbology"]').val();
       var exp = /^\d+$/;
   
       if(!(product_code.match(exp)) && (barcode_symbology == 'UPCA' || barcode_symbology == 'UPCE' || barcode_symbology == 'EAN8' || barcode_symbology == 'EAN13') ) {
           alert('Product code must be numeric.');
           return false;
       }
       else if(product_code.match(exp)) {
           if(barcode_symbology == 'UPCA' && product_code.length > 11){
               alert('Product code length must be less than 12');
               return false;
           }
           else if(barcode_symbology == 'EAN8' && product_code.length > 7){
               alert('Product code length must be less than 8');
               return false;
           }
           else if(barcode_symbology == 'EAN13' && product_code.length > 12){
               alert('Product code length must be less than 13');
               return false;
           }
       }
   
       if( $("#type").val() == 'combo' ) {
           var rownumber = $('table.order-list tbody tr:last').index();
           if (rownumber < 0) {
               alert("Please insert product to table!")
               return false;
           }
       }
       if($("#is-variant").is(":checked")) {
           rowindex = $("table#variant-table tbody tr:last").index();
           if (rowindex < 0) {
               alert('This product has variant. Please insert variant to table');
               return false;
           }
       }
       $("input[name='price']").prop('disabled',false);
       return true;
   }
   
   $("table#variant-table tbody").sortable({
       items: 'tr',
       cursor: 'grab',
       opacity: 0.5,
   });
   
   $(".dropzone").sortable({
       items:'.dz-preview',
       cursor: 'grab',
       opacity: 0.5,
       containment: '.dropzone',
       distance: 20,
       tolerance: 'pointer',
       stop: function () {
         var queue = myDropzone.getAcceptedFiles();
         newQueue = [];
         $('#imageUpload .dz-preview .dz-filename [data-dz-name]').each(function (count, el) {
               var name = el.innerHTML;
               queue.forEach(function(file) {
                   if (file.name === name) {
                       newQueue.push(file);
                   }
               });
         });
         myDropzone.files = newQueue;
       }
   });
   
   
   let submitType = 'no_print';
   
   $(".submit-product").on("click", function () {
        submitType = $(this).val(); 
    });

// ✅ disable auto discovery (important if using plain <div>)
Dropzone.autoDiscover = false;

var myDropzone = new Dropzone("#imageUpload", {
    url: "{{ route('products.store') }}",  // same endpoint as form
    autoProcessQueue: false,   // we'll handle submit manually
    uploadMultiple: true,
    parallelUploads: 100,
    maxFilesize: 12,
    paramName: "image[]",   // 👈 array key for product images
    addRemoveLinks: true,
    acceptedFiles: ".jpeg,.jpg,.png,.gif",
    headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
    }
});

$(".submit-product").on("click", function (e) {
    e.preventDefault();

    var validator = $("#product-form").validate();
    validator.form();

    if (!validator.valid() || !validate()) {
        return;
    }

    tinyMCE.triggerSave();

    // Build FormData
    const formElement = document.getElementById("product-form");
    const formData = new FormData(formElement);

    // ✅ append variant images
    $('input[name="variants_image[]"]').each(function (i) {
        if (this.files[0]) {
            formData.append(`variants_image[${i}]`, this.files[0]);
        }
    });

    // ✅ append Dropzone files with index
    myDropzone.files.forEach((file, index) => {
        formData.append(`image[${index}]`, file);
    });

    formData.append("submit_type", submitType);

    // Single AJAX call for everything
    $.ajax({
        url: "{{ route('products.store') }}",
        method: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            myDropzone.removeAllFiles(true);
            $("#product-form")[0].reset();

            // ✅ success alert
            let successAlert = document.createElement("div");
            successAlert.className = "alert alert-success";
            successAlert.textContent = "Product added successfully!";
            successAlert.style.position = "fixed";
            successAlert.style.top = "20px";
            successAlert.style.right = "20px";
            successAlert.style.zIndex = "1051";
            document.body.appendChild(successAlert);
            setTimeout(() => successAlert.remove(), 1000);

            // If barcodes are returned
            if (submitType !== 'no_print' && response.barcodes && response.barcodes.length > 0) {
                let labelContent = document.getElementById("label-content");
                labelContent.innerHTML = "";

                response.barcodes.forEach((item) => {
                    let repeatCount = (submitType === "print_quantity") ? (Number(item.qty) || 1) : 1;

                    for (let i = 0; i < repeatCount; i++) {
                        let barcodeHTML = `<div class="barcode-item" style="border:1px solid #ddd; padding:10px; margin-bottom:10px; text-align:center;">`;

                        let columns = [];
                        if (item.code) columns.push({ label: "ART NO.", value: item.code });
                        if (item.color) columns.push({ label: "Color", value: item.color });
                        if (item.size) columns.push({ label: "Size", value: item.size });

                        const columnCount = columns.length;

                        barcodeHTML += `<div style="display: grid; grid-template-columns: repeat(${columnCount}, 1fr); gap: 5px; text-align: center;">`;

                        // Row 1: Headings
                        columns.forEach(col => {
                            barcodeHTML += `<div style="font-weight: bold;">${col.label}</div>`;
                        });

                        // Row 2: Values
                        columns.forEach(col => {
                            barcodeHTML += `<div>${col.value}</div>`;
                        });

                        barcodeHTML += `</div>`;

                        // Barcode
                        if (item.barcode) {
                            barcodeHTML += `
                                <div style="margin-top: 15px;">
                                    <img src="${item.barcode}" alt="Barcode" style="display: block; margin: 0 auto;">
                                </div>
                            `;
                        }

                        barcodeHTML += `</div>`; // End barcode item

                        labelContent.insertAdjacentHTML("beforeend", barcodeHTML);
                    }
                });

                $("#barcodeModal").modal("show");
            } else {
                window.location.href = '{{ route('products.index') }}';
            }
        },
        error: function (xhr) {
            console.error(xhr.responseText);
            alert("Something went wrong!");
        }
    });
});


   
//   myDropzone = new Dropzone('div#imageUpload', {
//       addRemoveLinks: true,
//       autoProcessQueue: false,
//       uploadMultiple: true,
//       parallelUploads: 100,
//       maxFilesize: 12,
//       paramName: 'image[]',
//       clickable: true,
//       method: 'POST',
//       url: '{{route('products.store')}}',
//       headers: {
//           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//       },
//       renameFile: function(file) {
//           var dt = new Date();
//           var time = dt.getTime();
//           return time + file.name;
//       },
//       acceptedFiles: ".jpeg,.jpg,.png,.gif",
//       init: function () {
//           var myDropzone = this;
//           $('.submit-product').on("click", function (e) {
            
//           var validator = $("#product-form").validate(); // get validator instance
//             validator.form(); // force validation
            
//             if (!validator.valid()) {
//                 console.log("Form valid?", false);
//                 console.log("Validation failed on fields:");
            
//                 validator.errorList.forEach(function(error) {
//                     console.log("Field:", error.element.name, "| Message:", error.message);
//                 });
//             } else {
//                 console.log("Form valid?", true);
//             }


//     e.preventDefault();
    
//     if ($("#product-form").valid() && validate()) {
//         tinyMCE.triggerSave();

//         const formElement = document.getElementById("product-form");
//         const formData = new FormData(formElement);
        
//               $('input[name="variants_image[]"]').each(function () {
//                     if (this.files[0]) {
//                         formData.append('variants_image[]', this.files[0]);
//                     }
//                 });
//                  formData.append('submit_type', submitType); 

//         $.ajax({
//             url: '{{ route('products.store') }}',
//             method: 'POST',
//             data: formData,
//             contentType: false,
//             processData: false,
//             success: function (response) {
            
//     let successAlert = document.createElement("div");
//     successAlert.className = "alert alert-success";
//     successAlert.textContent = "Product added successfully!";
//     successAlert.style.position = "fixed";
//     successAlert.style.top = "20px";
//     successAlert.style.right = "20px";
//     successAlert.style.zIndex = "1051";
//     document.body.appendChild(successAlert);
//     setTimeout(() => successAlert.remove(), 1000);

//   if (submitType !== 'no_print' && response.barcodes && response.barcodes.length > 0) {
//     let labelContent = document.getElementById("label-content");
//     labelContent.innerHTML = "";

//     response.barcodes.forEach((item) => {
//         let repeatCount = 1;

//         if (submitType === "print_quantity") {
//             repeatCount = Number(item.qty) || 1;
//         }

//         for (let i = 0; i < repeatCount; i++) {
//             // Start barcode item container
//             let barcodeHTML = `<div class="barcode-item" style="border:1px solid #ddd; padding:10px; margin-bottom:10px; text-align:center;">`;

//             // Determine which fields exist
//             let columns = [];
//             if (item.code) columns.push({ label: "ART NO.", value: item.code });
//             if (item.color) columns.push({ label: "Color", value: item.color });
//             if (item.size) columns.push({ label: "Size", value: item.size });
//             const columnCount = columns.length;

//             // Render the grid layout
//             barcodeHTML += `<div style="display: grid; grid-template-columns: repeat(${columnCount}, 1fr); gap: 5px; text-align: center;">`;

//             // Row 1: Headings
//             columns.forEach(col => {
//                 barcodeHTML += `<div style="font-weight: bold;">${col.label}</div>`;
//             });

//             // Row 2: Values
//             columns.forEach(col => {
//                 barcodeHTML += `<div>${col.value}</div>`;
//             });

//             barcodeHTML += `</div>`; // End grid layout

//             // Barcode (centered)
//             if (item.barcode) {
//                 barcodeHTML += `
//                     <div style="margin-top: 15px;">
//                         <img src="${item.barcode}" alt="Barcode" style="display: block; margin: 0 auto;">
//                     </div>
//                 `;
//             }

//             barcodeHTML += `</div>`; // End barcode item

//             labelContent.insertAdjacentHTML("beforeend", barcodeHTML);
//         }
//     });

//     $("#barcodeModal").modal("show");
// }else {
//         window.location.href ='{{ route('products.index') }}';
//     }

//     myDropzone.removeAllFiles();
//     $('#product-form')[0].reset();
// },

//             error: function (xhr) {
//                 console.error(xhr.responseText);
//                 alert("Something went wrong");
//             }
//         });
//     }
// });

   
//           this.on('sending', function (file, xhr, formData) {
//               // Append all form inputs to the formData Dropzone will POST
//               var data = $("#product-form").serializeArray();
//               $.each(data, function (key, el) {
//                   formData.append(el.name, el.value);
//               });
//           });
//       },
//       error: function (file, response) {
//           console.log(response);
//           if(response.errors.name) {
//              $("#name-error").text(response.errors.name);
//              this.removeAllFiles(true);
//           }
//           else if(response.errors.code) {
//              $("#code-error").text(response.errors.code);
//              this.removeAllFiles(true);
//           }
//           else {
//              try {
//                  var res = JSON.parse(response);
//                  if (typeof res.message !== 'undefined' && !$modal.hasClass('in')) {
//                      $("#success-icon").attr("class", "fas fa-thumbs-down");
//                      $("#success-text").html(res.message);
//                      $modal.modal("show");
//                  } else {
//                      if ($.type(response) === "string")
//                          var message = response; //dropzone sends it's own error messages in string
//                      else
//                          var message = response.message;
//                      file.previewElement.classList.add("dz-error");
//                      _ref = file.previewElement.querySelectorAll("[data-dz-errormessage]");
//                      _results = [];
//                      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
//                          node = _ref[_i];
//                          _results.push(node.textContent = message);
//                      }
//                      return _results;
//                  }
//              } catch (error) {
//                  console.log(error);
//              }
//           }
//       },
//       successmultiple: function (file, response) {
//           location.href = '../products';
//           //console.log(file, response);
//       },
//       completemultiple: function (file, response) {
//           console.log(file, response, "completemultiple");
//       },
//       reset: function () {
//           console.log("resetFiles");
//           this.removeAllFiles(true);
//       }
//   });
   
</script>
<div id="barcodeModal" tabindex="-1" role="dialog" aria-labelledby="barcodeModalLabel" aria-hidden="true" class="modal fade text-left">
   <div role="document" class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header">
            <h5 id="modal_header" class="modal-title">{{trans('file.Barcode')}}</h5>
            &nbsp;&nbsp;
            <button id="print-btn" type="button" class="btn btn-default btn-sm" onclick="printBarcodes();"><i class="dripicons-print" ></i> {{trans('file.Print')}}</button>
            <button type="button" id="close-btn" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
         </div>
         <div class="modal-body" id="barcodeModalBody" style="display: flex; flex-wrap: wrap; gap: 10px;">
            <div id="label-content">
            </div>
         </div>
      </div>
   </div>
</div>
<script>
    function printBarcodes() {
        let barcodes = document.querySelectorAll(".barcode-item");

        let newWindow = window.open("", "_blank");
        let htmlContent = `
            <html>
            <head>
                <title>Print Barcodes</title>
                <style>
                    .barcode-item {
                        text-align: center;
                        border: 1px solid #ddd;
                        padding: 5px;
                        margin: 10px;
                    }
                    @media print {
                        .barcode-item {
                            page-break-after: always;
                        }
                    }
                </style>
            </head>
            <body>
        `;

        barcodes.forEach((barcode) => {
            htmlContent += `
                <div class="barcode-item">
                    ${barcode.innerHTML}
                </div>
            `;
        });

        htmlContent += `
            </body>
            </html>
        `;

        newWindow.document.open();
        newWindow.document.write(htmlContent);
        newWindow.document.close();

        // Wait until all images in new window are loaded
        newWindow.onload = function () {
            const images = newWindow.document.images;
            let loadedCount = 0;

            if (images.length === 0) {
                newWindow.print();
                newWindow.close();
                window.location.href = '../products';
                return;
            }

            for (let img of images) {
                img.onload = img.onerror = function () {
                    loadedCount++;
                    if (loadedCount === images.length) {
                        newWindow.focus();
                        newWindow.print();
                        newWindow.close();
                        window.location.href = '../products';
                    }
                };
            }
        };
    }

    document.getElementById("close-btn").addEventListener("click", function () {
        location.href = '../products';
    });
</script>

<script>
   $(document).ready(function() {
   $.get('gencode', function(data) {
       $("input[name='code']").val(data);
   });
   });
   
</script>
<script>
   document.addEventListener("DOMContentLoaded", function () {
       const checkbox = document.getElementById("is-imei");
       const priceSection = document.getElementById("price-section");
       const productUnit = document.getElementById("unit_id");
       const saleUnit = document.getElementById("sale-unit");
       const unitNamePlaceholder = document.getElementById("unit-name-placeholder");
   
       function checkAndTogglePriceSection() {
           const productText = productUnit.options[productUnit.selectedIndex]?.text.trim();
           const saleText = saleUnit.options[saleUnit.selectedIndex]?.text.trim();
   
           // Get all non-empty sale unit options
           const saleUnitOptions = Array.from(saleUnit.options)
               .map(opt => opt.text.trim())
               .filter(opt => opt !== "");
   
           if (checkbox.checked) {
               // Check if there are at least two sale units
               if (saleUnitOptions.length < 2) {
                   alert("Please add at least two Sale Units first.");
                   checkbox.checked = false;
                   unitNamePlaceholder.textContent = "--";
                   priceSection.style.display = "none";
                   return; // Stop further checks
               }
   
               // Proceed with matching validation
               if (productText === saleText && productText !== "") {
                   const otherUnit = saleUnitOptions.find(unit => unit !== productText);
                   unitNamePlaceholder.textContent = otherUnit || "--";
                   priceSection.style.display = "block";
               } else {
                   alert("Product Unit and Sale Unit must be the same to enter the price.");
                   checkbox.checked = false;
                   unitNamePlaceholder.textContent = "--";
                   priceSection.style.display = "none";
               }
           } else {
               priceSection.style.display = "none";
               unitNamePlaceholder.textContent = "--";
           }
       }
   
       checkbox.addEventListener("change", checkAndTogglePriceSection);
       productUnit.addEventListener("change", checkAndTogglePriceSection);
       saleUnit.addEventListener("change", checkAndTogglePriceSection);
   });
</script>
@endpush