@extends('layout.main')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@section('content')
<section class="forms">
   <div class="container-fluid">
      <div class="row">
         <div class="col-md-12">
            <div class="card">
               <div class="card-header d-flex align-items-center">
                  <h4>{{trans('file.Update Product')}}</h4>
               </div>
               <div class="card-body">
                  <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                  <form id="product-form">
                     <input type="hidden" name="id" value="{{$lims_product_data->id}}" />
                     <div class="row">
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Type')}} *</strong> </label>
                              <div class="input-group">
                                 <select name="type" required class="form-control selectpicker" id="type">
                                    <option value="standard">Standard</option>
                                    <option value="combo">Combo</option>
                                    <option value="digital">Digital</option>
                                    <option value="service">Service</option>
                                 </select>
                                 <input type="hidden" name="type_hidden" value="{{$lims_product_data->type}}">
                              </div>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Name')}} *</strong> </label>
                              <input id="name" type="text" name="name" value="{{$lims_product_data->name}}" required class="form-control">
                              <span class="validation-msg" id="name-error"></span>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Code')}} *</strong> </label>
                              <div class="input-group">
                                 <input type="text" name="code" id="code" value="{{$lims_product_data->code}}" class="form-control" required>
                                 <div class="input-group-append">
                                    <button id="genbutton" type="button" class="btn btn-sm btn-default" title="{{trans('file.Generate')}}"><i class="fa fa-refresh"></i></button>
                                 </div>
                              </div>
                              <span class="validation-msg" id="code-error"></span>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Barcode Symbology')}} *</strong> </label>
                              <div class="input-group">
                                 <input type="hidden" name="barcode_symbology_hidden" value="{{$lims_product_data->barcode_symbology}}">
                                 <select name="barcode_symbology" required class="form-control selectpicker">
                                    <option value="UPCE">UPC-E</option>
                                    <option value="C128">Code 128</option>
                                    <option value="C39">Code 39</option>
                                    <option value="UPCA">UPC-A</option>
                                    <option value="EAN8">EAN-8</option>
                                    <option value="EAN13">EAN-13</option>
                                 </select>
                              </div>
                           </div>
                        </div>
                        <div id="digital" class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Attach File')}}</strong> </label>
                              <div class="input-group">
                                 <input type="file" name="file" class="form-control">
                              </div>
                              <span class="validation-msg"></span>
                           </div>
                        </div>
                        <div id="combo" class="col-md-9 mb-1">
                           <label>{{trans('file.add_product')}}</label>
                           <div class="search-box input-group mb-3">
                              <button class="btn btn-secondary"><i class="fa fa-barcode"></i></button>
                              <input type="text" name="product_code_name" id="lims_productcodeSearch" placeholder="Please type product code and select..." class="form-control" />
                           </div>
                           <label>{{trans('file.Combo Products')}}</label>
                           <div class="table-responsive">
                              <table id="myTable" class="table table-hover order-list">
                                 <thead>
                                    <tr>
                                       <th>{{trans('file.product')}}</th>
                                       <th>{{trans('file.Quantity')}}</th>
                                       <th>{{trans('file.Unit Price')}}</th>
                                       <th><i class="dripicons-trash"></i></th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    @if($lims_product_data->type == 'combo')
                                    <?php
                                       $product_list = explode(",", $lims_product_data->product_list);
                                       $qty_list = explode(",", $lims_product_data->qty_list);
                                       $variant_list = explode(",", $lims_product_data->variant_list);
                                       $price_list = explode(",", $lims_product_data->price_list);
                                       ?>
                                    @foreach($product_list as $key=>$id)
                                    <tr>
                                       <?php
                                          $product = App\Product::find($id);
                                          if($variant_list[$key]) {
                                              $product_variant_data = App\ProductVariant::select('item_code')->FindExactProduct($id, $variant_list[$key])->first();
                                              $product->code = $product_variant_data->item_code;
                                          }
                                          ?>
                                       <td>{{$product->name}} [{{$product->code}}]</td>
                                       <td><input type="number" class="form-control qty" name="product_qty[]" value="{{$qty_list[$key]}}" step="any"></td>
                                       <td><input type="number" class="form-control unit_price" name="unit_price[]" value="{{$price_list[$key]}}" step="any"/></td>
                                       <td><button type="button" class="ibtnDel btn btn-danger btn-sm">X</button></td>
                                       <input type="hidden" class="product-id" name="product_id[]" value="{{$id}}"/>
                                       <input type="hidden" class="variant-id" name="variant_id[]" value="{{$variant_list[$key]}}"/>
                                    </tr>
                                    @endforeach
                                    @endif
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Brand')}}</strong> </label>
                              <div class="input-group">
                                 <input type="hidden" name="brand" value="{{ $lims_product_data->brand_id}}">
                                 <select name="brand_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Brand...">
                                    @foreach($lims_brand_list as $brand)
                                    <option value="{{$brand->id}}">{{$brand->title}}</option>
                                    @endforeach
                                 </select>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <input type="hidden" name="category" value="{{$lims_product_data->category_id}}">
                              <label>{{trans('file.category')}} *</strong> </label>
                              <div class="input-group">
                                 <select name="category_id" required class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Category...">
                                    @foreach($lims_category_list as $category)
                                    <option value="{{$category->id}}">{{$category->name}}</option>
                                    @endforeach
                                 </select>
                              </div>
                           </div>
                        </div>
                        <div id="unit" class="col-md-12">
                           <div class="row ">
                              <div class="col-md-4">
                                 <label>{{trans('file.Product Unit')}} *</label>
                                 <div class="input-group">
                                    <select required class="form-control selectpicker" data-live-search="true" data-live-search-style="begins" 
                                       title="Select unit..." name="unit_id" id="unit_id">
                                    @foreach($lims_unit_list as $unit)
                                    @if($unit->base_unit == null)
                                    <option value="{{$unit->id}}" 
                                    {{$lims_product_data->unit_id == $unit->id ? 'selected' : ''}}>{{$unit->unit_name}}</option>
                                    @endif
                                    @endforeach
                                    </select>
                                    <input type="hidden" name="unit" value="{{ $lims_product_data->unit_id}}">
                                 </div>
                              </div>
                              <!-- Sale Unit Selection -->
                              <div class="col-md-4">
                                 <label>{{trans('file.Sale Unit')}}</label>
                                 <div class="input-group">
                                    <select class="form-control selectpicker" name="sale_unit_id" id="sale-unit">
                                    @foreach($lims_unit_list as $unit)
                                    <option value="{{$unit->id}}" 
                                    {{$lims_product_data->sale_unit_id == $unit->id ? 'selected' : ''}}>{{$unit->unit_name}}</option>
                                    @endforeach
                                    </select>
                                    <input type="hidden" name="sale_unit" value="{{ $lims_product_data->sale_unit_id}}">
                                 </div>
                              </div>
                              <div class="col-md-4 mt-2">
                                 <div class="form-group">
                                    <label>{{trans('file.Purchase Unit')}}</strong> </label>
                                    <div class="input-group">
                                       <select class="form-control selectpicker" name="purchase_unit_id">
                                       </select>
                                       <input type="hidden" name="purchase_unit" value="{{ $lims_product_data->purchase_unit_id}}">
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div id="cost" class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Cost')}} *</strong> </label>
                              <input type="number" name="cost" value="{{$lims_product_data->cost}}" id="cost" required class="form-control" step="any">
                              <span class="validation-msg"></span>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Product Price')}} *</strong> </label>
                              <input type="number" name="price" value="{{$lims_product_data->price}}" id="price" required class="form-control" step="any">
                              <span class="validation-msg"></span>
                           </div>
                           <div class="form-group">
                              <input type="hidden" name="qty" value="{{ $lims_product_data->qty }}" class="form-control">
                           </div>
                        </div>
                        <div id="alert-qty" class="col-md-4">
                           <div class="form-group">
                              <label>{{trans('file.Alert Quantity')}}</strong> </label>
                              <input type="number" id="alert_quantity" name="alert_quantity" value="{{$lims_product_data->alert_quantity}}" class="form-control" step="any">
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <input type="hidden" name="tax" value="{{$lims_product_data->tax_id}}">
                              <label>{{trans('file.product')}} {{trans('file.Tax')}}</strong> </label>
                              <select name="tax_id" class="form-control selectpicker">
                                 <option value="">No Tax</option>
                                 @foreach($lims_tax_list as $tax)
                                 <option value="{{$tax->id}}">{{$tax->name}}</option>
                                 @endforeach
                              </select>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group">
                              <input type="hidden" name="tax_method_id" value="{{$lims_product_data->tax_method}}">
                              <label>{{trans('file.Tax Method')}}</strong> </label>
                              <select name="tax_method" class="form-control selectpicker">
                                 <option value="1">{{trans('file.Exclusive')}}</option>
                                 <option value="2">{{trans('file.Inclusive')}}</option>
                              </select>
                           </div>
                        </div>
                        <div class="col-md-4">
                           <div class="form-group mt-3">
                              @if($lims_product_data->featured)
                              <input type="checkbox" name="featured" value="1" checked>
                              @else
                              <input type="checkbox" name="featured" value="1">
                              @endif
                              <label>{{trans('file.Featured')}}</label>
                           </div>
                        </div>
                        <div class="col-md-4 mt-5">
                           <div class="form-group mt-3">
                              <input type="checkbox" id="is_variant" name="is_variant" value="1" {{ $lims_product_data->group_order ? 'checked' : '' }}>
                              <label for="is_variant">{{ trans('variant') }}</label>
                           </div>
                           <div id="variant-options" class="form-group mt-2" style="display: none;">
                              <input type="radio" id="variant_only_color" name="group_order" value="only_color"
                              {{ $lims_product_data->group_order == 'only_color' ? 'checked disabled' : 'disabled' }}>
                              <label for="variant_only_color">{{ trans('color') }}</label><br>
                              <input type="radio" id="variant_only_size" name="group_order" value="only_size"
                              {{ $lims_product_data->group_order == 'only_size' ? 'checked disabled' : 'disabled' }}>
                              <label for="variant_only_size">{{ trans('size') }}</label><br>
                              <input type="radio" id="variant_color_size" name="group_order" value="color_size"
                              {{ $lims_product_data->group_order == 'color_size' ? 'checked disabled' : 'disabled' }}>
                              <label for="variant_color_size">{{ trans('color') }} × {{ trans('size') }}</label><br>
                              <input type="radio" id="variant_size_color" name="group_order" value="size_color"
                              {{ $lims_product_data->group_order == 'size_color' ? 'checked disabled' : 'disabled' }}>
                              <label for="variant_size_color">{{ trans('size') }} × {{ trans('color') }}</label>
                           </div>
                        </div>
                        <div class="table-responsive ml-2" id="variant-table-wrapper" style="display: none;">
                           <table id="variant-table" class="table table-hover variant-list">
                              <thead>
                                 <tr>
                                    <th>#</th>
                                    <th>{{trans('Image')}}</th>
                                    <th>{{ trans('name') }}</th>
                                    <th>{{ trans('Color') }}</th>
                                    <th>{{ trans('Size') }}</th>
                                    <th>{{ trans('file.Item Code') }}</th>
                                    <th>{{ trans('Purchase Price') }}</th>
                                    <th>{{ trans('Sale Price') }}</th>
                                    <th>{{ trans('Opening Qty') }}</th>
                                    <th>{{ trans('Alert Qty') }}</th>
                                    <th><i class="dripicons-trash"></i></th>
                                 </tr>
                              </thead>
                              <tbody></tbody>
                           </table>
                           <button type="button" class="btn btn-primary" onclick="addmore()">Add More</button>
                        </div>
                        <!-- JavaScript for Variant Logic -->
                        <script>
                           const existingVariants = @json($variantProducts);
                           const colorArray = @json($colors);
                           const sizeArray = @json($sizes);
                           const warehouseList = @json($lims_warehouse_list);
                           const mainProduct =  @json($lims_product_data);
                           const vareint_type = @json($lims_product_data->group_order);
                           console.log(existingVariants,colorArray,sizeArray,warehouseList,mainProduct,vareint_type);
                           const deleteVariantUrl = "{{ route('product.varient.delete', ['id' => '__ID__']) }}";
                           
                           const tbody = document.querySelector("#variant-table tbody");
                           let rowCounter = 0;
                           
                           const warehouseOptions = warehouseList.map(w =>
                             `<option value="${w.id}">${w.name}</option>`
                           ).join("");
                           
                           function removeRow(btn) {
                             const row = btn.closest("tr");
                             const variantId = row.getAttribute("data-variant-id");
                             console.log(variantId);
                             // If there's a variant ID, this means it exists in DB
                             if (variantId) {
                               if (!confirm("Are you sure you want to delete this variant?")) return;
                           
                               const url = deleteVariantUrl.replace('__ID__', variantId);
                            
                               // Call your delete API (update URL accordingly)
                               fetch(url, {
                                 method: 'post',
                                 headers: {
                                   'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                                   'Content-Type': 'application/json',
                                 }
                               })
                               .then(response => {
                                 if (!response.ok) throw new Error('Failed to delete');
                                 // Remove row from DOM if deletion is successful
                                 row.remove();
                               })
                               .catch(error => {
                                 alert("Error deleting variant: " + error.message);
                               });
                             } else {
                               // If not saved yet, just remove it
                               row.remove();
                               updateVariantRowNumbers();
                             }
                           }
                           
                           
                           function clearAllVariantRows() {
                             tbody.innerHTML = "";
                             rowCounter = 0;
                           }
                           function updateVariantRowNumbers() {
                              const name = document.getElementById("name").value.trim();
                              const baseCode = document.getElementById("code").value.trim();
                              const rows = tbody.querySelectorAll("tr");
                            
                              let currentId = 0;
                              rows.forEach(row => {
                                const tds = row.querySelectorAll("td");
                            
                                // Skip section headers
                                if (tds.length < 10 || !row.querySelector("input[name='variants_name[]']")) return;
                            
                                currentId++;
                                const paddedId = String(currentId).padStart(3, '0');
                                tds[0].textContent = currentId;
                            
                                // Set name
                                const variantNameInput = row.querySelector("input[name='variants_name[]']");
                                if (variantNameInput) variantNameInput.value = `${name} -${currentId}`;
                            
                                const colorInput = row.querySelector("select[name='variants_color[]'], input[name='variants_color[]']");
                                const sizeInput = row.querySelector("select[name='variants_size[]'], input[name='variants_size[]']");
                            
                                const color = colorInput?.value?.trim() || '';
                                const size = sizeInput?.value?.trim() || '';
                            
                                let suffixParts = [];
                            
                                // Determine variant order (color_size or size_color)
                                const selectedType = document.querySelector('input[name="group_order"]:checked')?.value || '';
                            
                                if (selectedType === 'size_color') {
                                  if (size && size.toLowerCase() !== 'null') suffixParts.push(size.toLowerCase().replace(/\s+/g, ''));
                                  if (color && color.toLowerCase() !== 'null') suffixParts.push(color.toLowerCase().replace(/\s+/g, ''));
                                } else {
                                  if (color && color.toLowerCase() !== 'null') suffixParts.push(color.toLowerCase().replace(/\s+/g, ''));
                                  if (size && size.toLowerCase() !== 'null') suffixParts.push(size.toLowerCase().replace(/\s+/g, ''));
                                }
                            
                                const suffix = suffixParts.join("-");
                                const itemCodeInput = row.querySelector("input[name='variants_item_code[]']");
                                if (itemCodeInput) {
                                  itemCodeInput.value = suffix ? `${baseCode}-${paddedId}-${suffix}` : `${baseCode}-${paddedId}`;
                                }
                              });
                            
                              rowCounter = currentId;
                            }

                           function addmore() {
  const name = document.getElementById("name").value.trim();
  const code = document.getElementById("code").value.trim();
  const variantCost = document.getElementById("cost").value;
  const variantPrice = document.getElementById("price").value;
  const selectedType = document.querySelector('input[name="group_order"]:checked')?.value;
  const variantAlertQty = document.getElementById("alert_quantity").value;

  const existingRows = Array.from(tbody.querySelectorAll("tr")).filter(row =>
    row.querySelector("input[name='variants_name[]']")
  );

  // Collect existing selections
  const usedColors = new Set();
  const usedSizes = new Set();
  const usedCombos = new Set();

  existingRows.forEach(row => {
    const color = row.querySelector("select[name='variants_color[]']")?.value || row.querySelector("input[name='variants_color[]']")?.value || '';
    const size = row.querySelector("select[name='variants_size[]']")?.value || row.querySelector("input[name='variants_size[]']")?.value || '';

    if (selectedType === 'only_color') usedColors.add(color);
    if (selectedType === 'only_size') usedSizes.add(size);
    if (selectedType === 'color_size' || selectedType === 'size_color') {
      if (color && size) usedCombos.add(`${color}::${size}`);
    }
  });

  // Enforce limits
  if (selectedType === 'only_color' && usedColors.size >= colorArray.length) {
    alert("All colors already used.");
    return;
  }

  if (selectedType === 'only_size' && usedSizes.size >= sizeArray.length) {
    alert("All sizes already used.");
    return;
  }

  if ((selectedType === 'color_size' || selectedType === 'size_color') &&
      usedCombos.size >= (colorArray.length * sizeArray.length)) {
    alert("All color-size combinations used.");
    return;
  }

  // Build select options dynamically
  const colorOptions = colorArray
    .filter(c => !usedColors.has(c.color_name))
    .map(c => `<option value="${c.color_name}">${c.color_name}</option>`)
    .join("");

  const sizeOptions = sizeArray
    .filter(s => !usedSizes.has(s.name))
    .map(s => `<option value="${s.name}">${s.name}</option>`)
    .join("");

  let colorSelect = `<select name="variants_color[]" class="form-control" onchange="updateVariantCode(this)">
                       <option value="">Select Color</option>
                       ${colorOptions}
                     </select>`;

  let sizeSelect = `<select name="variants_size[]" class="form-control" onchange="updateVariantCode(this)">
                      <option value="">Select Size</option>
                      ${sizeOptions}
                    </select>`;

  if (selectedType === 'color_size' || selectedType === 'size_color') {
    // Allow full sets, but restrict combo
    colorSelect = `<select name="variants_color[]" class="form-control" onchange="checkCombo(this)">
                     <option value="">Select Color</option>
                     ${colorArray.map(c => `<option value="${c.color_name}">${c.color_name}</option>`).join("")}
                   </select>`;

    sizeSelect = `<select name="variants_size[]" class="form-control" onchange="checkCombo(this)">
                    <option value="">Select Size</option>
                    ${sizeArray.map(s => `<option value="${s.name}">${s.name}</option>`).join("")}
                  </select>`;
  }

  const id = ++rowCounter;
  
 let newId = id;
 if(existingRows.length !=0){
 const idData  = existingRows[existingRows.length-1].querySelector("input[name='variants_name[]").value;
 if(idData !=null){console.log(idData);
     const idString =idData.split("-") [idData.split("-").length - 1];
     newId = Number(idString) +1;
     
 }
 
 }
  
  console.log(id, newId);
  const paddedId = String(newId).padStart(3, '0');
  const variantName = `${name} -${newId}`;
  const variantCode = `${code}-${paddedId}`;

    const headingRow = `
      <tr>
        <td colspan="11" style="font-weight: bold; background-color: #f9f9f9;">Add New Variant</td>
      </tr>
    `;

  const row = `
    <tr>
      <td>${id}<input type="hidden" class="form-control" name="variants_id[]" value="null"></td>
      <td><input type="file" class="form-control" name="variants_image[]"></td>
      <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}" readonly></td>
      <td>${colorSelect}</td>
      <td>${sizeSelect}</td>
      <td><input type="text" class="form-control" name="variants_item_code[]" value="${variantCode}"></td>
      <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variantCost}" step="0.01"></td>
      <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variantPrice}" step="0.01"></td>
      <td><input type="number" class="form-control" name="variants_qty[]" step="1"></td>
      <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variantAlertQty}" ></td>
      <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
    </tr>
  `;

  tbody.insertAdjacentHTML("beforeend", headingRow);
  tbody.insertAdjacentHTML("beforeend", row);
}
function checkCombo(selectEl) {
  const row = selectEl.closest("tr");
  const color = row.querySelector("select[name='variants_color[]']")?.value ||row.querySelector("input[name='variants_color[]']")?.value || '';
  const size = row.querySelector("select[name='variants_size[]']")?.value  ||row.querySelector("input[name='variants_size[]']")?.value || '';
  const comboKey = `${color}::${size}`;
  console.log("Combo key", comboKey);

  const existingCombos =  [];
  
  Array.from(tbody.querySelectorAll("tr")).forEach(r => {
    const c = r.querySelector("input[name='variants_color[]']")?.value || '';
    const s = r.querySelector("input[name='variants_size[]']")?.value || '';
    if (c && s) {
      existingCombos.push(`${c}::${s}`);
    }
  });
  const comboCount = existingCombos.filter(key => key === comboKey).length
console.log("Combo length", comboCount);
console.log("Combo ", existingCombos);
  if (comboCount >0) {
    alert("This color-size combination already exists.");
    row.querySelector("select[name='variants_color[]']").value = '';
    row.querySelector("select[name='variants_size[]']").value = '';
  } else {
    updateVariantCode(selectEl);
  }
}

                           
                           
                           function updateVariantCode(selectElement) {
                                  const row = selectElement.closest("tr");
                                  const color = row.querySelector("select[name='variants_color[]']")?.value?.trim() || '';
                                  const size = row.querySelector("select[name='variants_size[]']")?.value?.trim() || '';
                                  const baseCode = document.getElementById("code").value.trim();
                                  const rowNumber = row.querySelector("td")?.textContent?.trim().padStart(3, '0') || '000';
                                
                                  // Get selected variant type to determine suffix order
                                  const selectedType = document.querySelector('input[name="group_order"]:checked')?.value || '';
                                
                                  let suffixParts = [];
                                
                                  if (selectedType === 'size_color') {
                                    if (size && size.toLowerCase() !== 'null') suffixParts.push(size.toLowerCase().replace(/\s+/g, ''));
                                    if (color && color.toLowerCase() !== 'null') suffixParts.push(color.toLowerCase().replace(/\s+/g, ''));
                                  } else {
                                    if (color && color.toLowerCase() !== 'null') suffixParts.push(color.toLowerCase().replace(/\s+/g, ''));
                                    if (size && size.toLowerCase() !== 'null') suffixParts.push(size.toLowerCase().replace(/\s+/g, ''));
                                  }
                                
                                  const suffix = suffixParts.join("-");
                                  const itemCode = suffix ? `${baseCode}-${rowNumber}-${suffix}` : `${baseCode}-${rowNumber}`;
                                
                                  row.querySelector("input[name='variants_item_code[]']").value = itemCode;
                                }

                           
                           document.getElementById("is_variant").addEventListener("change", function () {
                             const show = this.checked;
                             document.getElementById("variant-options").style.display = show ? "block" : "none";
                             document.getElementById("variant-table-wrapper").style.display = show ? "block" : "none";
                             if (!show) {
                               clearAllVariantRows();
                               document.querySelectorAll("input[name='group_order']").forEach(r => r.checked = false);
                             }
                           });
                           
                           window.addEventListener("DOMContentLoaded", function () {
                              const isVariantChecked = document.getElementById("is_variant").checked;
                              const groupOrder = "{{ $lims_product_data->group_order }}";
                            
                              if (isVariantChecked && groupOrder) {
                                document.getElementById("variant-options").style.display = "block";
                                document.getElementById("variant-table-wrapper").style.display = "block";
                            
                                // const radio = document.querySelector(`input[name="group_order"][value="${groupOrder}"]`);
                                // if (radio) {
                                //   radio.checked = true;
                                //   handleVariantTypeChange(groupOrder); 
                                // }
                                console.log(existingVariants);
                                populateExistingVariants(existingVariants); // ✅ This fills in the values
                              }
                            });

function populateExistingVariants(variants) {
  clearAllVariantRows(); 

  const groupOrder = "{{ $lims_product_data->group_order }}";
  const name = document.getElementById("name").value.trim();
  const baseCode = document.getElementById("code").value.trim();
  const variantCost = document.getElementById("cost").value;
  const variantPrice = document.getElementById("price").value;

  const groupHeadings = new Set();
  let grouped = {};

  variants.forEach(variant => {
    let key;
    switch (groupOrder) {
      case 'only_color':
        key = 'Only Colors';
        break;
      case 'only_size':
        key = 'Only Sizes';
        break;
      case 'color_size':
        key = variant.color || 'Unknown Color';
        break;
      case 'size_color':
        key = variant.size || 'Unknown Size';
        break;
      default:
        key = 'All';
    }

    if (!grouped[key]) grouped[key] = [];
    grouped[key].push(variant);
  });

  // Insert rows
  for (const [groupLabel, groupVariants] of Object.entries(grouped)) {
    if (!groupHeadings.has(groupLabel)) {
      tbody.insertAdjacentHTML("beforeend", `<tr><td colspan="11"><strong>${groupLabel}</strong></td></tr>`);
      groupHeadings.add(groupLabel);
    }

    groupVariants.forEach(variant => {
      const id = ++rowCounter;
      const paddedId = String(id).padStart(3, '0');
      const variantName = variant.name || `${name} -${id}`;

      const colorSlug = (variant.color || '').toLowerCase().replace(/\s+/g, '');
      const sizeSlug = (variant.size || '').toLowerCase().replace(/\s+/g, '');
      let variantCode = `${baseCode}-${paddedId}`;

      if (groupOrder === "only_color" && colorSlug)
        variantCode += `-${colorSlug}`;
      if (groupOrder === "only_size" && sizeSlug)
        variantCode += `-${sizeSlug}`;
      if (groupOrder === "color_size" && colorSlug && sizeSlug)
        variantCode += `-${colorSlug}-${sizeSlug}`;
      if (groupOrder === "size_color" && sizeSlug && colorSlug)
        variantCode += `-${sizeSlug}-${colorSlug}`;

      const row = `
        <tr data-variant-id="${variant.id}">
          <td>${id}<input type="hidden" class="form-control" name="variants_id[]" value="${variant.id}"></td>
          <td><input type="file" class="form-control" name="variants_image[]"></td>
          <td><input type="text" class="form-control" name="variants_name[]" value="${variantName}"></td>
          <td>
            ${variant.color
              ? `<input type="hidden" name="variants_color[]" value="${variant.color}">${variant.color}`
              : `<input type="hidden" name="variants_color[]" value="null">-`}
          </td>
          <td>
            ${variant.size
              ? `<input type="hidden" name="variants_size[]" value="${variant.size}">${variant.size}`
              : `<input type="hidden" name="variants_size[]" value="null">-`}
          </td>
          <td><input type="text" class="form-control" name="variants_item_code[]" value="${variant.code || variantCode}"></td>
          <td><input type="number" class="form-control" name="variant_purchase_price[]" value="${variant.cost || variantCost}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_sale_price[]" value="${variant.price || variantPrice}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_qty[]" value="${variant.qty || ''}" step="0.01"></td>
          <td><input type="number" class="form-control" name="variants_alert_qty[]" value="${variant.alert_quantity || 0}" ></td>
          <td><button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">×</button></td>
        </tr>
      `;
      tbody.insertAdjacentHTML("beforeend", row);
    });
  }
}





                           
                        </script>
                        <div class="col-md-6">
                           <div class="form-group">
                              <label>{{trans('file.Product Image')}}</strong> </label> <i class="dripicons-question" data-toggle="tooltip" title="{{trans('file.You can upload multiple image. Only .jpeg, .jpg, .png, .gif file can be uploaded. First image will be base image.')}}"></i>
                              <div id="imageUpload" class="dropzone"></div>
                              <span class="validation-msg" id="image-error"></span>
                           </div>
                        </div>
                        <div class="col-md-6">
                           <div class="form-group">
                              <table class="table table-hover">
                                 <thead>
                                    <tr>
                                       <th><button type="button" class="btn btn-sm"><i class="fa fa-list"></i></button></th>
                                       <th>Image</th>
                                       <th>Remove</th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    <?php $images = explode(",", $lims_product_data->image)?>
                                    @foreach($images as $key => $image)
                                    <tr>
                                       <td><button type="button" class="btn btn-sm"><i class="fa fa-list"></i></button></i></td>
                                       <td>
                                          <img src="{{url('public/images/product', $image)}}" height="60" width="60">
                                          <input type="hidden" name="prev_img[]" value="{{$image}}">
                                       </td>
                                       <td><button type="button" class="btn btn-sm btn-danger remove-img">X</button></td>
                                    </tr>
                                    @endforeach
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-md-12">
                           <div class="form-group">
                              <label>{{trans('file.Product Details')}}</label>
                              <textarea name="product_details" class="form-control" rows="5">{{str_replace('@', '"', $lims_product_data->product_details)}}</textarea>
                           </div>
                        </div>
                        <div class="col-md-12 mt-2" id="diffPrice-option">
                           @if($lims_product_data->is_diffPrice)
                           <h5><input name="is_diffPrice" type="checkbox" id="is-diffPrice" value="1" checked>&nbsp; {{trans('file.This product has different price for different warehouse')}}</h5>
                           @else
                           <h5><input name="is_diffPrice" type="checkbox" id="is-diffPrice" value="1">&nbsp; {{trans('file.This product has different price for different warehouse')}}</h5>
                           @endif
                        </div>
                        <div class="col-md-6" id="diffPrice-section">
                           <div class="table-responsive ml-2">
                              <table id="diffPrice-table" class="table table-hover">
                                 <thead>
                                    <tr>
                                       <th>{{trans('file.Warehouse')}}</th>
                                       <th>{{trans('file.Price')}}</th>
                                    </tr>
                                    @foreach($lims_warehouse_list as $warehouse)
                                    <tr>
                                       <td>
                                          <input type="hidden" name="warehouse_id[]" value="{{$warehouse->id}}">
                                          {{$warehouse->name}}
                                       </td>
                                       <td>
                                          <?php
                                             $product_warehouse = \App\Product_Warehouse::FindProductWithoutVariant($lims_product_data->id, $warehouse->id)->first();
                                             ?>
                                          @if($product_warehouse)
                                          <input type="number" name="diff_price[]" class="form-control" value="{{$product_warehouse->price}}">
                                          @else
                                          <input type="number" name="diff_price[]" class="form-control">
                                          @endif
                                       </td>
                                    </tr>
                                    @endforeach
                                 </thead>
                                 <tbody>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-md-12 mt-3" id="batch-option">
                           @if($lims_product_data->is_batch)
                           <h5><input name="is_batch" type="checkbox" id="is-batch" value="1" checked>&nbsp; {{trans('file.This product has batch and expired date')}}</h5>
                           @else
                           <h5><input name="is_batch" type="checkbox" id="is-batch" value="1">&nbsp; {{trans('file.This product has batch and expired date')}}</h5>
                           @endif
                        </div>
                        <!--<div class="col-md-12 mt-3" id="imei-option">-->
                        <!--    @if($lims_product_data->is_imei)-->
                        <!--<h5><input name="is_imei" type="checkbox" id="is-imei" value="1" checked>&nbsp; {{trans('file.This product has IMEI or Serial numbers')}}</h5>-->
                        <!--    @endif-->
                        <!--</div>-->
                        <div class="col-md-12 mt-3" id="imei-option">
                           <h5><input name="is_imei" type="checkbox" id="is-imei" value="1" 
                              {{$lims_product_data->is_imei == true ? 'checked' : ''}}>&nbsp; {{trans('Sale Product as Single and bulk')}}
                           </h5>
                        </div>
                        <div class="col-md-12 mt-3" id="price-section" style="display: none;">
                           <div class="form-group">
                              <label>Provide <span id="unit-name-placeholder">--</span> price</label>
                              <input type="text" name="single_product_price" class="form-control" id="single_product_price" 
                                 placeholder="Enter Price" value="{{$lims_product_data->single_product_price}}" 
                                 aria-describedby="single_product_price">
                              <span class="validation-msg" id="name-error"></span>
                           </div>
                        </div>
                        <!--<div class="col-md-12 mt-3" id="variant-option">-->
                        <!--    @if($lims_product_data->is_variant)-->
                        <!--    <h5><input name="is_variant" type="checkbox" id="is-variant" value="1" checked>&nbsp; {{trans('file.This product has variant')}}</h5>-->
                        <!--    @else-->
                        <!--    <h5><input name="is_variant" type="checkbox" id="is-variant" value="1">&nbsp; {{trans('file.This product has variant')}}</h5>-->
                        <!--    @endif-->
                        <!--</div>-->
                        <div class="col-md-12" id="variant-section">
                           <div class="col-md-6 form-group mt-2">
                              <input type="text" name="variant" class="form-control" placeholder="{{trans('file.Enter variant seperated by comma')}}">
                           </div>
                           <div class="table-responsive ml-2">
                              <table id="variant-table" class="table table-hover variant-list">
                                 <thead>
                                    <tr>
                                       <th><i class="dripicons-view-apps"></i></th>
                                       <th>{{trans('file.name')}}</th>
                                       <th>{{trans('file.Item Code')}}</th>
                                       <th>{{trans('file.Additional Price')}}</th>
                                       <th><i class="dripicons-trash"></i></th>
                                    </tr>
                                 </thead>
                                 <tbody>
                                    @foreach($lims_product_variant_data as $key=> $variant)
                                    <tr>
                                       <td style="cursor:grab">
                                          <i class="dripicons-view-apps"></i>
                                          <input type="hidden" name="product_variant_id[]" value="{{$variant->pivot['id']}}">
                                          <input type="hidden" name="variant_id[]" value="{{$variant->pivot['variant_id']}}">
                                       </td>
                                       <td><input type="text" class="form-control" name="variant_name[]" value="{{$variant->name}}" /></td>
                                       <td><input type="text" class="form-control" name="item_code[]" value="{{$variant->pivot['item_code']}}" /></td>
                                       <td><input type="number" class="form-control" name="additional_price[]" value="{{$variant->pivot['additional_price']}}" step="any" /></td>
                                       <td><button type="button" class="vbtnDel btn btn-sm btn-danger">X</button></td>
                                    </tr>
                                    @endforeach
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-md-4 mt-3">
                           <input type="hidden" name="promotion_hidden" value="{{$lims_product_data->promotion}}">
                           <input name="promotion" type="checkbox" id="promotion" value="1">&nbsp;
                           <label>
                              <h5>{{trans('file.Add Promotional Price')}}</h5>
                           </label>
                        </div>
                        <div class="col-md-12">
                           <div class="row">
                              <div class="col-md-4" id="promotion_price">   <label>{{trans('file.Promotional Price')}}</label>
                                 <input type="number" name="promotion_price" value="{{$lims_product_data->promotion_price}}" class="form-control" step="any" />
                              </div>
                              <div id="start_date" class="col-md-4">
                                 <div class="form-group">
                                    <label>{{trans('file.Promotion Starts')}}</label>
                                    <input type="text" name="starting_date" value="{{$lims_product_data->starting_date}}" id="starting_date" class="form-control" />
                                 </div>
                              </div>
                              <div id="last_date" class="col-md-4">
                                 <div class="form-group">
                                    <label>{{trans('file.Promotion Ends')}}</label>
                                    <input type="text" name="last_date" value="{{$lims_product_data->last_date}}" id="ending_date" class="form-control" />
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-12">
                           <div class="form-group">
                              <input type="button" value="{{trans('file.submit')}}" class="btn btn-primary" id="submit-btn">
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
@endsection
@push('scripts')
<script type="text/javascript">
   $("ul#product").siblings('a').attr('aria-expanded','true');
   $("ul#product").addClass("show");
   var product_id = <?php echo json_encode($lims_product_data->id) ?>;
   var is_batch = <?php echo json_encode($lims_product_data->is_batch) ?>;
   var is_variant = <?php echo json_encode($lims_product_data->is_variant) ?>;
   $('[data-toggle="tooltip"]').tooltip();
   
   $(".remove-img").on("click", function () {
       $(this).closest("tr").remove();
   });
   
   $("#digital").hide();
   $("#combo").hide();
   $("select[name='type']").val($("input[name='type_hidden']").val());
   variantShowHide();
   diffPriceShowHide();
   if(is_batch)
       $("#variant-option").hide();
   if(is_variant) {
       $("#batch-option").hide();
   }
   
   
   if($("input[name='type_hidden']").val() == "digital"){
       $("input[name='cost']").prop('required',false);
       $("select[name='unit_id']").prop('required',false);
       hide();
       $("#digital").show();
   }
   else if($("input[name='type_hidden']").val() == "service"){
       $("input[name='cost']").prop('required',false);
       $("select[name='unit_id']").prop('required',false);
       hide();
       $("#variant-section, #variant-option").hide();
   }
   else if($("input[name='type_hidden']").val() == "combo"){
       $("input[name='cost']").prop('required', false);
       $("input[name='price']").prop('disabled', true);
       $("select[name='unit_id']").prop('required', false);
       hide();
       $("#combo").show();
   }
   
   var promotion = $("input[name='promotion_hidden']").val();
   if(promotion){
       $("input[name='promotion']").prop('checked', true);
       $("#promotion_price").show(300);
       $("#start_date").show(300);
       $("#last_date").show(300);
   }
   else {
       $("#promotion_price").hide(300);
       $("#start_date").hide(300);
       $("#last_date").hide(300);
   }
   
   $.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
   });
   
   $('#genbutton').on("click", function(){
     $.get('../gencode', function(data){
       $("input[name='code']").val(data);
     });
   });
   
   $('.selectpicker').selectpicker({
     style: 'btn-link',
   });
   
   tinymce.init({
     selector: 'textarea',
     height: 130,
     plugins: [
       'advlist autolink lists link image charmap print preview anchor textcolor',
       'searchreplace visualblocks code fullscreen',
       'insertdatetime media table contextmenu paste code wordcount'
     ],
     toolbar: 'insert | undo redo |  formatselect | bold italic backcolor  | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat',
     branding:false
   });
   
   var barcode_symbology = $("input[name='barcode_symbology_hidden']").val();
   $('select[name=barcode_symbology]').val(barcode_symbology);
   
   var brand = $("input[name='brand']").val();
   $('select[name=brand_id]').val(brand);
   
   var cat = $("input[name='category']").val();
   $('select[name=category_id]').val(cat);
   
   if($("input[name='unit']").val()) {
       $('select[name=unit_id]').val($("input[name='unit']").val());
       populate_unit($("input[name='unit']").val());
   }
   
   var tax = $("input[name='tax']").val();
   if(tax)
       $('select[name=tax_id]').val(tax);
   
   var tax_method = $("input[name='tax_method_id']").val();
   $('select[name=tax_method]').val(tax_method);
   $('.selectpicker').selectpicker('refresh');
   
   $('select[name="type"]').on('change', function() {
       if($(this).val() == 'combo'){
           $("input[name='cost']").prop('required',false);
           $("select[name='unit_id']").prop('required',false);
           hide();
           $("#digital").hide();
           $("#variant-section, #variant-option, #diffPrice-option, #diffPrice-section").hide(300);
           $("#combo").show();
           $("input[name='price']").prop('disabled',true);
       }
       else if($(this).val() == 'digital'){
           $("input[name='cost']").prop('required',false);
           $("select[name='unit_id']").prop('required',false);
           $("input[name='file']").prop('required',true);
           hide();
           $("#combo").hide();
           $("#digital").show();
           $("#variant-section, #variant-option, #diffPrice-option, #diffPrice-section").hide(300);
           $("input[name='price']").prop('disabled',false);
       }
       else if($(this).val() == 'service') {
           $("input[name='cost']").prop('required',false);
           $("select[name='unit_id']").prop('required',false);
           $("input[name='file']").prop('required',true);
           hide();
           $("#combo").hide(300);
           $("#digital").hide(300);
           $("input[name='price']").prop('disabled',false);
           $("#is-variant").prop("checked", false);
           $("#variant-section, #variant-option").hide(300);
       }
       else if($(this).val() == 'standard'){
           $("input[name='cost']").prop('required',true);
           $("select[name='unit_id']").prop('required',true);
           $("input[name='file']").prop('required',false);
           $("#cost").show();
           $("#unit").show();
           $("#alert-qty").show();
           $("#variant-option").show(300);
           $("#diffPrice-option").show(300);
           $("#digital").hide();
           $("#combo").hide();
           $("input[name='price']").prop('disabled',false);
       }
   });
   
   $('select[name="unit_id"]').on('change', function() {
       unitID = $(this).val();
       if(unitID) {
           populate_unit_second(unitID);
       }else{
           $('select[name="sale_unit_id"]').empty();
           $('select[name="purchase_unit_id"]').empty();
       }
   });
   
   <?php $productArray = []; ?>
   var lims_product_code = [
       @foreach($lims_product_list_without_variant as $product)
       <?php
      $productArray[] = htmlspecialchars($product->code . ' (' . $product->name . ')');
      ?>
       @endforeach
       @foreach($lims_product_list_with_variant as $product)
           <?php
      $productArray[] = htmlspecialchars($product->item_code . ' (' . $product->name . ')');
      ?>
       @endforeach
           <?php
      echo  '"'.implode('","', $productArray).'"';
      ?> ];
   
   var lims_productcodeSearch = $('#lims_productcodeSearch');
   
   lims_productcodeSearch.autocomplete({
       source: function(request, response) {
           var matcher = new RegExp(".?" + $.ui.autocomplete.escapeRegex(request.term), "i");
           response($.grep(lims_product_code, function(item) {
               return matcher.test(item);
           }));
       },
       select: function(event, ui) {
           var data = ui.item.value;
           $.ajax({
               type: 'GET',
               url: '../lims_product_search',
               data: {
                   data: data
               },
               success: function(data) {
                   //console.log(data);
                   var flag = 1;
                   $(".product-id").each(function() {
                       if ($(this).val() == data[8]) {
                           alert('Duplicate input is not allowed!')
                           flag = 0;
                       }
                   });
                   $("input[name='product_code_name']").val('');
                   if(flag){
                       var newRow = $("<tr>");
                       var cols = '';
                       cols += '<td>' + data[0] +' [' + data[1] + ']</td>';
                       cols += '<td><input type="number" class="form-control qty" name="product_qty[]" value="1" step="any"/></td>';
                       cols += '<td><input type="number" class="form-control unit_price" name="unit_price[]" value="' + data[2] + '" step="any"/></td>';
                       cols += '<td><button type="button" class="ibtnDel btn btn-sm btn-danger">X</button></td>';
                       cols += '<input type="hidden" class="product-id" name="product_id[]" value="' + data[8] + '"/>';
                       cols += '<input type="hidden" class="" name="variant_id[]" value="' + data[9] + '"/>';
   
                       newRow.append(cols);
                       $("table.order-list tbody").append(newRow);
                       calculate_price();
                   }
               }
           });
       }
   });
   
   //Change quantity or unit price
   $("#myTable").on('input', '.qty , .unit_price', function() {
       calculate_price();
   });
   
   //Delete product
   $("table.order-list tbody").on("click", ".ibtnDel", function(event) {
       $(this).closest("tr").remove();
       calculate_price();
   });
   
   function calculate_price() {
       var price = 0;
       $(".qty").each(function() {
           rowindex = $(this).closest('tr').index();
           quantity =  $(this).val();
           unit_price = $('table.order-list tbody tr:nth-child(' + (rowindex + 1) + ') .unit_price').val();
           price += quantity * unit_price;
       });
       $('input[name="price"]').val(price);
   }
   
   function hide() {
       $("#cost").hide();
       $("#unit").hide();
       $("#alert-qty").hide();
   }
   
   function populate_unit(unitID){
       $.ajax({
           url: '../saleunit/'+unitID,
           type: "GET",
           dataType: "json",
   
           success:function(data) {
                 $('select[name="sale_unit_id"]').empty();
                 $('select[name="purchase_unit_id"]').empty();
                 $.each(data, function(key, value) {
                     $('select[name="sale_unit_id"]').append('<option value="'+ key +'">'+ value +'</option>');
                     $('select[name="purchase_unit_id"]').append('<option value="'+ key +'">'+ value +'</option>');
                 });
                 $('.selectpicker').selectpicker('refresh');
                 var sale_unit = $("input[name='sale_unit']").val();
                 var purchase_unit = $("input[name='purchase_unit']").val();
               $('#sale-unit').val(sale_unit);
               $('select[name=purchase_unit_id]').val(purchase_unit);
               $('.selectpicker').selectpicker('refresh');
           },
       });
   }
   
   function populate_unit_second(unitID){
       $.ajax({
           url: '../saleunit/'+unitID,
           type: "GET",
           dataType: "json",
           success:function(data) {
                 $('select[name="sale_unit_id"]').empty();
                 $('select[name="purchase_unit_id"]').empty();
                 $.each(data, function(key, value) {
                     $('select[name="sale_unit_id"]').append('<option value="'+ key +'">'+ value +'</option>');
                     $('select[name="purchase_unit_id"]').append('<option value="'+ key +'">'+ value +'</option>');
                 });
                 $('.selectpicker').selectpicker('refresh');
           },
       });
   };
   
   $("input[name='is_batch']").on("change", function () {
       if ($(this).is(':checked')) {
           $("#variant-option").hide(300);
       }
       else
           $("#variant-option").show(300);
   });
   
   $("input[name='is_variant']").on("change", function () {
       variantShowHide();
   });
   
   $("input[name='is_diffPrice']").on("change", function () {
       diffPriceShowHide();
   });
   
   $("input[name='variant']").on("input", function () {
       if($("#code").val() == ''){
           $("input[name='variant']").val('');
           alert('Please fillup above information first.');
       }
       else if($(this).val().indexOf(',') > -1) {
           var variant_name = $(this).val().slice(0, -1);
           var item_code = variant_name+'-'+$("#code").val();
           var newRow = $("<tr>");
           var cols = '';
           cols += '<td style="cursor:grab"><i class="dripicons-view-apps"></i><input type="hidden" name="product_variant_id[]" value="0"></td>';
           cols += '<td><input type="text" class="form-control" name="variant_name[]" value="' + variant_name + '" /></td>';
           cols += '<td><input type="text" class="form-control" name="item_code[]" value="'+item_code+'" /></td>';
           cols += '<td><input type="number" class="form-control" name="additional_price[]" value="" step="any" /></td>';
           cols += '<td><button type="button" class="vbtnDel btn btn-sm btn-danger">X</button></td>';
   
           $("input[name='variant']").val('');
           newRow.append(cols);
           $("table.variant-list tbody").append(newRow);
       }
   });
   
   //Delete variant
   $("table#variant-table tbody").on("click", ".vbtnDel", function(event) {
       $(this).closest("tr").remove();
   });
   
   function variantShowHide() {
        if ($("#is-variant").is(':checked')) {
           $("#variant-section").show(300);
           $("#batch-option").hide(300);
       }
       else {
           $("#variant-section").hide(300);
           $("#batch-option").show(300);
       }
   };
   
   function diffPriceShowHide() {
        if ($("#is-diffPrice").is(':checked')) {
           $("#diffPrice-section").show(300);
       }
       else {
           $("#diffPrice-section").hide(300);
       }
   };
   
   $( "#promotion" ).on( "change", function() {
       if ($(this).is(':checked')) {
           $("#promotion_price").show();
           $("#start_date").show();
           $("#last_date").show();
       }
       else {
           $("#promotion_price").hide();
           $("#start_date").hide();
           $("#last_date").hide();
       }
   });
   
   var starting_date = $('#starting_date');
   starting_date.datepicker({
    format: "dd-mm-yyyy",
    startDate: "<?php echo date('d-m-Y'); ?>",
    autoclose: true,
    todayHighlight: true
    });
   
   var ending_date = $('#ending_date');
   ending_date.datepicker({
    format: "dd-mm-yyyy",
    startDate: "<?php echo date('d-m-Y'); ?>",
    autoclose: true,
    todayHighlight: true
    });
   
   //dropzone portion
   Dropzone.autoDiscover = false;
   
   jQuery.validator.setDefaults({
       errorPlacement: function (error, element) {
           if(error.html() == 'Select Category...')
               error.html('This field is required.');
           $(element).closest('div.form-group').find('.validation-msg').html(error.html());
       },
       highlight: function (element) {
           $(element).closest('div.form-group').removeClass('has-success').addClass('has-error');
       },
       unhighlight: function (element, errorClass, validClass) {
           $(element).closest('div.form-group').removeClass('has-error').addClass('has-success');
           $(element).closest('div.form-group').find('.validation-msg').html('');
       }
   });
   
   function validate() {
       var product_code = $("input[name='code']").val();
       var barcode_symbology = $('select[name="barcode_symbology"]').val();
       var exp = /^\d+$/;
   
       if(!(product_code.match(exp)) && (barcode_symbology == 'UPCA' || barcode_symbology == 'UPCE' || barcode_symbology == 'EAN8' || barcode_symbology == 'EAN13') ) {
           alert('Product code must be numeric.');
           return false;
       }
       else if(product_code.match(exp)) {
           if(barcode_symbology == 'UPCA' && product_code.length > 11){
               alert('Product code length must be less than 12');
               return false;
           }
           else if(barcode_symbology == 'EAN8' && product_code.length > 7){
               alert('Product code length must be less than 8');
               return false;
           }
           else if(barcode_symbology == 'EAN13' && product_code.length > 12){
               alert('Product code length must be less than 13');
               return false;
           }
       }
   
       if( $("#type").val() == 'combo' ) {
           var rownumber = $('table.order-list tbody tr:last').index();
           if (rownumber < 0) {
               alert("Please insert product to table!")
               return false;
           }
       }
       $("input[name='price']").prop('disabled',false);
       return true;
   }
   
   $("table#variant-table tbody").sortable({
       items: 'tr',
       cursor: 'grab',
       opacity: 0.5,
   });
   
   $(".dropzone").sortable({
       items:'.dz-preview',
       cursor: 'grab',
       opacity: 0.5,
       containment: '.dropzone',
       distance: 20,
       tolerance: 'pointer',
       stop: function () {
         var queue = myDropzone.getAcceptedFiles();
         newQueue = [];
         $('#imageUpload .dz-preview .dz-filename [data-dz-name]').each(function (count, el) {
               var name = el.innerHTML;
               queue.forEach(function(file) {
                   if (file.name === name) {
                       newQueue.push(file);
                   }
               });
         });
         myDropzone.files = newQueue;
       }
   });


  myDropzone = new Dropzone('div#imageUpload', {
      addRemoveLinks: true,
      autoProcessQueue: false,
      uploadMultiple: true,
      parallelUploads: 100,
      maxFilesize: 12,
      paramName: 'image',
      clickable: true,
      method: 'POST',
      url:'../update',
      headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
      renameFile: function(file) {
          var dt = new Date();
          var time = dt.getTime();
          return time + file.name;
      },
      acceptedFiles: ".jpeg,.jpg,.png,.gif",
      init: function () {
          var myDropzone = this;
          $('#submit-btn').on("click", function (e) {
              e.preventDefault();
              if ( $("#product-form").valid() && validate() ) {
                  tinyMCE.triggerSave();
                  
                    const formElement = document.getElementById("product-form");
                    const formData = new FormData(formElement);

                    $('input[name="variants_image[]"]').each(function () {
                        if (this.files[0]) {
                            formData.append('variants_image[]', this.files[0]);
                        }
                    });

                  if(myDropzone.getAcceptedFiles().length) {
                      myDropzone.processQueue();
                  }
                  else {
                      $.ajax({
                          type:'POST',
                          url:'../update',
                          data: $("#product-form").serialize(),
                          success:function(response){
                                 let successAlert = document.createElement("div");
                                  successAlert.className = "alert alert-success";
                                  successAlert.textContent = "Product updated successfully!";
                                   
                                  // Styling
                                  successAlert.style.position = "fixed";
                                  successAlert.style.top = "20px";
                                  successAlert.style.right = "20px";
                                  successAlert.style.padding = "15px 25px";
                                  successAlert.style.backgroundColor = "#d4edda";
                                  successAlert.style.color = "#155724";
                                  successAlert.style.border = "1px solid #c3e6cb";
                                  successAlert.style.borderRadius = "5px";
                                  successAlert.style.boxShadow = "0 2px 6px rgba(0,0,0,0.2)";
                                  successAlert.style.zIndex = "1051";
                                   
                                  document.body.appendChild(successAlert);
                                  setTimeout(() => {
                                      successAlert.remove();
                                  }, 3000);
                          },
                          error:function(response) {
                             if(response.responseJSON.errors.name) {
                                 $("#name-error").text(response.responseJSON.errors.name);
                             }
                             else if(response.responseJSON.errors.code) {
                                 $("#code-error").text(response.responseJSON.errors.code);
                             }
                          },
                      });
                  }
              }
          });
   
          this.on('sending', function (file, xhr, formData) {
              var data = $("#product-form").serializeArray();
              $.each(data, function (key, el) {
                  formData.append(el.name, el.value);
              });
          });
      },
      error: function (file, response) {
          console.log(response);

      },
      successmultiple: function (file, response) {
    //  location.href = '../';
      },
      completemultiple: function (file, response) {
          console.log(file, response, "completemultiple");
      },
      reset: function () {
          console.log("resetFiles");
          this.removeAllFiles(true);
      }
  });
   
</script>
<script>
   document.addEventListener("DOMContentLoaded", function () {
       const checkbox = document.getElementById("is-imei");
       const priceSection = document.getElementById("price-section");
       const productUnit = document.getElementById("unit_id");
       const saleUnit = document.getElementById("sale-unit");
       const unitNamePlaceholder = document.getElementById("unit-name-placeholder");
   
       function checkAndTogglePriceSection() {
           const productText = productUnit.options[productUnit.selectedIndex]?.text.trim();
           const saleText = saleUnit.options[saleUnit.selectedIndex]?.text.trim();
   
       
           const saleUnitOptions = Array.from(saleUnit.options)
               .map(opt => opt.text.trim())
               .filter(opt => opt !== "");
   
           if (checkbox.checked) {
               // Check if there are at least two sale units
               if (saleUnitOptions.length < 2) {
                   alert("Please add at least two Sale Units first.");
                   checkbox.checked = false;
                   unitNamePlaceholder.textContent = "--";
                   priceSection.style.display = "none";
                   return; // Stop further checks
               }
   
         
               if (productText === saleText && productText !== "") {
                   const otherUnit = saleUnitOptions.find(unit => unit !== productText);
                   unitNamePlaceholder.textContent = otherUnit || "--";
                   priceSection.style.display = "block";
               } else {
                   alert("Product Unit and Sale Unit must be the same to enter the price.");
                   checkbox.checked = false;
                   unitNamePlaceholder.textContent = "--";
                   priceSection.style.display = "none";
               }
           } else {
               priceSection.style.display = "none";
               unitNamePlaceholder.textContent = "--";
           }
       }
   
       // Call when the checkbox changes
       checkbox.addEventListener("change", checkAndTogglePriceSection);
   
       // Call when either unit selection changes
       productUnit.addEventListener("change", checkAndTogglePriceSection);
       saleUnit.addEventListener("change", checkAndTogglePriceSection);
   
       // Run on initial page load to set the initial state
       checkAndTogglePriceSection();
   });
</script>
@endpush