@extends('layout.main')

@section('content')
<section class="forms">
    <div class="container-fluid">

        {{-- Success Message --}}
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Error Messages --}}
        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        {{-- Page Header --}}
        <div class="row mb-3">
            <div class="col-md-6">
                <h4>Color List</h4>
            </div>
            <div class="col-md-6 text-right">
                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addSizeModal">
                    + Add New Size
                </button>
            </div>
        </div>

        {{-- Color Table --}}
        <div class="card h-100">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Size Name</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($sizes as $index => $size)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $size->name }}</td>
                                <td>
                                    <form action="{{ route('size.update', $size->id) }}" method="POST" id="toggle-form-{{ $size->id }}">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="name" value="{{ $size->name }}">
                                        <input type="hidden" name="is_active" value="{{ $size->is_active ? 0 : 1 }}">
                                        <input type="checkbox"
                                               onchange="document.getElementById('toggle-form-{{ $size->id }}').submit()"
                                               {{ $size->is_active ? 'checked' : '' }}>
                                    </form>
                                </td>
                                <td>{{ $size->created_at->format('Y-m-d') }}</td>
                                <td>
                                    <form action="{{ route('size.destroy', $size->id) }}" method="POST" onsubmit="return confirm('Are you sure to delete this size?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                {{ $sizes->links() }}
            </div>
        </div>
    </div>
</section>

<!-- Add Color Modal -->
<div class="modal fade" id="addSizeModal" tabindex="-1" role="dialog" aria-labelledby="addSizeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="{{ route('size.store') }}" method="POST">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addSizeModalLabel">Size</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="name"><strong>Name</strong></label>
            <input type="text" name="name" id="name" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Status</strong></label>
            <select name="is_active" id="is_active" class="form-control" required>
              <option value="1">Active</option>
              <option value="0">Inactive</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Add Size</button>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
