@extends('layout.main') 
@section('content')

<div class=" mt-4">
    

@if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
 @if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif
    <div class="row justify-content-center">
        <div class="col-lg-4 col-md-6 col-sm-6 ">
            <div class="card shadow-sm ">
                <div class="card-body ">
                    <h5 class="mb-3">Send WhatsApp Message</h5>
                   <form method="POST" action="" enctype="multipart/form-data">
                        @csrf
                    
                        <textarea class="form-control mb-3" name="message" placeholder="Type your message" rows="3"></textarea>
                    
                        <div class="mb-3">
                            <label><strong>Select Customer Groups:</strong></label><br>
                            @foreach($customergroups as $customergroup)
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="group_ids[]" value="{{ $customergroup->id }}" id="group_{{ $customergroup->id }}">
                                    <label class="form-check-label" for="group_{{ $customergroup->id }}">{{ $customergroup->name }}</label>
                                </div>
                            @endforeach
                        </div>
                    
                        <input type="file" accept="image/png, image/jpeg" class="form-control mb-3" name="image">
                        <input type="hidden" name="ids[]" id="selectedCustomers">
                        <button type="submit" class="btn btn-primary w-100">Submit</button>
                    </form>

                </div>
            </div>
        </div>
        <div class="col-lg-8 col-md-6 col-sm-6">

            <div class="card shadow-sm">
                  <div class="card-body pb-0">
                        <div class="mb-3 d-flex gap-3 align-items-center">
                            <input type="tel" id="customerSearch" name="mobile" class="form-control" placeholder="Enter mobile number or name">
                        </div>
                </div>
                 <div class="card-body pt-0">
                    <h5 class="mb-3">Customer Information</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover text-center">
                            <thead class="table-primary">
                                <tr>
                                    <th><input type="checkbox" id="selectAll"></th>
                                    <th>Name</th>
                                    <th>Mobile</th>
                                    <th>Address</th>
                                    <th>City</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customers as $customer)
                                    <tr>
                                        <td><input type="checkbox" name="customer_ids[]" value="{{$customer->id}}" data-group-id="{{$customer->customer_group_id}}" class="customer-checkbox"></td>
                                        <td>{{$customer->name}}</td>
                                        <td>{{$customer->phone_number}}</td>
                                        <td>{{$customer->address}}</td>
                                        <td>{{$customer->city}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById("selectAll").addEventListener("change", function() {
        let checkboxes = document.querySelectorAll(".customer-checkbox");
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
        updateSelectedCustomers();
    });

    document.querySelectorAll(".customer-checkbox").forEach(checkbox => {
        checkbox.addEventListener("change", updateSelectedCustomers);
    });

    function updateSelectedCustomers() {
        let selected = [];
        document.querySelectorAll(".customer-checkbox:checked").forEach(checkbox => {
            selected.push(checkbox.value);
        });
        document.getElementById("selectedCustomers").value = selected.join(",");
    }
    
    document.getElementById("customerSearch").addEventListener("input", function () {
    let searchValue = this.value.toLowerCase();
    let rows = document.querySelectorAll("tbody tr");

    rows.forEach(row => {
        let name = row.cells[1].textContent.toLowerCase();
        let phone = row.cells[2].textContent.toLowerCase();

        if (name.includes(searchValue) || phone.includes(searchValue)) {
            row.style.display = "";
        } else {
            row.style.display = "none";
        }
    });
});

</script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    // 🔹 Group checkbox change
    document.querySelectorAll('input[name="group_ids[]"]').forEach(groupCheckbox => {
        groupCheckbox.addEventListener('change', function () {

            let groupId = this.value;
            let isChecked = this.checked;

            document.querySelectorAll('.customer-checkbox').forEach(customerCheckbox => {
                if (customerCheckbox.dataset.groupId === groupId) {
                    customerCheckbox.checked = isChecked;
                }
            });

            updateSelectedCustomers();
        });
    });

    // 🔹 Individual customer checkbox change
    document.querySelectorAll('.customer-checkbox').forEach(cb => {
        cb.addEventListener('change', updateSelectedCustomers);
    });

    // 🔹 Select All checkbox
    document.getElementById('selectAll').addEventListener('change', function () {
        document.querySelectorAll('.customer-checkbox').forEach(cb => {
            cb.checked = this.checked;
        });

        document.querySelectorAll('input[name="group_ids[]"]').forEach(gcb => {
            gcb.checked = this.checked;
        });

        updateSelectedCustomers();
    });

    // 🔹 Update hidden input with selected customer IDs
    function updateSelectedCustomers() {
        let selected = [];

        document.querySelectorAll('.customer-checkbox:checked').forEach(cb => {
            selected.push(cb.value);
        });

        document.getElementById('selectedCustomers').value = selected.join(',');
    }

});
</script>


@endsection
