 <?php $__env->startSection('content'); ?>
<?php if(session()->has('not_permitted')): ?>
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
<?php endif; ?>
<style>
    /*.barcodelist {
        max-width: 378px;
        text-align: center;
    }
    .barcodelist img {
        max-width: 150px;
    }*/

    @media  print {
        * {
            font-size:12px;
            line-height: 20px;
        }
        td,th {padding: 5px 0;}
        .hidden-print {
            display: none !important;
        }
        @page  { size: landscape; margin: 0 !important; }
        .barcodelist {
            max-width: 378px;
        }
        .barcodelist img {
            max-width: 150px;
        }
    }

</style>
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4><?php echo e(trans('file.print_barcode')); ?></h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small><?php echo e(trans('file.The field labels marked with * are required input fields')); ?>.</small></p>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label><?php echo e(trans('file.add_product')); ?> *</label>
                                        <div class="search-box input-group">

                                            <button type="button" class="btn btn-secondary btn-lg"><i class="fa fa-barcode"></i></button>
                                            <input type="text" name="product_code_name" id="lims_productcodeSearch" placeholder="Please type product code and select..." class="form-control" />
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col-md-12">
                                        <div class="table-responsive mt-3">
                                            <table id="myTable" class="table table-hover order-list">
                                                <thead>
                                                    <tr>
                                                        <th><?php echo e(trans('file.name')); ?></th>
                                                        <th><?php echo e(trans('file.Code')); ?></th>
                                                        <th><?php echo e(trans('stock')); ?></th>
                                                        <th><?php echo e(trans('file.Quantity')); ?></th>
                                                        <th><i class="dripicons-trash"></i></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                  <?php
                                    $barcodesetting = $barcodesetting ?? (object)[
                                        'name' => 1,
                                        'price' => 1,
                                        'promotional_price' => 1,
                                        'paper_size' => 38
                                    ];
                                ?>
                                <!--<div class="form-group mt-2">-->
                                <!--    <strong><?php echo e(trans('file.Print')); ?>: </strong>&nbsp;-->
                                <!--    <strong><input type="checkbox" name="name"  <?php echo e($barcodesetting->name == 1 ? 'checked' : ''); ?>/> <?php echo e(trans('file.Product Name')); ?></strong>&nbsp;-->
                                <!--    <strong><input type="checkbox" name="price"  <?php echo e($barcodesetting->price == 1 ? 'checked' : ''); ?>/> <?php echo e(trans('file.Price')); ?></strong>&nbsp;-->
                                <!--    <strong><input type="checkbox" name="promo_price"  <?php echo e($barcodesetting->promotional_price == 1 ? 'checked' : ''); ?>/> <?php echo e(trans('file.Promotional Price')); ?></strong>-->
                                <!--</div>-->
                                <div class="row">
                                    <div class="col-md-4">
                                        <label><strong>Paper Size *</strong></label>
                                        <select class="form-control" name="paper_size" required id="paper-size">
                                            <option value="0" <?php echo e($barcodesetting->paper_size == 0 ? 'selected' : ''); ?> >Select paper size...</option>
                                            <option value="38" <?php echo e($barcodesetting->paper_size == 38 ? 'selected' : ''); ?> >38 mm (1.49 inch)</option>
                                            <option value="36" <?php echo e($barcodesetting->paper_size == 36 ? 'selected' : ''); ?> >36 mm (1.4 inch)</option>
                                            <option value="24" <?php echo e($barcodesetting->paper_size == 24 ? 'selected' : ''); ?> >24 mm (0.94 inch)</option>
                                            <option value="18" <?php echo e($barcodesetting->paper_size == 18 ? 'selected' : ''); ?> >18 mm (0.7 inch)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group mt-3">
                                    <input type="submit" value="<?php echo e(trans('file.submit')); ?>" class="btn btn-primary" id="submit-button">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="print-barcode" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
        <div role="document" class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                  <h5 id="modal_header" class="modal-title"><?php echo e(trans('file.Barcode')); ?></h5>&nbsp;&nbsp;
                  <button id="print-btn" type="button" class="btn btn-default btn-sm"><i class="dripicons-print"></i> <?php echo e(trans('file.Print')); ?></button>
                  <button type="button" id="close-btn" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="modal-body">
                    <div id="label-content">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">

    $("ul#product").siblings('a').attr('aria-expanded','true');
    $("ul#product").addClass("show");
    $("ul#product #printBarcode-menu").addClass("active");
    <?php $productArray = []; ?>
    var lims_product_code = [
    <?php if(isset($lims_product_list_without_variant)): ?>
    <?php $__currentLoopData = $lims_product_list_without_variant; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $productArray[] = htmlspecialchars($product->code . ' (' . $product->name . ')');
        ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <?php if(isset($lims_product_list_with_variant)): ?>
    <?php $__currentLoopData = $lims_product_list_with_variant; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $productArray[] = htmlspecialchars($product->item_code . ' (' . $product->name . ')');
        ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <?php
        echo  '"'.implode('","', $productArray).'"';
    ?>
    ];

    var lims_productcodeSearch = $('#lims_productcodeSearch');

    lims_productcodeSearch.autocomplete({
    source: function(request, response) {
        var matcher = new RegExp(".?" + $.ui.autocomplete.escapeRegex(request.term), "i");
        response($.grep(lims_product_code, function(item) {
            return matcher.test(item);
        }));
    },
    select: function(event, ui) {
        var data = ui.item.value;
        $.ajax({
            type: 'GET',
            url: 'lims_product_search',
            data: {
                data: data
            },
            success: function(data) {
                console.log(data);
                var flag = 1;
                $(".product-code").each(function() {
                    if ($(this).text() == data[1]) {
                        alert('duplicate input is not allowed!')
                        flag = 0;
                    }
                });
                $("input[name='product_code_name']").val('');
                if(flag){
                    var newRow = $('<tr data-imagedata="'+data[3]+'" data-price="'+data[2]+'" data-promo-price="'+data[4]+'" data-currency="'+data[5]+'" data-currency-position="'+data[6]+'" data-color="'+data[7]+'" data-size="'+data[8]+'">');
                    var cols = '';
                    cols += '<td>' + data[0] + '</td>';
                    cols += '<td class="product-code">' + data[1] + '</td>';
                    cols += '<td class="product-code">' + data[7] + '</td>';
                    cols += '<td><input type="number" class="form-control qty" name="qty[]" value="1" /></td>';
                    cols += '<td><button type="button" class="ibtnDel btn btn-md btn-danger">Delete</button></td>';

                    newRow.append(cols);
                    $("table.order-list tbody").append(newRow);
                }
            }
        });
    }
});

    //Delete product
    $("table.order-list tbody").on("click", ".ibtnDel", function(event) {
        rowindex = $(this).closest('tr').index();
        $(this).closest("tr").remove();
    });

    $("#submit-button").on("click", function(event) {
        paper_size = ($("#paper-size").val());
        if(paper_size != "0") {
            var product_name = [];
            var code = [];
            var price = [];
            var promo_price = [];
            var qty = [];
            var barcode_image = [];
            var currency = [];
            var currency_position = [];
            var color = [];
            var size = [];
            var rownumber = $('table.order-list tbody tr:last').index();
            for(i = 0; i <= rownumber; i++){
                product_name.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').find('td:nth-child(1)').text());
                code.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').find('td:nth-child(2)').text());
                price.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('price'));
                promo_price.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('promo-price'));
                currency.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('currency'));
                currency_position.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('currency-position'));
                qty.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').find('.qty').val());
                barcode_image.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('imagedata'));
                color.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('color'));
                size.push($('table.order-list tbody tr:nth-child(' + (i + 1) + ')').data('size'));
            }
            var htmltext = '<table class="barcodelist" style="width:378px;" cellpadding="5px" cellspacing="10px">';
            $.each(qty, function(index){
            for(let i = 0; i < qty[index]; i++) {
                let columns = [];
                if (code[index]) columns.push({ label: "ART NO.", value: code[index] });
                if (color[index]) columns.push({ label: "Color", value: color[index] });
                if (size[index]) columns.push({ label: "Size", value: size[index] });
        
                const columnCount = columns.length;
        
                htmltext += `<tr><td colspan="2" style="padding: 10px; border: 1px solid #ddd;">`;
        
                // Start barcode item container
                htmltext += `<div style="text-align:center;">`;
        
                // Grid layout: headings
                htmltext += `<div style="display: grid; grid-template-columns: repeat(${columnCount}, 1fr); gap: 5px; text-align: center; font-weight: bold;">`;
                columns.forEach(col => {
                    htmltext += `<div>${col.label}</div>`;
                });
                htmltext += `</div>`;
        
                // Grid layout: values
                htmltext += `<div style="display: grid; grid-template-columns: repeat(${columnCount}, 1fr); gap: 5px; text-align: center;">`;
                columns.forEach(col => {
                    htmltext += `<div>${col.value}</div>`;
                });
                htmltext += `</div>`;
        
                // Barcode image
                htmltext += `
                    <div style="margin-top: 10px;">
                        <img src="data:image/png;base64,${barcode_image[index]}" alt="Barcode" style="max-width: 150px; display: block; margin: 0 auto;" />
                    </div>
                `;
        
                htmltext += `</div></td></tr>`;
            }
        });

            // $.each(qty, function(index){
            //     i = 0;
            //     while(i < qty[index]) {
            //         if(i % 2 == 0)
            //             htmltext +='<tr>';
            //         // 36mm
            //         if(paper_size == 36)
            //             htmltext +='<td style="width:164px;height:88%;padding-top:7px;vertical-align:middle;text-align:center">';
            //         //24mm
            //         else if(paper_size == 24)
            //             htmltext +='<td style="width:164px;height:100%;font-size:12px;text-align:center">';
            //         //18mm
            //         else if(paper_size == 18)
            //             htmltext +='<td style="width:164px;height:100%;font-size:10px;text-align:center">';

            //         if($('input[name="name"]').is(":checked"))
            //             htmltext += product_name[index] + '<br>';

            //         if(paper_size == 18)
            //             htmltext += '<img style="max-width:150px;" src="data:image/png;base64,'+barcode_image[index]+'" alt="barcode" /><br>';
            //         else
            //             htmltext += '<img style="max-width:150px;" src="data:image/png;base64,'+barcode_image[index]+'" alt="barcode" /><br>';

            //         htmltext += code[index] + '<br>';
            //         if($('input[name="code"]').is(":checked"))
            //             htmltext += '<strong>'+code[index]+'</strong><br>';
            //         if($('input[name="promo_price"]').is(":checked")) {
            //             if(currency_position[index] == 'prefix')
            //                 htmltext += 'Price: '+currency[index]+'<span style="text-decoration: line-through;"> '+price[index]+'</span> '+promo_price[index]+'<br>';
            //             else
            //                 htmltext += 'Price: <span style="text-decoration: line-through;">'+price[index]+'</span> '+promo_price[index]+' '+currency[index]+'<br>';
            //         }
            //         else if($('input[name="price"]').is(":checked")) {
            //             if(currency_position[index] == 'prefix')
            //                 htmltext += 'Price: '+currency[index]+' '+price[index];
            //             else
            //                 htmltext += 'Price: '+price[index]+' '+currency[index];
            //         }
            //         htmltext +='</td>';
            //         if(i % 2 != 0)
            //             htmltext +='</tr>';
            //         i++;
            //     }
            // });
            htmltext += '</table">';
            $('#label-content').html(htmltext);
            $('#print-barcode').modal('show');
        }
        else
            alert('Please select paper size');
    });

    /*$("#print-btn").on("click", function(){
          var divToPrint=document.getElementById('print-barcode');
          var newWin=window.open('','Print-Window');
          newWin.document.open();
          newWin.document.write('<style type="text/css">@media  print { #modal_header { display: none } #print-btn { display: none } #close-btn { display: none } } table.barcodelist { page-break-inside:auto } table.barcodelist tr { page-break-inside:avoid; page-break-after:auto }</style><body onload="window.print()">'+divToPrint.innerHTML+'</body>');
          newWin.document.close();
          setTimeout(function(){newWin.close();},10);
    });*/

    $("#print-btn").on("click", function() {
          var divToPrint=document.getElementById('print-barcode');
          var newWin=window.open('','Print-Window');
          newWin.document.open();
          newWin.document.write('<style type="text/css">@media  print { #modal_header { display: none } #print-btn { display: none } #close-btn { display: none } } table.barcodelist { page-break-inside:auto } table.barcodelist tr { page-break-inside:avoid; page-break-after:auto }</style><body onload="window.print()">'+divToPrint.innerHTML+'</body>');
          newWin.document.close();
          setTimeout(function(){newWin.close();},10);
    });

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u799939957/domains/akstechgroup.com/public_html/sales/salepro/resources/views/product/print_barcode.blade.php ENDPATH**/ ?>