

<?php $__env->startSection('content'); ?>

<section class="forms">
    <div class="container-fluid">

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-12"> 
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Barcode setting</h4>
                    </div>
                    <div class="card-body">
                      <form id="product-form" action="<?php echo e(url('barcode-setting')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                    
                        <div class="row">
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>Name</strong></label>
                                    <div class="input-group">
                                        <select name="name" class="form-control selectpicker">
                                            <option value="1" <?php echo e(isset($barcodesetting) && $barcodesetting->name == 1 ? 'selected' : ''); ?>>Yes</option>
                                            <option value="0" <?php echo e(isset($barcodesetting) && $barcodesetting->name == 0 ? 'selected' : ''); ?>>No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong><?php echo e(trans('file.Product Type')); ?></strong> *</label>
                                    <div class="input-group">
                                        <select name="price" class="form-control selectpicker">
                                            <option value="1" <?php echo e(isset($barcodesetting) && $barcodesetting->price == 1 ? 'selected' : ''); ?>>Yes</option>
                                            <option value="0" <?php echo e(isset($barcodesetting) && $barcodesetting->price == 0 ? 'selected' : ''); ?>>No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>Promotional Price</strong></label>
                                    <div class="input-group">
                                        <select name="promotional_price" class="form-control selectpicker">
                                            <option value="1" <?php echo e(isset($barcodesetting) && $barcodesetting->promotional_price == 1 ? 'selected' : ''); ?>>Yes</option>
                                            <option value="0" <?php echo e(isset($barcodesetting) && $barcodesetting->promotional_price == 0 ? 'selected' : ''); ?>>No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><strong>Paper Type (Size)</strong></label>
                                    <div class="input-group">
                                        <select class="form-control selectpicker" name="paper_size" required id="paper-size">
                                            <option value="" disabled <?php echo e(empty($barcodesetting->paper_size) ? 'selected' : ''); ?>>Select paper size...</option>
                                            <option value="38" <?php echo e(isset($barcodesetting) && $barcodesetting->paper_size == '38' ? 'selected' : ''); ?>>38 mm (1.496 inch)</option>
                                            <option value="36" <?php echo e(isset($barcodesetting) && $barcodesetting->paper_size == '36' ? 'selected' : ''); ?>>36 mm (1.4 inch)</option>
                                            <option value="24" <?php echo e(isset($barcodesetting) && $barcodesetting->paper_size == '24' ? 'selected' : ''); ?>>24 mm (0.94 inch)</option>
                                            <option value="18" <?php echo e(isset($barcodesetting) && $barcodesetting->paper_size == '18' ? 'selected' : ''); ?>>18 mm (0.7 inch)</option>
                                            
                                        </select>
                                    </div>
                                </div>
                            </div>
                    
                        </div>
                    
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(trans('file.submit')); ?>

                            </button>
                        </div>
                    </form>

                    </div> <!-- card-body -->
                </div> <!-- card -->
            </div> <!-- col-md-12 -->
        </div> <!-- row -->
    </div> <!-- container-fluid -->
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u799939957/domains/akstechgroup.com/public_html/sales/salepro/resources/views/barcode-setting.blade.php ENDPATH**/ ?>