

<?php $__env->startSection('content'); ?>
<section class="forms">
    <div class="container-fluid">

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <div class="row mb-3">
            <div class="col-md-6">
                <h4>Qr Whatsapp Profiles</h4>
            </div>
            <div class="col-md-6 text-right">
                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addSizeModal">
                    + Add New Whatsapp
                </button>
            </div>
        </div>

        
        <div class="card h-100">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>S.no</th>
                        <th>Name</th>
                        <th>Instant</th>
                        <th>Phone</th>
                        <th>Created On</th>
                        <th>Status</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                        <tbody>
                        <?php if($profiles->count() > 0): ?>
                        <?php $__currentLoopData = $profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index =>  $profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <?php $encryptedId = encrypt($profile->id); ?>
                              <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($profile->name); ?></td>
                                <td><?php echo e($profile->instance); ?></td>
                                <td><?php echo e($profile->phone); ?></td>
                                </td>
                                <td><strong><?php echo e($profile->created_at->format('d F Y')); ?></strong></td>
                                <td>
                                  <span
                                    class="badge bg-label-<?php echo e($profile->is_active ? 'success' : 'danger'); ?>">
                                    <?php echo e($profile->is_active ? 'Active' : 'Inactive'); ?>

                                  </span>
                                </td>
                                <td>
                                      <form id="deleteForm<?php echo e($encryptedId); ?>" method="POST" action="<?php echo e(route('profiles.whatsapp.destroy', $encryptedId)); ?>" onsubmit="return confirm('Are you sure?');">
                                          <?php echo csrf_field(); ?>
                                          <?php echo method_field('DELETE'); ?>
                                         <button class="btn btn-sm btn-danger">
                                            Delete
                                        </button>
                                      </form>
                                </td>
                              </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          <?php else: ?>
                            <tr>
                              <td colspan="10" class="text-center text-muted">No User found</td>
                            </tr>
                          <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($profiles->links()); ?>

            </div>
        </div>
    </div>
</section>

<!-- Add Color Modal -->
<div class="modal fade" id="addSizeModal" tabindex="-1" role="dialog" aria-labelledby="addSizeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form method="POST" enctype="multipart/form-data" id="profileForm">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addSizeModalLabel">Qr Generate</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="name"><strong>Name</strong></label>
            <input type="text" id="name" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter profile Name" value="<?php echo e(old('name')); ?>" required>
            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Phone</strong></label>
            <input type="text" id="phone" name="phone" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter Number with Country Code" value="<?php echo e(old('phone')); ?>" required>
            <small class="text-danger">Note: Please include the country code (e.g. 91xxxxxxxxxx).</small>
            <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="text-danger"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Click to generate Qr</button>
        </div>
      </div>
    </form>
     <div id="responseBox" class="mt-3"></div>
  </div>
</div>
<script>
document.getElementById('profileForm').addEventListener('submit', async function (e) {
    e.preventDefault();

    let form = e.target;
    let formData = new FormData(form);
    let responseBox = document.getElementById('responseBox');
    let pollInterval = null;

    // show loading card
    responseBox.innerHTML = `
        <div class="card border-primary shadow-sm mt-3">
            <div class="card-body text-center">
                <h5 class="card-title text-primary mb-2">
                    <i class="bx bx-loader-alt bx-spin"></i> Please wait...
                </h5>
            </div>
        </div>
    `;

    try {
        let response = await fetch("<?php echo e(route('profiles.whatsapp.store')); ?>", {
            method: "POST",
            headers: {
                "X-CSRF-TOKEN": document.querySelector('input[name=_token]').value
            },
            body: formData
        });

        let data = await response.json();

        if (data.success) {
            if (data.api?.qrcode?.base64) {
                // ✅ QR code exists → show QR
                responseBox.innerHTML = `
                    <div class="card shadow-sm mt-3">
                        <div class="card-body text-center">
                          <h5 class="card-title mb-3"> Enter this code to connect ${data.api.qrcode.pairingCode}</h5>
                            <h5 class="card-title mb-3">📱 Scan this QR Code to connect</h5>
                            <img src="${data.api.qrcode.base64}" 
                                 class="img-fluid border rounded shadow-sm p-2 bg-white"
                                 style="max-width:250px">
                            <p class="mt-3 text-muted">
                                After scanning, please wait a few seconds while we check the connection...
                            </p>
                            <div class="spinner-border text-success mt-2" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                `;

                let instance = data.api.instance.instanceName;

                // 🔄 Polling
                pollInterval = setInterval(async () => {
                    try {
                        let checkRes = await fetch("<?php echo e(route('profiles.whatsapp.connection-status', '')); ?>/" + instance, {
                            method: "GET",
                            headers: { "Accept": "application/json" }
                        });

                        let checkData = await checkRes.json();

                        if (checkData.connected) {
                            clearInterval(pollInterval);

                            // Countdown 5 → show success text instead of "0 sec"
                            let countdown = 5;
                            responseBox.innerHTML = `
                                <div class="card border-info shadow-sm mt-3">
                                    <div class="card-body text-center">
                                        <h5 class="card-title text-info">
                                            <i class="bx bx-time"></i> Connected! Finalizing in <span id="countdown">${countdown}</span> sec...
                                        </h5>
                                        <div class="spinner-grow text-info mt-2" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                </div>
                            `;

                            let countdownInterval = setInterval(() => {
                                countdown--;
                                if (countdown > 0) {
                                    document.getElementById('countdown').textContent = countdown;
                                } else {
                                    clearInterval(countdownInterval);

                                    responseBox.innerHTML = `
                                        <div class="card shadow-lg border-0 rounded-3 mt-3 animate__animated animate__fadeIn">
                                            <div class="card-body text-center bg-gradient bg-success text-white rounded-3 p-4">
                                                <i class="bx bx-check-circle display-1 mb-3"></i>
                                                <h3 class="fw-bold mb-2">Profile Created Successfully!</h3>
                                            </div>
                                        </div>
                                    `;
                                    
                                    setTimeout(() => {
                                            location.reload();
                                        }, 200);
                                                                            
                                }
                            }, 1000);
                        }

                    } catch (err) {
                        console.error("Polling error:", err);
                    }
                }, 5000);

            } else {
                // ❌ No QR → show error toast only
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: "❌ QR code not created. Please try again.",
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true
                });
                responseBox.innerHTML = "";
            }

            form.reset();
        } else {
             if (data.errors) {
                // Show validation messages
                let errorMessages = Object.values(data.errors).flat().join('<br>');
                Swal.fire({
                    icon: 'error',
                    title: 'Validation Error',
                    html: errorMessages,
                    toast: false,
                    confirmButtonText: 'OK'
                });
            } else {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: data.message || "❌ Something went wrong",
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true
                });
            }
        
            responseBox.innerHTML = "";
            return; 
        }
    } catch (err) {
        Swal.fire({
            toast: true,
            position: 'top-end',
            icon: 'error',
            title: "❌ Error: " + err.message,
            showConfirmButton: false,
            timer: 4000,
            timerProgressBar: true
        });
        responseBox.innerHTML = "";
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u799939957/domains/akstechgroup.com/public_html/sales/salepro/resources/views/evo-whatsapp-profiles/index.blade.php ENDPATH**/ ?>