

<?php $__env->startSection('content'); ?>

<section class="forms">
    <div class="container-fluid">

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Upload Gift Card Images</h4>
                    </div>
                    <div class="card-body">
                        <form id="image-form" action="<?php echo e(route('gift.card.setting.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <label><strong>Front Image</strong></label>
                                    <input type="file" name="front_image" class="form-control" accept="image/*" onchange="previewImage(event, 'frontPreview')">
                                     <span class="text-danger d-block mt-2">Upload 80 width and 55 height pixel image</span>
                                    <img id="frontPreview" src="#" alt="Front Preview" style="max-width: 100px; margin-top: 10px; display: none;">
                                </div>

                                <div class="col-md-6">
                                    <label><strong>Back Image</strong></label>
                                    <input type="file" name="back_image" class="form-control" accept="image/*" onchange="previewImage(event, 'backPreview')">
                                     <span class="text-danger d-block mt-2">Upload 80 width and 55 height pixel image</span>
                                    <img id="backPreview" src="#" alt="Back Preview" style="max-width: 100px; margin-top: 10px; display: none;">
                                </div>
                            </div>

                            <div class="form-group mt-3 ">
                                <button type="submit" class="btn btn-primary">
                                    <?php echo e(trans('file.submit')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="row mt-4">
            <div class="col-md-12">
                <h4>Existing Gift Card Images</h4>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Front Image</th>
                                <th>Back Image</th>
                                <th>Active</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $giftcardImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><img src="<?php echo e(asset($image->front_image)); ?>" alt="Front" width="80"></td>
                            <td><img src="<?php echo e(asset($image->back_image)); ?>" alt="Back" width="80"></td>
                            <td>
                                <form action="<?php echo e(route('gift.card.setting.update', $image->id)); ?>" method="POST" id="toggle-form-<?php echo e($image->id); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <input type="checkbox" onchange="document.getElementById('toggle-form-<?php echo e($image->id); ?>').submit()" <?php echo e($image->is_active ? 'checked' : ''); ?>>
                                </form>
                            </td>
                            <td>
                                <?php echo e($image->created_at->format('Y-m-d')); ?>

                                <form action="<?php echo e(route('gift.card.setting.destroy', $image->id)); ?>" method="POST" style="display:inline-block;" onsubmit="return confirm('Are you sure you want to delete this image?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function previewImage(event, previewId) {
        const output = document.getElementById(previewId);
        output.src = URL.createObjectURL(event.target.files[0]);
        output.style.display = 'block';
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u799939957/domains/akstechgroup.com/public_html/sales/salepro/resources/views/gift-card-setting/index.blade.php ENDPATH**/ ?>