

<?php $__env->startSection('content'); ?>
<section class="forms">
    <div class="container-fluid">

        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        
        <div class="row mb-3">
            <div class="col-md-6">
                <h4>Color List</h4>
            </div>
            <div class="col-md-6 text-right">
                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addColorModal">
                    + Add New Color
                </button>
            </div>
        </div>

        
        <div class="card h-100">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="">
                            <tr>
                                <th>S.no</th>
                                <th>Color Name</th>
                                <th>Color Code</th>
                                <th>Status</th>
                                <th>Toggle</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($color->color_name); ?></td>
                                <td>
                                    <span style="background-color: <?php echo e($color->color_code); ?>; padding: 5px 10px; border: 1px solid #ccc;">
                                        <?php echo e($color->color_code); ?>

                                    </span>
                                </td>
                                <td><?php echo e($color->is_active ? 'Active' : 'Inactive'); ?></td>
                                <td>
                                    <form action="<?php echo e(route('color.update', $color->id)); ?>" method="POST" id="toggle-form-<?php echo e($color->id); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <input type="hidden" name="color_name" value="<?php echo e($color->color_name); ?>">
                                        <input type="hidden" name="color_code" value="<?php echo e($color->color_code); ?>">
                                        <input type="hidden" name="is_active" value="<?php echo e($color->is_active ? 0 : 1); ?>">
                                        <input
                                            type="checkbox"
                                            onchange="document.getElementById('toggle-form-<?php echo e($color->id); ?>').submit()"
                                            <?php echo e($color->is_active ? 'checked' : ''); ?>

                                        >
                                    </form>
                                </td>
                                <td><?php echo e($color->created_at->format('Y-m-d')); ?></td>
                                <td>
                                    <form action="<?php echo e(route('color.destroy', $color->id)); ?>" method="POST" onsubmit="return confirm('Are you sure?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-danger">
                                            Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center">No colors found.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($colors->links()); ?>

            </div>
        </div>
    </div>
</section>

<!-- Add Color Modal -->
<div class="modal fade" id="addColorModal" tabindex="-1" role="dialog" aria-labelledby="addColorModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="<?php echo e(route('color.store')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addColorModalLabel">Add New Color</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label for="color_name"><strong>Color Name</strong></label>
            <input type="text" name="color_name" id="color_name" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="color_code"><strong>Color Code</strong></label>
            <input type="color" name="color_code" id="color_code" class="form-control" required>
          </div>

          <div class="form-group">
            <label for="is_active"><strong>Status</strong></label>
            <select name="is_active" id="is_active" class="form-control" required>
              <option value="1">Active</option>
              <option value="0">Inactive</option>
            </select>
          </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Add Color</button>
        </div>
      </div>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u799939957/domains/akstechgroup.com/public_html/sales/salepro/resources/views/color-setting/index.blade.php ENDPATH**/ ?>