 
<?php $__env->startSection('content'); ?>

<div class=" mt-4">
    

<?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>
 <?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>
    <div class="row justify-content-center">
        <div class="col-lg-4 col-md-6 col-sm-6 ">
            <div class="card shadow-sm ">
                <div class="card-body ">
                    <h5 class="mb-3">Send WhatsApp Message</h5>
                   <form method="POST" action="" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                    
                        <textarea class="form-control mb-3" name="message" placeholder="Type your message" rows="3"></textarea>
                    
                        <div class="mb-3">
                            <label><strong>Select Customer Groups:</strong></label><br>
                            <?php $__currentLoopData = $customergroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customergroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="group_ids[]" value="<?php echo e($customergroup->id); ?>" id="group_<?php echo e($customergroup->id); ?>">
                                    <label class="form-check-label" for="group_<?php echo e($customergroup->id); ?>"><?php echo e($customergroup->name); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    
                        <input type="file" accept="image/png, image/jpeg" class="form-control mb-3" name="image">
                        <input type="hidden" name="ids[]" id="selectedCustomers">
                        <button type="submit" class="btn btn-primary w-100">Submit</button>
                    </form>

                </div>
            </div>
        </div>
        <div class="col-lg-8 col-md-6 col-sm-6">

            <div class="card shadow-sm">
                  <div class="card-body pb-0">
                        <div class="mb-3 d-flex gap-3 align-items-center">
                            <input type="tel" id="customerSearch" name="mobile" class="form-control" placeholder="Enter mobile number or name">
                        </div>
                </div>
                 <div class="card-body pt-0">
                    <h5 class="mb-3">Customer Information</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover text-center">
                            <thead class="table-primary">
                                <tr>
                                    <th><input type="checkbox" id="selectAll"></th>
                                    <th>Name</th>
                                    <th>Mobile</th>
                                    <th>Address</th>
                                    <th>City</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="checkbox" name="customer_ids[]" value="<?php echo e($customer->id); ?>" data-group-id="<?php echo e($customer->customer_group_id); ?>" class="customer-checkbox"></td>
                                        <td><?php echo e($customer->name); ?></td>
                                        <td><?php echo e($customer->phone_number); ?></td>
                                        <td><?php echo e($customer->address); ?></td>
                                        <td><?php echo e($customer->city); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById("selectAll").addEventListener("change", function() {
        let checkboxes = document.querySelectorAll(".customer-checkbox");
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
        updateSelectedCustomers();
    });

    document.querySelectorAll(".customer-checkbox").forEach(checkbox => {
        checkbox.addEventListener("change", updateSelectedCustomers);
    });

    function updateSelectedCustomers() {
        let selected = [];
        document.querySelectorAll(".customer-checkbox:checked").forEach(checkbox => {
            selected.push(checkbox.value);
        });
        document.getElementById("selectedCustomers").value = selected.join(",");
    }
    
    document.getElementById("customerSearch").addEventListener("input", function () {
    let searchValue = this.value.toLowerCase();
    let rows = document.querySelectorAll("tbody tr");

    rows.forEach(row => {
        let name = row.cells[1].textContent.toLowerCase();
        let phone = row.cells[2].textContent.toLowerCase();

        if (name.includes(searchValue) || phone.includes(searchValue)) {
            row.style.display = "";
        } else {
            row.style.display = "none";
        }
    });
});

</script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    // 🔹 Group checkbox change
    document.querySelectorAll('input[name="group_ids[]"]').forEach(groupCheckbox => {
        groupCheckbox.addEventListener('change', function () {

            let groupId = this.value;
            let isChecked = this.checked;

            document.querySelectorAll('.customer-checkbox').forEach(customerCheckbox => {
                if (customerCheckbox.dataset.groupId === groupId) {
                    customerCheckbox.checked = isChecked;
                }
            });

            updateSelectedCustomers();
        });
    });

    // 🔹 Individual customer checkbox change
    document.querySelectorAll('.customer-checkbox').forEach(cb => {
        cb.addEventListener('change', updateSelectedCustomers);
    });

    // 🔹 Select All checkbox
    document.getElementById('selectAll').addEventListener('change', function () {
        document.querySelectorAll('.customer-checkbox').forEach(cb => {
            cb.checked = this.checked;
        });

        document.querySelectorAll('input[name="group_ids[]"]').forEach(gcb => {
            gcb.checked = this.checked;
        });

        updateSelectedCustomers();
    });

    // 🔹 Update hidden input with selected customer IDs
    function updateSelectedCustomers() {
        let selected = [];

        document.querySelectorAll('.customer-checkbox:checked').forEach(cb => {
            selected.push(cb.value);
        });

        document.getElementById('selectedCustomers').value = selected.join(',');
    }

});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u799939957/domains/akstechgroup.com/public_html/sales/salepro/resources/views/whatsapp-markating.blade.php ENDPATH**/ ?>